/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.BinningDetailsNumeric;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TransformNulls;
import oracle.ide.util.ResourceUtils;

public class BinningPanelSimple
extends JPanel
implements BinningDetailsNumeric {
    private Integer bincount;
    private String binningType;
    private TransformNulls transformNulls;
    private boolean showTransformNULLsCheckBox = false;
    private JLabel jLabelCount;
    private JTextField jTextFieldBinCount;
    private JTextField jTxtNullValue;
    private JCheckBox jchkBoxXformNulls;

    public BinningPanelSimple(String string, Integer n, TransformNulls transformNulls, boolean bl) {
        this.binningType = string;
        this.bincount = n;
        this.transformNulls = transformNulls;
        this.showTransformNULLsCheckBox = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jTextFieldBinCount = new NumberTextField();
        this.jchkBoxXformNulls = new JCheckBox();
        this.jTxtNullValue = new JTextField();
        this.jLabelCount = new JLabel();
        this.jchkBoxXformNulls.setText("Transform NULL's");
        this.jLabelCount.setText("Bin Count:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jchkBoxXformNulls, -1, 150, Short.MAX_VALUE).addComponent(this.jLabelCount, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTextFieldBinCount, -2, 67, -2).addGap(0, 226, Short.MAX_VALUE)).addComponent(this.jTxtNullValue))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldBinCount, -2, -1, -2).addComponent(this.jLabelCount)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jchkBoxXformNulls).addComponent(this.jTxtNullValue, -2, -1, -2)).addContainerGap(152, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelCount, (Component)this.jTextFieldBinCount, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_COUNT"));
        this.jTextFieldBinCount.setToolTipText(XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_BIN_COUNT_TOOLTIP"));
        if (this.showTransformNULLsCheckBox) {
            this.jchkBoxXformNulls.setText(_TRANSFORM_NULLS);
            String string = StringUtils.trimSingleQuotes(this.transformNulls.getLabel());
            string = StringUtils.getReplacedString(string, "''", "'");
            this.jTxtNullValue.setText(string);
        }
    }

    public void initUI() {
        ((NumberTextField)this.jTextFieldBinCount).setDataType(Integer.class);
        ((NumberTextField)this.jTextFieldBinCount).setSigned(false);
        this.jTextFieldBinCount.setLocale(Locale.getDefault());
        ((NumberTextField)this.jTextFieldBinCount).setNumber((Number)this.bincount);
        if (!this.showTransformNULLsCheckBox) {
            this.jchkBoxXformNulls.setVisible(false);
            this.jTxtNullValue.setVisible(false);
        }
        this.jchkBoxXformNulls.setSelected(this.transformNulls.isIncludeNulls());
        this.jTxtNullValue.setEnabled(this.transformNulls.isIncludeNulls());
        this.jchkBoxXformNulls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BinningPanelSimple.this.transformNulls.setIncludeNulls(BinningPanelSimple.this.jchkBoxXformNulls.isSelected());
                BinningPanelSimple.this.jTxtNullValue.setEnabled(BinningPanelSimple.this.jchkBoxXformNulls.isSelected());
            }
        });
    }

    @Override
    public Integer getBinCount() {
        Number number = ((NumberTextField)this.jTextFieldBinCount).getNumber();
        Integer n = (Integer)number;
        return n;
    }

    @Override
    public void setBinCount(Integer n) {
        ((NumberTextField)this.jTextFieldBinCount).setNumber((Number)n);
    }

    @Override
    public String getSelectedBinngType() {
        return this.binningType;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isLabels() {
        return false;
    }

    @Override
    public void setAuto(boolean bl) {
    }

    @Override
    public void setLabels(boolean bl) {
    }

    @Override
    public void activateDlg() {
    }

    @Override
    public TransformNulls getSrcTransformNulls() {
        return this.transformNulls;
    }

    @Override
    public TransformNulls getResultTransformNulls() {
        TransformNulls transformNulls = AttributeTypeHelper.cloneTransformNulls(this.transformNulls);
        String string = StringUtils.trimSingleQuotes(this.jTxtNullValue.getText());
        string = StringUtils.escapeSingleQuotesForSQL(string);
        transformNulls.setLabel(StringUtils.addSingleQuotes(string));
        return transformNulls;
    }
}

