/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.tests;

import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.tests.DialogsLrb;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class TestPreferencesPanel
extends DefaultTraversablePanel {
    private Boolean _automateSetting = true;
    private JCheckBox _jAutomaticSettingCheckBox;

    public TestPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jAutomaticSettingCheckBox, (String)DialogsLrb.get("TEST_AUTOMATE_SETTING"));
        this._jAutomaticSettingCheckBox.getAccessibleContext().setAccessibleName(DialogsLrb.get("TEST_AUTOMATE_SETTING"));
        this._jAutomaticSettingCheckBox.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TEST_AUTOMATE_SETTING_ADA"));
        this.setHelpID("preferences_test");
    }

    public void initUI() {
    }

    private void initComponents() {
        this._jAutomaticSettingCheckBox = new JCheckBox();
        this._jAutomaticSettingCheckBox.setText("Automate Specification Settings");
        this._jAutomaticSettingCheckBox.setName("_jAutomaticSettingCheckBox");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jAutomaticSettingCheckBox, -1, 254, Short.MAX_VALUE).addGap(140, 140, 140)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this._jAutomaticSettingCheckBox).addContainerGap(260, Short.MAX_VALUE)));
    }

    public void onEntry(TraversableContext traversableContext) {
        TestPreferenceSettings testPreferenceSettings = TestPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._automateSetting = testPreferenceSettings.getAutomaticSetting();
        this._jAutomaticSettingCheckBox.setSelected(this._automateSetting);
    }

    public void onExit(TraversableContext traversableContext) {
        TestPreferenceSettings testPreferenceSettings = TestPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        Boolean bl = this._jAutomaticSettingCheckBox.isSelected();
        if (bl != null) {
            testPreferenceSettings.setAutomaticSetting(bl);
        }
    }

    private static TestPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return TestPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public static class TestPreferenceSettings
    extends DataMinerPreferenceSettings {
        protected static final String DATA_KEY = "oracle.dmt.dataminer.workflow.TestPreferenceSettings";

        public static TestPreferenceSettings getInstance() {
            return TestPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        }

        private TestPreferenceSettings(HashStructure hashStructure) {
            super(hashStructure);
        }

        public static TestPreferenceSettings getInstance(PropertyStorage propertyStorage) {
            return new TestPreferenceSettings(TestPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        public void setAutomaticSetting(boolean bl) {
            this._hash.putBoolean("automatic_setting", bl);
        }

        public boolean getAutomaticSetting() {
            return this._hash.getBoolean("automatic_setting", true);
        }
    }
}

