/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.rowFilter;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.FilterPanel;
import oracle.dmt.dataminer.workflow.dialog.rowFilter.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.model.RowFilterNode;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RowFilterOutputColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.dialogs.ExceptionDialog;

public class RowFilterEditorPanel
extends DialogDisplayer<RowFilterNode> {
    private PropertyModel _model;
    private RowFilterNode _node;
    private OutputColumnPanel _dataPanel;
    private FilterPanel _filterPanel;
    private RowFilterOutputColumnsType _outputColumns;
    private String _filter;
    private RowFilterNode.RowFilterOutputColumnNameGenerator _outputColumnNameGenerator;
    private JTabbedPane jTabbedPane;
    private static String ROWFILTER_DATA_TAB = DialogsLrb.get("ROWFILTER_DATA_TAB");
    private static String ROWFILTER_FILTER_TAB = DialogsLrb.get("ROWFILTER_FILTER_TAB");

    public RowFilterEditorPanel(Context context, RowFilterNode rowFilterNode, PropertyModel propertyModel) {
        super(context, rowFilterNode);
        assert (context != null) : "Context must not be null.";
        assert (rowFilterNode != null) : "Join node must not be null.";
        this._context = context;
        this._model = propertyModel;
        this._node = rowFilterNode;
        RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)rowFilterNode.getData();
        this._outputColumns = (RowFilterOutputColumnsType)MetaDataHelper.copyMetadataObject(rowFilterNodeType.getOutputColumns());
        this._filter = rowFilterNodeType.getFilter();
        this._outputColumnNameGenerator = new RowFilterNode.RowFilterOutputColumnNameGenerator(this._context, rowFilterNodeType.getOutputColumns());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this._filterPanel = new FilterPanel(this._context, this._node, this);
        this.jTabbedPane.add(ROWFILTER_FILTER_TAB, this._filterPanel);
        this._dataPanel = new OutputColumnPanel(this._context, this._node, this);
        this.jTabbedPane.add(ROWFILTER_DATA_TAB, this._dataPanel);
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
            }
        });
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setName("jTabbedPane");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 785, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 499, Short.MAX_VALUE).addContainerGap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        boolean bl = true;
        if (this._dataPanel.isDirty() || this._filterPanel.isDirty()) {
            CommandProcessor.getInstance().beginTrans(DialogsLrb.get("ROWFILTER_NODE_EDIT_TRANSACTION_NAME"));
            try {
                Object object;
                boolean bl2 = false;
                RowFilterNodeType rowFilterNodeType = (RowFilterNodeType)this._node.getData();
                ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
                if (this._dataPanel.isDirty() && this._model == null) {
                    object = new ComplexProperty("RowFilterAttributes", this._dataPanel.getOutputColumns());
                    ((ComplexProperty)object).setOldData(rowFilterNodeType.getOutputColumns());
                    arrayList.add((ComplexProperty)object);
                    bl2 = true;
                }
                if (this._filterPanel.isDirty() && this._model == null && (bl2 = true)) {
                    object = new ComplexProperty("rowFilter", this._filterPanel.getFilter());
                    ((ComplexProperty)object).setOldData(rowFilterNodeType.getFilter());
                    arrayList.add((ComplexProperty)object);
                }
                if (bl2) {
                    object = (OdmrSDMUndoFilter)((RowFilterNode)this.getData()).getUndoFilter();
                    ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(this._node, this.getContext(), arrayList);
                    this._node.validate(true);
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("ROWFILTER_NODE_EDIT_ERROR_MESG"), null);
                CommandProcessor.getInstance().abortTrans();
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        }
        return bl;
    }

    public RowFilterOutputColumnsType getOutputColumns() {
        return this._outputColumns;
    }

    public String getFilter() {
        return this._filter;
    }

    public PropertyModel getModel() {
        return this._model;
    }

    public RowFilterNode.RowFilterOutputColumnNameGenerator getOutputColumnNameGenerator() {
        return this._outputColumnNameGenerator;
    }

    public OutputColumnPanel getDataPanel() {
        return this._dataPanel;
    }

    public FilterPanel getFilterPanel() {
        return this._filterPanel;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("EDIT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "rowfilter_editor";
    }
}

