/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.SchemaChooserTableModel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.model.common.build.MiningModelSettings;
import oracle.dmt.dataminer.core.model.common.build.ModelDescription;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.Classification;
import oracle.dmt.dataminer.server.model.MiningAlgorithms;
import oracle.dmt.dataminer.server.model.MiningFunctionOptions;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodePartitionDefPanel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelDescriptionTableModel;
import oracle.dmt.dataminer.workflow.dialog.model.ModelNodeEditorPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.model.TargetValuesPanel;
import oracle.dmt.dataminer.workflow.inspect.ModelNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.ModelNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingODMType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSettingsODM;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class EditModelNodePanel
extends JPanel
implements DialogDisplayable {
    public static final int SEARCH_FULL_NAME = 0;
    public static final int SEARCH_MODEL_NAME = 1;
    public static final int SEARCH_SCHEMA_NAME = 2;
    public static final int SEARCH_FUNCTION = 3;
    public static final int SEARCH_ALGORITHM = 4;
    public static final int SEARCH_TARGET_NAME = 5;
    public static final int SEARCH_TARGET_DATA_TYPE = 6;
    public static final int SEARCH_COMMENTS = 7;
    private static final Logger theLogger = Logger.getLogger(EditModelNodePanel.class.getName());
    private String ownerName;
    private boolean isSelectionBusy;
    private PropertyModel propertyModel;
    private BlockingComponent overlayPanel;
    private AbstractModelNode abstractModelNode;
    private ModelDescriptionTableModel selectedModelsTableModel;
    private ModelDescriptionTableModel availableModelsTableModel;
    private ModelDescriptionTableModel filteredAvaiableModelsTableModel;
    private Context _context;
    private int currentSearchCategory;
    private List<? extends Object> targetValues;
    private MiningFunctionOptions currentFunctionOption;
    private ModelNodeEditorPreferenceSettings editorPreferences = ModelNodeEditorPreferenceSettings.getInstance();
    private Version dbVersion;
    private ControlBar controlBar;
    private DataMinerTable jAvailModels;
    private ComponentWithTitlebar<JComponent> jAvailableModelsComponent;
    private JLabel jAvailableModelsLabel;
    private JCheckBox jChkIncludeAllSchemas;
    private JLabel jComboFunctionLabel;
    private JComboBox jComboModelFunctions;
    private PropertyLabel jMiningFunctionLabel;
    private JTextField jMiningFunctionValue;
    private JLabel jNonComformingPartitionLabel;
    private JButton jPartitionKeysButton;
    private JLabel jPartitionKeysLabel;
    private JButton jRemoveAllButton;
    private JButton jRemoveButton;
    private JScrollPane jScrollPaneAvailable;
    private JScrollPane jScrollPaneSelected;
    private JButton jSelectAllButton;
    private JButton jSelectButton;
    private DataMinerTable jSelectedModels;
    private ComponentWithTitlebar<JComponent> jSelectedModelsComponent;
    private JLabel jSelectedModelsLabel;
    private PropertyLabel jTargetAttributeLabel;
    private JTextField jTargetAttributeValue;
    private JLabel jTargetDataTypeLabel;
    private JTextField jTargetDataTypeValue;
    private JButton jTargetValuesButton;
    private SearchField searchField;

    public EditModelNodePanel(Context context, AbstractModelNode abstractModelNode, PropertyModel propertyModel) {
        assert (context != null) : "Context must not be null.";
        assert (abstractModelNode != null) : "Model Node must not be null.";
        assert (abstractModelNode instanceof ModelNode) : "Must be an instance of model node.";
        this._context = context;
        this.propertyModel = propertyModel;
        this.abstractModelNode = abstractModelNode;
        this.targetValues = new ArrayList<Object>();
        this.currentSearchCategory = 0;
        this.currentFunctionOption = MiningFunctionOptions.ALL;
        this.overlayPanel = new BlockingComponent((JComponent)this);
        this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jAvailableModelsLabel = new JLabel();
        this.jSelectedModelsLabel = new JLabel();
        this.searchField = new SearchField();
        this.controlBar = new ControlBar();
        this.controlBar.add((Component)this.searchField);
        this.jScrollPaneSelected = new JScrollPane();
        this.jSelectedModels = new DataMinerTable();
        this.jScrollPaneAvailable = new JScrollPane();
        this.jAvailModels = new DataMinerTable();
        this.jComboFunctionLabel = new JLabel();
        this.jComboModelFunctions = new JComboBox();
        this.jMiningFunctionLabel = new PropertyLabel();
        this.jMiningFunctionValue = new JTextField();
        this.jTargetAttributeLabel = new PropertyLabel();
        this.jTargetAttributeValue = new JTextField();
        this.jSelectButton = new JButton();
        this.jSelectAllButton = new JButton();
        this.jRemoveButton = new JButton();
        this.jRemoveAllButton = new JButton();
        this.jChkIncludeAllSchemas = new JCheckBox();
        this.jTargetDataTypeLabel = new JLabel();
        this.jTargetDataTypeValue = new JTextField();
        this.jAvailableModelsComponent = new ComponentWithTitlebar();
        this.jSelectedModelsComponent = new ComponentWithTitlebar();
        this.jTargetValuesButton = new JButton();
        this.jPartitionKeysLabel = new JLabel();
        this.jPartitionKeysButton = new JButton();
        this.jNonComformingPartitionLabel = new JLabel();
        this.jAvailableModelsLabel.setText(DialogsLrb.get("MODEL_NODE_AVAILABLE_MODELS"));
        this.jSelectedModelsLabel.setText(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS"));
        this.searchField.setPreferredSize(new Dimension(160, 21));
        this.controlBar.setPreferredSize(new Dimension(160, 25));
        this.jScrollPaneSelected.setViewportView((Component)((Object)this.jSelectedModels));
        this.jScrollPaneAvailable.setViewportView((Component)((Object)this.jAvailModels));
        this.jComboFunctionLabel.setText("Model Function:");
        this.jMiningFunctionLabel.setText("Function:");
        this.jMiningFunctionValue.setEditable(false);
        this.jMiningFunctionValue.setText("Classification");
        this.jMiningFunctionValue.setBorder(null);
        this.jTargetAttributeLabel.setText("Target:");
        this.jTargetAttributeValue.setEditable(false);
        this.jTargetAttributeValue.setText("Churn");
        this.jTargetAttributeValue.setBorder(null);
        this.jSelectButton.setText(">");
        this.jSelectAllButton.setText(">>");
        this.jRemoveButton.setText("<");
        this.jRemoveAllButton.setText("<<");
        this.jChkIncludeAllSchemas.setText("Include Models from Other Schemas");
        this.jChkIncludeAllSchemas.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkIncludeAllSchemas.setMargin(new Insets(0, 0, 0, 0));
        this.jTargetDataTypeLabel.setText("Data Type:");
        this.jTargetDataTypeValue.setEditable(false);
        this.jTargetDataTypeValue.setText("VARCHAR2");
        this.jTargetDataTypeValue.setBorder(null);
        this.jAvailableModelsComponent.setComponent((JComponent)this.jScrollPaneAvailable);
        this.jAvailableModelsComponent.setControlBar(this.controlBar);
        this.jAvailableModelsComponent.setLabel(this.jAvailableModelsLabel);
        this.jSelectedModelsComponent.setComponent((JComponent)this.jScrollPaneSelected);
        this.jSelectedModelsComponent.setLabel(this.jSelectedModelsLabel);
        this.jTargetValuesButton.setText("Values...");
        this.jPartitionKeysLabel.setText("Partition Keys:");
        this.jPartitionKeysButton.setText("Details...");
        this.jNonComformingPartitionLabel.setForeground(new Color(204, 51, 0));
        this.jNonComformingPartitionLabel.setText("Selected models do not have conforming partition keys");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jComboFunctionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboModelFunctions, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent((Component)this.jAvailableModelsComponent, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectButton, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllButton, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveButton, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllButton, -2, 49, -2)).addGap(9, 9, 9)))).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jChkIncludeAllSchemas, -2, 288, -2).addGap(348, 348, 348))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTargetDataTypeLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jTargetAttributeLabel, -1, -1, Short.MAX_VALUE).addComponent((Component)this.jMiningFunctionLabel, -2, -1, -2).addComponent(this.jPartitionKeysLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jMiningFunctionValue, -1, 213, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTargetAttributeValue, -1, 132, Short.MAX_VALUE).addComponent(this.jTargetDataTypeValue, GroupLayout.Alignment.TRAILING, -1, 132, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetValuesButton)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPartitionKeysButton)))).addComponent((Component)this.jSelectedModelsComponent, -2, 0, Short.MAX_VALUE).addComponent(this.jNonComformingPartitionLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboFunctionLabel).addComponent(this.jComboModelFunctions, -2, -1, -2)).addGap(14, 14, 14)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jMiningFunctionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jMiningFunctionValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.jTargetAttributeLabel, -2, -1, -2).addComponent(this.jTargetValuesButton).addComponent(this.jTargetAttributeValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetDataTypeLabel).addComponent(this.jTargetDataTypeValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPartitionKeysLabel).addComponent(this.jPartitionKeysButton)))).addGap(2, 2, 2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.jAvailableModelsComponent, -1, 306, Short.MAX_VALUE).addComponent((Component)this.jSelectedModelsComponent, -1, 306, Short.MAX_VALUE)).addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChkIncludeAllSchemas, -2, 15, -2).addComponent(this.jNonComformingPartitionLabel))).addGroup(groupLayout.createSequentialGroup().addGap(155, 155, 155).addComponent(this.jSelectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllButton))).addContainerGap()));
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jComboFunctionLabel, (Component)this.jComboModelFunctions, (String)DialogsLrb.get("MODEL_NODE_MODEL_FUNCTION"));
        this.jComboModelFunctions.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_MODEL_FUNCTION_ADA"));
        this.jComboModelFunctions.setToolTipText(DialogsLrb.get("MODEL_NODE_MODEL_FUNCTION_ADA"));
        this.jComboModelFunctions.setModel(new DefaultComboBoxModel<MiningFunctionOptions>(MiningFunctionOptions.values()));
        this.jAvailModels.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_AVAILABLE_MODELS_ADA"));
        this.jAvailModels.setToolTipText(DialogsLrb.get("MODEL_NODE_AVAILABLE_MODELS_ADA"));
        this.jSelectedModels.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS_ADA"));
        this.jSelectedModels.setToolTipText(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS_ADA"));
        this.searchField.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_FILTER_ADA"));
        this.searchField.setToolTipText(DialogsLrb.get("MODEL_NODE_FILTER_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jChkIncludeAllSchemas, (String)DialogsLrb.get("MODEL_NODE_INCLUDE_FROM_SCHEMAS"));
        this.jChkIncludeAllSchemas.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_INCLUDE_FROM_SCHEMAS_ADA"));
        this.searchField.setToolTipText(DialogsLrb.get("MODEL_NODE_INCLUDE_FROM_SCHEMAS_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMiningFunctionLabel, (Component)this.jMiningFunctionValue, (String)(DialogsLrb.get("MODEL_NODE_FUNCTION") + ":"));
        ResourceUtils.resLabel((JLabel)this.jTargetAttributeLabel, (Component)this.jTargetAttributeValue, (String)(DialogsLrb.get("MODEL_NODE_TARGET") + ":"));
        ResourceUtils.resLabel((JLabel)this.jTargetDataTypeLabel, (Component)this.jTargetDataTypeValue, (String)(DialogsLrb.get("MODEL_NODE_TARGET_DATA_TYPE") + ":"));
        ResourceUtils.resButton((AbstractButton)this.jTargetValuesButton, (String)DialogsLrb.get("MODEL_NODE_MODEL_TARGET_VALUES"));
        this.jSelectedModels.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_SELECTED_MODELS_ADA"));
        this.jSelectButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectButton.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ADA"));
        this.jSelectAllButton.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveButton.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllButton.setToolTipText(DialogsLrb.get("MODEL_NODE_CHOOSER_REMOVE.ALL_ADA"));
        this.jSelectButton.setText("");
        this.jSelectAllButton.setText("");
        this.jRemoveButton.setText("");
        this.jRemoveAllButton.setText("");
        this.jTargetAttributeValue.setFocusable(false);
        this.jTargetAttributeValue.setText("");
        this.jTargetDataTypeValue.setText("");
        this.jTargetDataTypeValue.setFocusable(false);
        this.jMiningFunctionValue.setText("");
        this.jMiningFunctionValue.setFocusable(false);
        this.jTargetValuesButton.setEnabled(false);
        this.jChkIncludeAllSchemas.setSelected(this.editorPreferences.getIncludeModelsFromOtherSchemas());
    }

    private void initUI() {
        this.ownerName = ConnectionFolder.getUserAccountName(this._context);
        this.ownerName = StringUtils.isDoubleQuotedString(this.ownerName) ? StringUtils.trimDoubleQuotes(this.ownerName) : this.ownerName.toUpperCase();
        this.initIcons();
        ModelDescriptionTableModel modelDescriptionTableModel = new ModelDescriptionTableModel(this._context);
        modelDescriptionTableModel.setLoadingStatus();
        this.jSelectedModels.setModel((TableModel)((Object)modelDescriptionTableModel));
        SchemaChooserTableModel schemaChooserTableModel = new SchemaChooserTableModel();
        this.jAvailModels.setModel((TableModel)((Object)schemaChooserTableModel));
        this.setupFilterCtl();
        this.enableControls(false);
        this.jAvailModels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (EditModelNodePanel.this.isSelectionBusy) {
                        return;
                    }
                    try {
                        EditModelNodePanel.this.isSelectionBusy = true;
                        EditModelNodePanel.this.moveAvailableRows();
                    }
                    finally {
                        EditModelNodePanel.this.isSelectionBusy = false;
                    }
                }
            }
        });
        boolean bl = DbVersionHelper.isDB122Up((Version)this.dbVersion);
        this.jPartitionKeysLabel.setVisible(bl);
        this.jPartitionKeysButton.setVisible(bl);
        this.jPartitionKeysButton.setEnabled(false);
        ListSelectionModel listSelectionModel = this.jSelectedModels.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionEvent -> this.jPartitionKeysButton.setEnabled(this.jSelectedModels.getSelectedRowCount() == 1));
        this.jPartitionKeysButton.addActionListener(actionEvent -> {
            int[] nArray = this.jSelectedModels.getSelectedRowsInModel();
            if (nArray.length != 1) {
                return;
            }
            String string = (String)this.jSelectedModels.getModel().getValueAt(nArray[0], 0);
            EditModelNodePartitionDefPanel editModelNodePartitionDefPanel = new EditModelNodePartitionDefPanel(this._context, this.ownerName, string);
            editModelNodePartitionDefPanel.load();
            DialogHelper dialogHelper = new DialogHelper(editModelNodePartitionDefPanel);
            dialogHelper.showAsDialog(this);
        });
        this.jNonComformingPartitionLabel.setVisible(false);
        this.jSelectedModels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (EditModelNodePanel.this.isSelectionBusy) {
                        return;
                    }
                    try {
                        EditModelNodePanel.this.isSelectionBusy = true;
                        EditModelNodePanel.this.moveSelectedRows();
                    }
                    finally {
                        EditModelNodePanel.this.isSelectionBusy = false;
                    }
                }
            }
        });
        this.jSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this.isSelectionBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this.isSelectionBusy = true;
                    EditModelNodePanel.this.moveAvailableRows();
                }
                finally {
                    EditModelNodePanel.this.isSelectionBusy = false;
                }
            }
        });
        this.jSelectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this.isSelectionBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this.isSelectionBusy = true;
                    EditModelNodePanel.this.jAvailModels.selectAll();
                    EditModelNodePanel.this.moveAvailableRows();
                }
                finally {
                    EditModelNodePanel.this.isSelectionBusy = false;
                }
            }
        });
        this.jRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this.isSelectionBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this.isSelectionBusy = true;
                    EditModelNodePanel.this.moveSelectedRows();
                }
                finally {
                    EditModelNodePanel.this.isSelectionBusy = false;
                }
            }
        });
        this.jRemoveAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EditModelNodePanel.this.isSelectionBusy) {
                    return;
                }
                try {
                    EditModelNodePanel.this.isSelectionBusy = true;
                    EditModelNodePanel.this.jSelectedModels.selectAll();
                    EditModelNodePanel.this.moveSelectedRows();
                }
                finally {
                    EditModelNodePanel.this.isSelectionBusy = false;
                }
            }
        });
        this.jChkIncludeAllSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelNodePanel.this.editorPreferences.setIncludeModelsFromOtherSchemas(EditModelNodePanel.this.jChkIncludeAllSchemas.isSelected());
                if (EditModelNodePanel.this.jAvailModels.getModel() != null) {
                    ((ModelDescriptionTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).setOwnerOnly(!EditModelNodePanel.this.jChkIncludeAllSchemas.isSelected());
                    EditModelNodePanel.this.processFilter(EditModelNodePanel.this.searchField.getText());
                }
            }
        });
        this.jTargetValuesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttributeType attributeType = EditModelNodePanel.this.createAttributeType(EditModelNodePanel.this.jTargetAttributeValue.getText(), EditModelNodePanel.this.jTargetDataTypeValue.getText());
                TargetValues targetValues = EditModelNodePanel.this.createTargetValues(attributeType);
                TargetValuesPanel targetValuesPanel = new TargetValuesPanel(attributeType.getName(), attributeType.getDataType(), targetValues);
                DialogHelper dialogHelper = new DialogHelper(targetValuesPanel);
                dialogHelper.showAsDialog(EditModelNodePanel.this);
            }
        });
        this.jComboModelFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelNodePanel.this.processComboAction(false);
            }
        });
        this.jAvailModels.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting() || EditModelNodePanel.this.isSelectionBusy) {
                    return;
                }
                int[] nArray = EditModelNodePanel.this.jAvailModels.getSelectedRowsInModel();
                try {
                    boolean bl = ((ModelDescriptionTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).validateSelectionIsCompatible(nArray, EditModelNodePanel.this._context, false);
                    if (!bl) {
                        MessageDialog.error((Component)UITools.getParentWindow(EditModelNodePanel.this), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(EditModelNodePanel.this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                }
            }
        });
    }

    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void setWarningVisible(boolean bl) {
        this.jNonComformingPartitionLabel.setVisible(bl);
    }

    private void setupFilterCtl() {
        SearchCategory searchCategory = new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_MODEL"));
        this.searchField.addCategory(searchCategory);
        this.searchField.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FULL_NAME")));
        this.searchField.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_SCHEMA")));
        this.searchField.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FUNCTION")));
        this.searchField.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_ALGORITHM")));
        this.searchField.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET")));
        this.searchField.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET_DATA_TYPE")));
        this.searchField.addCategory(new SearchCategory(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_COMMENTS")));
        this.searchField.setSelectedCategory(searchCategory);
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                String string = searchEvent.getSearchText();
                EditModelNodePanel.this.translateSearchCategoryToConstant(EditModelNodePanel.this.searchField.getSelectedCategory());
                EditModelNodePanel.this.processFilter(string);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
                EditModelNodePanel.this.translateSearchCategoryToConstant(searchEvent.getSearchCategory());
                String string = searchEvent.getSearchText();
                EditModelNodePanel.this.processFilter(string);
            }
        });
    }

    private void processComboAction(boolean bl) {
        MiningFunctionOptions miningFunctionOptions = (MiningFunctionOptions)((Object)this.jComboModelFunctions.getSelectedItem());
        if (this.currentFunctionOption != miningFunctionOptions || bl) {
            this.currentFunctionOption = miningFunctionOptions;
            this.processFilter(this.searchField.getText());
        }
    }

    private void moveAvailableRows() {
        try {
            int[] nArray = this.jAvailModels.getSelectedRowsInModel();
            if (nArray.length == 0) {
                return;
            }
            ValidateSelectionIsCompatible validateSelectionIsCompatible = new ValidateSelectionIsCompatible(nArray);
            validateSelectionIsCompatible.setTitle(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_TITLE"));
            validateSelectionIsCompatible.setMessage(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_DESC"));
            validateSelectionIsCompatible.setCancelable(true);
            try {
                validateSelectionIsCompatible.start(true);
            }
            catch (ProgressException progressException) {
                Exception exception = (Exception)progressException.getCause();
                if (exception instanceof ModelDescriptionTableModel.MisMatchedTargetValuesException) {
                    MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS_TARGET_VALUES"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                } else {
                    ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                }
                return;
            }
            if (!validateSelectionIsCompatible.isCompatible()) {
                MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
            } else if (this.isSelectionCompatibleWithCurrentSelected()) {
                Object object;
                ModelDescriptionTableModel modelDescriptionTableModel = (ModelDescriptionTableModel)((Object)this.jSelectedModels.getModel());
                if (modelDescriptionTableModel.getSrcData().isEmpty()) {
                    object = ((ModelDescriptionTableModel)((Object)this.jAvailModels.getModel())).getSrcData();
                    ModelDescription modelDescription = (ModelDescription)object.get(nArray[0]);
                    if (MiningFunctions.CLASSIFICATION.toString().equals(modelDescription.getFunction())) {
                        ModelDescriptor modelDescriptor = new ModelDescriptor(modelDescription.getSchema(), modelDescription.getModelName());
                        if (DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, modelDescription.getTargetDataType())) {
                            this.loadTargetValues(modelDescriptor, false);
                        } else if (DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, modelDescription.getTargetDataType())) {
                            this.loadTargetValues(modelDescriptor, true);
                        } else {
                            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)("Unsupported target data type encountered: " + modelDescription.getTargetDataType()), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                            return;
                        }
                    }
                }
                object = this.jAvailModels.getSelectedRowsInModel();
                this.moveItems(this.jAvailModels, this.jSelectedModels);
                modelDescriptionTableModel.setOwnerOnly(!modelDescriptionTableModel.isModelsFromOtherSchemas());
                this.setSelectionOnInsertedRows(this.jSelectedModels, ((Object)object).length);
                this.filterAvailableBasedOnSelected();
                this.checkPartitionKeysCompatibility();
            } else {
                MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_WITH_SELECTED"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
            }
        }
        catch (ModelDescriptionTableModel.MisMatchedTargetValuesException misMatchedTargetValuesException) {
            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS_TARGET_VALUES_WITH_SELECTED"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
        }
    }

    private void filterAvailableBasedOnSelected() {
        ModelDescriptionTableModel modelDescriptionTableModel = (ModelDescriptionTableModel)((Object)this.jSelectedModels.getModel());
        if (modelDescriptionTableModel.getRowCount() > 0) {
            List list = modelDescriptionTableModel.getSrcData();
            ModelDescription modelDescription = (ModelDescription)list.get(0);
            if (this.jMiningFunctionValue.getText().length() == 0) {
                this.jMiningFunctionValue.setText(modelDescription.getFunction());
                boolean bl = true;
                if (this.jTargetAttributeValue.getText().compareTo(modelDescription.getTargetName()) == 0 && this.jTargetDataTypeValue.getText().compareTo(modelDescription.getTargetDataType()) == 0) {
                    bl = false;
                }
                this.jTargetAttributeValue.setText(modelDescription.getTargetName());
                this.jTargetDataTypeValue.setText(modelDescription.getTargetDataType());
                this.jComboModelFunctions.setSelectedItem((Object)MiningFunctionOptions.fromString(modelDescription.getFunction()));
                this.jComboModelFunctions.setEnabled(false);
                this.processComboAction(bl);
            }
        }
    }

    private boolean isSelectionCompatibleWithCurrentSelected() throws ModelDescriptionTableModel.MisMatchedTargetValuesException {
        boolean bl = false;
        ModelDescriptionTableModel modelDescriptionTableModel = (ModelDescriptionTableModel)((Object)this.jSelectedModels.getModel());
        int[] nArray = this.jAvailModels.getSelectedRowsInModel();
        ModelDescriptionTableModel modelDescriptionTableModel2 = (ModelDescriptionTableModel)((Object)this.jAvailModels.getModel());
        List list = modelDescriptionTableModel2.getSrcData();
        ModelDescription modelDescription = (ModelDescription)list.get(nArray[0]);
        if (this.jMiningFunctionValue.getText().length() == 0) {
            bl = true;
        } else if (modelDescription.getFunction().equals(this.jMiningFunctionValue.getText()) && modelDescription.getTargetName().equals(this.jTargetAttributeValue.getText()) && modelDescriptionTableModel.isDataTypeCompatible(modelDescription.getTargetDataType(), this.jTargetDataTypeValue.getText())) {
            block11: {
                try {
                    if (MiningFunctions.CLASSIFICATION.toString().compareTo(this.jMiningFunctionValue.getText()) != 0) break block11;
                    ModelDescription modelDescription2 = (ModelDescription)modelDescriptionTableModel.getSrcData().get(0);
                    String string = Model.getCombinedUserNameModelName(modelDescription2.getSchema(), modelDescription2.getModelName(), false);
                    ValidateSelectionHasSameTargetValues validateSelectionHasSameTargetValues = new ValidateSelectionHasSameTargetValues(nArray, string);
                    validateSelectionHasSameTargetValues.setTitle(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_TITLE"));
                    validateSelectionHasSameTargetValues.setMessage(DialogsLrb.get("MODEL_NODE_CHOOSER_VALIDATING_COMPATIBILITY_DESC"));
                    validateSelectionHasSameTargetValues.setCancelable(true);
                    try {
                        validateSelectionHasSameTargetValues.start(true);
                    }
                    catch (ProgressException progressException) {
                        Exception exception = (Exception)progressException.getCause();
                        if (exception instanceof ModelDescriptionTableModel.MisMatchedTargetValuesException) {
                            throw exception;
                        }
                        ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                        return false;
                    }
                    if (!validateSelectionHasSameTargetValues.isCompatible()) {
                        MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("MODEL_NODE_CHOOSER_INCOMPATIBLE_MODELS_TARGET_VALUES_WITH_SELECTED"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), null);
                        return false;
                    }
                }
                catch (ModelDescriptionTableModel.MisMatchedTargetValuesException misMatchedTargetValuesException) {
                    throw misMatchedTargetValuesException;
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
                    return false;
                }
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void moveSelectedRows() {
        int[] nArray = this.jSelectedModels.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        this.moveItems(this.jSelectedModels, this.jAvailModels);
        ModelDescriptionTableModel modelDescriptionTableModel = (ModelDescriptionTableModel)((Object)this.jSelectedModels.getModel());
        modelDescriptionTableModel.setOwnerOnly(!modelDescriptionTableModel.isModelsFromOtherSchemas());
        if (modelDescriptionTableModel.getRowCount() == 0) {
            this.jMiningFunctionValue.setText("");
            this.jTargetAttributeValue.setText("");
            this.jTargetDataTypeValue.setText("");
            this.jComboModelFunctions.setEnabled(true);
            this.targetValues.clear();
            this.jTargetValuesButton.setEnabled(false);
            this.processComboAction(true);
        }
        this.checkPartitionKeysCompatibility();
    }

    private void checkPartitionKeysCompatibility() {
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
            if (this.jSelectedModels.getRowCount() == 0) {
                this.jNonComformingPartitionLabel.setVisible(false);
            } else {
                int[] nArray = this.jSelectedModels.getSelectedRows();
                this.jSelectedModels.selectAll();
                int[] nArray2 = this.jSelectedModels.getSelectedRowsInModel();
                boolean bl = ((ModelDescriptionTableModel)((Object)this.jSelectedModels.getModel())).partitionKeysCompatible(nArray2);
                this.jNonComformingPartitionLabel.setVisible(!bl);
                this.jSelectedModels.setSelectedRowsInModel(nArray);
            }
        }
    }

    private synchronized int translateSearchCategoryToConstant(SearchCategory searchCategory) {
        int n = -1;
        String string = searchCategory.getLabel();
        if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FULL_NAME"))) {
            this.currentSearchCategory = 0;
        } else if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_SCHEMA"))) {
            this.currentSearchCategory = 2;
        } else if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_MODEL"))) {
            this.currentSearchCategory = 1;
        } else if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_FUNCTION"))) {
            this.currentSearchCategory = 3;
        } else if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_ALGORITHM"))) {
            this.currentSearchCategory = 4;
        } else if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET"))) {
            this.currentSearchCategory = 5;
        } else if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_TARGET_DATA_TYPE"))) {
            this.currentSearchCategory = 6;
        } else if (string.equals(DialogsLrb.get("MODEL_NODE_CHOOSER_MODELS_SEARCH_CAT_COMMENTS"))) {
            this.currentSearchCategory = 7;
        } else assert (false) : "Invalid Search Category Code";
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFilter(String string) {
        Window window = UITools.getParentWindow(this);
        try {
            window.setCursor(new Cursor(3));
            this.enableControls(false);
            String string2 = null;
            String string3 = null;
            if ((this.currentFunctionOption == MiningFunctionOptions.CLASSIFICATION || this.currentFunctionOption == MiningFunctionOptions.REGRESSION) && this.jTargetAttributeValue.getText().length() > 0 && this.jTargetDataTypeValue.getText().length() > 0) {
                string2 = this.jTargetAttributeValue.getText();
                string3 = this.jTargetDataTypeValue.getText();
            }
            this.filteredAvaiableModelsTableModel = this.availableModelsTableModel.getfilteredCopy(string, this.currentSearchCategory, this.jChkIncludeAllSchemas.isSelected(), this.currentFunctionOption, string2, string3);
            this.setupTables(this.filteredAvaiableModelsTableModel, this.selectedModelsTableModel);
            this.enableControls(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_CHOOSER_ERROR_MESG"), null);
        }
        finally {
            window.setCursor(new Cursor(0));
        }
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        ModelDescriptionTableModel modelDescriptionTableModel = (ModelDescriptionTableModel)((Object)genericTable.getModel());
        ModelDescriptionTableModel modelDescriptionTableModel2 = (ModelDescriptionTableModel)((Object)genericTable2.getModel());
        modelDescriptionTableModel2.addSelection(modelDescriptionTableModel, nArray);
        if (modelDescriptionTableModel2.isFilteredTableModel()) {
            this.availableModelsTableModel.addSelection(modelDescriptionTableModel, nArray);
        }
        if (genericTable2.equals((Object)this.jSelectedModels)) {
            this.setSelectionOnInsertedRows(genericTable2, nArray.length);
        }
        if (modelDescriptionTableModel.isFilteredTableModel()) {
            this.availableModelsTableModel.removeDuplicateRows(modelDescriptionTableModel.getSrcData(), nArray);
        }
        modelDescriptionTableModel.removeSelectedRows(nArray);
    }

    private void setSelectionOnInsertedRows(GenericTable genericTable, int n) {
        genericTable.setRowSelectionInterval(genericTable.getModel().getRowCount() - n, genericTable.getModel().getRowCount() - 1);
        genericTable.scrollToSelection();
    }

    public ModelDescriptionTableModel getModel() {
        if (this.filteredAvaiableModelsTableModel != null) {
            return this.filteredAvaiableModelsTableModel;
        }
        return this.availableModelsTableModel;
    }

    private void enableControls(boolean bl) {
        this.jRemoveAllButton.setEnabled(bl);
        this.jRemoveButton.setEnabled(bl);
        this.jSelectAllButton.setEnabled(bl);
        this.jSelectButton.setEnabled(bl);
        this.jChkIncludeAllSchemas.setEnabled(bl);
        if (this.jMiningFunctionValue.getText().length() == 0) {
            this.jComboModelFunctions.setEnabled(bl);
        }
    }

    private Vector<ModelDescription> loadSelectedModelsFromNode() {
        ModelNodeType modelNodeType = (ModelNodeType)this.abstractModelNode.getData();
        List list = modelNodeType.getModels().getModel();
        if (list != null) {
            if (list.isEmpty()) {
                return new Vector<ModelDescription>();
            }
        } else {
            return new Vector<ModelDescription>();
        }
        String string = MetaDataHelper.getFunctionName(modelNodeType.getMiningFunction());
        this.currentFunctionOption = MiningFunctionOptions.fromString(string);
        String string2 = null;
        String string3 = null;
        if (modelNodeType.getTargetAttribute() != null) {
            string2 = modelNodeType.getTargetAttribute().getName();
            string3 = modelNodeType.getTargetAttribute().getDataType();
        }
        String string4 = "";
        Vector<ModelDescription> vector = new Vector<ModelDescription>();
        for (ModelNodeType.Models.Model model : list) {
            List list2;
            string4 = MiningAlgorithms.translateFromDataMinerServerMiningAlgorithm(model.getMiningAlgorithm()).toString();
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            if (model.getPartitionExpressions() != null && !(list2 = model.getPartitionExpressions().getPartitionExpression()).isEmpty()) {
                for (int i = 0; i < list2.size(); ++i) {
                    PartitionExpressionType partitionExpressionType = (PartitionExpressionType)list2.get(i);
                    if (i > 0) {
                        stringBuilder.append(",");
                        stringBuilder2.append(",");
                    }
                    stringBuilder.append(partitionExpressionType.getPartitionAttribute().getName());
                    stringBuilder2.append(partitionExpressionType.getPartitionAttribute().getDataType());
                }
            }
            list2 = new ModelDescription(model.getSchema(), model.getName(), string, string4, string2, string3, null, null, model.getStatus(), model.getModelId(), new ModelSettingsODM(), model.isUseForOutput(), stringBuilder.toString(), stringBuilder2.toString());
            vector.add((ModelDescription)list2);
        }
        if (this.currentFunctionOption == MiningFunctionOptions.CLASSIFICATION && string3 != null) {
            if (DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, string3)) {
                this.targetValues.addAll(modelNodeType.getTargetValues().getTargetValueNumber());
            } else if (DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, string3)) {
                this.targetValues.addAll(modelNodeType.getTargetValues().getTargetValueString());
            }
            this.jTargetValuesButton.setEnabled(true);
        } else {
            this.jTargetValuesButton.setEnabled(false);
        }
        return vector;
    }

    private void initIcons() {
        this.jSelectButton.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllButton.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveButton.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllButton.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    private void setupTables(ModelDescriptionTableModel modelDescriptionTableModel, ModelDescriptionTableModel modelDescriptionTableModel2) {
        Object object;
        Object object2;
        this.jAvailModels.setModel((TableModel)((Object)modelDescriptionTableModel));
        this.jSelectedModels.setModel((TableModel)((Object)modelDescriptionTableModel2));
        if (modelDescriptionTableModel2.getRowCount() > 0) {
            object2 = modelDescriptionTableModel2.getSrcData();
            object = (ModelDescription)object2.get(0);
            this.jMiningFunctionValue.setText(object.getFunction());
            this.jTargetAttributeValue.setText(object.getTargetName());
            this.jTargetDataTypeValue.setText(object.getTargetDataType());
            this.jComboModelFunctions.setSelectedItem((Object)MiningFunctionOptions.fromString(object.getFunction()));
            this.jComboModelFunctions.setEnabled(false);
            this.processComboAction(false);
        }
        this.jSelectedModels.setAutoResizeMode(4);
        this.jAvailModels.setAutoResizeMode(0);
        this.jSelectedModels.getTableHeader().setReorderingAllowed(true);
        this.jAvailModels.getTableHeader().setReorderingAllowed(true);
        this.jSelectedModels.setColumnSelectorAvailable(false);
        this.jAvailModels.setColumnSelectorAvailable(false);
        this.jAvailModels.setSorted(true);
        this.jAvailModels.setSortColumn(0, true);
        this.jSelectedModels.setSorted(false);
        this.hideTableColumns();
        this.jSelectedModels.setColumnSelectorAvailable(false);
        object2 = this.jAvailModels.getColumnModel();
        object2.getColumn(0).setPreferredWidth(100);
        object2.getColumn(1).setPreferredWidth(100);
        object2.getColumn(2).setPreferredWidth(100);
        object2.getColumn(4).setPreferredWidth(120);
        object2.getColumn(5).setPreferredWidth(90);
        object2.getColumn(6).setPreferredWidth(90);
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
            object2.getColumn(7).setPreferredWidth(400);
            object2.getColumn(3).setPreferredWidth(200);
        } else {
            object2.getColumn(6).setPreferredWidth(400);
        }
        object2 = this.jSelectedModels.getColumnModel();
        object2.getColumn(0).setPreferredWidth(100);
        object2.getColumn(1).setPreferredWidth(100);
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
            object2.getColumn(2).setPreferredWidth(200);
        }
        object = this.jSelectedModels.getColumnModel().getColumn(0);
        ((TableColumn)object).setCellRenderer(new CustomCellRenderer());
        object = this.jAvailModels.getColumnModel().getColumn(0);
        ((TableColumn)object).setCellRenderer(new CustomCellRenderer());
        this.jAvailModels.autoSizeColumnsToFit();
        this.jSelectedModels.autoSizeColumnsToFit();
    }

    private void hideTableColumns() {
        if (DbVersionHelper.isDB122Up((Version)this.dbVersion)) {
            int[] nArray = new int[]{1, 4, 5, 6, 7};
            this.jSelectedModels.setHiddenColumns(nArray);
        } else {
            int[] nArray = new int[]{1, 4, 5, 6, 3, 7};
            this.jSelectedModels.setHiddenColumns(nArray);
            this.jAvailModels.setHiddenColumns(new int[]{3});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWork() {
        ModelNodeType.Models models;
        TargetValues targetValues;
        boolean bl = true;
        AttributeType attributeType = null;
        MiningFunctionType miningFunctionType = null;
        if (this.selectedModelsTableModel.getRowCount() == 0) {
            targetValues = new TargetValues();
            models = new ModelNodeType.Models();
        } else {
            miningFunctionType = MiningFunctionOptions.translateToODMServerMiningFunction(this.currentFunctionOption);
            models = this.createModelsCollection(miningFunctionType);
            attributeType = this.createAttributeType(this.jTargetAttributeValue.getText(), this.jTargetDataTypeValue.getText());
            targetValues = this.createTargetValues(attributeType);
            try {
                this.loadModelSettings(models, miningFunctionType);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                return false;
            }
        }
        CommandProcessor.getInstance().beginTrans(DialogsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
        try {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.abstractModelNode.getUndoFilter();
            if (this.propertyModel == null) {
                odmrSDMUndoFilter.prepareUndo(this.abstractModelNode, this._context, "miningFunctionType", miningFunctionType);
                odmrSDMUndoFilter.prepareUndo(this.abstractModelNode, this._context, "targetAttribute", attributeType);
                odmrSDMUndoFilter.prepareUndo(this.abstractModelNode, this._context, "modelsGroup", models);
                odmrSDMUndoFilter.prepareUndo(this.abstractModelNode, this._context, "targetValues", targetValues);
                this.abstractModelNode.validate(true);
            } else {
                this.propertyModel.setValueAt((Object)miningFunctionType, ModelNodePropertyModel.MINING_FUNCTION.index, 0);
                this.propertyModel.setValueAt((Object)attributeType, ModelNodePropertyModel.TARGET_ATTRIBUTE.index, 0);
                this.propertyModel.setValueAt((Object)models, ModelNodePropertyModel.MODELS.index, 0);
                this.propertyModel.setValueAt((Object)targetValues, ModelNodePropertyModel.TARGET_VALUES.index, 0);
                Element[] elementArray = this._context.getSelection();
                WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                workflowNodeInspectorElement.validate(true);
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(this), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
        return bl;
    }

    private TargetValues createTargetValues(AttributeType attributeType) {
        TargetValues targetValues = new TargetValues();
        if (attributeType != null) {
            if (DatabaseMetadataUtils.isTargetNumericalDataTypeSupported(this._context, attributeType.getDataType())) {
                targetValues.getTargetValueNumber().addAll(this.targetValues);
            } else if (DatabaseMetadataUtils.isTargetCategoricalDataTypeSupported(this._context, attributeType.getDataType())) {
                targetValues.getTargetValueString().addAll(this.targetValues);
            }
        }
        return targetValues;
    }

    private void loadTargetValues(ModelDescriptor modelDescriptor, boolean bl) {
        boolean bl2 = true;
        GetTargetValues getTargetValues = new GetTargetValues(modelDescriptor, bl);
        getTargetValues.setTitle(DialogsLrb.get("MODEL_NODE_CHOOSER_LOADING_TARGET_VALUES_TITLE"));
        getTargetValues.setMessage(DialogsLrb.get("MODEL_NODE_CHOOSER_LOADING_TARGET_VALUES_DESC"));
        getTargetValues.setCancelable(false);
        try {
            getTargetValues.start(true);
            this.targetValues = getTargetValues.getTargetValues();
        }
        catch (ProgressException progressException) {
            bl2 = false;
        }
        this.jTargetValuesButton.setEnabled(bl2);
    }

    private void loadModelSettings(ModelNodeType.Models models, MiningFunctionType miningFunctionType) throws Exception {
        GetModelSettings getModelSettings = new GetModelSettings(models, miningFunctionType);
        getModelSettings.setTitle(DialogsLrb.get("MODEL_NODE_UPDATING_TITLE"));
        getModelSettings.setMessage(DialogsLrb.get("MODEL_NODE_UPDATING_DESC"));
        getModelSettings.setCancelable(false);
        try {
            getModelSettings.start(true);
        }
        catch (ProgressException progressException) {
            throw (Exception)progressException.getCause();
        }
    }

    private ModelNodeType.Models createModelsCollection(MiningFunctionType miningFunctionType) {
        ModelNodeType.Models models = new ModelNodeType.Models();
        List list = models.getModel();
        ModelNodeType.Models.Model model = null;
        for (ModelDescription modelDescription : this.selectedModelsTableModel.getSrcData()) {
            String string;
            model = new ModelNodeType.Models.Model();
            model.setName(modelDescription.getModelName());
            model.setSchema(modelDescription.getSchema());
            MiningAlgorithms miningAlgorithms = MiningAlgorithms.fromString(modelDescription.getAlgorithm());
            MiningAlgorithmType miningAlgorithmType = MiningAlgorithms.translateToDataMinerServerMiningAlgorithm(miningAlgorithms);
            model.setMiningAlgorithm(miningAlgorithmType);
            model.setMiningFunction(miningFunctionType);
            model.setStatus(modelDescription.getStatus());
            model.setUseForOutput(modelDescription.isUseForOutput());
            model.setModelSettingsODM(new ModelSettingsODM());
            if (StringUtils.isNotEmpty(modelDescription.getPartitionKey())) {
                string = null;
                String[] stringArray = modelDescription.getPartitionKey().split(",");
                String[] stringArray2 = modelDescription.getDataType().split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].trim().isEmpty()) continue;
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName(stringArray[i]);
                    attributeType.setDataType(stringArray2[i]);
                    attributeType.setStatus(AttributeStatus.VALID);
                    PartitionExpressionType partitionExpressionType = new PartitionExpressionType();
                    partitionExpressionType.setPartitionAttribute(attributeType);
                    if (string == null) {
                        new PartitionExpressions();
                    }
                    string.getPartitionExpression().add(partitionExpressionType);
                }
                if (string != null) {
                    model.setPartitionExpressions((PartitionExpressions)string);
                }
            }
            if (modelDescription.getModelId().length() == 0) {
                try {
                    string = this.abstractModelNode.getModel().getNextNewIdString();
                    model.setModelId(string);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            } else {
                model.setModelId(modelDescription.getModelId());
            }
            list.add(model);
        }
        return models;
    }

    private AttributeType createAttributeType(String string, String string2) {
        AttributeType attributeType = null;
        if (string.length() > 0) {
            attributeType = new AttributeType();
            attributeType.setDataType(string2);
            attributeType.setName(string);
            attributeType.setStatus(AttributeStatus.VALID);
        }
        return attributeType;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public String getTitle() {
                return DialogsLrb.get("MODEL_NODE_CHOOSER_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "model_selection_dialog";
            }

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                jEWTDialog.setMaximumInitialSize(new Dimension(1200, 500));
            }

            @Override
            public JComponent getContent() {
                return EditModelNodePanel.this.overlayPanel.getBlockingComponent();
            }

            @Override
            public void onOK() throws DialogExecutionException {
                ModelNodeType.Models models;
                TargetValues targetValues;
                AttributeType attributeType = null;
                MiningFunctionType miningFunctionType = null;
                if (EditModelNodePanel.this.selectedModelsTableModel.getRowCount() == 0) {
                    targetValues = new TargetValues();
                    models = new ModelNodeType.Models();
                } else {
                    miningFunctionType = MiningFunctionOptions.translateToODMServerMiningFunction(EditModelNodePanel.this.currentFunctionOption);
                    models = EditModelNodePanel.this.createModelsCollection(miningFunctionType);
                    attributeType = EditModelNodePanel.this.createAttributeType(EditModelNodePanel.this.jTargetAttributeValue.getText(), EditModelNodePanel.this.jTargetDataTypeValue.getText());
                    targetValues = EditModelNodePanel.this.createTargetValues(attributeType);
                    try {
                        EditModelNodePanel.this.loadModelSettings(models, miningFunctionType);
                    }
                    catch (Exception exception) {
                        throw new DialogExecutionException(DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                    }
                }
                CommandProcessor.getInstance().beginTrans(DialogsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
                try {
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)EditModelNodePanel.this.abstractModelNode.getUndoFilter();
                    if (EditModelNodePanel.this.propertyModel == null) {
                        odmrSDMUndoFilter.prepareUndo(EditModelNodePanel.this.abstractModelNode, EditModelNodePanel.this._context, "miningFunctionType", miningFunctionType);
                        odmrSDMUndoFilter.prepareUndo(EditModelNodePanel.this.abstractModelNode, EditModelNodePanel.this._context, "targetAttribute", attributeType);
                        odmrSDMUndoFilter.prepareUndo(EditModelNodePanel.this.abstractModelNode, EditModelNodePanel.this._context, "modelsGroup", models);
                        odmrSDMUndoFilter.prepareUndo(EditModelNodePanel.this.abstractModelNode, EditModelNodePanel.this._context, "targetValues", targetValues);
                        EditModelNodePanel.this.abstractModelNode.validate(true);
                    } else {
                        EditModelNodePanel.this.propertyModel.setValueAt((Object)miningFunctionType, ModelNodePropertyModel.MINING_FUNCTION.index, 0);
                        EditModelNodePanel.this.propertyModel.setValueAt((Object)attributeType, ModelNodePropertyModel.TARGET_ATTRIBUTE.index, 0);
                        EditModelNodePanel.this.propertyModel.setValueAt((Object)models, ModelNodePropertyModel.MODELS.index, 0);
                        EditModelNodePanel.this.propertyModel.setValueAt((Object)targetValues, ModelNodePropertyModel.TARGET_VALUES.index, 0);
                        Element[] elementArray = EditModelNodePanel.this._context.getSelection();
                        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                        workflowNodeInspectorElement.validate(true);
                    }
                }
                catch (Exception exception) {
                    throw new DialogExecutionException(DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
            }
        };
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private LoadUI() {
            super(EditModelNodePanel.this, EditModelNodePanel.this.overlayPanel);
        }

        @Override
        protected Void doInBackground() throws Exception {
            EditModelNodePanel.this.availableModelsTableModel = new ModelDescriptionTableModel(EditModelNodePanel.this._context);
            Vector<ModelDescription> vector = EditModelNodePanel.this.loadSelectedModelsFromNode();
            EditModelNodePanel.this.selectedModelsTableModel = new ModelDescriptionTableModel(EditModelNodePanel.this.ownerName, vector, EditModelNodePanel.this._context);
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(EditModelNodePanel.this._context);
            EditModelNodePanel.this.availableModelsTableModel.load(connectionFolder);
            List<ModelDescription> list = EditModelNodePanel.this.availableModelsTableModel.createMissingRowsBasedOnMatch(EditModelNodePanel.this.selectedModelsTableModel.getSrcData());
            EditModelNodePanel.this.selectedModelsTableModel.refreshModelStatus(list);
            EditModelNodePanel.this.availableModelsTableModel.removeDuplicateRowsBasedOnMatch(EditModelNodePanel.this.selectedModelsTableModel.getSrcData());
            String string = null;
            String string2 = null;
            if (EditModelNodePanel.this.selectedModelsTableModel.getRowCount() > 0) {
                List list2 = EditModelNodePanel.this.selectedModelsTableModel.getSrcData();
                ModelDescription modelDescription = (ModelDescription)list2.get(0);
                string = modelDescription.getTargetName();
                string2 = modelDescription.getTargetDataType();
            }
            EditModelNodePanel.this.filteredAvaiableModelsTableModel = EditModelNodePanel.this.availableModelsTableModel.getfilteredCopy("", EditModelNodePanel.this.currentSearchCategory, EditModelNodePanel.this.jChkIncludeAllSchemas.isSelected(), EditModelNodePanel.this.currentFunctionOption, string, string2);
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            EditModelNodePanel.this.setupTables(EditModelNodePanel.this.filteredAvaiableModelsTableModel, EditModelNodePanel.this.selectedModelsTableModel);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ModelDescriptionTableModel modelDescriptionTableModel = new ModelDescriptionTableModel(EditModelNodePanel.this._context);
            modelDescriptionTableModel.setFailedStatus();
            EditModelNodePanel.this.setupTables(modelDescriptionTableModel, EditModelNodePanel.this.selectedModelsTableModel);
            super.onFailure(throwable);
        }

        @Override
        protected void onFinally() {
            EditModelNodePanel.this.enableControls(true);
        }
    }

    private class ValidateSelectionIsCompatible
    extends ProgressRunnable {
        private int[] _selected;
        private boolean _compatible;

        private ValidateSelectionIsCompatible(int[] nArray) {
            this._selected = nArray;
        }

        private boolean isCompatible() {
            return this._compatible;
        }

        protected Object doWork() throws Exception {
            boolean bl = EditModelNodePanel.this.jMiningFunctionValue.getText().length() == 0;
            this._compatible = ((ModelDescriptionTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).validateSelectionIsCompatible(this._selected, EditModelNodePanel.this._context, bl);
            return this._compatible;
        }
    }

    private class ValidateSelectionHasSameTargetValues
    extends ProgressRunnable {
        private int[] selected;
        private boolean compatible;
        private String currentModelName;

        public ValidateSelectionHasSameTargetValues(int[] nArray, String string) {
            this.selected = nArray;
            this.currentModelName = string;
        }

        public boolean isCompatible() {
            return this.compatible;
        }

        protected Object doWork() throws Exception {
            this.compatible = ((ModelDescriptionTableModel)((Object)EditModelNodePanel.this.jAvailModels.getModel())).areTargetValuesTheSame(this.selected, EditModelNodePanel.this._context, this.currentModelName);
            return this.compatible;
        }
    }

    private static class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            GenericTable genericTable = (GenericTable)jTable;
            int n3 = genericTable.convertRowIndexToModel(n);
            ModelDescriptionTableModel modelDescriptionTableModel = (ModelDescriptionTableModel)((Object)genericTable.getModel());
            try {
                ModelDescription modelDescription = (ModelDescription)modelDescriptionTableModel.getSrcData().get(n3);
                if (modelDescription.getStatus() != null) {
                    if (modelDescription.getStatus() == RefModelStatusType.VALID) {
                        this.setIcon(DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT));
                    } else {
                        this.setIcon(OracleIcons.getIcon((String)"database_error.png"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return component;
        }
    }

    private class GetTargetValues
    extends ProgressRunnable {
        private boolean targetsAreStrings;
        private ModelDescriptor modelDescriptor;
        private List<? extends Object> targetValues;

        public GetTargetValues(ModelDescriptor modelDescriptor, boolean bl) {
            this.modelDescriptor = modelDescriptor;
            this.targetsAreStrings = bl;
        }

        public List<? extends Object> getTargetValues() {
            return this.targetValues;
        }

        protected Object doWork() throws Exception {
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(EditModelNodePanel.this._context);
            this.targetValues = this.targetsAreStrings ? Classification.getTargetValueStrings(connectionFolder, this.modelDescriptor) : Classification.getTargetValueNumbers(connectionFolder, this.modelDescriptor);
            return null;
        }
    }

    private class GetModelSettings
    extends ProgressRunnable {
        private ModelNodeType.Models _models;
        private MiningFunctionType _miningFunction;

        private GetModelSettings(ModelNodeType.Models models, MiningFunctionType miningFunctionType) {
            this._models = models;
            this._miningFunction = miningFunctionType;
        }

        protected Object doWork() throws Exception {
            Object var1_1 = null;
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(EditModelNodePanel.this._context);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ModelNodeType.Models.Model model : this._models.getModel()) {
                String string = Model.getCombinedUserNameModelName(model.getSchema(), model.getName(), true);
                arrayList.add(string);
            }
            List<MiningModelSettings> list = Model.getModelSettings(connectionFolder, arrayList);
            if (this._miningFunction == MiningFunctionType.CLASSIFICATION) {
                Model.doModelsContainScoringCostMatrix(connectionFolder, this._models, list);
            }
            for (ModelNodeType.Models.Model model : this._models.getModel()) {
                for (MiningModelSettings miningModelSettings : list) {
                    if (miningModelSettings.getModelName().compareTo(model.getName()) != 0 || miningModelSettings.getOwner().compareTo(model.getSchema()) != 0) continue;
                    ModelSettingODMType modelSettingODMType = new ModelSettingODMType();
                    modelSettingODMType.setName(miningModelSettings.getSettingName());
                    modelSettingODMType.setValue(miningModelSettings.getSettingValue());
                    modelSettingODMType.setType(miningModelSettings.getSettingType());
                    model.getModelSettingsODM().getModelSettingODM().add(modelSettingODMType);
                }
            }
            return var1_1;
        }
    }
}

