/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dmt.dataminer.controls.JSONStructureTreeTable;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONAddAggregationSelectionChange;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONAggregationElement;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONStructureAddAggregationTreeTableModel;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;

public class JSONStructureAddAggregationTreeTable
extends JSONStructureTreeTable {
    private JSONAddAggregationSelectionChange listener;

    public JSONStructureAddAggregationTreeTable() {
        super(new JSONStructureAddAggregationTreeTableModel());
        this.setCheckBoxesEnabled(false);
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.getTree().setEditable(true);
        this.setSelectionMode(2);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 != JSONAggregationElement.JSON_SUBGROUP_BY_COLUMN) {
            return super.getCellRenderer(n, n2);
        }
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        return tableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 != JSONAggregationElement.JSON_SUBGROUP_BY_COLUMN) {
            return super.getCellEditor(n, n2);
        }
        return super.getCellEditor(n, n2);
    }

    public void addSelectionChangeListener(JSONAddAggregationSelectionChange jSONAddAggregationSelectionChange) {
        this.listener = jSONAddAggregationSelectionChange;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TreePath treePath;
        if (n2 == JSONAggregationElement.JSON_ATTRIBUTE_COLUMN) {
            return true;
        }
        if ((n2 == JSONAggregationElement.JSON_SUBGROUP_BY_COLUMN || n2 == JSONAggregationElement.JSON_FUNCTION_COLUMN) && (treePath = this.getTree().getPathForRow(n)) != null) {
            JSONAggregationElement jSONAggregationElement = (JSONAggregationElement)((Object)treePath.getLastPathComponent());
            JSONStructureAddAggregationTreeTableModel jSONStructureAddAggregationTreeTableModel = (JSONStructureAddAggregationTreeTableModel)((Object)this.getTree().getModel());
            if (null == jSONStructureAddAggregationTreeTableModel.getAggregationElements()) {
                return false;
            }
            String string = jSONStructureAddAggregationTreeTableModel.getJSONElementPathByID(jSONAggregationElement.getElementID());
            boolean bl = false;
            for (AggregationElementsExType.AggregationElement aggregationElement : jSONStructureAddAggregationTreeTableModel.getAggregationElements().getAggregationElement()) {
                if (!aggregationElement.getJSONAttribute().getPath().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl && n2 == JSONAggregationElement.JSON_SUBGROUP_BY_COLUMN) {
                return false;
            }
            String string2 = jSONAggregationElement.getDataType();
            if (DatabaseMetadataUtils.isPrimitiveJSONType(string2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void selectionChanged(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.listener != null) {
            this.listener.selectionChanged();
        }
    }
}

