/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.JSONAggregationFunctionCellEditor;
import oracle.dmt.dataminer.controls.JSONAggregationFunctionProvider;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.controls.JSONStructureDefaultTreeTableModel;
import oracle.dmt.dataminer.controls.JSONStructurePanel;
import oracle.dmt.dataminer.controls.JSONSubGroupByEditorProvider;
import oracle.dmt.dataminer.controls.JSONSubGroupByTableCellEditor;
import oracle.dmt.dataminer.controls.JSONSubGroupByTreeTableCelRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AddAggregationColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AddSubGroupByColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONAddAggregationSelectionChange;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONAggregationElement;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONQueryEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONStructureAddAggregationTreeTable;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONStructureAddAggregationTreeTableModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.DropDownMenuButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class JSONStructureAddAggregationPanel
extends JSONStructurePanel
implements JSONAddAggregationSelectionChange,
JSONSubGroupByEditorProvider,
JSONAggregationFunctionProvider {
    protected static final String _EMPTY_ELEMENT = DialogsLrb.get("JSON_ADD_AGGREGATION_DLG_EMPTY_COLUMN");
    protected static final String MIXED_TYPE = "MIXED_TYPE";
    protected static final String WARNING_AGGREGATION_MIXED_TYPES = DialogsLrb.get("JSON_ADD_AGGREGATION_MIXED_TYPE_WARNING");
    protected static final String WARNING_AGGREGATION_MIXED_SUB_GROUP_BY = DialogsLrb.get("JSON_ADD_AGGREGATION_MIXED_SUB_GROUP_BY_WARNING");
    protected static final String AGGREGATION_COUNT = DialogsLrb.get("JSON_ADD_AGGREGATION_COUNT");
    private AddAggregationColumnPanel enclosingPanel;
    private AggregationElementsExType newAggregationElements;
    private AggregationElementsExType previousAggregationElements;
    private DropDownMenuButton aggrfunction;
    private JButton removeBtn;
    private JButton btnSubGroupBy;
    private static List<String> catAggregateFunctions = DatabaseMetadataUtils.AggregateFunctions.listCategoricFunctions();
    private static List<String> numAggregateFunctions = DatabaseMetadataUtils.AggregateFunctions.listNumericFunctions();
    private static List<String> mixedFunctions = DatabaseMetadataUtils.AggregateFunctions.listCommonCategoricAndNumericFunctions();
    private List<JSONAggregationElement> currentJSONSelectionList = new ArrayList<JSONAggregationElement>();

    public JSONStructureAddAggregationPanel(Context context, AbstractDataNode abstractDataNode, AttributeType attributeType, JSONColumnsType.Attribute attribute, AggregationElementsExType aggregationElementsExType, AggregationElementsExType aggregationElementsExType2, boolean bl) {
        super(context, abstractDataNode, attributeType, attribute, bl);
        this.newAggregationElements = aggregationElementsExType;
        this.previousAggregationElements = aggregationElementsExType2;
    }

    public JSONQueryEditorPanel getJSONQueryEditorPanel() {
        return this.enclosingPanel.getJSONQueryEditorPanel();
    }

    @Override
    public boolean isShowPath() {
        return true;
    }

    private void updateWarning() {
        AggregationElementsExType aggregationElementsExType = new AggregationElementsExType();
        aggregationElementsExType.getAggregationElement().addAll(this.newAggregationElements.getAggregationElement());
        aggregationElementsExType.getAggregationElement().addAll(this.previousAggregationElements.getAggregationElement());
        this.enclosingPanel.updateWarning(aggregationElementsExType);
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public void setEnclosingPanel(AddAggregationColumnPanel addAggregationColumnPanel) {
        this.enclosingPanel = addAggregationColumnPanel;
        JSONStructureAddAggregationTreeTableModel jSONStructureAddAggregationTreeTableModel = (JSONStructureAddAggregationTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureAddAggregationTreeTableModel.setAggregationElements(this.newAggregationElements);
        TableColumn tableColumn = this.jsonTree.getColumnModel().getColumn(JSONAggregationElement.JSON_SUBGROUP_BY_COLUMN);
        tableColumn.setCellEditor(new JSONSubGroupByTableCellEditor(this.getContext(), this, this.getJSONQueryEditorPanel()));
        tableColumn.setCellRenderer(new JSONSubGroupByTreeTableCelRenderer(this));
        tableColumn = this.jsonTree.getColumnModel().getColumn(JSONAggregationElement.JSON_FUNCTION_COLUMN);
        tableColumn.setCellEditor(new JSONAggregationFunctionCellEditor(new JComboBox<String>(), this));
    }

    @Override
    protected void createJSONTree() {
        this.jsonTree = new JSONStructureAddAggregationTreeTable();
        ((JSONStructureAddAggregationTreeTable)this.jsonTree).addSelectionChangeListener(this);
    }

    @Override
    public void selectionChanged() {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        Object object5;
        this.currentJSONSelectionList.clear();
        int[] nArray = this.jsonTree.getSelectedRows();
        if (nArray == null || 0 == nArray.length) {
            this.btnSubGroupBy.setEnabled(false);
            this.removeBtn.setEnabled(false);
            return;
        }
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            object5 = this.jsonTree.getTree().getPathForRow(nArray[i]);
            object4 = (JSONAggregationElement)((Object)((TreePath)object5).getLastPathComponent());
            string = object4.getDataType();
            if (!DatabaseMetadataUtils.isPrimitiveJSONType(string)) continue;
            bl2 = true;
            this.currentJSONSelectionList.add((JSONAggregationElement)((Object)object4));
            object3 = DatabaseMetadataUtils.convertJSONAttrType(string);
            object2 = DatabaseMetadataUtils.getDefaultMiningType((String)object3);
            if (string2 != null && !bl && !((String)object2).equals(string2)) {
                bl = true;
            }
            string2 = object2;
        }
        if (string2 == null || this.currentJSONSelectionList.isEmpty()) {
            this.removeBtn.setEnabled(false);
            this.aggrfunction.setEnabled(false);
            this.btnSubGroupBy.setEnabled(false);
            return;
        }
        this.aggrfunction.setEnabled(bl2);
        List<String> list = null;
        if (bl) {
            list = mixedFunctions;
        } else {
            if (string2.equalsIgnoreCase("Categorical")) {
                list = catAggregateFunctions;
            }
            if (string2.equalsIgnoreCase("Numerical")) {
                list = numAggregateFunctions;
            }
        }
        object5 = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        object4 = new Vector<String>(list);
        ((Vector)object4).insertElementAt(_EMPTY_ELEMENT, 0);
        string = null;
        string = this.currentJSONSelectionList.size() > 1 ? _EMPTY_ELEMENT : ((object3 = this.findMatchingAggregationElement(((JSONStructureDefaultTreeTableModel)((Object)object5)).getJSONElementPathByID(this.currentJSONSelectionList.get(0).getElementID()))) != null ? object3.getAggregationFunction() : _EMPTY_ELEMENT);
        this.aggrfunction.removeAllPopupItems();
        object3 = ((Vector)object4).iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            boolean bl3 = string.equals(object2);
            object = new JCheckBoxMenuItem(new AbstractAction((String)object2){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSONStructureAddAggregationPanel.this.changeAggregationFunction(actionEvent);
                }
            });
            ((AbstractButton)object).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    AbstractButton abstractButton = (AbstractButton)itemEvent.getItem();
                    String string = abstractButton.getText();
                    if (itemEvent.getStateChange() == 1) {
                        MenuElement[] menuElementArray;
                        for (MenuElement menuElement : menuElementArray = JSONStructureAddAggregationPanel.this.aggrfunction.getPopupMenu().getSubElements()) {
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)menuElement;
                            boolean bl = string.equals(jCheckBoxMenuItem.getText());
                            jCheckBoxMenuItem.setSelected(bl);
                        }
                    }
                }
            });
            ((AbstractButton)object).setSelected(bl3);
            this.aggrfunction.addPopupItem((JMenuItem)object);
        }
        boolean bl4 = false;
        if (!this.currentJSONSelectionList.isEmpty() && this.newAggregationElements != null && !this.newAggregationElements.getAggregationElement().isEmpty() && this.currentJSONSelectionList.size() <= this.newAggregationElements.getAggregationElement().size()) {
            bl4 = true;
            for (JSONAggregationElement jSONAggregationElement : this.currentJSONSelectionList) {
                object = ((JSONStructureDefaultTreeTableModel)((Object)object5)).getJSONElementPathByID(jSONAggregationElement.getElementID());
                boolean bl5 = false;
                for (AggregationElementsExType.AggregationElement aggregationElement : this.newAggregationElements.getAggregationElement()) {
                    if (!((String)object).equals(aggregationElement.getJSONAttribute().getPath())) continue;
                    bl5 = true;
                    break;
                }
                if (bl5) continue;
                bl4 = false;
                break;
            }
        }
        this.removeBtn.setEnabled(bl4);
        this.btnSubGroupBy.setEnabled(bl4);
    }

    @Override
    protected JSONStructureDefaultTreeTableModel loadJSONPanel(String string) {
        JSONStructureAddAggregationTreeTableModel jSONStructureAddAggregationTreeTableModel = (JSONStructureAddAggregationTreeTableModel)this.jsonTree.getTreeModel();
        jSONStructureAddAggregationTreeTableModel.loadJSONPanel(this.dataGuideInfo, this.editedJSONColumns, string);
        return jSONStructureAddAggregationTreeTableModel;
    }

    @Override
    protected void setPreferredColumnWidth() {
        this.jsonTree.getColumnModel().getColumn(JSONAggregationElement.JSON_ATTRIBUTE_COLUMN).setPreferredWidth(300);
        this.jsonTree.getColumnModel().getColumn(JSONAggregationElement.JSON_DATA_COLUMN).setPreferredWidth(10);
        this.jsonTree.getColumnModel().getColumn(JSONAggregationElement.JSON_FUNCTION_COLUMN).setPreferredWidth(10);
        this.jsonTree.getColumnModel().getColumn(JSONAggregationElement.JSON_OUTPUT_COLUMN).setPreferredWidth(40);
        this.jsonTree.getColumnModel().getColumn(JSONAggregationElement.JSON_SUBGROUP_BY_COLUMN).setPreferredWidth(60);
    }

    private void createComponents() {
        this.aggrfunction = new DropDownMenuButton();
        this.aggrfunction.setIcon((Icon)DataMinerIcons.get(Icons.AGGREGATION_FUNCTION));
        this.aggrfunction.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_DLG_FUNCTION"));
        this.aggrfunction.setEnabled(false);
        this.removeBtn = new JButton();
        this.removeBtn.setEnabled(false);
        this.btnSubGroupBy = new JButton();
        this.btnSubGroupBy.setEnabled(false);
    }

    @Override
    public void initRes() {
        super.initRes();
        this.createComponents();
        this.removeBtn.setIcon(OracleIcons.getIcon((String)"clear.png"));
        this.removeBtn.setToolTipText(DialogsLrb.get("JSON_TOOLBAR_CLEAR_AGG_DEFINITON_TOOLTIP"));
        this.btnSubGroupBy.setIcon(DataMinerIcons.get(Icons.SUB_GROUP_BY_EDIT));
        this.btnSubGroupBy.setToolTipText(DialogsLrb.get("JSON_TOOLBAR_EDIT_SUBGROUP_BY_TOOLTIP"));
    }

    @Override
    protected void updatePanelTitle() {
        if (null != this.newAggregationElements) {
            String string = JSON_SCHEMA_TITLE + ". " + AGGREGATION_COUNT + this.newAggregationElements.getAggregationElement().size();
            this.titleLabel.setText(string);
        }
    }

    @Override
    public void setupControlBar() {
        this.controlBar.add((Component)this.aggrfunction);
        this.controlBar.add((Component)this.btnSubGroupBy);
        this.btnSubGroupBy.setEnabled(false);
        this.btnSubGroupBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                int[] nArray = JSONStructureAddAggregationPanel.this.jsonTree.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    JSONStructureAddAggregationPanel.this.btnSubGroupBy.setEnabled(false);
                    JSONStructureAddAggregationPanel.this.removeBtn.setEnabled(false);
                    return;
                }
                ArrayList<AggregationElementsExType.AggregationElement> arrayList = new ArrayList<AggregationElementsExType.AggregationElement>();
                block0: for (int i = 0; i < nArray.length; ++i) {
                    serializable = JSONStructureAddAggregationPanel.this.jsonTree.getTree().getPathForRow(nArray[i]);
                    if (serializable == null) continue;
                    JSONAggregationElement jSONAggregationElement = (JSONAggregationElement)((Object)((TreePath)serializable).getLastPathComponent());
                    JSONStructureAddAggregationTreeTableModel jSONStructureAddAggregationTreeTableModel = (JSONStructureAddAggregationTreeTableModel)JSONStructureAddAggregationPanel.this.jsonTree.getTreeModel();
                    String string = jSONStructureAddAggregationTreeTableModel.getJSONElementPathByID(jSONAggregationElement.getElementID());
                    if (string == null) continue;
                    for (AggregationElementsExType.AggregationElement aggregationElement : JSONStructureAddAggregationPanel.this.newAggregationElements.getAggregationElement()) {
                        if (!string.equals(aggregationElement.getJSONAttribute().getPath())) continue;
                        arrayList.add(aggregationElement);
                        continue block0;
                    }
                }
                if (arrayList.isEmpty()) {
                    return;
                }
                if (arrayList.size() < nArray.length) {
                    MessageDialog.optionalInformation((String)JSONStructureAddAggregationPanel.MIXED_TYPE, (Component)Ide.getMainWindow(), (Object)WARNING_AGGREGATION_MIXED_SUB_GROUP_BY, (String)DialogsLrb.get("WARNING_TITLE"), null);
                }
                AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy = null;
                if (arrayList.size() == 1) {
                    subGroupBy = ((AggregationElementsExType.AggregationElement)arrayList.get(0)).getSubGroupBy();
                }
                if (subGroupBy == null) {
                    subGroupBy = new AggregationElementsExType.AggregationElement.SubGroupBy();
                    subGroupBy.setAttributes(new AggregationElementsExType.AggregationElement.SubGroupBy.Attributes());
                }
                if (((DialogDisplayer)(serializable = new AddSubGroupByColumnPanel(JSONStructureAddAggregationPanel.this.getContext(), (AbstractDataNode)JSONStructureAddAggregationPanel.this.enclosingPanel.getJSONQueryEditorPanel().getData(), JSONStructureAddAggregationPanel.this.enclosingPanel.getJSONQueryEditorPanel(), subGroupBy))).showAsDialog(JSONStructureAddAggregationPanel.this)) {
                    for (AggregationElementsExType.AggregationElement aggregationElement : arrayList) {
                        aggregationElement.setSubGroupBy(subGroupBy);
                        AttributeTypeHelper.setJSONOutputAttributeType(JSONStructureAddAggregationPanel.this.getContext(), aggregationElement.getOutput().getName(), aggregationElement);
                        JSONStructureAddAggregationPanel.this.addNewAggregationElement(aggregationElement);
                    }
                    JSONStructureAddAggregationPanel.this.updateWarning();
                }
                for (int i = 0; i < nArray.length; ++i) {
                    JSONStructureAddAggregationPanel.this.jsonTree.getSelectionModel().addSelectionInterval(nArray[i], nArray[i]);
                }
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray;
                int[] nArray = JSONStructureAddAggregationPanel.this.jsonTree.getSelectedRows();
                if (nArray == null || nArray.length == 0) {
                    return;
                }
                ArrayList<AggregationElementsExType.AggregationElement> arrayList = new ArrayList<AggregationElementsExType.AggregationElement>();
                block0: for (int i = 0; i < nArray.length; ++i) {
                    componentArray = JSONStructureAddAggregationPanel.this.jsonTree.getTree().getPathForRow(nArray[i]);
                    if (componentArray == null) continue;
                    Component[] componentArray2 = (Component[])componentArray.getLastPathComponent();
                    JSONStructureAddAggregationTreeTableModel jSONStructureAddAggregationTreeTableModel = (JSONStructureAddAggregationTreeTableModel)JSONStructureAddAggregationPanel.this.jsonTree.getTreeModel();
                    String string = jSONStructureAddAggregationTreeTableModel.getJSONElementPathByID(componentArray2.getElementID());
                    if (string == null) continue;
                    for (Object object : JSONStructureAddAggregationPanel.this.newAggregationElements.getAggregationElement()) {
                        if (!string.equals(object.getJSONAttribute().getPath())) continue;
                        arrayList.add((AggregationElementsExType.AggregationElement)object);
                        componentArray2.setSubGroupBy(null);
                        componentArray2.setFunction(null);
                        componentArray2.setOutput(null);
                        continue block0;
                    }
                }
                if (arrayList.isEmpty()) {
                    return;
                }
                JSONStructureAddAggregationPanel.this.newAggregationElements.getAggregationElement().removeAll(arrayList);
                JSONStructureAddAggregationPanel.this.updateWarning();
                JSONStructureAddAggregationPanel.this.updatePanelTitle();
                JSONStructureAddAggregationPanel.this.jsonTree.updateUI();
                JSONStructureAddAggregationPanel.this.removeBtn.setEnabled(false);
                JSONStructureAddAggregationPanel.this.btnSubGroupBy.setEnabled(false);
                JPopupMenu jPopupMenu = JSONStructureAddAggregationPanel.this.aggrfunction.getPopupMenu();
                componentArray = jPopupMenu.getComponents();
                if (componentArray != null && componentArray.length > 0) {
                    for (Component component : componentArray) {
                        Object object;
                        object = (JCheckBoxMenuItem)component;
                        ((AbstractButton)object).setSelected(false);
                    }
                }
            }
        });
        this.controlBar.add((Component)this.removeBtn);
        super.setupControlBar();
    }

    private void changeAggregationFunction(ActionEvent actionEvent) {
        String string;
        if (this.currentJSONSelectionList == null || this.currentJSONSelectionList.isEmpty()) {
            return;
        }
        String string2 = actionEvent.getActionCommand();
        if (string2 == null) {
            return;
        }
        int[] nArray = this.jsonTree.getSelectedRows();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            TreePath treePath = this.jsonTree.getTree().getPathForRow(nArray[i]);
            JSONAggregationElement jSONAggregationElement = (JSONAggregationElement)((Object)treePath.getLastPathComponent());
            string = jSONAggregationElement.getDataType();
            if (DatabaseMetadataUtils.isPrimitiveJSONType(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            MessageDialog.optionalInformation((String)MIXED_TYPE, (Component)Ide.getMainWindow(), (Object)WARNING_AGGREGATION_MIXED_TYPES, (String)DialogsLrb.get("WARNING_TITLE"), null);
        }
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        for (JSONAggregationElement jSONAggregationElement : this.currentJSONSelectionList) {
            AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy;
            string = jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONAggregationElement.getElementID());
            AggregationElementsExType.AggregationElement aggregationElement = this.findMatchingAggregationElement(string);
            if (string2.equals(_EMPTY_ELEMENT)) {
                if (aggregationElement == null) continue;
                aggregationElement.setAggregationFunction(null);
                jSONAggregationElement.setFunction(null);
                jSONAggregationElement.setOutput(null);
                continue;
            }
            JSONAttributeType jSONAttributeType = new JSONAttributeType();
            jSONAttributeType.setPath(string);
            int n = string.lastIndexOf(".");
            String string3 = string.substring(n + 1, string.length());
            String string4 = StringUtils.trimDoubleQuotes(string3);
            string4 = string4.toUpperCase();
            string4 = string4.replaceAll("\\s+", "");
            jSONAttributeType.setDataType((String)jSONAggregationElement.getValue(JSONElement.JSON_DATA_COLUMN));
            if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                jSONAttributeType.setUnnest(Boolean.TRUE);
            }
            jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONAggregationElement.getValue(JSONElement.JSON_DATA_COLUMN)));
            jSONAttributeType.setDBName(this.enclosingPanel.getJSONQueryEditorPanel().getNameGenerator().GenerateName(string4, jSONAttributeType.getPath()));
            jSONAttributeType.setStatus(AttributeStatus.VALID);
            AggregationElementsExType.AggregationElement aggregationElement2 = null;
            if (aggregationElement != null) {
                aggregationElement2 = aggregationElement;
            } else {
                aggregationElement2 = new AggregationElementsExType.AggregationElement();
                subGroupBy = new AggregationElementsExType.AggregationElement.SubGroupBy();
                subGroupBy.setAttributes(new AggregationElementsExType.AggregationElement.SubGroupBy.Attributes());
                aggregationElement2.setSubGroupBy(subGroupBy);
                this.newAggregationElements.getAggregationElement().add(aggregationElement2);
            }
            aggregationElement2.setJSONAttribute(jSONAttributeType);
            aggregationElement2.setAggregationFunction(string2);
            subGroupBy = new AggregationElementsExType();
            subGroupBy.getAggregationElement().addAll(this.newAggregationElements.getAggregationElement());
            subGroupBy.getAggregationElement().addAll(this.previousAggregationElements.getAggregationElement());
            String string5 = AttributeTypeHelper.createUniqueJSONAggregationOutputName(this._context, string4, DatabaseMetadataUtils.AggregateFunctions.toAggregateName(string2), subGroupBy.getAggregationElement());
            AttributeTypeHelper.setJSONOutputAttributeType(this.getContext(), string5, aggregationElement2);
            jSONAggregationElement.setOutput(string5);
            jSONAggregationElement.setFunction(string2);
        }
        this.updatePanelTitle();
        this.btnSubGroupBy.setEnabled(true);
        this.removeBtn.setEnabled(true);
        this.jsonTree.getTree().updateUI();
        for (int i = 0; i < nArray.length; ++i) {
            this.jsonTree.getSelectionModel().addSelectionInterval(nArray[i], nArray[i]);
        }
    }

    @Override
    public List<JSONAttributeType> getSubGroupByJSONAttributes(int n) {
        List list = null;
        TreePath treePath = this.jsonTree.getTree().getPathForRow(n);
        if (treePath == null) {
            return list;
        }
        JSONAggregationElement jSONAggregationElement = (JSONAggregationElement)((Object)treePath.getLastPathComponent());
        JSONStructureAddAggregationTreeTableModel jSONStructureAddAggregationTreeTableModel = (JSONStructureAddAggregationTreeTableModel)this.jsonTree.getTreeModel();
        String string = jSONStructureAddAggregationTreeTableModel.getJSONElementPathByID(jSONAggregationElement.getElementID());
        if (string == null) {
            return list;
        }
        if (this.newAggregationElements == null) {
            return list;
        }
        for (AggregationElementsExType.AggregationElement aggregationElement : this.newAggregationElements.getAggregationElement()) {
            if (!string.equals(aggregationElement.getJSONAttribute().getPath())) continue;
            list = aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute();
            break;
        }
        return list;
    }

    @Override
    public JPanel getParentPanel() {
        return this;
    }

    @Override
    public AggregationElementsExType.AggregationElement getAggregationElement(int n) {
        TreePath treePath = this.jsonTree.getTree().getPathForRow(n);
        return this.getAggregationElement(treePath);
    }

    @Override
    public AggregationElementsExType.AggregationElement getAggregationElement() {
        AggregationElementsExType.AggregationElement aggregationElement = null;
        int[] nArray = this.jsonTree.getSelectedRows();
        if (nArray == null || 1 != nArray.length) {
            return aggregationElement;
        }
        TreePath treePath = this.jsonTree.getTree().getPathForRow(nArray[0]);
        return this.getAggregationElement(treePath);
    }

    private AggregationElementsExType.AggregationElement getAggregationElement(TreePath treePath) {
        AggregationElementsExType.AggregationElement aggregationElement = null;
        if (treePath == null) {
            return aggregationElement;
        }
        JSONAggregationElement jSONAggregationElement = (JSONAggregationElement)((Object)treePath.getLastPathComponent());
        String string = jSONAggregationElement.getDataType();
        if (!DatabaseMetadataUtils.isPrimitiveJSONType(string)) {
            return aggregationElement;
        }
        JSONStructureAddAggregationTreeTableModel jSONStructureAddAggregationTreeTableModel = (JSONStructureAddAggregationTreeTableModel)this.jsonTree.getTreeModel();
        String string2 = jSONStructureAddAggregationTreeTableModel.getJSONElementPathByID(jSONAggregationElement.getElementID());
        if (string2 == null) {
            return aggregationElement;
        }
        for (AggregationElementsExType.AggregationElement aggregationElement2 : this.newAggregationElements.getAggregationElement()) {
            if (!string2.equals(aggregationElement2.getJSONAttribute().getPath())) continue;
            aggregationElement = aggregationElement2;
            break;
        }
        if (aggregationElement == null) {
            var7_7 = new JSONAttributeType();
            var7_7.setPath(string2);
            int n = string2.lastIndexOf(".");
            String string3 = string2.substring(n + 1, string2.length());
            String string4 = StringUtils.trimDoubleQuotes(string3);
            string4 = string4.toUpperCase();
            string4 = string4.replaceAll("\\s+", "");
            var7_7.setDataType((String)jSONAggregationElement.getValue(JSONElement.JSON_DATA_COLUMN));
            if (var7_7.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                var7_7.setUnnest(Boolean.TRUE);
            }
            var7_7.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONAggregationElement.getValue(JSONElement.JSON_DATA_COLUMN)));
            var7_7.setDBName(this.enclosingPanel.getJSONQueryEditorPanel().getNameGenerator().GenerateName(string4, var7_7.getPath()));
            var7_7.setStatus(AttributeStatus.VALID);
            aggregationElement = new AggregationElementsExType.AggregationElement();
            aggregationElement.setJSONAttribute(var7_7);
            AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy = new AggregationElementsExType.AggregationElement.SubGroupBy();
            subGroupBy.setAttributes(new AggregationElementsExType.AggregationElement.SubGroupBy.Attributes());
            aggregationElement.setSubGroupBy(subGroupBy);
        } else if (null == aggregationElement.getSubGroupBy()) {
            var7_7 = new AggregationElementsExType.AggregationElement.SubGroupBy();
            var7_7.setAttributes(new AggregationElementsExType.AggregationElement.SubGroupBy.Attributes());
            aggregationElement.setSubGroupBy((AggregationElementsExType.AggregationElement.SubGroupBy)var7_7);
        }
        return aggregationElement;
    }

    public AggregationElementsExType.AggregationElement getTableAggregationElement(int n) {
        return null;
    }

    @Override
    public boolean isOutputNameUnique(String string) {
        return true;
    }

    @Override
    public void addNewAggregationElement(AggregationElementsExType.AggregationElement aggregationElement) {
        if (this.newAggregationElements.getAggregationElement().contains(aggregationElement)) {
            this.updateWarning();
            return;
        }
        this.newAggregationElements.getAggregationElement().add(aggregationElement);
        this.updateWarning();
        this.updatePanelTitle();
    }

    private AggregationElementsExType.AggregationElement findMatchingAggregationElement(String string) {
        AggregationElementsExType.AggregationElement aggregationElement = null;
        if (null == this.newAggregationElements) {
            return aggregationElement;
        }
        List list = this.newAggregationElements.getAggregationElement();
        for (AggregationElementsExType.AggregationElement aggregationElement2 : list) {
            if (!aggregationElement2.getJSONAttribute().getPath().equals(string)) continue;
            aggregationElement = aggregationElement2;
            break;
        }
        return aggregationElement;
    }

    @Override
    public void setOutputName(String string, int n) {
    }

    @Override
    public void setAggregationFunction(String string, int n) {
        AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy;
        JSONStructureDefaultTreeTableModel jSONStructureDefaultTreeTableModel = (JSONStructureDefaultTreeTableModel)this.jsonTree.getTreeModel();
        TreePath treePath = this.jsonTree.getTree().getPathForRow(n);
        JSONAggregationElement jSONAggregationElement = (JSONAggregationElement)((Object)treePath.getLastPathComponent());
        String string2 = jSONStructureDefaultTreeTableModel.getJSONElementPathByID(jSONAggregationElement.getElementID());
        AggregationElementsExType.AggregationElement aggregationElement = this.findMatchingAggregationElement(string2);
        JSONAttributeType jSONAttributeType = new JSONAttributeType();
        jSONAttributeType.setPath(string2);
        int n2 = string2.lastIndexOf(".");
        String string3 = string2.substring(n2 + 1, string2.length());
        String string4 = StringUtils.trimDoubleQuotes(string3);
        string4 = string4.toUpperCase();
        string4 = string4.replaceAll("\\s+", "");
        jSONAttributeType.setDataType((String)jSONAggregationElement.getValue(JSONElement.JSON_DATA_COLUMN));
        if (jSONAttributeType.getDataType().compareToIgnoreCase("ARRAY") == 0) {
            jSONAttributeType.setUnnest(Boolean.TRUE);
        }
        jSONAttributeType.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType((String)jSONAggregationElement.getValue(JSONElement.JSON_DATA_COLUMN)));
        jSONAttributeType.setDBName(this.enclosingPanel.getJSONQueryEditorPanel().getNameGenerator().GenerateName(string4, jSONAttributeType.getPath()));
        jSONAttributeType.setStatus(AttributeStatus.VALID);
        AggregationElementsExType.AggregationElement aggregationElement2 = null;
        if (aggregationElement != null) {
            aggregationElement2 = aggregationElement;
        } else {
            aggregationElement2 = new AggregationElementsExType.AggregationElement();
            subGroupBy = new AggregationElementsExType.AggregationElement.SubGroupBy();
            subGroupBy.setAttributes(new AggregationElementsExType.AggregationElement.SubGroupBy.Attributes());
            aggregationElement2.setSubGroupBy(subGroupBy);
            this.newAggregationElements.getAggregationElement().add(aggregationElement2);
        }
        aggregationElement2.setJSONAttribute(jSONAttributeType);
        if (string.equals(_EMPTY_ELEMENT)) {
            aggregationElement2.setAggregationFunction(null);
            aggregationElement2.setOutput(null);
            jSONAggregationElement.setFunction(null);
            jSONAggregationElement.setOutput(null);
        } else {
            aggregationElement2.setAggregationFunction(string);
            subGroupBy = new AggregationElementsExType();
            subGroupBy.getAggregationElement().addAll(this.newAggregationElements.getAggregationElement());
            subGroupBy.getAggregationElement().addAll(this.previousAggregationElements.getAggregationElement());
            String string5 = AttributeTypeHelper.createUniqueJSONAggregationOutputName(this._context, string4, DatabaseMetadataUtils.AggregateFunctions.toAggregateName(string), subGroupBy.getAggregationElement());
            AttributeTypeHelper.setJSONOutputAttributeType(this.getContext(), string5, aggregationElement2);
            jSONAggregationElement.setOutput(string5);
            jSONAggregationElement.setFunction(string);
        }
        this.updatePanelTitle();
        this.removeBtn.setEnabled(true);
        this.aggrfunction.setEnabled(true);
        this.btnSubGroupBy.setEnabled(true);
        this.jsonTree.updateUI();
    }

    static {
        Collections.sort(catAggregateFunctions);
        Collections.sort(numAggregateFunctions);
        Collections.sort(mixedFunctions);
    }
}

