/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;

public class FilterParser {
    private static final String ARRAY_TYPE = "ARRAY";
    private static final String STRING_TYPE = "STRING";
    private static final String NUMBER_TYPE = "NUMBER";
    static final char ITEM_SEPARATOR = ';';
    static final char RANGE_SEPARATOR = ':';
    private static FilterParser parser = null;

    private FilterParser() {
    }

    private boolean isPositvieInteger(String string) {
        return Pattern.matches("\\d+", string);
    }

    private boolean isNumber(String string) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        return Pattern.matches("-?\\d*(\\" + decimalFormatSymbols.getDecimalSeparator() + "\\d+)?", string);
    }

    private List ParseHelper(String string, String string2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(string2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            Object object;
            char c = stringBuffer.charAt(i);
            if (c == '\"' && !bl) {
                bl = true;
                if (!STRING_TYPE.equals(string)) {
                    String string5 = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_CHAR_POS_ERROR"), Character.valueOf(c), i + 1);
                    throw new Exception(string5);
                }
                stringBuffer2.append(c);
                continue;
            }
            if (c == '\"' && bl) {
                int n;
                int n2 = n = i + 1 < stringBuffer.length() ? (int)stringBuffer.charAt(i + 1) : 32;
                if (n == 34) {
                    stringBuffer2.append(c);
                    ++i;
                    continue;
                }
                bl = false;
                stringBuffer2.append(c);
                object = stringBuffer2.toString().trim();
                if (ARRAY_TYPE.equals(string) && !this.isPositvieInteger((String)object)) {
                    String string6 = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_INTEGER_POS_ERROR"), object, i - ((String)object).length() + 1);
                    throw new Exception(string6);
                }
                if (NUMBER_TYPE.equals(string) && !this.isNumber((String)object)) {
                    String string7 = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_NUMBER_POS_ERROR"), object, i - ((String)object).length() + 1);
                    throw new Exception(string7);
                }
                arrayList.add(object);
                stringBuffer2.setLength(0);
                continue;
            }
            if (c == ';' && !bl) {
                if (stringBuffer2.length() > 0) {
                    String string8 = stringBuffer2.toString().trim();
                    if (!string8.equals("null")) {
                        if (ARRAY_TYPE.equals(string) && !this.isPositvieInteger(string8)) {
                            object = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_INTEGER_POS_ERROR"), string8, i - string8.length() + 1);
                            throw new Exception((String)object);
                        }
                        if (NUMBER_TYPE.equals(string) && !this.isNumber(string8)) {
                            object = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_NUMBER_POS_ERROR"), string8, i - string8.length() + 1);
                            throw new Exception((String)object);
                        }
                    }
                    if (string3 != null) {
                        if (string8.equals("null")) {
                            object = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_RANGE_POS_ERROR"), string8, i - string8.length() + 1);
                            throw new Exception((String)object);
                        }
                        string4 = string8;
                        object = new ArrayList();
                        object.add(string3);
                        object.add(string4);
                        arrayList.add(object);
                        string3 = null;
                        string4 = null;
                    } else {
                        arrayList.add(string8);
                    }
                }
                stringBuffer2.setLength(0);
                continue;
            }
            if (c == ':' && !bl) {
                if (stringBuffer2.length() > 0) {
                    String string9 = stringBuffer2.toString().trim();
                    if (!string9.equals("null")) {
                        if (ARRAY_TYPE.equals(string) && !this.isPositvieInteger(string9)) {
                            object = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_INTEGER_POS_ERROR"), string9, i - string9.length() + 1);
                            throw new Exception((String)object);
                        }
                        if (NUMBER_TYPE.equals(string) && !this.isNumber(string9)) {
                            object = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_NUMBER_POS_ERROR"), string9, i - string9.length() + 1);
                            throw new Exception((String)object);
                        }
                    }
                    if (string3 != null || string9.equals("null")) {
                        object = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_RANGE_POS_ERROR"), string9, i - string9.length() + 1);
                        throw new Exception((String)object);
                    }
                    string3 = string9;
                }
                stringBuffer2.setLength(0);
                continue;
            }
            stringBuffer2.append(c);
        }
        if (bl) {
            throw new Exception(DialogsLrb.get("JSON_FILTER_PARSER_MISSING_MATCHING_QUOTE_ERROR"));
        }
        if (stringBuffer2.length() > 0) {
            String string10 = stringBuffer2.toString().trim();
            if (!string10.equals("null")) {
                if (ARRAY_TYPE.equals(string) && !this.isPositvieInteger(string10)) {
                    String string11 = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_INTEGER_ERROR"), string10);
                    throw new Exception(string11);
                }
                if (NUMBER_TYPE.equals(string) && !this.isNumber(string10)) {
                    String string12 = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_NUMBER_ERROR"), string10);
                    throw new Exception(string12);
                }
            }
            if (string3 != null) {
                if (string10.equals("null")) {
                    String string13 = MessageFormat.format(DialogsLrb.get("JSON_FILTER_PARSER_INVALID_RANGE_ERROR"), string10);
                    throw new Exception(string13);
                }
                string4 = string10;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(string3);
                arrayList2.add(string4);
                arrayList.add(arrayList2);
            } else {
                arrayList.add(string10);
            }
        }
        return arrayList;
    }

    public static FilterParser getInstance() {
        if (parser == null) {
            parser = new FilterParser();
        }
        return parser;
    }

    public List ParseArray(String string) throws Exception {
        return this.ParseHelper(ARRAY_TYPE, string);
    }

    public List ParseNumber(String string) throws Exception {
        return this.ParseHelper(NUMBER_TYPE, string);
    }

    public List ParseString(String string) throws Exception {
        return this.ParseHelper(STRING_TYPE, string);
    }
}

