/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.join.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.JoinNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JoinOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.RefDBColumnType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class AttrsPanel
extends DialogDisplayer<JoinNode> {
    private List<RefDBColumnType> availAttrsCache;
    private List<RefDBColumnType> selectedAttrsCache;
    private OutputColumnPanel _parent;
    private boolean _dirty = false;
    private DataMinerTable jAvailAttrs;
    private JScrollPane jAvailAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTable jSelectedAttrs;
    private JScrollPane jSelectedAttrsScrollPane;
    private JLabel jSelectedLabel;

    public AttrsPanel(Context context, OutputColumnPanel outputColumnPanel, List<AbstractNode> list, JoinOutputColumnsType joinOutputColumnsType) {
        super(context, (JoinNode)outputColumnPanel.getData());
        this._parent = outputColumnPanel;
        this.availAttrsCache = new ArrayList<RefDBColumnType>();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            DataProvider dataProvider = (DataProvider)((Object)abstractNode);
            List list2 = dataProvider.getAttributes().getAttribute();
            for (AttributeType attributeType : list2) {
                RefDBColumnType refDBColumnType = new RefDBColumnType();
                String string = attributeType.getAlias() == null ? attributeType.getName() : attributeType.getAlias();
                refDBColumnType.setName(string);
                refDBColumnType.setNodeId(abstractNode.getMetadataId());
                refDBColumnType.setNodeName(abstractNode.getData().getName());
                refDBColumnType.setDataType(attributeType.getDataType());
                refDBColumnType.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                refDBColumnType.setStatus(attributeType.getStatus());
                this.availAttrsCache.add(refDBColumnType);
            }
        }
        JoinOutputColumnsType joinOutputColumnsType2 = (JoinOutputColumnsType)MetaDataHelper.copyMetadataObject(joinOutputColumnsType);
        this.selectedAttrsCache = joinOutputColumnsType2.getRefDBColumn();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedAttrs = new DataMinerTable();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jAvailAttrsScrollPane = new JScrollPane();
        this.jAvailAttrs = new DataMinerTable();
        this.jSelectedAttrsScrollPane.setName("jSelectedAttrsScrollPane");
        this.jSelectedAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jSelectedAttrs.setName("jSelectedAttrs");
        this.jSelectedAttrsScrollPane.setViewportView((Component)((Object)this.jSelectedAttrs));
        this.jSelectBtn.setText(">");
        this.jSelectBtn.setName("jSelectBtn");
        this.jSelectAllBtn.setText(">>");
        this.jSelectAllBtn.setName("jSelectAllBtn");
        this.jRemoveBtn.setText("<");
        this.jRemoveBtn.setName("jRemoveBtn");
        this.jRemoveAllBtn.setText("<<");
        this.jRemoveAllBtn.setName("jRemoveAllBtn");
        this.jAvailableLabel.setText("Available Attributes");
        this.jAvailableLabel.setName("jAvailableLabel");
        this.jSelectedLabel.setText("Selected Attributes");
        this.jSelectedLabel.setName("jSelectedLabel");
        this.jAvailAttrsScrollPane.setName("jAvailAttrsScrollPane");
        this.jAvailAttrs.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"Name", "Data Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.jAvailAttrs.setName("jAvailAttrs");
        this.jAvailAttrsScrollPane.setViewportView((Component)((Object)this.jAvailAttrs));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -1, 375, Short.MAX_VALUE).addComponent(this.jAvailAttrsScrollPane, GroupLayout.Alignment.TRAILING, -1, 375, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 49, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 383, Short.MAX_VALUE).addComponent(this.jSelectedLabel, -1, 383, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSelectedLabel).addComponent(this.jAvailableLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -1, 275, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn)).addComponent(this.jAvailAttrsScrollPane, -1, 275, Short.MAX_VALUE)).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAvailableLabel, (Component)((Object)this.jAvailAttrs), (String)DataDialogsLrb.get("AVAILABLE_LABEL"));
        ResourceUtils.resLabel((JLabel)this.jSelectedLabel, (Component)((Object)this.jSelectedAttrs), (String)DataDialogsLrb.get("SELECTED_LABEL"));
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        RefAttrTableModel refAttrTableModel = new RefAttrTableModel(this._parent, this.availAttrsCache);
        this.jAvailAttrs.setModel((TableModel)((Object)refAttrTableModel));
        this.jAvailAttrs.setSorted(true);
        TableColumn tableColumn = this.jAvailAttrs.getColumnModel().getColumn(0);
        AttributeNameCellRenderer attributeNameCellRenderer = new AttributeNameCellRenderer(this.availAttrsCache, OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        RefAttrTableModel refAttrTableModel2 = new RefAttrTableModel(this._parent, this.selectedAttrsCache);
        this.jSelectedAttrs.setModel((TableModel)((Object)refAttrTableModel2));
        this.jSelectedAttrs.setSorted(true);
        tableColumn = this.jSelectedAttrs.getColumnModel().getColumn(0);
        attributeNameCellRenderer = new AttributeNameCellRenderer(this.selectedAttrsCache, OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        tableColumn.setCellRenderer(attributeNameCellRenderer);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jAvailAttrs, AttrsPanel.this.jSelectedAttrs, false);
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jAvailAttrs, AttrsPanel.this.jSelectedAttrs, true);
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jSelectedAttrs, AttrsPanel.this.jAvailAttrs, false);
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttrsPanel.this.moveItems(AttrsPanel.this.jSelectedAttrs, AttrsPanel.this.jAvailAttrs, true);
            }
        });
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        Object object2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((RefAttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<RefDBColumnType> arrayList = new ArrayList<RefDBColumnType>();
        if (!bl) {
            for (var7_7 = 0; var7_7 < nArray.length; ++var7_7) {
                object2 = (RefDBColumnType)list.get(nArray[var7_7]);
                arrayList.add((RefDBColumnType)object2);
            }
        } else {
            for (var7_7 = 0; var7_7 < list.size(); ++var7_7) {
                arrayList.add((RefDBColumnType)list.get(var7_7));
            }
        }
        for (Object object2 : arrayList) {
            n = list.indexOf(object2);
            if (n == -1) continue;
            list.remove(n);
        }
        List list2 = ((RefAttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((RefAttrTableModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((RefAttrTableModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        object2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n2 = list2.indexOf(arrayList.get(n));
            assert (n2 != -1) : "Unexpected state - added item should be present and must have an index";
            object2[n] = (RefDBColumnType)n2;
        }
        genericTable2.setSelectedRowsInModel((int[])object2);
        this._dirty = true;
    }

    private void removeSelectedAttrs(List<RefDBColumnType> list, List<RefDBColumnType> list2) {
        HashMap<CallSite, RefDBColumnType> hashMap = new HashMap<CallSite, RefDBColumnType>();
        for (RefDBColumnType refDBColumnType : list2) {
            hashMap.put((CallSite)((Object)(refDBColumnType.getNodeId() + "." + refDBColumnType.getName())), refDBColumnType);
        }
        Iterator<RefDBColumnType> iterator = list.iterator();
        while (iterator.hasNext()) {
            RefDBColumnType refDBColumnType;
            refDBColumnType = iterator.next();
            RefDBColumnType refDBColumnType2 = (RefDBColumnType)hashMap.get(refDBColumnType.getNodeId() + "." + refDBColumnType.getName());
            if (refDBColumnType2 == null || !refDBColumnType2.getName().equals(refDBColumnType.getName()) || !refDBColumnType2.getDataType().equals(refDBColumnType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        return bl;
    }

    public List<RefDBColumnType> getSelectedAttrsCache() {
        return this.selectedAttrsCache;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("JOIN_DATA_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "join_attributes";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setMinimumSize(new Dimension(650, 300));
    }

    private static class RefAttrTableModel
    extends AttrTableModel<RefDBColumnType> {
        private OutputColumnPanel parent;

        public RefAttrTableModel(OutputColumnPanel outputColumnPanel, List<RefDBColumnType> list) {
            super(list);
            this.parent = outputColumnPanel;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            RefDBColumnType refDBColumnType = (RefDBColumnType)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    object = ((JoinNode)this.parent.getData()).getDataNodeName(refDBColumnType.getNodeId()) + "." + refDBColumnType.getName();
                    break;
                }
                case 1: {
                    object = this.getDataType((AttributeType)refDBColumnType);
                    break;
                }
                default: {
                    super.getValueAt(n, n2);
                }
            }
            return object;
        }
    }

    private static class AttributeNameCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;
        private List<RefDBColumnType> _cache;

        public AttributeNameCellRenderer(List<RefDBColumnType> list, Icon icon, Icon icon2) {
            this._cache = list;
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            RefDBColumnType refDBColumnType = this._cache.get(n);
            AttributeStatus attributeStatus = refDBColumnType.getStatus();
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }
}

