/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.featureCompare;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.AttributeNameCellRenderer;
import oracle.dmt.dataminer.controls.renderers.TransferableRenderer;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.core.utils.comparator.NullComparator;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.FeatureCompareEditValuePanel;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.FeatureCompareEditorState;
import oracle.dmt.dataminer.workflow.inspect.WorkflowFeatureCompareNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.FeatureCompareNode;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureCompareNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelSignatureType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;

public class FeatureCompareInputPanel
extends JPanel {
    private boolean dirty;
    private boolean modelDirty;
    private Context context;
    private boolean updateFromUser;
    private FeatureCompareNode node;
    private boolean isSource1UserDefined;
    private boolean isSource2UserDefined;
    private FeatureCompareEditorState state;
    private FeatureCompareTableModel tableModel;
    private ModelSignatureType lastSelectedModel;
    private String lastSelectedDataInput1;
    private String lastSelectedDataInput2;
    private Map<String, Boolean> partitionedAttributes;
    private AttributeNameCellRenderer modelCellRenderer;
    private WorkflowFeatureCompareNodePropertyProxyModel propertyModel;
    private List<AttributeType> dataInput1Attributes;
    private List<AttributeType> dataInput2Attributes;
    public static final String CUSTOM = "CUSTOM";
    public static final String DATA_SOURCE = "DATA_SOURCE";
    public static final String DATA_SOURCE_1_PREFIX = "A.";
    public static final String DATA_SOURCE_2_PREFIX = "B.";
    public static final String USER_DEFINED_ID = "-1";
    public static final String REPEATED_ATTRIBUTE_SUFFIX = "_2";
    public static final String RESULT_SUFFIX = "_FCOMP";
    private AttributeType NONE_ATTRIBUTE;
    private ModelSignatureType EMPTY_MODEL;
    private DataSourceNode USER_DEFINED;
    private AttributeType EMPTY_CASE_ID;
    private JCheckBox autoCheckBox;
    private DataMinerCombBox<AttributeType> caseId1ComboBox;
    private JLabel caseId1Label;
    private JLabel caseId1Warning;
    private DataMinerCombBox<AttributeType> caseId2ComboBox;
    private JLabel caseId2Label;
    private JLabel caseId2Warning;
    private JLabel columnLabel;
    private JTextField columnTextField;
    private DataMinerCombBox<AbstractDataNode> dataInput1ComboBox;
    private JLabel dataInput1Label;
    private JLabel dataInput1Warning;
    private DataMinerCombBox<AbstractDataNode> dataInput2ComboBox;
    private JLabel dataInput2Label;
    private JLabel dataInput2Warning;
    private DataMinerTablePanel dataMinerTablePanel1;
    private DataMinerCombBox<ModelSignatureType> modelComboBox;
    private JLabel modelLabel;
    private JLabel modelWarning;

    public FeatureCompareInputPanel(Context context, FeatureCompareNode featureCompareNode, FeatureCompareEditorState featureCompareEditorState, PropertyModel propertyModel) {
        this.node = featureCompareNode;
        this.context = context;
        this.propertyModel = (WorkflowFeatureCompareNodePropertyProxyModel)propertyModel;
        this.state = featureCompareEditorState;
        this.tableModel = new FeatureCompareTableModel((List<FeatureCompareEntry>)new ArrayList<FeatureCompareEntry>());
        this.modelCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        this.updateFromUser = true;
        this.initDefaultValues();
        this.lastSelectedModel = this.EMPTY_MODEL;
        this.lastSelectedDataInput1 = USER_DEFINED_ID;
        this.lastSelectedDataInput2 = USER_DEFINED_ID;
        this.dataInput1Attributes = new ArrayList<AttributeType>();
        this.dataInput2Attributes = new ArrayList<AttributeType>();
        this.initComponents();
        this.initRes();
        this.setupWidgets();
        this.initListeners();
    }

    public FeatureCompareInputPanel(PropertyModel propertyModel) {
        assert (propertyModel != null) : "PropertyModel for fc node is null.";
        this.context = this.getContext(propertyModel);
        this.node = this.getTargetNode(propertyModel);
        this.propertyModel = (WorkflowFeatureCompareNodePropertyProxyModel)propertyModel;
        this.state = new FeatureCompareEditorState();
        this.tableModel = new FeatureCompareTableModel((List<FeatureCompareEntry>)new ArrayList<FeatureCompareEntry>());
        this.modelCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        this.updateFromUser = true;
        this.initDefaultValues();
        this.lastSelectedModel = this.EMPTY_MODEL;
        this.lastSelectedDataInput1 = USER_DEFINED_ID;
        this.lastSelectedDataInput2 = USER_DEFINED_ID;
        this.dataInput1Attributes = new ArrayList<AttributeType>();
        this.dataInput2Attributes = new ArrayList<AttributeType>();
        this.initComponents();
        this.initRes();
        this.setupWidgets();
        this.initListeners();
    }

    private void initDefaultValues() {
        this.EMPTY_MODEL = new ModelSignatureType();
        this.USER_DEFINED = new DataSourceNode("", new NodeType(), this.context);
        this.EMPTY_CASE_ID = new AttributeType();
        this.NONE_ATTRIBUTE = new AttributeType();
        ModelInfoType modelInfoType = new ModelInfoType();
        modelInfoType.setName(DialogsLrb.get("EMPTY_COMBO"));
        modelInfoType.setSchema("");
        modelInfoType.setMiningFunction(MiningFunctionType.FEATURE_EXTRACTION);
        modelInfoType.setStatus(RefModelStatusType.INVALID);
        modelInfoType.setMiningAlgorithm(MiningAlgorithmType.ALL);
        modelInfoType.setUseForOutput(false);
        modelInfoType.setModelId("");
        this.EMPTY_MODEL.setModel(modelInfoType);
        this.EMPTY_MODEL.setAttributes(new Attributes());
        this.USER_DEFINED.getData().setName(DialogsLrb.get("USER_DEFINED"));
        this.USER_DEFINED.getData().setId(USER_DEFINED_ID);
        this.EMPTY_CASE_ID.setName(DialogsLrb.get("EMPTY_COMBO"));
        this.EMPTY_CASE_ID.setDataType("");
        this.EMPTY_CASE_ID.setAlias("");
        this.EMPTY_CASE_ID.setAnnotation("");
        this.EMPTY_CASE_ID.setDataTypeQualifier("");
        this.EMPTY_CASE_ID.setStatus(AttributeStatus.INVALID);
        this.NONE_ATTRIBUTE.setName(DialogsLrb.get("EMPTY_COMBO"));
        this.NONE_ATTRIBUTE.setDataType("");
        this.NONE_ATTRIBUTE.setAlias("");
        this.NONE_ATTRIBUTE.setAnnotation("");
        this.NONE_ATTRIBUTE.setDataTypeQualifier("");
        this.NONE_ATTRIBUTE.setStatus(AttributeStatus.VALID);
    }

    private Context getContext(PropertyModel propertyModel) {
        Context context = null;
        if (propertyModel instanceof WorkflowFeatureCompareNodePropertyProxyModel) {
            WorkflowFeatureCompareNodePropertyProxyModel workflowFeatureCompareNodePropertyProxyModel = (WorkflowFeatureCompareNodePropertyProxyModel)propertyModel;
            context = workflowFeatureCompareNodePropertyProxyModel.getSelectionContext();
        }
        return context;
    }

    private FeatureCompareNode getTargetNode(PropertyModel propertyModel) {
        WorkflowFeatureCompareNodePropertyProxyModel workflowFeatureCompareNodePropertyProxyModel;
        Context context;
        Element[] elementArray;
        WorkflowNodeInspectorElement workflowNodeInspectorElement;
        NodeType nodeType;
        FeatureCompareNode featureCompareNode = null;
        if (propertyModel instanceof WorkflowFeatureCompareNodePropertyProxyModel && (nodeType = (workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)(elementArray = (context = (workflowFeatureCompareNodePropertyProxyModel = (WorkflowFeatureCompareNodePropertyProxyModel)propertyModel).getSelectionContext()).getSelection())[0].getData())).getNode().getData()) instanceof FeatureCompareNodeType) {
            featureCompareNode = (FeatureCompareNode)workflowNodeInspectorElement.getNode();
        }
        return featureCompareNode;
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowFeatureCompareNodePropertyProxyModel workflowFeatureCompareNodePropertyProxyModel = (WorkflowFeatureCompareNodePropertyProxyModel)propertyModel;
        Context context = workflowFeatureCompareNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        FeatureCompareNode featureCompareNode = (FeatureCompareNode)workflowNodeInspectorElement.getNode();
        if (featureCompareNode != null) {
            this.propertyModel = (WorkflowFeatureCompareNodePropertyProxyModel)propertyModel;
            this.context = context;
            this.node = featureCompareNode;
            this.dirty = false;
            this.modelDirty = false;
            this.setupModelComboBox();
            this.setupDataSourceComboBox();
            this.setupColumnName();
        }
    }

    private boolean isPIMode() {
        return this.propertyModel != null;
    }

    private void updateNode() {
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.node.getData();
        featureCompareNodeType.setModelSignature(this.getSelectedModel());
        featureCompareNodeType.getOutputColumn().setName(this.getColumnName());
        featureCompareNodeType.getOutputColumn().setAutoSpec(this.isAutoColumn() ? AutoSpecType.YES : AutoSpecType.NO);
        featureCompareNodeType.setDataInput1(this.getDataInput1());
        featureCompareNodeType.setDataInput2(this.getDataInput2());
        if (this.node.validate(true)) {
            featureCompareNodeType.setSQLExpression(this.node.generateSQLExpression());
        }
    }

    private void tableModelChanged() {
        ModelSignatureType modelSignatureType = (ModelSignatureType)this.modelComboBox.getSelectedItem();
        ArrayList<FeatureCompareEntry> arrayList = new ArrayList<FeatureCompareEntry>();
        this.setModelCellRenderer(modelSignatureType);
        HashMap<String, FeatureCompareEntry> hashMap = new HashMap<String, FeatureCompareEntry>();
        for (FeatureCompareEntry featureCompareEntry : this.tableModel.getSrcData()) {
            hashMap.put(featureCompareEntry.getModelAttribute().getName(), featureCompareEntry);
        }
        for (int i = 0; i < modelSignatureType.getAttributes().getAttribute().size(); ++i) {
            FeatureCompareEntry featureCompareEntry;
            featureCompareEntry = (AttributeType)modelSignatureType.getAttributes().getAttribute().get(i);
            Object object = this.NONE_ATTRIBUTE;
            Object object2 = this.NONE_ATTRIBUTE;
            if (hashMap.containsKey(featureCompareEntry.getName()) && ((FeatureCompareEntry)hashMap.get(featureCompareEntry.getName())).getModelAttribute().getDataType().equals(featureCompareEntry.getDataType())) {
                object = ((FeatureCompareEntry)hashMap.get(featureCompareEntry.getName())).getDataInput1();
                object2 = ((FeatureCompareEntry)hashMap.get(featureCompareEntry.getName())).getDataInput2();
            }
            arrayList.add(new FeatureCompareEntry((AttributeType)featureCompareEntry, object, object2, this.partitionedAttributes.containsKey(featureCompareEntry.getName())));
        }
        this.tableModel.setSrcData(arrayList);
        this.populateAttributes(FeatureCompareNode.DataInput.INPUT_1);
        this.populateAttributes(FeatureCompareNode.DataInput.INPUT_2);
    }

    private void setModelCellRenderer(ModelSignatureType modelSignatureType) {
        this.partitionedAttributes.clear();
        List<String> list = this.node.getPartitionAttributes(modelSignatureType);
        for (String string : list) {
            this.partitionedAttributes.put(string, false);
        }
        this.modelCellRenderer.setPartitions(list);
    }

    private void setupTable() {
        Object object;
        ArrayList<FeatureCompareEntry> arrayList = new ArrayList<FeatureCompareEntry>();
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.node.getData();
        ModelSignatureType modelSignatureType = featureCompareNodeType.getModelSignature().getModel().getName().equals("") ? (ModelSignatureType)this.modelComboBox.getModel().getSelectedItem() : featureCompareNodeType.getModelSignature();
        this.setModelCellRenderer(modelSignatureType);
        InputSourceType inputSourceType = ((FeatureCompareNodeType)this.node.getData()).getDataInput1();
        InputSourceType inputSourceType2 = ((FeatureCompareNodeType)this.node.getData()).getDataInput2();
        for (int i = 0; i < modelSignatureType.getAttributes().getAttribute().size(); ++i) {
            AttributeType attributeType = (AttributeType)modelSignatureType.getAttributes().getAttribute().get(i);
            object = new AttributeType();
            Object object2 = new AttributeType();
            object = inputSourceType.getDataSource() != null && inputSourceType.getDataSource().getAttributes().getAttribute().size() > 0 ? inputSourceType.getDataSource().getAttributes().getAttribute().get(i) : (inputSourceType.getCustom() != null && inputSourceType.getCustom().getAttributes().getAttribute().size() > 0 ? inputSourceType.getCustom().getAttributes().getAttribute().get(i) : this.NONE_ATTRIBUTE);
            object2 = inputSourceType2.getDataSource() != null && inputSourceType2.getDataSource().getAttributes().getAttribute().size() > 0 ? inputSourceType2.getDataSource().getAttributes().getAttribute().get(i) : (inputSourceType2.getCustom() != null && inputSourceType2.getCustom().getAttributes().getAttribute().size() > 0 ? inputSourceType2.getCustom().getAttributes().getAttribute().get(i) : this.NONE_ATTRIBUTE);
            if (this.partitionedAttributes.get(attributeType.getName()) == null) {
                arrayList.add(new FeatureCompareEntry(attributeType, object, object2, false));
                continue;
            }
            arrayList.add(new FeatureCompareEntry(attributeType, object, object2, true));
            if (!(object instanceof InputSourceType.Custom.Attributes.Attribute) && !object.getName().equals(this.NONE_ATTRIBUTE.getName())) {
                this.state.addPartitionedAttrInput1(object.getName(), (AttributeType)object);
            }
            if (object2 instanceof InputSourceType.Custom.Attributes.Attribute || object2.getName().equals(this.NONE_ATTRIBUTE.getName())) continue;
            this.state.addPartitionedAttrInput2(object2.getName(), (AttributeType)object2);
        }
        for (AttributeType attributeType : featureCompareNodeType.getSupplementalAttributes().getAttribute()) {
            object = new AttributeType();
            object.setName(attributeType.getName());
            object.setAlias(attributeType.getAlias());
            object.setDataType(attributeType.getDataType());
            object.setStatus(attributeType.getStatus());
            object.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            object.setAnnotation(attributeType.getAnnotation());
            if (attributeType.getName().startsWith(DATA_SOURCE_1_PREFIX) && !this.state.getPartitionedAttrsInput1().containsKey(attributeType.getName().substring(2))) {
                object.setName(object.getName().substring(2));
                this.state.addAdditionalOutput1(object.getName(), (AttributeType)object);
                continue;
            }
            if (!attributeType.getName().startsWith(DATA_SOURCE_2_PREFIX) || this.state.getPartitionedAttrsInput2().containsKey(attributeType.getName().substring(2))) continue;
            object.setName(object.getName().substring(2));
            this.state.addAdditionalOutput2(object.getName(), (AttributeType)object);
        }
        this.tableModel.setSrcData(arrayList);
    }

    private void setupModelComboBox() {
        List<ModelSignatureType> list = this.node.getAvailableModels().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        ModelSignatureType modelSignatureType = ((FeatureCompareNodeType)this.node.getData()).getModelSignature();
        list.add(0, this.EMPTY_MODEL);
        DefaultComboBoxModel<ModelSignatureType> defaultComboBoxModel = new DefaultComboBoxModel<ModelSignatureType>(list.toArray(new ModelSignatureType[list.size()]));
        if (!modelSignatureType.getModel().getName().equals("") && !modelSignatureType.getModel().getName().equals(this.EMPTY_MODEL.getModel().getName())) {
            Optional<ModelSignatureType> optional = list.stream().filter(modelSignatureType2 -> StringUtils.isNotEmpty((String)modelSignatureType2.getModel().getModelId()) && modelSignatureType2.getModel().getModelId().equals(modelSignatureType.getModel().getModelId())).findFirst();
            if (!optional.isPresent()) {
                defaultComboBoxModel.setSelectedItem(modelSignatureType);
                this.modelWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
                this.lastSelectedModel = modelSignatureType;
            } else {
                defaultComboBoxModel.setSelectedItem(optional.get());
                this.modelWarning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                this.lastSelectedModel = optional.get();
            }
            this.modelComboBox.setModel(defaultComboBoxModel);
            this.setupTable();
        } else {
            this.modelComboBox.setModel(defaultComboBoxModel);
        }
    }

    private void setupDataSourceComboBox() {
        Optional<AbstractDataNode> optional;
        InputSourceType inputSourceType;
        List<AbstractDataNode> list = this.node.findDataSourceNodes();
        FeatureCompareNodeType featureCompareNodeType = (FeatureCompareNodeType)this.node.getData();
        list.add(0, this.USER_DEFINED);
        DefaultComboBoxModel<AbstractDataNode> defaultComboBoxModel = new DefaultComboBoxModel<AbstractDataNode>(list.toArray(new AbstractDataNode[list.size()]));
        DefaultComboBoxModel<AbstractDataNode> defaultComboBoxModel2 = new DefaultComboBoxModel<AbstractDataNode>(list.toArray(new AbstractDataNode[list.size()]));
        this.caseId1ComboBox.setEnabled(false);
        this.caseId2ComboBox.setEnabled(false);
        this.state.setSource1(null);
        this.state.setSource2(null);
        this.state.setCaseId1(null);
        this.state.setCaseId2(null);
        InputSourceType inputSourceType2 = featureCompareNodeType.getDataInput1();
        if (inputSourceType2.getDataSource() != null) {
            inputSourceType = list.stream().filter(abstractDataNode -> StringUtils.isNotEmpty((String)abstractDataNode.getData().getId()) && abstractDataNode.getData().getId().equals(inputSourceType2.getDataSource().getId())).findFirst();
            if (!inputSourceType.isPresent() && featureCompareNodeType.getDataInput1().getDataSource() != null) {
                optional = new DataSourceNode("", (NodeType)new DataSourceNodeType(), this.context);
                ((AbstractNode)((Object)optional)).getData().setId(featureCompareNodeType.getDataInput1().getDataSource().getId());
                ((AbstractNode)((Object)optional)).getData().setName(featureCompareNodeType.getDataInput1().getDataSource().getName());
                ((AbstractNode)((Object)optional)).getData().setStatus(NodeStatusType.INVALID);
                defaultComboBoxModel.setSelectedItem(optional);
                this.state.setSource1((AbstractDataNode)((Object)optional));
                this.dataInput1Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                defaultComboBoxModel.setSelectedItem(inputSourceType.get());
                this.state.setSource1((AbstractDataNode)inputSourceType.get());
                this.dataInput1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
            }
            this.isSource1UserDefined = false;
            this.caseId1ComboBox.setEnabled(true);
            this.dataInput1ComboBox.setModel(defaultComboBoxModel);
            this.lastSelectedDataInput1 = this.state.getSource1().getData().getId();
            this.setupCaseId1();
        } else {
            this.dataInput1ComboBox.setModel(defaultComboBoxModel);
        }
        inputSourceType = featureCompareNodeType.getDataInput2();
        if (inputSourceType.getDataSource() != null) {
            optional = list.stream().filter(abstractDataNode -> StringUtils.isNotEmpty((String)abstractDataNode.getData().getId()) && abstractDataNode.getData().getId().equals(inputSourceType.getDataSource().getId())).findFirst();
            if (!optional.isPresent() && featureCompareNodeType.getDataInput2().getDataSource() != null) {
                DataSourceNode dataSourceNode = new DataSourceNode("", (NodeType)new DataSourceNodeType(), this.context);
                dataSourceNode.getData().setId(featureCompareNodeType.getDataInput2().getDataSource().getId());
                dataSourceNode.getData().setName(featureCompareNodeType.getDataInput2().getDataSource().getName());
                dataSourceNode.getData().setStatus(NodeStatusType.INVALID);
                defaultComboBoxModel2.setSelectedItem(dataSourceNode);
                this.state.setSource2(dataSourceNode);
                this.dataInput2Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                defaultComboBoxModel2.setSelectedItem(optional.get());
                this.state.setSource2((AbstractDataNode)optional.get());
                this.dataInput2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
            }
            this.isSource2UserDefined = false;
            this.caseId2ComboBox.setEnabled(true);
            this.dataInput2ComboBox.setModel(defaultComboBoxModel2);
            this.lastSelectedDataInput2 = this.state.getSource2().getData().getId();
            this.setupCaseId2();
        } else {
            this.dataInput2ComboBox.setModel(defaultComboBoxModel2);
        }
    }

    private void setupColumnName() {
        FeatureCompareNodeType.OutputColumn outputColumn = ((FeatureCompareNodeType)this.node.getData()).getOutputColumn();
        this.autoCheckBox.setSelected(outputColumn.getAutoSpec() == AutoSpecType.YES);
        this.columnTextField.setEnabled(!this.autoCheckBox.isSelected());
        if (outputColumn.getName() != null && !outputColumn.getName().isEmpty()) {
            this.updateFromUser = false;
            this.columnTextField.setText(outputColumn.getName());
            this.updateFromUser = true;
        }
    }

    private void setupCaseId1() {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.dataInput1ComboBox.getSelectedItem();
        if (abstractDataNode.getData().getId() != USER_DEFINED_ID) {
            AttributeType attributeType2;
            List<AttributeType> list = new ArrayList();
            if (!abstractDataNode.getData().getStatus().equals((Object)NodeStatusType.INVALID)) {
                list = abstractDataNode.getAttributes().getAttribute();
            }
            list.sort((Comparator<AttributeType>)AttributeTypeComparator.getComparator());
            this.dataInput1Attributes.clear();
            for (AttributeType attributeType2 : list) {
                this.dataInput1Attributes.add(attributeType2);
            }
            list.add(0, this.EMPTY_CASE_ID);
            DefaultComboBoxModel<AttributeType> defaultComboBoxModel = new DefaultComboBoxModel<AttributeType>(list.toArray(new AttributeType[list.size()]));
            attributeType2 = (FeatureCompareNodeType)this.node.getData();
            int n = 0;
            AttributeType attributeType3 = attributeType2.getDataInput1().getDataSource().getCaseAttribute();
            if (attributeType3 != null) {
                for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                    AttributeType attributeType4 = (AttributeType)defaultComboBoxModel.getElementAt(i);
                    if (!attributeType3.getName().equals(attributeType4.getName())) continue;
                    AttributeType attributeType5 = new AttributeType();
                    attributeType5.setAlias(attributeType3.getAlias());
                    attributeType5.setAnnotation(attributeType3.getAnnotation());
                    attributeType5.setDataType(attributeType3.getDataType());
                    attributeType5.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
                    attributeType5.setName(attributeType3.getName());
                    attributeType5.setStatus(attributeType3.getStatus());
                    this.state.setCaseId1(attributeType5);
                    n = i;
                    break;
                }
                if (n == 0 && !attributeType3.getName().equals(this.EMPTY_CASE_ID.getName())) {
                    defaultComboBoxModel.setSelectedItem(attributeType3);
                    this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    this.state.setCaseId1(attributeType3);
                } else {
                    defaultComboBoxModel.setSelectedItem(defaultComboBoxModel.getElementAt(n));
                    this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                }
            } else {
                this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            this.caseId1ComboBox.setModel((ComboBoxModel<AttributeType>)defaultComboBoxModel);
        } else {
            this.caseId1ComboBox.removeAllItems();
            this.caseId1ComboBox.setEnabled(false);
            this.dataInput1Attributes.clear();
        }
    }

    private void setupCaseId2() {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.dataInput2ComboBox.getSelectedItem();
        if (abstractDataNode.getData().getId() != USER_DEFINED_ID) {
            List<AttributeType> list = new ArrayList();
            if (!abstractDataNode.getData().getStatus().equals((Object)NodeStatusType.INVALID)) {
                list = abstractDataNode.getAttributes().getAttribute();
            }
            list.sort((Comparator<AttributeType>)AttributeTypeComparator.getComparator());
            this.dataInput2Attributes.clear();
            for (AttributeType attributeType : list) {
                this.dataInput2Attributes.add(attributeType);
            }
            list.add(0, this.EMPTY_CASE_ID);
            DefaultComboBoxModel<AttributeType> defaultComboBoxModel = new DefaultComboBoxModel<AttributeType>(list.toArray(new AttributeType[list.size()]));
            int n = 0;
            AttributeType attributeType = ((FeatureCompareNodeType)this.node.getData()).getDataInput2().getDataSource().getCaseAttribute();
            if (attributeType != null) {
                for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
                    AttributeType attributeType2 = (AttributeType)defaultComboBoxModel.getElementAt(i);
                    if (!attributeType.getName().equals(attributeType2.getName())) continue;
                    AttributeType attributeType3 = new AttributeType();
                    attributeType3.setAlias(attributeType.getAlias());
                    attributeType3.setAnnotation(attributeType.getAnnotation());
                    attributeType3.setDataType(attributeType.getDataType());
                    attributeType3.setDataTypeQualifier(attributeType.getDataTypeQualifier());
                    attributeType3.setName(attributeType.getName());
                    attributeType3.setStatus(attributeType.getStatus());
                    this.state.setCaseId2(attributeType3);
                    n = i;
                    break;
                }
                if (n == 0 && !attributeType.getName().equals(this.EMPTY_CASE_ID.getName())) {
                    defaultComboBoxModel.setSelectedItem(attributeType);
                    this.state.setCaseId2(attributeType);
                    this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
                } else {
                    defaultComboBoxModel.setSelectedItem(defaultComboBoxModel.getElementAt(n));
                    this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                }
            } else {
                this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            this.caseId2ComboBox.setModel((ComboBoxModel<AttributeType>)defaultComboBoxModel);
        } else {
            this.caseId2ComboBox.removeAllItems();
            this.caseId2ComboBox.setEnabled(false);
            this.dataInput2Attributes.clear();
        }
    }

    public boolean isAutoColumn() {
        return this.autoCheckBox.isSelected();
    }

    public ModelSignatureType getSelectedModel() {
        return (ModelSignatureType)this.modelComboBox.getSelectedItem();
    }

    public String getColumnName() {
        return this.columnTextField.getText();
    }

    public InputSourceType getDataInput1() {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.dataInput1ComboBox.getSelectedItem();
        InputSourceType inputSourceType = new InputSourceType();
        if (USER_DEFINED_ID.equals(abstractDataNode.getData().getId())) {
            inputSourceType.setDataSource(null);
            InputSourceType.Custom custom = new InputSourceType.Custom();
            custom.setAttributes(this.getEditedAttributes(FeatureCompareNode.DataInput.INPUT_1));
            inputSourceType.setCustom(custom);
        } else {
            inputSourceType.setCustom(null);
            InputSourceType.DataSource dataSource = new InputSourceType.DataSource();
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)this.dataInput1ComboBox.getSelectedItem();
            dataSource.setName(abstractDataNode2.getData().getName());
            dataSource.setId(abstractDataNode2.getData().getId());
            dataSource.setStatus(abstractDataNode2.getData().getStatus());
            dataSource.setCaseAttribute(this.state.getCaseId1());
            dataSource.setAttributes(this.getSelectedAttributes(FeatureCompareNode.DataInput.INPUT_1));
            inputSourceType.setDataSource(dataSource);
        }
        return inputSourceType;
    }

    public InputSourceType getDataInput2() {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.dataInput2ComboBox.getSelectedItem();
        InputSourceType inputSourceType = new InputSourceType();
        if (USER_DEFINED_ID.equals(abstractDataNode.getData().getId())) {
            inputSourceType.setDataSource(null);
            InputSourceType.Custom custom = new InputSourceType.Custom();
            custom.setAttributes(this.getEditedAttributes(FeatureCompareNode.DataInput.INPUT_2));
            inputSourceType.setCustom(custom);
        } else {
            inputSourceType.setCustom(null);
            InputSourceType.DataSource dataSource = new InputSourceType.DataSource();
            AbstractDataNode abstractDataNode2 = (AbstractDataNode)this.dataInput2ComboBox.getSelectedItem();
            dataSource.setName(abstractDataNode2.getData().getName());
            dataSource.setId(abstractDataNode2.getData().getId());
            dataSource.setStatus(abstractDataNode2.getData().getStatus());
            dataSource.setCaseAttribute(this.state.getCaseId2());
            dataSource.setAttributes(this.getSelectedAttributes(FeatureCompareNode.DataInput.INPUT_2));
            inputSourceType.setDataSource(dataSource);
        }
        return inputSourceType;
    }

    private InputSourceType.Custom.Attributes getEditedAttributes(FeatureCompareNode.DataInput dataInput) {
        InputSourceType.Custom.Attributes attributes = new InputSourceType.Custom.Attributes();
        List list = attributes.getAttribute();
        int n = this.tableModel.getRowCount();
        int n2 = FeatureCompareTableModel.getCorrespondingColumn(dataInput);
        for (int i = 0; i < n; ++i) {
            InputSourceType.Custom.Attributes.Attribute attribute;
            Object object = this.tableModel.getValueAt(i, n2);
            if (object instanceof InputSourceType.Custom.Attributes.Attribute) {
                attribute = (InputSourceType.Custom.Attributes.Attribute)object;
                list.add(attribute);
                continue;
            }
            attribute = new InputSourceType.Custom.Attributes.Attribute();
            attribute.setValue(DialogsLrb.get("EMPTY_COMBO"));
            attribute.setSource(CUSTOM);
            list.add(attribute);
        }
        return attributes;
    }

    private InputSourceType.DataSource.Attributes getSelectedAttributes(FeatureCompareNode.DataInput dataInput) {
        InputSourceType.DataSource.Attributes attributes = new InputSourceType.DataSource.Attributes();
        List list = attributes.getAttribute();
        int n = this.tableModel.getRowCount();
        int n2 = FeatureCompareTableModel.getCorrespondingColumn(dataInput);
        for (int i = 0; i < n; ++i) {
            AttributeType attributeType = (AttributeType)this.tableModel.getValueAt(i, n2);
            InputSourceType.DataSource.Attributes.Attribute attribute = new InputSourceType.DataSource.Attributes.Attribute();
            attribute.setName(attributeType.getName());
            attribute.setStatus(attributeType.getStatus());
            attribute.setAlias(attributeType.getAlias());
            attribute.setAnnotation(attributeType.getAnnotation());
            attribute.setDataType(attributeType.getDataType());
            attribute.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            attribute.setSource(DATA_SOURCE);
            list.add(attribute);
        }
        return attributes;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isModelDirty() {
        return this.modelDirty;
    }

    private void cleanAttributes(FeatureCompareNode.DataInput dataInput) {
        int n = FeatureCompareTableModel.getCorrespondingColumn(dataInput);
        int n2 = this.tableModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            this.tableModel.setValueAt(this.NONE_ATTRIBUTE, i, n);
        }
    }

    public void initRes() {
        this.modelLabel.setText(DialogsLrb.get("MODEL_LABEL"));
        this.dataInput1Label.setText(DialogsLrb.get("DATA_INPUT_1"));
        this.dataInput2Label.setText(DialogsLrb.get("DATA_INPUT_2"));
        this.columnLabel.setText(DialogsLrb.get("COLUMN"));
        this.caseId1Label.setText(DialogsLrb.get("CASE_ID"));
        this.caseId2Label.setText(DialogsLrb.get("CASE_ID"));
        this.partitionedAttributes = new HashMap<String, Boolean>();
        this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.dataInput1Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.dataInput2Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.modelWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.caseId1Warning.setToolTipText(NodeMessagesLrb.get("DYNAMIC_PREDICTION_NODE_INVALID_CASE_ATTR"));
        this.caseId2Warning.setToolTipText(NodeMessagesLrb.get("DYNAMIC_PREDICTION_NODE_INVALID_CASE_ATTR"));
        this.dataInput1Warning.setToolTipText(NodeMessagesLrb.format("FEATURE_COMPARE_MISSING_DATA_SOURCE", ""));
        this.dataInput2Warning.setToolTipText(NodeMessagesLrb.format("FEATURE_COMPARE_MISSING_DATA_SOURCE", ""));
        this.modelWarning.setToolTipText(NodeMessagesLrb.get("APPLY_INVAL_MODEL"));
        this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
        this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
        this.dataInput1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
        this.dataInput2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
        this.modelWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.isSource1UserDefined = true;
        this.isSource2UserDefined = true;
        this.dataMinerTablePanel1.setup((TableModel)((Object)this.tableModel), null, 0, true);
        this.dataMinerTablePanel1.getTable().getFullColumnModel().getColumn(0).setCellRenderer(this.modelCellRenderer);
        this.dataMinerTablePanel1.getTable().getSelectionModel().setSelectionMode(0);
        this.dataMinerTablePanel1.getTable().getFullColumnModel().getColumn(2).setCellEditor(new AttributeTypeEditor());
        this.dataMinerTablePanel1.getTable().getFullColumnModel().getColumn(2).setCellRenderer(new AttributeTypeRenderer());
        this.dataMinerTablePanel1.getTable().getSelectionModel().setSelectionMode(0);
        this.dataMinerTablePanel1.getTable().getFullColumnModel().getColumn(3).setCellEditor(new AttributeTypeEditor());
        this.dataMinerTablePanel1.getTable().getFullColumnModel().getColumn(3).setCellRenderer(new AttributeTypeRenderer());
        this.modelComboBox.setRenderer(new ModelSignatureTypeComboRenderer());
        this.dataInput1ComboBox.setRenderer(new DataSourceComboRenderer());
        this.dataInput2ComboBox.setRenderer(new DataSourceComboRenderer());
        this.caseId1ComboBox.setRenderer(new AttributesComboRenderer());
        this.caseId2ComboBox.setRenderer(new AttributesComboRenderer());
        this.dirty = false;
        this.modelDirty = false;
        this.dataInput1Attributes.clear();
        this.dataInput2Attributes.clear();
    }

    private void setupWidgets() {
        this.setupModelComboBox();
        this.setupDataSourceComboBox();
        this.setupColumnName();
    }

    private void initListeners() {
        this.modelComboBox.addActionListener(actionEvent -> {
            ModelSignatureType modelSignatureType = (ModelSignatureType)this.modelComboBox.getSelectedItem();
            if (!modelSignatureType.getModel().getModelId().equals(this.lastSelectedModel.getModel().getModelId())) {
                if (!modelSignatureType.getModel().getName().equals(this.EMPTY_MODEL.getModel().getName())) {
                    if (this.autoCheckBox.isSelected()) {
                        this.updateFromUser = false;
                        this.columnTextField.setText(modelSignatureType.getModel().getName() + RESULT_SUFFIX);
                        this.updateFromUser = true;
                    }
                    this.tableModelChanged();
                    this.modelDirty = true;
                    this.dirty = true;
                    this.state.clearPartitionedAttrsInput1();
                    this.state.clearPartitionedAttrsInput2();
                    this.modelWarning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                } else {
                    if (this.autoCheckBox.isSelected()) {
                        this.updateFromUser = false;
                        this.columnTextField.setText("");
                        this.updateFromUser = true;
                    }
                    this.tableModel.setSrcData(new ArrayList());
                    this.modelDirty = true;
                    this.dirty = true;
                    this.state.clearPartitionedAttrsInput1();
                    this.state.clearPartitionedAttrsInput2();
                    this.modelWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
                }
                this.lastSelectedModel = modelSignatureType;
                if (this.isPIMode()) {
                    this.updateNode();
                }
            }
        });
        this.dataInput1ComboBox.addActionListener(actionEvent -> {
            AbstractDataNode abstractDataNode = (AbstractDataNode)this.dataInput1ComboBox.getSelectedItem();
            if (!abstractDataNode.getData().getId().equals(this.lastSelectedDataInput1)) {
                if (!abstractDataNode.getData().getId().equals(USER_DEFINED_ID)) {
                    this.caseId1ComboBox.setEnabled(true);
                    List list = abstractDataNode.getAttributes().getAttribute();
                    list.sort(AttributeTypeComparator.getComparator());
                    list.add(0, this.EMPTY_CASE_ID);
                    DefaultComboBoxModel<AttributeType> defaultComboBoxModel = new DefaultComboBoxModel<AttributeType>(list.toArray(new AttributeType[list.size()]));
                    this.caseId1ComboBox.setModel(defaultComboBoxModel);
                    this.dataInput1Attributes.clear();
                    for (AttributeType attributeType : list) {
                        this.dataInput1Attributes.add(attributeType);
                    }
                    this.isSource1UserDefined = false;
                    this.state.setNewSource1(abstractDataNode);
                    this.state.setCaseId1(null);
                    this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    this.dataInput1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                    this.cleanAttributes(FeatureCompareNode.DataInput.INPUT_1);
                    this.populateAttributes(FeatureCompareNode.DataInput.INPUT_1);
                } else {
                    this.caseId1ComboBox.setModel(new DefaultComboBoxModel());
                    this.caseId1ComboBox.setEnabled(false);
                    this.dataInput1Attributes.clear();
                    this.isSource1UserDefined = true;
                    this.state.setNewSource1(null);
                    this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                    this.dataInput1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                    this.state.setCaseId1(null);
                    this.cleanAttributes(FeatureCompareNode.DataInput.INPUT_1);
                }
                this.dirty = true;
                this.lastSelectedDataInput1 = abstractDataNode.getData().getId();
                if (this.isPIMode()) {
                    this.updateNode();
                }
            }
        });
        this.dataInput2ComboBox.addActionListener(actionEvent -> {
            AbstractDataNode abstractDataNode = (AbstractDataNode)this.dataInput2ComboBox.getSelectedItem();
            if (!abstractDataNode.getData().getId().equals(this.lastSelectedDataInput2)) {
                if (!abstractDataNode.getData().getId().equals(USER_DEFINED_ID)) {
                    this.caseId2ComboBox.setEnabled(true);
                    List list = abstractDataNode.getAttributes().getAttribute();
                    list.sort(AttributeTypeComparator.getComparator());
                    list.add(0, this.EMPTY_CASE_ID);
                    DefaultComboBoxModel<AttributeType> defaultComboBoxModel = new DefaultComboBoxModel<AttributeType>(list.toArray(new AttributeType[list.size()]));
                    this.caseId2ComboBox.setModel(defaultComboBoxModel);
                    this.dataInput2Attributes.clear();
                    for (AttributeType attributeType : list) {
                        this.dataInput2Attributes.add(attributeType);
                    }
                    this.isSource2UserDefined = false;
                    this.state.setNewSource2(abstractDataNode);
                    this.state.setCaseId2(null);
                    this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    this.dataInput2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                    this.cleanAttributes(FeatureCompareNode.DataInput.INPUT_2);
                    this.populateAttributes(FeatureCompareNode.DataInput.INPUT_2);
                } else {
                    this.caseId2ComboBox.setModel(new DefaultComboBoxModel());
                    this.caseId2ComboBox.setEnabled(false);
                    this.dataInput2Attributes.clear();
                    this.isSource2UserDefined = true;
                    this.state.setNewSource2(null);
                    this.state.setCaseId2(null);
                    this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                    this.dataInput2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
                    this.cleanAttributes(FeatureCompareNode.DataInput.INPUT_2);
                }
                this.dirty = true;
                this.lastSelectedDataInput2 = abstractDataNode.getData().getId();
                if (this.isPIMode()) {
                    this.updateNode();
                }
            }
        });
        this.autoCheckBox.addActionListener(actionEvent -> {
            this.columnTextField.setEnabled(!this.autoCheckBox.isSelected());
            ModelSignatureType modelSignatureType = (ModelSignatureType)this.modelComboBox.getSelectedItem();
            if (!modelSignatureType.getModel().getName().equals(this.EMPTY_MODEL.getModel().getName())) {
                this.updateFromUser = false;
                this.columnTextField.setText(modelSignatureType.getModel().getName() + RESULT_SUFFIX);
                this.updateFromUser = true;
            }
            this.dirty = true;
            if (this.isPIMode()) {
                this.updateNode();
            }
        });
        this.caseId1ComboBox.addActionListener(actionEvent -> {
            if (!this.EMPTY_CASE_ID.getName().equals(((AttributeType)this.caseId1ComboBox.getSelectedItem()).getName())) {
                this.state.setCaseId1((AttributeType)this.caseId1ComboBox.getSelectedItem());
                if (this.state.getCaseId1() != null && this.state.getCaseId2() != null && StringUtils.areEqual((String)this.state.getCaseId1().getName(), (String)this.state.getCaseId2().getName()) && StringUtils.isEmpty((String)this.state.getCaseId2().getAlias())) {
                    this.state.getCaseId2().setAlias(this.state.getCaseId2().getName() + REPEATED_ATTRIBUTE_SUFFIX);
                }
                this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
            } else {
                this.state.setCaseId1(null);
                this.caseId1Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            this.dirty = true;
            if (this.isPIMode()) {
                this.updateNode();
            }
        });
        this.caseId2ComboBox.addActionListener(actionEvent -> {
            if (!this.EMPTY_CASE_ID.getName().equals(((AttributeType)this.caseId2ComboBox.getSelectedItem()).getName())) {
                this.state.setCaseId2((AttributeType)this.caseId2ComboBox.getSelectedItem());
                if (this.state.getCaseId1() != null && this.state.getCaseId2() != null && StringUtils.areEqual((String)this.state.getCaseId1().getName(), (String)this.state.getCaseId2().getName()) && StringUtils.isEmpty((String)this.state.getCaseId2().getAlias())) {
                    this.state.getCaseId2().setAlias(this.state.getCaseId2().getName() + REPEATED_ATTRIBUTE_SUFFIX);
                }
                this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
            } else {
                this.state.setCaseId2(null);
                this.caseId2Warning.setIcon(OracleIcons.getIcon((String)"warning.png"));
            }
            this.dirty = true;
            if (this.isPIMode()) {
                this.updateNode();
            }
        });
        this.columnTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FeatureCompareInputPanel.this.dirty = true;
                if (FeatureCompareInputPanel.this.isPIMode() && FeatureCompareInputPanel.this.updateFromUser) {
                    FeatureCompareInputPanel.this.updateNode();
                    FeatureCompareInputPanel.this.updateFromUser = true;
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FeatureCompareInputPanel.this.dirty = true;
                if (FeatureCompareInputPanel.this.isPIMode() && FeatureCompareInputPanel.this.updateFromUser) {
                    FeatureCompareInputPanel.this.updateNode();
                    FeatureCompareInputPanel.this.updateFromUser = true;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FeatureCompareInputPanel.this.dirty = true;
                if (FeatureCompareInputPanel.this.isPIMode() && FeatureCompareInputPanel.this.updateFromUser) {
                    FeatureCompareInputPanel.this.updateNode();
                    FeatureCompareInputPanel.this.updateFromUser = true;
                }
            }
        });
    }

    private boolean attributePresentInDataInput(AttributeType attributeType, FeatureCompareNode.DataInput dataInput) {
        List<AttributeType> list = FeatureCompareNode.DataInput.INPUT_1.equals((Object)dataInput) ? this.dataInput1Attributes : this.dataInput2Attributes;
        boolean bl = false;
        for (AttributeType attributeType2 : list) {
            if (!this.dataTypeAndNameMatches(attributeType2, attributeType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean dataTypeAndNameMatches(AttributeType attributeType, AttributeType attributeType2) {
        boolean bl = attributeType.getName().equals(attributeType2.getName());
        boolean bl2 = attributeType.getDataType().equals(attributeType2.getDataType());
        return bl && bl2;
    }

    private void populateAttributes(FeatureCompareNode.DataInput dataInput) {
        List list = this.tableModel.getSrcData();
        int n = FeatureCompareTableModel.getCorrespondingColumn(dataInput);
        int n2 = this.tableModel.getRowCount();
        for (int i = 0; i < n2; ++i) {
            FeatureCompareEntry featureCompareEntry = (FeatureCompareEntry)list.get(i);
            Object object = FeatureCompareNode.DataInput.INPUT_1.equals((Object)dataInput) ? featureCompareEntry.getDataInput1() : featureCompareEntry.getDataInput2();
            String string = object instanceof AttributeType ? ((AttributeType)object).getName() : ((InputSourceType.Custom.Attributes.Attribute)object).getValue();
            AttributeType attributeType = featureCompareEntry.getModelAttribute();
            if (!this.NONE_ATTRIBUTE.getName().equals(string) || !this.attributePresentInDataInput(attributeType, dataInput)) continue;
            this.tableModel.setValueAt(attributeType, i, n);
        }
    }

    private void initComponents() {
        this.dataMinerTablePanel1 = new DataMinerTablePanel();
        this.modelLabel = new JLabel();
        this.dataInput1Label = new JLabel();
        this.dataInput2Label = new JLabel();
        this.columnLabel = new JLabel();
        this.caseId1Label = new JLabel();
        this.caseId2Label = new JLabel();
        this.columnTextField = new JTextField();
        this.autoCheckBox = new JCheckBox();
        this.modelComboBox = new DataMinerCombBox();
        this.dataInput1ComboBox = new DataMinerCombBox();
        this.dataInput2ComboBox = new DataMinerCombBox();
        this.caseId1ComboBox = new DataMinerCombBox();
        this.caseId2ComboBox = new DataMinerCombBox();
        this.modelWarning = new JLabel();
        this.dataInput1Warning = new JLabel();
        this.dataInput2Warning = new JLabel();
        this.caseId1Warning = new JLabel();
        this.caseId2Warning = new JLabel();
        this.setPreferredSize(new Dimension(800, 500));
        this.modelLabel.setText("Model:");
        this.dataInput1Label.setText("Data Input 1:");
        this.dataInput2Label.setText("Data Input 2:");
        this.columnLabel.setText("Column:");
        this.caseId1Label.setText("Case ID:");
        this.caseId2Label.setText("Case ID:");
        this.autoCheckBox.setText("Auto");
        this.modelWarning.setText("");
        this.dataInput1Warning.setText("");
        this.dataInput2Warning.setText("");
        this.caseId1Warning.setText("");
        this.caseId2Warning.setText("");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel1, GroupLayout.Alignment.TRAILING, -1, 780, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modelLabel).addComponent(this.dataInput1Label).addComponent(this.dataInput2Label)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.dataInput2ComboBox, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataInput2Warning)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modelComboBox, -2, 160, -2).addComponent(this.dataInput1ComboBox, -2, 160, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modelWarning).addComponent(this.dataInput1Warning)))).addGap(27, 27, 27).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.caseId2Label).addComponent(this.columnLabel).addComponent(this.caseId1Label)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.caseId1ComboBox, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.caseId1Warning)).addGroup(groupLayout.createSequentialGroup().addComponent(this.caseId2ComboBox, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.caseId2Warning)).addGroup(groupLayout.createSequentialGroup().addComponent(this.columnTextField, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.autoCheckBox))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modelLabel).addComponent(this.columnLabel).addComponent(this.columnTextField, -2, -1, -2).addComponent(this.autoCheckBox).addComponent(this.modelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataInput1Label).addComponent(this.caseId1Label).addComponent(this.dataInput1ComboBox, -2, -1, -2).addComponent(this.caseId1ComboBox, -2, -1, -2)).addComponent(this.caseId1Warning, GroupLayout.Alignment.TRAILING))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.modelWarning).addGap(18, 18, 18).addComponent(this.dataInput1Warning))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataInput2Label).addComponent(this.caseId2Label).addComponent(this.dataInput2ComboBox, -2, -1, -2).addComponent(this.caseId2ComboBox, -2, -1, -2)).addComponent(this.caseId2Warning, GroupLayout.Alignment.TRAILING)).addComponent(this.dataInput2Warning, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataMinerTablePanel1, -1, 392, Short.MAX_VALUE).addContainerGap()));
    }

    public static class FeatureCompareTableModel
    extends ODMrTableModel<FeatureCompareEntry> {
        private static final int MODEL_ATTRIBUTE = 0;
        private static final int DATA_TYPE = 1;
        private static final int DATA_INPUT_1 = 2;
        private static final int DATA_INPUT_2 = 3;
        private static final String[] _columns = new String[]{DialogsLrb.get("MODEL_ATTRIBUTE"), CommonLrb.get("DATA_TYPE"), DialogsLrb.get("DATA_INPUT_1"), DialogsLrb.get("DATA_INPUT_2")};

        public FeatureCompareTableModel(List<FeatureCompareEntry> list) {
            super(_columns, list);
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            FeatureCompareEntry featureCompareEntry = (FeatureCompareEntry)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    object = featureCompareEntry.getModelAttribute();
                    break;
                }
                case 1: {
                    object = featureCompareEntry.getModelAttribute().getDataType();
                    break;
                }
                case 2: {
                    object = featureCompareEntry.getDataInput1();
                    break;
                }
                case 3: {
                    object = featureCompareEntry.getDataInput2();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        @Override
        public String getStringValueAt(int n, int n2) {
            String string = "";
            FeatureCompareEntry featureCompareEntry = (FeatureCompareEntry)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    string = featureCompareEntry.getModelAttribute().getName();
                    break;
                }
                case 1: {
                    string = featureCompareEntry.getModelAttribute().getDataType();
                    break;
                }
                case 2: {
                    string = featureCompareEntry.getDataInput1() instanceof InputSourceType.Custom.Attributes.Attribute ? ((InputSourceType.Custom.Attributes.Attribute)featureCompareEntry.getDataInput1()).getValue() : ((InputSourceType.DataSource.Attributes.Attribute)featureCompareEntry.getDataInput1()).getName();
                    break;
                }
                case 3: {
                    string = featureCompareEntry.getDataInput2() instanceof InputSourceType.Custom.Attributes.Attribute ? ((InputSourceType.Custom.Attributes.Attribute)featureCompareEntry.getDataInput2()).getValue() : ((InputSourceType.DataSource.Attributes.Attribute)featureCompareEntry.getDataInput2()).getName();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2 || n2 == 3;
        }

        public boolean isCellPartitioned(int n) {
            return ((FeatureCompareEntry)this.srcData.get(n)).isPartitioned();
        }

        public void setValueAt(Object object, int n, int n2) {
            FeatureCompareEntry featureCompareEntry = (FeatureCompareEntry)this.srcData.get(n);
            switch (n2) {
                case 2: {
                    featureCompareEntry.setDataInput1(object);
                    break;
                }
                case 3: {
                    featureCompareEntry.setDataInput2(object);
                    break;
                }
                default: {
                    assert (false) : "Invalid index";
                    break;
                }
            }
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 0: {
                    return AttributeTypeComparator.getComparator();
                }
                case 1: {
                    break;
                }
                case 2: {
                    return CustomAttributeTypeComparator.getComparator();
                }
                case 3: {
                    return CustomAttributeTypeComparator.getComparator();
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return super.getColumnSortComparator(n);
        }

        public static int getCorrespondingColumn(FeatureCompareNode.DataInput dataInput) {
            int n = FeatureCompareNode.DataInput.INPUT_1.equals((Object)dataInput) ? 2 : 3;
            return n;
        }
    }

    public class FeatureCompareEntry {
        private AttributeType modelAttribute;
        private Object dataInput1;
        private Object dataInput2;
        private boolean isPartitioned;

        public FeatureCompareEntry(AttributeType attributeType, Object object, Object object2, boolean bl) {
            this.modelAttribute = attributeType;
            this.dataInput1 = object;
            this.dataInput2 = object2;
            this.isPartitioned = bl;
        }

        public void setIsPartitioned(boolean bl) {
            this.isPartitioned = bl;
        }

        public boolean isPartitioned() {
            return this.isPartitioned;
        }

        public void setModelAttribute(AttributeType attributeType) {
            this.modelAttribute = attributeType;
        }

        public AttributeType getModelAttribute() {
            return this.modelAttribute;
        }

        public void setDataInput1(Object object) {
            this.dataInput1 = object;
        }

        public Object getDataInput1() {
            return this.dataInput1;
        }

        public void setDataInput2(Object object) {
            this.dataInput2 = object;
        }

        public Object getDataInput2() {
            return this.dataInput2;
        }
    }

    public class AttributeTypeEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private Object currentValue;
        private JComboBox<AttributeType> comboComponent;
        private JPanel panel;
        private JFormattedTextField textField;
        private NumberTextField numberField;
        private JButton editButton;
        protected static final String EDIT = "edit";

        public AttributeTypeEditor() {
            this.initUI();
        }

        private void initUI() {
            this.comboComponent = new JComboBox();
            this.comboComponent.setActionCommand(EDIT);
            this.comboComponent.addActionListener(this);
            this.comboComponent.setRenderer(new AttributesComboRenderer());
            this.comboComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    AttributeTypeEditor.this.fireEditingStopped();
                }
            });
            this.textField = new JFormattedTextField();
            this.numberField = new NumberTextField();
            this.numberField.setDataType(Double.class);
            this.editButton = new JButton();
            this.panel = new CustomEditorPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.panel.add(this.textField);
            this.panel.add((Component)this.numberField);
            this.panel.add(this.editButton);
            this.panel.setBackground(this.textField.getBackground());
            this.panel.setBorder(this.textField.getBorder());
            this.textField.setBorder(null);
            this.numberField.setBorder(null);
            this.editButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
            this.editButton.addActionListener(new EditButtonActionListener());
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }

        public void commitChange(InputSourceType.Custom.Attributes.Attribute attribute) {
            this.currentValue = attribute;
            FeatureCompareInputPanel.this.dirty = true;
            if (FeatureCompareInputPanel.this.isPIMode()) {
                FeatureCompareInputPanel.this.updateNode();
            }
            this.fireEditingStopped();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                int n = FeatureCompareInputPanel.this.dataMinerTablePanel1.getTable().getEditingRow();
                int n2 = FeatureCompareInputPanel.this.dataMinerTablePanel1.getTable().getEditingColumn();
                if (n != -1 && n2 != -1) {
                    boolean bl;
                    n = FeatureCompareInputPanel.this.dataMinerTablePanel1.getTable().convertRowIndexToModel(n);
                    n2 = FeatureCompareInputPanel.this.dataMinerTablePanel1.getTable().convertRowIndexToModel(n2);
                    boolean bl2 = ((FeatureCompareTableModel)((Object)FeatureCompareInputPanel.this.dataMinerTablePanel1.getTable().getModel())).isCellPartitioned(n);
                    boolean bl3 = bl = !((AttributeType)this.comboComponent.getSelectedItem()).getName().equals(FeatureCompareInputPanel.this.NONE_ATTRIBUTE.getName());
                    if (bl2 && bl) {
                        if (n2 == 2) {
                            FeatureCompareInputPanel.this.state.addPartitionedAttrInput1(((AttributeType)this.comboComponent.getSelectedItem()).getName(), (AttributeType)this.comboComponent.getSelectedItem());
                            FeatureCompareInputPanel.this.state.rmvPartitionedAttrInput1(((AttributeType)this.currentValue).getName());
                        } else if (n2 == 3) {
                            FeatureCompareInputPanel.this.state.addPartitionedAttrInput2(((AttributeType)this.comboComponent.getSelectedItem()).getName(), (AttributeType)this.comboComponent.getSelectedItem());
                            FeatureCompareInputPanel.this.state.rmvPartitionedAttrInput2(((AttributeType)this.currentValue).getName());
                        }
                    }
                }
                this.currentValue = this.comboComponent.getSelectedItem();
                FeatureCompareInputPanel.this.dirty = true;
                this.fireEditingStopped();
                if (FeatureCompareInputPanel.this.isPIMode()) {
                    FeatureCompareInputPanel.this.updateNode();
                }
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentValue = object;
            boolean bl2 = true;
            if (n2 == 2) {
                bl2 = FeatureCompareInputPanel.this.isSource1UserDefined;
            } else if (n2 == 3) {
                bl2 = FeatureCompareInputPanel.this.isSource2UserDefined;
            }
            if (!bl2) {
                String string = ((AttributeType)this.currentValue).getName();
                String string2 = (String)jTable.getModel().getValueAt(jTable.convertRowIndexToModel(n), 1);
                this.comboComponent.removeAllItems();
                switch (n2) {
                    case 2: {
                        this.comboComponent.addItem(FeatureCompareInputPanel.this.NONE_ATTRIBUTE);
                        for (AttributeType attributeType : FeatureCompareInputPanel.this.dataInput1Attributes) {
                            if (!attributeType.getDataType().equals(string2)) continue;
                            if (attributeType.getName().equals(string)) {
                                this.comboComponent.addItem(attributeType);
                                this.comboComponent.getModel().setSelectedItem(attributeType);
                                continue;
                            }
                            this.comboComponent.addItem(attributeType);
                        }
                        break;
                    }
                    case 3: {
                        this.comboComponent.addItem(FeatureCompareInputPanel.this.NONE_ATTRIBUTE);
                        for (AttributeType attributeType : FeatureCompareInputPanel.this.dataInput2Attributes) {
                            if (!attributeType.getDataType().equals(string2)) continue;
                            if (attributeType.getName().equals(string)) {
                                this.comboComponent.addItem(attributeType);
                                this.comboComponent.getModel().setSelectedItem(attributeType);
                                continue;
                            }
                            this.comboComponent.addItem(attributeType);
                        }
                        break;
                    }
                }
                return this.comboComponent;
            }
            String string = (String)jTable.getModel().getValueAt(jTable.convertRowIndexToModel(n), 1);
            if ("NUMBER".equals(string)) {
                this.textField.setVisible(false);
                this.editButton.setVisible(false);
                this.numberField.setVisible(true);
                if (this.currentValue instanceof InputSourceType.Custom.Attributes.Attribute) {
                    if (FeatureCompareInputPanel.this.NONE_ATTRIBUTE.getName().equals(((InputSourceType.Custom.Attributes.Attribute)this.currentValue).getValue())) {
                        this.numberField.setText("");
                    } else {
                        this.numberField.setText(((InputSourceType.Custom.Attributes.Attribute)this.currentValue).getValue());
                    }
                } else {
                    this.numberField.setText("");
                }
            } else {
                this.textField.setVisible(true);
                this.editButton.setVisible(true);
                this.numberField.setVisible(false);
                if (this.currentValue instanceof InputSourceType.Custom.Attributes.Attribute) {
                    if (FeatureCompareInputPanel.this.NONE_ATTRIBUTE.getName().equals(((InputSourceType.Custom.Attributes.Attribute)this.currentValue).getValue())) {
                        this.textField.setText("");
                    } else {
                        this.textField.setText(((InputSourceType.Custom.Attributes.Attribute)this.currentValue).getValue());
                    }
                } else {
                    this.textField.setText("");
                }
            }
            return this.panel;
        }

        private class CustomEditorPanel
        extends JPanel {
            private CustomEditorPanel() {
            }

            @Override
            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
                if (this.isTabKeyPressed(keyStroke)) {
                    return this.processTabKey();
                }
                if (this.isEnterKeyPressed(keyStroke)) {
                    return this.processEnterKey();
                }
                return this.processKeyPressed(keyStroke, n);
            }

            private boolean isEnterKeyPressed(KeyStroke keyStroke) {
                return keyStroke.getKeyCode() == 10;
            }

            private boolean isTabKeyPressed(KeyStroke keyStroke) {
                return keyStroke.getKeyCode() == 9;
            }

            private boolean processTabKey() {
                AttributeTypeEditor.this.editButton.requestFocus();
                return true;
            }

            private boolean processEnterKey() {
                InputSourceType.Custom.Attributes.Attribute attribute = new InputSourceType.Custom.Attributes.Attribute();
                attribute.setValue(AttributeTypeEditor.this.textField.isVisible() ? AttributeTypeEditor.this.textField.getText() : AttributeTypeEditor.this.numberField.getText());
                attribute.setValue(attribute.getValue().isEmpty() ? DialogsLrb.get("EMPTY_COMBO") : attribute.getValue());
                attribute.setSource(FeatureCompareInputPanel.CUSTOM);
                AttributeTypeEditor.this.currentValue = attribute;
                AttributeTypeEditor.this.stopCellEditing();
                FeatureCompareInputPanel.this.dirty = true;
                if (FeatureCompareInputPanel.this.isPIMode()) {
                    FeatureCompareInputPanel.this.updateNode();
                }
                return true;
            }

            private boolean processKeyPressed(KeyStroke keyStroke, int n) {
                return this.hasAssociatedAction(keyStroke, n) ? this.setFocusOnTextField() : false;
            }

            private boolean hasAssociatedAction(KeyStroke keyStroke, int n) {
                boolean bl = false;
                InputMap inputMap = AttributeTypeEditor.this.textField.getInputMap(n);
                ActionMap actionMap = AttributeTypeEditor.this.textField.getActionMap();
                if (inputMap != null && actionMap != null && this.isEnabled()) {
                    Object object = inputMap.get(keyStroke);
                    Action action = object == null ? null : actionMap.get(object);
                    bl = action != null;
                }
                return bl;
            }

            private boolean setFocusOnTextField() {
                AttributeTypeEditor.this.textField.requestFocus();
                return true;
            }
        }

        private class EditButtonActionListener
        implements ActionListener {
            private EditButtonActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeatureCompareEditValuePanel featureCompareEditValuePanel = new FeatureCompareEditValuePanel(AttributeTypeEditor.this);
                featureCompareEditValuePanel.showAsTooltipDialog(AttributeTypeEditor.this.panel);
            }
        }
    }

    public class AttributeTypeRenderer
    extends DefaultTableCellRenderer
    implements TransferableRenderer {
        private String transferableStringValue;

        public AttributeTypeRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                this.transferableStringValue = "";
            } else if (object instanceof AttributeType) {
                int n3 = jTable.convertRowIndexToModel(n);
                int n4 = jTable.convertColumnIndexToModel(n2);
                this.setEnabled(jTable.getModel().isCellEditable(n3, n4));
                this.transferableStringValue = ((AttributeType)object).getName();
                if (((AttributeType)object).getName().equals(FeatureCompareInputPanel.this.NONE_ATTRIBUTE.getName())) {
                    this.setIcon(OracleIcons.getIcon((String)"edit.png"));
                } else if (((AttributeType)object).getStatus().equals((Object)AttributeStatus.INVALID)) {
                    this.setIcon(OracleIcons.getIcon((String)"warning.png"));
                } else {
                    this.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
            } else if (object instanceof InputSourceType.Custom.Attributes.Attribute) {
                int n5 = jTable.convertRowIndexToModel(n);
                int n6 = jTable.convertColumnIndexToModel(n2);
                this.setEnabled(jTable.getModel().isCellEditable(n5, n6));
                this.transferableStringValue = ((InputSourceType.Custom.Attributes.Attribute)object).getValue();
                if (((InputSourceType.Custom.Attributes.Attribute)object).getValue().equals(FeatureCompareInputPanel.this.NONE_ATTRIBUTE.getName())) {
                    this.setIcon(OracleIcons.getIcon((String)"edit.png"));
                } else {
                    this.setIcon(DataMinerIcons.get(Icons.CUSTOM_ATTRIBUTE));
                }
            }
            this.setText(this.transferableStringValue);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }

        @Override
        public String getTransferrableStringValue() {
            return this.transferableStringValue;
        }
    }

    public class ModelSignatureTypeComboRenderer
    implements ListCellRenderer<ModelSignatureType> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends ModelSignatureType> jList, ModelSignatureType modelSignatureType, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent(jList, modelSignatureType, n, bl, bl2);
            if (modelSignatureType != null) {
                jLabel.setText(modelSignatureType.getModel().getName());
            }
            return jLabel;
        }
    }

    public class DataSourceComboRenderer
    implements ListCellRenderer<AbstractDataNode> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends AbstractDataNode> jList, AbstractDataNode abstractDataNode, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent(jList, abstractDataNode, n, bl, bl2);
            if (abstractDataNode != null) {
                String string = abstractDataNode.getData().getName();
                jLabel.setText(string);
                if (-1 < n) {
                    jList.setToolTipText(string);
                }
            }
            return jLabel;
        }
    }

    public class AttributesComboRenderer
    implements ListCellRenderer<AttributeType> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        @Override
        public Component getListCellRendererComponent(JList<? extends AttributeType> jList, AttributeType attributeType, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent(jList, attributeType, n, bl, bl2);
            if (attributeType != null) {
                jLabel.setText(attributeType.getName());
                jLabel.setToolTipText(attributeType.getAlias());
            }
            return jLabel;
        }
    }

    private static class CustomAttributeTypeComparator
    extends NullComparator<Object> {
        private static volatile CustomAttributeTypeComparator instance;

        private CustomAttributeTypeComparator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static CustomAttributeTypeComparator getComparator() {
            if (instance != null) return instance;
            Class<CustomAttributeTypeComparator> clazz = CustomAttributeTypeComparator.class;
            synchronized (CustomAttributeTypeComparator.class) {
                if (instance != null) return instance;
                instance = new CustomAttributeTypeComparator();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        public int compareImpl(Object object, Object object2) {
            String string = object instanceof InputSourceType.Custom.Attributes.Attribute ? ((InputSourceType.Custom.Attributes.Attribute)object).getValue() : ((AttributeType)object).getName();
            String string2 = object2 instanceof InputSourceType.Custom.Attributes.Attribute ? ((InputSourceType.Custom.Attributes.Attribute)object2).getValue() : ((AttributeType)object2).getName();
            return string.compareTo(string2);
        }
    }
}

