/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.data;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.common.model.JSONAttrTableModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.JSONDataTypeCellEditor;
import oracle.dmt.dataminer.controls.JSONHelper;
import oracle.dmt.dataminer.controls.JSONJComboBox;
import oracle.dmt.dataminer.controls.JSONTableCellRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.renderers.AttributeTypeCellRenderer;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.WritablePanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizard;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardModel;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizardPage;
import oracle.dmt.dataminer.workflow.dialog.data.EditDataGuideDialog;
import oracle.dmt.dataminer.workflow.dialog.data.JSONParsingSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class DataSourceAttributesPanel
extends DataSourceWizardPage
implements DataminerGUIPanel,
DataConsumerPanel,
ActionListener,
WritablePanel {
    private static final Logger theLogger = Logger.getLogger(DataSourceAttributesPanel.class.getName());
    protected List<AttributeType> availAttrsTotal;
    protected List<AttributeType> availAttrsCache;
    protected Map<String, AttributeType> availAttrsCacheMap;
    protected List<AttributeType> selectedAttrsCache;
    private Context _context;
    private AbstractNode _node;
    private boolean _wizardMode = false;
    private boolean showChangeDS = false;
    private JButton editBtn;
    private boolean _isDatabaseVersion12andUp = false;
    protected List<String> nonMutableJSONColumns;
    private List<String> isJSONConstraintColumns;
    private boolean includeAllAttsDirty;
    protected AttributeType selJSONAttribute;
    public boolean isPageInitialized = false;
    private JLabel statusLabel;
    protected Map<String, JSONColumnsType.Attribute> modifiedJSONColumns;
    private JButton jsonSettingBtn;
    private DataGuideSettingsType dataGuideSettings;
    private Map<String, JSONColumnsType.Attribute> allJSONColumns;
    private DataMinerTablePanel availAttrsPanel;
    private JCheckBox chkIncludeAllAvailableAtts;
    private JButton jChangeDsBtn;
    private JLabel jChangeDsLbl;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private JTextField jTableTxt;
    private DataMinerTablePanel selAttrsPanel;
    private JPanel statusPanel;

    public void setIsDatabaseVersion12andUp(boolean bl) {
        this._isDatabaseVersion12andUp = bl;
    }

    public DataSourceAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list, boolean bl) {
        this(context, abstractNode, list, null, false, bl);
    }

    public DataSourceAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list) {
        this(context, abstractNode, list, null, false, false);
    }

    public DataSourceAttributesPanel(Context context, AbstractNode abstractNode, List<AttributeType> list, List<String> list2, boolean bl, boolean bl2) {
        this._isDatabaseVersion12andUp = bl;
        this.isJSONConstraintColumns = list2;
        assert (list != null) : "Available attribute collection must not be null";
        this.availAttrsCache = new ArrayList<AttributeType>();
        this.availAttrsCacheMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            this.availAttrsCache.add(attributeType2);
            this.availAttrsCacheMap.put(attributeType2.getName(), attributeType2);
        }
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.availAttrsTotal.addAll(list);
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        this._context = context;
        this._node = abstractNode;
        this.initComponents();
        this.initRes();
        if (!bl2) {
            this.initUI();
        }
    }

    public DataSourceAttributesPanel() {
        this.availAttrsCache = new ArrayList<AttributeType>();
        this.availAttrsCacheMap = new HashMap<String, AttributeType>();
        this.availAttrsTotal = new ArrayList<AttributeType>();
        this.selectedAttrsCache = new ArrayList<AttributeType>();
        this._context = null;
        this._node = null;
        this._wizardMode = true;
        this.initComponents();
        this.initRes();
    }

    private void initComponents() {
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.availAttrsPanel = new DataMinerTablePanel();
        this.selAttrsPanel = new DataMinerTablePanel();
        this.jChangeDsBtn = new JButton();
        this.jChangeDsLbl = new JLabel();
        this.jTableTxt = new JTextField();
        this.statusPanel = new JPanel();
        this.chkIncludeAllAvailableAtts = new JCheckBox();
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jChangeDsBtn.setText("...");
        this.jChangeDsLbl.setText("Data Source");
        this.jTableTxt.setEnabled(false);
        this.statusPanel.setBorder(new BevelBorder(1));
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        this.chkIncludeAllAvailableAtts.setLabel("Include all available attributes");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.availAttrsPanel, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, 282, Short.MAX_VALUE).addComponent(this.selAttrsPanel, -1, -1, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jChangeDsLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTableTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChangeDsBtn))).addGap(5, 5, 5)).addGroup(groupLayout.createSequentialGroup().addComponent(this.chkIncludeAllAvailableAtts, -2, 287, -2).addGap(0, 0, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jChangeDsBtn).addComponent(this.jChangeDsLbl).addComponent(this.jTableTxt, -2, -1, -2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(92, 92, 92).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIncludeAllAvailableAtts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selAttrsPanel, -1, 369, Short.MAX_VALUE).addComponent(this.availAttrsPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.statusPanel, -2, -1, -2).addGap(15, 15, 15)));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jChangeDsLbl, (Component)this.jTableTxt, (String)DataDialogsLrb.get("DATA_SOURCE_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.jChangeDsBtn, (String)DataDialogsLrb.get("EDIT_SOURCE_BTN"));
        if (this._node != null && this._node.getData() instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this._node.getData();
            Table table = new Table(dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName());
            this.jTableTxt.setText(table.toString());
            this.jTableTxt.setToolTipText(table.toString());
            this.jTableTxt.setCaretPosition(0);
        }
        this.initIcons();
        this.statusLabel = new JLabel("");
        this.statusLabel.setVisible(false);
    }

    void setJsonButton(JButton jButton) {
        this.jsonSettingBtn = jButton;
        boolean bl = false;
        if (this.jsonSettingBtn != null && this._isDatabaseVersion12andUp) {
            bl = true;
        }
        jButton.setVisible(bl);
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    protected List<AttributeType> getSelectedAttributes() {
        AbstractDataNode abstractDataNode = (AbstractDataNode)this.getData();
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        return list;
    }

    public void initUINonWizard() {
        List<AttributeType> list = this.getSelectedAttributes();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        boolean bl = this.availAttrsCache.isEmpty();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
            if (bl) {
                attributeType2.setStatus(AttributeStatus.MISSING);
            }
            if (null == this.availAttrsCacheMap.get(attributeType2.getName())) {
                attributeType2.setStatus(AttributeStatus.MISSING);
            } else if (attributeType2.getStatus().equals((Object)AttributeStatus.MISSING)) {
                attributeType2.setStatus(AttributeStatus.VALID);
            }
            this.selectedAttrsCache.add(attributeType2);
        }
        this.addInvalidAttributes();
        this.removeSelectedAttrs(this.availAttrsCache, this.selectedAttrsCache);
        if (this._node != null && this._node.getData() instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this._node.getData();
            if (dataSourceNodeType.isIncludeAllAvailableAttributes() != null) {
                this.chkIncludeAllAvailableAtts.setSelected(dataSourceNodeType.isIncludeAllAvailableAttributes());
            } else {
                this.chkIncludeAllAvailableAtts.setSelected(false);
            }
        }
    }

    public void initUIWizard() {
        DataSourceWizardModel dataSourceWizardModel = this.getModel(this.getTraversableContext());
        this._isDatabaseVersion12andUp = dataSourceWizardModel.isDatabaseVersion12andUp();
        this.availAttrsCache = dataSourceWizardModel.getAvailableColumns();
        for (AttributeType attributeType : this.availAttrsTotal) {
            this.availAttrsCacheMap.put(attributeType.getName(), attributeType);
        }
        this.availAttrsTotal.clear();
        this.availAttrsTotal.addAll(this.availAttrsCache);
        this.selectedAttrsCache = dataSourceWizardModel.getSelectedColumns();
        this.addInvalidAttributes();
        this.chkIncludeAllAvailableAtts.setSelected(dataSourceWizardModel.isIncludeAllAvailableAttributes());
    }

    private void addInvalidAttributes() {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>(this.availAttrsTotal.size());
        for (AttributeType attributeType : this.availAttrsTotal) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (AttributeType attributeType : this.selectedAttrsCache) {
            if (null != hashMap.get(attributeType.getName())) continue;
            this.availAttrsTotal.add(attributeType);
            hashMap.put(attributeType.getName(), attributeType);
        }
    }

    public Map<String, JSONColumnsType.Attribute> getModifiedJSONColumns() {
        return this.modifiedJSONColumns;
    }

    protected void enableShuttleButtons(boolean bl) {
        int[] nArray = this.selAttrsPanel.getTable().getSelectedRows();
        boolean bl2 = this.selAttrsPanel.getTable().getRowCount() > 0;
        int[] nArray2 = this.availAttrsPanel.getTable().getSelectedRows();
        boolean bl3 = this.availAttrsPanel.getTable().getRowCount() > 0;
        boolean bl4 = nArray != null && nArray.length > 0;
        boolean bl5 = nArray2 != null && nArray2.length > 0;
        this.jSelectBtn.setEnabled(bl4 && bl);
        this.jRemoveAllBtn.setEnabled(bl2 && bl);
        this.jRemoveBtn.setEnabled(bl5 && bl);
        this.jSelectAllBtn.setEnabled(bl3 && bl);
    }

    @Override
    public void initUI() {
        if (this._wizardMode) {
            this.initUIWizard();
        } else {
            this.initUINonWizard();
        }
        this.statusPanel.add(this.statusLabel);
        this.statusPanel.setVisible(false);
        if (!this.isUiInitialized()) {
            this.jSelectBtn.setText("");
            this.jSelectAllBtn.setText("");
            this.jRemoveBtn.setText("");
            this.jRemoveAllBtn.setText("");
            this.jSelectBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.availAttrsPanel.getTable(), DataSourceAttributesPanel.this.selAttrsPanel.getTable(), false);
                }
            });
            this.jSelectAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.availAttrsPanel.getTable(), DataSourceAttributesPanel.this.selAttrsPanel.getTable(), true);
                }
            });
            this.jRemoveBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.stopCellEditing(DataSourceAttributesPanel.this.selAttrsPanel);
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.selAttrsPanel.getTable(), DataSourceAttributesPanel.this.availAttrsPanel.getTable(), false);
                }
            });
            this.jRemoveAllBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.selAttrsPanel.getTable(), DataSourceAttributesPanel.this.availAttrsPanel.getTable(), true);
                }
            });
            this.initializeTables();
            this.enableShuttleButtons(true);
            this.availAttrsPanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    boolean bl = !listSelectionModel.isSelectionEmpty();
                    DataSourceAttributesPanel.this.jSelectBtn.setEnabled(bl);
                    boolean bl2 = DataSourceAttributesPanel.this.availAttrsPanel.getTable().getRowCount() > 0;
                    DataSourceAttributesPanel.this.jSelectAllBtn.setEnabled(bl2);
                }
            });
            this.availAttrsPanel.getTable().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.availAttrsPanel.getTable(), DataSourceAttributesPanel.this.selAttrsPanel.getTable(), false);
                    }
                }
            });
            this.selAttrsPanel.getTable().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent) && !DataSourceAttributesPanel.this.chkIncludeAllAvailableAtts.isSelected()) {
                        DataSourceAttributesPanel.this.moveItems(DataSourceAttributesPanel.this.selAttrsPanel.getTable(), DataSourceAttributesPanel.this.availAttrsPanel.getTable(), false);
                    }
                }
            });
            this.selAttrsPanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ListSelectionModel listSelectionModel;
                    boolean bl;
                    if (DataSourceAttributesPanel.this._isDatabaseVersion12andUp) {
                        DataSourceAttributesPanel.this.enableEditButton();
                    }
                    boolean bl2 = bl = !(listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty();
                    if (DataSourceAttributesPanel.this.chkIncludeAllAvailableAtts.isSelected()) {
                        DataSourceAttributesPanel.this.jRemoveBtn.setEnabled(false);
                        DataSourceAttributesPanel.this.jRemoveAllBtn.setEnabled(false);
                    } else {
                        DataSourceAttributesPanel.this.jRemoveBtn.setEnabled(bl);
                        boolean bl3 = DataSourceAttributesPanel.this.selAttrsPanel.getTable().getRowCount() > 0;
                        DataSourceAttributesPanel.this.jRemoveAllBtn.setEnabled(bl3);
                    }
                }
            });
            this.jChangeDsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UITools.getParentDialog((JPanel)((Object)DataSourceAttributesPanel.this)).closeDialog(true);
                    DataSourceWizard dataSourceWizard = new DataSourceWizard();
                    dataSourceWizard.runWizard((Component)Ide.getMainWindow(), DataSourceAttributesPanel.this._context, (AbstractDataNode)DataSourceAttributesPanel.this._node);
                }
            });
        } else {
            this.initializeTables();
        }
        this.jChangeDsBtn.setVisible(this.showChangeDS && this.isWritable());
        this.jChangeDsLbl.setVisible(this.showChangeDS);
        this.jTableTxt.setVisible(this.showChangeDS);
        if (this._isDatabaseVersion12andUp) {
            TableColumn tableColumn = this.selAttrsPanel.getTable().getColumnModel().getColumn(1);
            tableColumn.setCellRenderer(new JSONTableCellRenderer());
            JSONJComboBox jSONJComboBox = new JSONJComboBox();
            jSONJComboBox.addActionListener(this);
            tableColumn.setCellEditor(new JSONDataTypeCellEditor((JComboBox)jSONJComboBox));
            this.chkIncludeAllAvailableAtts.setVisible(true);
            this.chkIncludeAllAvailableAtts.addActionListener(new IncludeAllAvailableAttsListener());
            if (this.chkIncludeAllAvailableAtts.isSelected()) {
                this.moveAllAvailableAttsToSelectedAtts(true);
            }
        } else {
            this.chkIncludeAllAvailableAtts.setVisible(false);
        }
    }

    private void moveAllAvailableAttsToSelectedAtts(boolean bl) {
        if (bl) {
            this.moveItems(this.availAttrsPanel.getTable(), this.selAttrsPanel.getTable(), true);
        }
        this.jSelectBtn.setEnabled(!bl);
        this.jSelectAllBtn.setEnabled(!bl);
        this.jRemoveBtn.setEnabled(!bl);
        this.jRemoveAllBtn.setEnabled(!bl);
    }

    protected boolean isAutoSpec() {
        return false;
    }

    private void stopCellEditing(DataMinerTablePanel dataMinerTablePanel) {
        TableColumn tableColumn = dataMinerTablePanel.getTable().getColumnModel().getColumn(1);
        DefaultCellEditor defaultCellEditor = (DefaultCellEditor)tableColumn.getCellEditor();
        if (null != defaultCellEditor) {
            defaultCellEditor.stopCellEditing();
        }
    }

    private void removeInvalidDataTypes(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            if (DatabaseMetadataUtils.isDataTypeSupported(attributeType.getDataType()) || DatabaseMetadataUtils.isJSONDataType(attributeType)) continue;
            arrayList.add(attributeType);
        }
        list.removeAll(arrayList);
    }

    private void initializeTables() {
        this.removeInvalidDataTypes(this.availAttrsCache);
        AttrTableModel<AttributeType> attrTableModel = new AttrTableModel<AttributeType>(this.availAttrsCache);
        this.setupAvailableTable(attrTableModel);
        if (this._isDatabaseVersion12andUp) {
            Object object;
            if (this._wizardMode) {
                object = this.getModel(this.getTraversableContext());
                this.nonMutableJSONColumns = object.getJsonColumns();
            } else {
                this.nonMutableJSONColumns = new ArrayList<String>();
                object = this.getJSONColumns();
                for (AttributeType attributeType : this.availAttrsTotal) {
                    String string;
                    String string2 = string = attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName();
                    if (!DatabaseMetadataUtils.isJSONDataType(attributeType)) continue;
                    if (this.isJSONConstraintColumns != null && this.isJSONConstraintColumns.contains(attributeType.getName())) {
                        this.nonMutableJSONColumns.add(string);
                        continue;
                    }
                    if (object != null && !object.getAttribute().isEmpty() && object.getAttribute().contains(attributeType) || null != this.modifiedJSONColumns && null != this.modifiedJSONColumns.get(string)) continue;
                    this.nonMutableJSONColumns.add(string);
                }
            }
            object = new JSONAttrTableModel<AttributeType>(this.selectedAttrsCache, this.nonMutableJSONColumns);
            this.setupSelectedTable((AttrTableModel)((Object)object));
        } else {
            AttrTableModel<AttributeType> attrTableModel2 = new AttrTableModel<AttributeType>(this.selectedAttrsCache);
            this.setupSelectedTable(attrTableModel2);
        }
    }

    protected JSONColumnsType getJSONColumns() {
        assert (this._node instanceof DataSourceNode);
        JSONColumnsType jSONColumnsType = null;
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this._node.getData();
        if (dataSourceNodeType != null && null != dataSourceNodeType.getJSONColumns()) {
            jSONColumnsType = JSONHelper.copyJSONColumnsType(dataSourceNodeType.getJSONColumns());
        }
        return jSONColumnsType;
    }

    private void setupSelectedTable(AttrTableModel attrTableModel) {
        this.selAttrsPanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("SELECTED_LABEL"), 0);
        this.selAttrsPanel.getTable().setSortColumn(0, true);
        if (this._isDatabaseVersion12andUp && this.editBtn == null) {
            this.editBtn = new JButton();
            this.editBtn.setIcon(OracleIcons.getIcon((String)"edit.png"));
            this.editBtn.setToolTipText(DataDialogsLrb.get("EDIT_DATA_GUIDE_TOOLTIP"));
            if (this.editBtn != null) {
                this.editBtn.setEnabled(false);
            }
            this.editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DataSourceAttributesPanel.this.editDataGuide();
                }
            });
            this.selAttrsPanel.addControlBarComponents(this.editBtn);
        }
        if (this.selAttrsPanel.getTable().getRowCount() == 0) {
            this.jRemoveAllBtn.setEnabled(false);
        }
        TableColumn tableColumn = this.selAttrsPanel.getTable().getColumnModel().getColumn(0);
        AttributeTypeCellRenderer attributeTypeCellRenderer = new AttributeTypeCellRenderer();
        tableColumn.setCellRenderer(attributeTypeCellRenderer);
    }

    private void enableEditButton() {
        boolean bl = false;
        int[] nArray = this.selAttrsPanel.getTable().getSelectedRowsInModel();
        if (nArray != null && nArray.length == 1) {
            List list;
            int n = nArray[0];
            DataMinerTable dataMinerTable = this.selAttrsPanel.getTable();
            AttrTableModel attrTableModel = (AttrTableModel)((Object)dataMinerTable.getModel());
            if (attrTableModel != null && (list = attrTableModel.getSrcData()) != null) {
                AttributeType attributeType = (AttributeType)list.get(n);
                if (DatabaseMetadataUtils.isJSONDataType(attributeType)) {
                    this.selJSONAttribute = attributeType;
                    String string = this.isDataGuideAvailable();
                    this.statusLabel.setText(string);
                    this.statusLabel.setVisible(true);
                    this.statusPanel.setVisible(true);
                    bl = true;
                } else {
                    this.statusLabel.setText("");
                    this.statusPanel.setVisible(false);
                }
            }
        } else {
            this.statusLabel.setText("");
            this.statusPanel.setVisible(false);
        }
        if (this._isDatabaseVersion12andUp && this.editBtn != null) {
            this.editBtn.setEnabled(bl);
        }
    }

    private String isDataGuideAvailable() {
        AbstractNode abstractNode;
        Object object;
        if (this._wizardMode) {
            object = this.getModel(this.getTraversableContext());
            abstractNode = ((DataSourceWizardModel)object).getNode();
        } else {
            abstractNode = this._node;
        }
        object = null;
        if (abstractNode instanceof DataGuideProvider) {
            DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)abstractNode);
            object = JSONHelper.isDataGuideAvailable(dataGuideProvider, this.selJSONAttribute);
        }
        return object != null ? object : JSONHelper.JSON_DATA_GUIDE_NOT_GENERATED;
    }

    /*
     * WARNING - void declaration
     */
    private void editDataGuide() {
        JSONColumnsType.Attribute attribute;
        Object object2;
        String string;
        AbstractNode abstractNode;
        DataSourceWizardModel dataSourceWizardModel;
        if (this._wizardMode) {
            dataSourceWizardModel = this.getModel(this.getTraversableContext());
            abstractNode = dataSourceWizardModel.getNode();
        } else {
            abstractNode = this._node;
        }
        assert (abstractNode instanceof DataGuideProvider);
        dataSourceWizardModel = null;
        String string2 = string = this.selJSONAttribute.getAlias() != null ? this.selJSONAttribute.getAlias() : this.selJSONAttribute.getName();
        if (this.modifiedJSONColumns != null) {
            dataSourceWizardModel = this.modifiedJSONColumns.get(string);
        }
        if (dataSourceWizardModel == null) {
            void var6_9;
            DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)abstractNode);
            object2 = dataGuideProvider.getJSONAttrDataGuideInfoType(this.selJSONAttribute);
            DataGuideInfoType object3 = (DataGuideInfoType)MetaDataHelper.copyMetadataObject(object2);
            if (null == object3) {
                DataGuideInfoType dataGuideInfoType = JSONHelper.getDefaultDataGuideInfo();
            }
            dataSourceWizardModel = new JSONColumnsType.Attribute();
            dataSourceWizardModel.setName(this.selJSONAttribute.getName());
            dataSourceWizardModel.setDataGuideInfo((DataGuideInfoType)var6_9);
            if (this.modifiedJSONColumns == null) {
                this.modifiedJSONColumns = new HashMap<String, JSONColumnsType.Attribute>();
            }
            this.modifiedJSONColumns.put(dataSourceWizardModel.getName(), (JSONColumnsType.Attribute)dataSourceWizardModel);
        }
        boolean bl = false;
        for (String string3 : this.nonMutableJSONColumns) {
            if (!string3.equals(this.selJSONAttribute.getName()) && !string3.equals(this.selJSONAttribute.getAlias())) continue;
            bl = true;
            break;
        }
        object2 = new EditDataGuideDialog(this._context, (AbstractDataNode)abstractNode);
        ((EditDataGuideDialog)object2).setSelJSONAttribute(this.selJSONAttribute, (JSONColumnsType.Attribute)dataSourceWizardModel, bl);
        DialogHelper dialogHelper = new DialogHelper((DialogDisplayable)object2);
        String string4 = this.isDataGuideAvailable();
        if (dialogHelper.showAsDialog((Component)((Object)this)) && (attribute = ((EditDataGuideDialog)object2).getCopyJSONAttributeMetadata()) != null) {
            if (this.modifiedJSONColumns == null) {
                this.modifiedJSONColumns = new HashMap<String, JSONColumnsType.Attribute>();
            }
            this.modifiedJSONColumns.put(attribute.getName(), attribute);
            if (null != attribute.getDataGuideInfo() && null != attribute.getDataGuideInfo().getCustom() && null != attribute.getDataGuideInfo().getCustom().getDataGuide() && !attribute.getDataGuideInfo().getCustom().getDataGuide().getItem().isEmpty()) {
                string4 = DataDialogsLrb.get("USER_DEFINED_DATA_GUIDE");
            }
        }
        this.statusLabel.setText(string4);
    }

    private void setupAvailableTable(AttrTableModel attrTableModel) {
        this.availAttrsPanel.setup((TableModel)((Object)attrTableModel), DataDialogsLrb.get("AVAILABLE_LABEL"), 0);
        this.availAttrsPanel.getTable().setSortColumn(0, true);
        if (this.availAttrsPanel.getTable().getRowCount() == 0) {
            this.jSelectAllBtn.setEnabled(false);
        }
        TableColumn tableColumn = this.availAttrsPanel.getTable().getColumnModel().getColumn(0);
        AttributeTypeCellRenderer attributeTypeCellRenderer = new AttributeTypeCellRenderer();
        tableColumn.setCellRenderer(attributeTypeCellRenderer);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        Object object;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((AttrTableModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        if (!bl) {
            for (var7_7 = 0; var7_7 < nArray.length; ++var7_7) {
                object = (AttributeType)list.get(nArray[var7_7]);
                arrayList.add((AttributeType)object);
            }
        } else {
            for (var7_7 = 0; var7_7 < list.size(); ++var7_7) {
                object = (AttributeType)list.get(var7_7);
                arrayList.add((AttributeType)object);
            }
        }
        ((AttrTableModel)((Object)genericTable.getModel())).removeRows(arrayList);
        ((AttrTableModel)((Object)genericTable2.getModel())).addRows(arrayList);
        List list2 = ((AttrTableModel)((Object)genericTable2.getModel())).getSrcData();
        object = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = list2.indexOf(arrayList.get(i));
            assert (n != -1) : "Unexpected state - added item should be present and must have an index";
            object[i] = (AttributeType)n;
        }
        genericTable2.setSelectedRowsInModel((int[])object);
        if (this._isDatabaseVersion12andUp) {
            this.enableEditButton();
        }
        this.jRemoveAllBtn.setEnabled(this.selAttrsPanel.getTable().getRowCount() != 0);
        this.jSelectAllBtn.setEnabled(this.availAttrsPanel.getTable().getRowCount() != 0);
    }

    private void removeSelectedAttrs(List<AttributeType> list, List<AttributeType> list2) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : list2) {
            hashMap.put(attributeType.getName(), attributeType);
        }
        Iterator<AttributeType> iterator = list.iterator();
        while (iterator.hasNext()) {
            AttributeType attributeType;
            attributeType = iterator.next();
            AttributeType attributeType2 = (AttributeType)hashMap.get(attributeType.getName());
            if (attributeType2 == null || !attributeType2.getName().equals(attributeType.getName())) continue;
            if (attributeType2.getDataType().equals(attributeType.getDataType())) {
                iterator.remove();
                continue;
            }
            if (!DatabaseMetadataUtils.isJSONDataType(attributeType2) || !attributeType2.getDataType().equals(attributeType.getDataType())) continue;
            iterator.remove();
        }
    }

    @Override
    public String getPageDirtyKey() {
        return "columnsDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        DataGuideInfoType dataGuideInfoType;
        boolean bl = true;
        if (traversableContext.getDirection() == 2) {
            this.selectedAttrsCache.clear();
            this.availAttrsCache.clear();
            this.availAttrsCacheMap.clear();
            return true;
        }
        if (this.selectedAttrsCache.isEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("COLUMN_CHOOSER_ERROR_MSG_NO_COLUMNS"), (String)DataDialogsLrb.get("COLUMN_CHOOSER_FAILURE_TITLE"), null);
            bl = false;
            return bl;
        }
        for (AttributeType object : this.selectedAttrsCache) {
            if (object.getStatus().equals((Object)AttributeStatus.INVALID)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("COLUMN_CHOOSER_ERROR_MSG_INVALID_COLUMNS"), (String)DataDialogsLrb.get("COLUMN_CHOOSER_FAILURE_TITLE"), null);
                bl = false;
                return bl;
            }
            if (!DatabaseMetadataUtils.isJSONDataType(object)) continue;
            JSONColumnsType.Attribute attribute = new JSONColumnsType.Attribute();
            attribute.setName(object.getAlias() != null ? object.getAlias() : object.getName());
            dataGuideInfoType = JSONHelper.getDefaultDataGuideInfo();
            attribute.setDataGuideInfo(dataGuideInfoType);
            if (this.allJSONColumns == null) {
                this.allJSONColumns = new HashMap<String, JSONColumnsType.Attribute>();
            }
            this.allJSONColumns.put(attribute.getName(), attribute);
        }
        DataSourceWizardModel dataSourceWizardModel = (DataSourceWizardModel)traversableContext.get("wizardModel");
        if (this.modifiedJSONColumns != null) {
            for (String string : this.modifiedJSONColumns.keySet()) {
                dataGuideInfoType = this.modifiedJSONColumns.get(string);
                this.allJSONColumns.put(string, (JSONColumnsType.Attribute)dataGuideInfoType);
            }
        }
        if (this.allJSONColumns != null && !this.allJSONColumns.isEmpty()) {
            dataSourceWizardModel.setModifiedJSONColumns(this.allJSONColumns);
        }
        return bl;
    }

    public AbstractNode getData() {
        return this._node;
    }

    public Context getContext() {
        return this._context;
    }

    public void setShowChangeDs(boolean bl) {
        this.showChangeDS = bl;
        this.jChangeDsBtn.setVisible(this.showChangeDS && this.isWritable());
        this.jChangeDsLbl.setVisible(this.showChangeDS);
        this.jTableTxt.setVisible(this.showChangeDS);
    }

    private static boolean discardJSONSettingsWarning() {
        MessageDialogPersistence messageDialogPersistence = MessageDialog.getPersistence();
        Boolean bl = messageDialogPersistence.getConfirmed("warnDiscardJSONSettings");
        if (Boolean.FALSE.equals(bl)) {
            messageDialogPersistence.setConfirmed("warnDiscardJSONSettings", Boolean.valueOf(true));
        }
        return 1 == MessageDialog.optionalConfirmOrCancel((String)"warnDiscardJSONSettings", (Component)Ide.getMainWindow(), (Object)DataDialogsLrb.get("DISCARD_JSON_SETTINGS_WARNING"), (String)DataDialogsLrb.get("DISCARD_JSON_OPT_WARNING_TITLE"), null);
    }

    @Override
    public boolean doWork() {
        boolean bl;
        if (!this.availAttrsCache.isEmpty()) {
            bl = false;
            for (AttributeType attributeType : this.availAttrsCache) {
                if (!DatabaseMetadataUtils.isJSONDataType(attributeType)) continue;
                bl = true;
                break;
            }
            if (bl && !DataSourceAttributesPanel.discardJSONSettingsWarning()) {
                return false;
            }
        }
        bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        DataSourceNode dataSourceNode = (DataSourceNode)this.getData();
        boolean bl6 = bl3 = !AttributeTypeHelper.areEqual(dataSourceNode.getAttributes() != null ? dataSourceNode.getAttributes().getAttribute() : null, this.selectedAttrsCache);
        if (this.dataGuideSettings != null && ((DataSourceNodeType)this._node.getData()).getDataGuideSettings() != null) {
            bl4 = !JSONHelper.equalDataGuideSettings(((DataSourceNodeType)this._node.getData()).getDataGuideSettings(), this.dataGuideSettings);
        }
        bl5 = this.modifiedJSONColumns != null && !this.modifiedJSONColumns.isEmpty();
        boolean bl7 = bl2 = bl3 || bl4 || bl5 || this.includeAllAttsDirty;
        if (bl2) {
            AttributeType attributeType;
            Attributes attributes = new Attributes();
            List list = attributes.getAttribute();
            if (this.selectedAttrsCache != null && !this.selectedAttrsCache.isEmpty()) {
                for (AttributeType object5 : this.selectedAttrsCache) {
                    attributeType = new AttributeType();
                    AttributeTypeHelper.copyAttribute(attributeType, object5);
                    list.add(attributeType);
                }
            }
            try {
                Object object;
                Object object2;
                Object object3;
                CommandProcessor.getInstance().beginTrans(NodeMessagesLrb.get("DATASRC_INPUT"));
                ArrayList arrayList = new ArrayList();
                ComplexProperty complexProperty = new ComplexProperty("dataSourceAttributes", attributes);
                complexProperty.setOldData(dataSourceNode.getAttributes());
                arrayList.add(complexProperty);
                attributeType = (DataSourceNodeType)dataSourceNode.getData();
                JSONColumnsType jSONColumnsType = attributeType.getJSONColumns();
                HashMap<String, JSONColumnsType.Attribute> hashMap = new HashMap<String, JSONColumnsType.Attribute>();
                if (jSONColumnsType != null) {
                    for (JSONColumnsType.Attribute attribute : jSONColumnsType.getAttribute()) {
                        hashMap.put(attribute.getName(), attribute);
                    }
                }
                this.allJSONColumns = new HashMap<String, JSONColumnsType.Attribute>();
                for (AttributeType attributeType2 : this.selectedAttrsCache) {
                    if (!attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                    if (DatabaseMetadataUtils.isJSONDataType(attributeType2)) {
                        String string = attributeType2.getAlias() != null ? attributeType2.getAlias() : attributeType2.getName();
                        object3 = (JSONColumnsType.Attribute)hashMap.get(string);
                        if (object3 == null) {
                            object3 = new JSONColumnsType.Attribute();
                            object3.setName(attributeType2.getAlias() != null ? attributeType2.getAlias() : attributeType2.getName());
                            object2 = JSONHelper.getDefaultDataGuideInfo();
                            object3.setDataGuideInfo((DataGuideInfoType)object2);
                        }
                        this.allJSONColumns.put(object3.getName(), (JSONColumnsType.Attribute)object3);
                        continue;
                    }
                    String string = attributeType2.getAlias() != null ? attributeType2.getAlias() : attributeType2.getName();
                    object3 = (JSONColumnsType.Attribute)hashMap.get(string);
                    if (null == object3) continue;
                    hashMap.remove(object3);
                }
                if (this.modifiedJSONColumns != null) {
                    for (String string : this.modifiedJSONColumns.keySet()) {
                        JSONColumnsType.Attribute attribute = this.modifiedJSONColumns.get(string);
                        this.allJSONColumns.put(string, attribute);
                    }
                }
                Iterator<Object> iterator = new JSONColumnsType();
                for (String string : this.allJSONColumns.keySet()) {
                    object3 = this.allJSONColumns.get(string);
                    iterator.getAttribute().add(object3);
                }
                ComplexProperty complexProperty2 = new ComplexProperty("JSONColumnsType", iterator);
                complexProperty2.setOldData(jSONColumnsType);
                arrayList.add(complexProperty2);
                object3 = new ComplexProperty("jsonDataGuideSettings", this.dataGuideSettings);
                ((ComplexProperty)object3).setOldData(((DataSourceNodeType)this._node.getData()).getDataGuideSettings());
                arrayList.add(object3);
                object2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                ((ComplexProperty)object2).setOldData(dataSourceNode.getSQLExpression());
                arrayList.add(object2);
                if (dataSourceNode.getData() instanceof DataSourceNodeType) {
                    object = (DataSourceNodeType)dataSourceNode.getData();
                    ComplexProperty complexProperty3 = new ComplexProperty("INCLUDE_ALL_COLUMNS", this.chkIncludeAllAvailableAtts.isSelected());
                    complexProperty3.setOldData(object.isIncludeAllAvailableAttributes());
                    arrayList.add(complexProperty3);
                }
                object = (OdmrSDMUndoFilter)this.getData().getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndoComplexPropertyList(dataSourceNode, this.getContext(), arrayList);
                dataSourceNode.validate(true);
                CommandProcessor.getInstance().endTrans();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                CommandProcessor.getInstance().abortTrans();
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected void pageSelected(TraversableContext traversableContext) {
        final DataSourceWizardModel dataSourceWizardModel = (DataSourceWizardModel)traversableContext.get("wizardModel");
        if (this._context == null) {
            this._context = dataSourceWizardModel.getContext();
        }
        super.pageSelected(traversableContext);
        JButton jButton = dataSourceWizardModel.getJsonSettingBtn();
        if (jButton != null) {
            jButton.setVisible(this._isDatabaseVersion12andUp);
            if (!this.isPageInitialized) {
                this.isPageInitialized = true;
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JSONParsingSettingsPanel jSONParsingSettingsPanel;
                        AbstractDataNode abstractDataNode = dataSourceWizardModel.getNode();
                        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)abstractDataNode.getData();
                        if (DataSourceAttributesPanel.this.dataGuideSettings == null) {
                            DataSourceAttributesPanel.this.dataGuideSettings = dataSourceNodeType.getDataGuideSettings();
                            if (null == DataSourceAttributesPanel.this.dataGuideSettings) {
                                DataSourceAttributesPanel.this.dataGuideSettings = JSONHelper.initDataGuideSettings();
                            }
                        }
                        if ((jSONParsingSettingsPanel = new JSONParsingSettingsPanel(DataSourceAttributesPanel.this._context, DataSourceAttributesPanel.this.dataGuideSettings)).showAsDialog((Component)((Object)DataSourceAttributesPanel.this))) {
                            DataSourceAttributesPanel.this.dataGuideSettings = jSONParsingSettingsPanel.getDataGuideSettings();
                            dataSourceWizardModel.setDataGuideSettings(DataSourceAttributesPanel.this.dataGuideSettings);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JSONParsingSettingsPanel jSONParsingSettingsPanel;
            JButton jButton = (JButton)actionEvent.getSource();
            if (!jButton.getText().equals(DataSourceAttributesDialog.JSON_SETTINGS_TEXT)) {
                return;
            }
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)this._node.getData();
            if (this.dataGuideSettings == null) {
                this.dataGuideSettings = dataSourceNodeType.getDataGuideSettings();
                if (null == this.dataGuideSettings) {
                    this.dataGuideSettings = JSONHelper.initDataGuideSettings();
                }
            }
            if ((jSONParsingSettingsPanel = new JSONParsingSettingsPanel(this._context, this.dataGuideSettings)).showAsDialog((Component)((Object)this))) {
                this.dataGuideSettings = jSONParsingSettingsPanel.getDataGuideSettings();
            }
        } else if (actionEvent.getSource() instanceof JSONJComboBox) {
            this.enableEditButton();
        }
    }

    @Override
    protected void pageDeselected(TraversableContext traversableContext) throws TraversalException {
        super.pageDeselected(traversableContext);
        DataSourceWizardModel dataSourceWizardModel = (DataSourceWizardModel)traversableContext.get("wizardModel");
        JButton jButton = dataSourceWizardModel.getJsonSettingBtn();
        if (jButton != null) {
            jButton.setVisible(false);
        }
    }

    @Override
    public boolean isWritable() {
        Node node = this._context.getNode();
        if (node instanceof WorkflowNode) {
            WorkflowNode workflowNode = (WorkflowNode)this._context.getNode();
            return !workflowNode.isReadOnly();
        }
        return true;
    }

    private class IncludeAllAvailableAttsListener
    implements ActionListener {
        private IncludeAllAvailableAttsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DataSourceAttributesPanel.this.includeAllAttsDirty = true;
            boolean bl = DataSourceAttributesPanel.this.chkIncludeAllAvailableAtts.isSelected();
            DataSourceAttributesPanel.this.moveAllAvailableAttsToSelectedAtts(bl);
        }
    }
}

