/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.columnFilter;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.models.AttributeItem;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.columnFilter.OutputColumnPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.ColumnFilterPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.columnFilter.WorkflowColumnFilterNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ColumnFilterNode;
import oracle.dmt.dataminer.workflow.preferences.ColumnFilterPreferencesPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttrImportantSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ColumnFilterSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataQualitySettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;

public class SettingsPanel
extends DialogDisplayer<ColumnFilterNode> {
    private static final String string = "String";
    private boolean dirty;
    private boolean isAdjusting;
    private String generatedAITableName = "NULL";
    private Version version;
    private AttributeItem selectATarget;
    private OutputColumnPanel parentPanel;
    private ColumnFilterSettingsType columnFilterSettings;
    private WorkflowColumnFilterNodePropertyProxyModel propertyModel;
    private JCheckBox jAttrDependencyCheckBox;
    private JCheckBox jAttrImportanceCheckBox;
    private JCheckBox jConstantPercentCheckBox;
    private JSpinner jConstantPercentSpinner;
    private JCheckBox jDataQualityCheckBox;
    private JCheckBox jImportanceCheckBox;
    private JSpinner jImportanceSpinner;
    private JCheckBox jNullPercentCheckBox;
    private JSpinner jNullPercentSpinner;
    private JLabel jRequiredSupervisedLabel;
    private JSpinner jSampleSizeSpinner;
    private JCheckBox jSamplingCheckBox;
    private DataMinerCombBox<String> jSamplingTypeComboBox;
    private JLabel jSamplingTypeLabel;
    private JSpinner jStratifiedCutoffSpinner;
    private DataMinerCombBox<AttributeItem> jTargetComboBox;
    private JLabel jTargetLabel;
    private JCheckBox jTopNCheckBox;
    private JSpinner jTopNSpinner;
    private JCheckBox jUniquePercentCheckBox;
    private JSpinner jUniquePercentSpinner;
    private JLabel samplingLabel;
    private JLabel stratifiedCutoffLabel;
    private JRadioButton systemSamplingRadioButton;
    private JRadioButton userSamplingRadioButton;

    public SettingsPanel(PropertyModel propertyModel) {
        super((Context)null, null);
        assert (propertyModel != null) : "PropertyModel for ColumnFilter node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.init((ColumnFilterNode)this._data, propertyModel);
    }

    public SettingsPanel(Context context, ColumnFilterNode columnFilterNode, OutputColumnPanel outputColumnPanel) {
        super(context, columnFilterNode);
        assert (context != null) : "Context must not be null.";
        assert (columnFilterNode != null) : "ColumnFilter node must not be null.";
        this.parentPanel = outputColumnPanel;
        this.init(columnFilterNode, null);
    }

    private boolean isPIMode() {
        return this.propertyModel != null;
    }

    private void init(ColumnFilterNode columnFilterNode, PropertyModel propertyModel) {
        Object object;
        this.propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this.dirty = false;
        if (this.parentPanel == null) {
            object = (ColumnFilterNodeType)columnFilterNode.getData();
            this.columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(object.getColumnFilterSettings());
            this.generatedAITableName = object.getColumnFilterResults().getAttrImportanceOutput();
        } else {
            this.columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(this.parentPanel.getColumnFilterSettings());
            this.generatedAITableName = this.parentPanel.getAIResultTable();
        }
        object = ConnectionFolder.getConnectionFolder(this.getContext());
        this.version = object.getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jDataQualityCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_DATA_QUALITY"));
        ResourceUtils.resButton((AbstractButton)this.jNullPercentCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_NULL_PERCENT"));
        ResourceUtils.resButton((AbstractButton)this.jUniquePercentCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_UNIQUE_PERCENT"));
        ResourceUtils.resButton((AbstractButton)this.jConstantPercentCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_CONSTANT_PERCENT"));
        ResourceUtils.resButton((AbstractButton)this.jAttrImportanceCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_ATTR_IMPORTANCE"));
        ResourceUtils.resLabel((JLabel)this.jTargetLabel, this.jTargetComboBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_TARGET"));
        ResourceUtils.resButton((AbstractButton)this.jImportanceCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_AI_CUT_OFF"));
        ResourceUtils.resButton((AbstractButton)this.jTopNCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_AI_TOPN"));
        ResourceUtils.resButton((AbstractButton)this.jSamplingCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING"));
        ResourceUtils.resLabel((JLabel)this.jSamplingTypeLabel, this.jSamplingTypeComboBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_TECHNIQUE"));
        ResourceUtils.resSpinner((JLabel)this.stratifiedCutoffLabel, (JSpinner)this.jStratifiedCutoffSpinner, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_STRATIFIED_CUTOFF"));
        ResourceUtils.resButton((AbstractButton)this.jAttrDependencyCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_ATTR_DEPENDENCY"));
        ResourceUtils.resLabel((JLabel)this.jRequiredSupervisedLabel, (Component)this.jTargetLabel, (String)DialogsLrb.get("COLUMN_FILTER_REQUIRED_SUPERVISED_MESSAGE"));
        ResourceUtils.resButton((AbstractButton)this.jAttrDependencyCheckBox, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_ATTR_DEPENDENCY"));
        ResourceUtils.resButton((AbstractButton)this.systemSamplingRadioButton, (String)DialogsLrb.get("SAMPLING_SYSTEM"));
        ResourceUtils.resButton((AbstractButton)this.userSamplingRadioButton, (String)DialogsLrb.get("SAMPLING_USER"));
        ResourceUtils.resLabel((JLabel)this.samplingLabel, (Component)this.jSampleSizeSpinner, (String)DialogsLrb.get("COLUMN_FILTER_SETTING_SAMPLING_SIZE"));
        this.jSamplingTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.SamplingType.toHuman((String)"System"), ServerConstants.SamplingType.toHuman((String)"Random"), ServerConstants.SamplingType.toHuman((String)"Stratified")}));
    }

    @Override
    public void initUI() {
        this.isAdjusting = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.systemSamplingRadioButton);
        buttonGroup.add(this.userSamplingRadioButton);
        this.systemSamplingRadioButton.addActionListener(new SystemSamplingListener());
        this.userSamplingRadioButton.addActionListener(new UserSamplingListener());
        ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings columnFilterPreferenceSettings = ColumnFilterPreferencesPanel.ColumnFilterPreferenceSettings.getInstance();
        DataQualitySettingsType dataQualitySettingsType = this.columnFilterSettings.getDataQualitySettings();
        this.jNullPercentCheckBox.setSelected(dataQualitySettingsType.getNullsPercent() != null);
        if (dataQualitySettingsType.getNullsPercent() != null) {
            this.jNullPercentSpinner.setValue(dataQualitySettingsType.getNullsPercent());
        } else {
            this.jNullPercentSpinner.setValue(columnFilterPreferenceSettings.getNullsPercentValue());
        }
        this.jUniquePercentCheckBox.setSelected(dataQualitySettingsType.getUniquePercent() != null);
        if (dataQualitySettingsType.getUniquePercent() != null) {
            this.jUniquePercentSpinner.setValue(dataQualitySettingsType.getUniquePercent());
        } else {
            this.jUniquePercentSpinner.setValue(columnFilterPreferenceSettings.getUniquePercentValue());
        }
        this.jConstantPercentCheckBox.setSelected(dataQualitySettingsType.getConstantPercent() != null);
        if (dataQualitySettingsType.getConstantPercent() != null) {
            this.jConstantPercentSpinner.setValue(dataQualitySettingsType.getConstantPercent());
        } else {
            this.jConstantPercentSpinner.setValue(columnFilterPreferenceSettings.getConstantPercentValue());
        }
        boolean bl = this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected();
        this.jDataQualityCheckBox.setSelected(bl);
        AttrImportantSettingsType attrImportantSettingsType = this.columnFilterSettings.getAttrImportantSettings();
        this.jImportanceCheckBox.setSelected(attrImportantSettingsType.getCutOff() != null);
        if (attrImportantSettingsType.getCutOff() != null) {
            this.jImportanceSpinner.setValue(attrImportantSettingsType.getCutOff());
        } else {
            this.jImportanceSpinner.setValue(columnFilterPreferenceSettings.getCutOffValue());
        }
        this.jTopNCheckBox.setSelected(attrImportantSettingsType.getTopN() != null);
        if (attrImportantSettingsType.getTopN() != null) {
            this.jTopNSpinner.setValue(attrImportantSettingsType.getTopN());
        } else {
            this.jTopNSpinner.setValue(columnFilterPreferenceSettings.getTopNValue());
        }
        if (DbVersionHelper.isDB122Up((Version)this.version)) {
            if (attrImportantSettingsType.isAttributeDependency() != null) {
                this.jAttrDependencyCheckBox.setSelected(attrImportantSettingsType.isAttributeDependency());
            } else {
                this.jAttrDependencyCheckBox.setSelected(columnFilterPreferenceSettings.getUseAttrDependency());
            }
        }
        if (this.generatedAITableName != null) {
            bl = this.jImportanceCheckBox.isSelected() || this.jTopNCheckBox.isSelected();
            this.jAttrImportanceCheckBox.setSelected(bl);
        } else if (DbVersionHelper.isDB122Up((Version)this.version)) {
            this.jAttrImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUse122AttrImportance());
        } else {
            this.jAttrImportanceCheckBox.setSelected(columnFilterPreferenceSettings.getUseOriginalAttrImportance());
        }
        boolean bl2 = false;
        if (attrImportantSettingsType.getSamplingType() == null || ServerConstants.SamplingType.isSysDetermined((String)attrImportantSettingsType.getSamplingType())) {
            this.jSamplingTypeComboBox.setSelectedItem(ServerConstants.SamplingType.toHuman((String)"System"));
            bl2 = true;
        } else if (ServerConstants.SamplingType.isStratified((String)attrImportantSettingsType.getSamplingType())) {
            this.jSamplingTypeComboBox.setSelectedItem(ServerConstants.SamplingType.toHuman((String)"Stratified"));
        } else {
            this.jSamplingTypeComboBox.setSelectedItem(ServerConstants.SamplingType.toHuman((String)"Random"));
        }
        if (attrImportantSettingsType.getStratifiedCutoff() != null) {
            this.jStratifiedCutoffSpinner.setValue(attrImportantSettingsType.getStratifiedCutoff());
        } else {
            this.jStratifiedCutoffSpinner.setValue(columnFilterPreferenceSettings.getStratifiedCutoff());
        }
        this.jStratifiedCutoffSpinner.setVisible(bl2);
        this.stratifiedCutoffLabel.setVisible(bl2);
        boolean bl3 = this.columnFilterSettings.isSamplingEnabled() == null ? false : this.columnFilterSettings.isSamplingEnabled();
        this.jSamplingCheckBox.setSelected(bl3);
        this.systemSamplingRadioButton.setSelected(this.columnFilterSettings.getNumberOfRows().intValue() == 0);
        this.userSamplingRadioButton.setSelected(!this.systemSamplingRadioButton.isSelected());
        this.jSampleSizeSpinner.setValue(this.systemSamplingRadioButton.isSelected() ? Integer.valueOf(columnFilterPreferenceSettings.getSamplingNumberOfRows()) : this.columnFilterSettings.getNumberOfRows());
        AttributeType attributeType = new AttributeType();
        attributeType.setDataType(string);
        if (DbVersionHelper.isDB122Up((Version)this.version)) {
            attributeType.setName(DialogsLrb.get("TEST_NONE"));
            attributeType.setStatus(AttributeStatus.VALID);
        } else {
            attributeType.setName(DialogsLrb.get("COLUMN_FILTER_SETTING_SELECT_A_TARGET"));
            attributeType.setStatus(AttributeStatus.INVALID);
        }
        this.selectATarget = new AttributeItem(attributeType);
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)this.getData();
        List<AttributeType> list = columnFilterNode.getTargetAttributes();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this.jTargetComboBox.removeAllItems();
        this.jTargetComboBox.addItem(this.selectATarget);
        for (AttributeType attributeType2 : list) {
            this.jTargetComboBox.addItem(new AttributeItem(attributeType2));
        }
        this.jTargetComboBox.setRenderer(new ToolTipComboBoxRenderer());
        AttributeType attributeType3 = attrImportantSettingsType.getTargetAttribute();
        if (attributeType3 != null) {
            AttributeItem attributeItem;
            boolean bl4 = false;
            for (int i = 0; i < this.jTargetComboBox.getItemCount(); ++i) {
                attributeItem = (AttributeItem)this.jTargetComboBox.getItemAt(i);
                if (!attributeType3.getName().equals(attributeItem.getAttribute().getName())) continue;
                this.jTargetComboBox.setSelectedItem(attributeItem);
                bl4 = true;
                break;
            }
            if (!bl4) {
                AttributeType attributeType4 = new AttributeType();
                attributeType4.setName(attributeType3.getName());
                attributeType4.setDataType(attributeType3.getDataType());
                attributeType4.setDataTypeQualifier(attributeType3.getDataTypeQualifier());
                attributeType4.setStatus(attributeType3.getStatus());
                attributeItem = new AttributeItem(attributeType4);
                this.jTargetComboBox.addItem(attributeItem);
                this.jTargetComboBox.setSelectedItem(attributeItem);
            }
        }
        if (DbVersionHelper.isDB122Up((Version)this.version)) {
            this.stratifiedCutoffLabel.setVisible(false);
            this.jStratifiedCutoffSpinner.setVisible(false);
            this.jSamplingTypeComboBox.setVisible(false);
            this.jSamplingTypeLabel.setVisible(false);
            this.jSamplingCheckBox.setMargin(new Insets(10, 0, 0, 0));
            this.jRequiredSupervisedLabel.setVisible(true);
            this.samplingLabel.setVisible(false);
        } else {
            this.jAttrDependencyCheckBox.setVisible(false);
            this.jRequiredSupervisedLabel.setVisible(false);
            this.systemSamplingRadioButton.setVisible(false);
            this.userSamplingRadioButton.setVisible(false);
        }
        this.isAdjusting = false;
        this.enableControls();
    }

    private void enableControls() {
        this.jDataQualityCheckBox.setEnabled(this.isWritable());
        this.jAttrImportanceCheckBox.setEnabled(this.isWritable());
        this.jSamplingCheckBox.setEnabled(this.isWritable());
        boolean bl = this.isWritable() && this.jDataQualityCheckBox.isSelected();
        this.jNullPercentCheckBox.setEnabled(bl);
        this.jUniquePercentCheckBox.setEnabled(bl);
        this.jConstantPercentCheckBox.setEnabled(bl);
        this.jNullPercentSpinner.setEnabled(bl && this.jNullPercentCheckBox.isSelected());
        this.jUniquePercentSpinner.setEnabled(bl && this.jUniquePercentCheckBox.isSelected());
        this.jConstantPercentSpinner.setEnabled(bl && this.jConstantPercentCheckBox.isSelected());
        AttributeType attributeType = ((AttributeItem)this.jTargetComboBox.getSelectedItem()).getAttribute();
        boolean bl2 = this.isWritable() && this.jAttrImportanceCheckBox.isSelected();
        this.jImportanceCheckBox.setEnabled(bl2);
        this.jTopNCheckBox.setEnabled(bl2);
        this.jImportanceSpinner.setEnabled(bl2 && this.jImportanceCheckBox.isSelected());
        this.jTopNSpinner.setEnabled(bl2 && this.jTopNCheckBox.isSelected());
        this.jTargetComboBox.setEnabled(bl2);
        this.jAttrDependencyCheckBox.setEnabled(bl2);
        this.jRequiredSupervisedLabel.setEnabled(bl2);
        this.jSamplingTypeLabel.setEnabled(bl2 && this.jSamplingCheckBox.isSelected());
        this.jSamplingTypeComboBox.setEnabled(bl2 && this.jSamplingCheckBox.isSelected());
        this.stratifiedCutoffLabel.setEnabled(bl2 && this.jSamplingCheckBox.isSelected());
        this.jStratifiedCutoffSpinner.setEnabled(bl2 && this.jSamplingCheckBox.isSelected());
        this.jSampleSizeSpinner.setEnabled(this.isWritable() && this.jSamplingCheckBox.isSelected() && this.userSamplingRadioButton.isSelected());
        if (this.jAttrImportanceCheckBox.isSelected() && !DbVersionHelper.isDB122Up((Version)this.version)) {
            AttributeItem attributeItem = (AttributeItem)this.jTargetComboBox.getSelectedItem();
            if (attributeItem.equals(this.selectATarget) || !attributeItem.getAttribute().getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jTargetLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                this.jTargetLabel.setIcon(null);
            }
        } else {
            this.jTargetLabel.setIcon(null);
        }
        this.systemSamplingRadioButton.setEnabled(this.jSamplingCheckBox.isSelected());
        this.userSamplingRadioButton.setEnabled(this.jSamplingCheckBox.isSelected());
        this.jSampleSizeSpinner.setEnabled(this.jSamplingCheckBox.isSelected() && this.userSamplingRadioButton.isSelected());
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ColumnFilterNode columnFilterNode = (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        if (columnFilterNode == null) {
            return;
        }
        this.propertyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = columnFilterNode;
        this.dirty = false;
        ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)columnFilterNode.getData();
        this.columnFilterSettings = (ColumnFilterSettingsType)MetaDataHelper.copyMetadataObject(columnFilterNodeType.getColumnFilterSettings());
        this.initUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ColumnFilterNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowColumnFilterNodePropertyProxyModel)) {
            return null;
        }
        WorkflowColumnFilterNodePropertyProxyModel workflowColumnFilterNodePropertyProxyModel = (WorkflowColumnFilterNodePropertyProxyModel)propertyModel;
        Context context = workflowColumnFilterNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ColumnFilterNodeType) {
            return (ColumnFilterNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        this.parentPanel.setColumnFilterSettings(this.columnFilterSettings);
        this.parentPanel.setAIResultTable(this.generatedAITableName);
        String string = ((AttributeItem)this.jTargetComboBox.getSelectedItem()).getAttribute().getName();
        this.parentPanel.getTargetLabel().setText(DialogsLrb.get("COLUMN_FILTER_SETTING_TARGET") + " " + string);
        if (string.equals(DialogsLrb.get("COLUMN_FILTER_SETTING_SELECT_A_TARGET")) && !DbVersionHelper.isDB122Up((Version)ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion())) {
            this.parentPanel.getTargetLabel().setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this.parentPanel.getTargetLabel().setIcon(OracleIcons.getIcon((String)"target.png"));
        }
        if (this.selectATarget.getAttribute() != null && !this.selectATarget.getAttribute().getName().equals(DialogsLrb.get("TEST_NONE")) && !this.selectATarget.getAttribute().getName().equals(DialogsLrb.get("COLUMN_FILTER_SETTING_SELECT_A_TARGET"))) {
            this.parentPanel.setTargetAttr(this.selectATarget.getAttribute());
        } else {
            this.parentPanel.setTargetAttr(null);
        }
        this.parentPanel.setDirty(true);
    }

    public ColumnFilterSettingsType getColumnFilterSettings() {
        return this.columnFilterSettings;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        if (this.isDirty() && !this.isPIMode()) {
            this.updateNode();
        }
        return bl;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("COLUMN_FILTER_SETTING_DIALOG");
    }

    @Override
    protected String getHelpTopic() {
        return "columnfilter_settings";
    }

    private void handleSampleSize() {
        BigInteger bigInteger = null;
        bigInteger = this.userSamplingRadioButton.isSelected() ? (this.jSampleSizeSpinner.getValue() instanceof BigInteger ? (BigInteger)this.jSampleSizeSpinner.getValue() : BigInteger.valueOf(((Integer)this.jSampleSizeSpinner.getValue()).intValue())) : BigInteger.valueOf(0L);
        this.columnFilterSettings.setSamplingEnabled(Boolean.valueOf(this.jSamplingCheckBox.isSelected()));
        this.columnFilterSettings.setNumberOfRows(bigInteger);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("sampleEnabled", this.jSamplingCheckBox.isSelected());
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().isSamplingEnabled());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.SAMPLE_ENABLED.index), null, complexProperty, null, null));
            complexProperty = new ComplexProperty("sampleSize", bigInteger);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getNumberOfRows());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.SAMPLE_SIZE.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_SAMPLE_SIZE_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
    }

    private void initComponents() {
        this.jDataQualityCheckBox = new JCheckBox();
        this.jNullPercentCheckBox = new JCheckBox();
        this.jNullPercentSpinner = new JSpinner();
        this.jUniquePercentCheckBox = new JCheckBox();
        this.jUniquePercentSpinner = new JSpinner();
        this.jConstantPercentCheckBox = new JCheckBox();
        this.jConstantPercentSpinner = new JSpinner();
        this.jAttrImportanceCheckBox = new JCheckBox();
        this.jTargetLabel = new JLabel();
        this.jTargetComboBox = new DataMinerCombBox();
        this.jImportanceCheckBox = new JCheckBox();
        this.jImportanceSpinner = new JSpinner();
        this.jTopNCheckBox = new JCheckBox();
        this.jTopNSpinner = new JSpinner();
        this.jSamplingTypeLabel = new JLabel();
        this.jSamplingTypeComboBox = new DataMinerCombBox();
        this.stratifiedCutoffLabel = new JLabel();
        this.jStratifiedCutoffSpinner = new JSpinner();
        this.jSamplingCheckBox = new JCheckBox();
        this.jSampleSizeSpinner = new JSpinner();
        this.jAttrDependencyCheckBox = new JCheckBox();
        this.jRequiredSupervisedLabel = new JLabel();
        this.systemSamplingRadioButton = new JRadioButton();
        this.userSamplingRadioButton = new JRadioButton();
        this.samplingLabel = new JLabel();
        this.jDataQualityCheckBox.setText("Data Quality");
        this.jDataQualityCheckBox.setName("jDataQualityCheckBox");
        this.jDataQualityCheckBox.setOpaque(false);
        this.jDataQualityCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jDataQualityCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentCheckBox.setText("% Nulls less than or equal");
        this.jNullPercentCheckBox.setName("jNullPercentCheckBox");
        this.jNullPercentCheckBox.setOpaque(false);
        this.jNullPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jNullPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jNullPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jNullPercentSpinner.setName("jNullPercentSpinner");
        this.jNullPercentSpinner.setOpaque(false);
        this.jNullPercentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jNullPercentSpinnerStateChanged(changeEvent);
            }
        });
        this.jUniquePercentCheckBox.setText("% Unique less than or equal");
        this.jUniquePercentCheckBox.setName("jUniquePercentCheckBox");
        this.jUniquePercentCheckBox.setOpaque(false);
        this.jUniquePercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jUniquePercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jUniquePercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jUniquePercentSpinner.setName("jUniquePercentSpinner");
        this.jUniquePercentSpinner.setOpaque(false);
        this.jUniquePercentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jUniquePercentSpinnerStateChanged(changeEvent);
            }
        });
        this.jConstantPercentCheckBox.setText("% Constant less than or equal");
        this.jConstantPercentCheckBox.setName("jConstantPercentCheckBox");
        this.jConstantPercentCheckBox.setOpaque(false);
        this.jConstantPercentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jConstantPercentCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jConstantPercentSpinner.setModel(new SpinnerNumberModel(95.0, 0.0, 100.0, 5.0));
        this.jConstantPercentSpinner.setName("jConstantPercentSpinner");
        this.jConstantPercentSpinner.setOpaque(false);
        this.jConstantPercentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jConstantPercentSpinnerStateChanged(changeEvent);
            }
        });
        this.jAttrImportanceCheckBox.setText("Attribute Importance");
        this.jAttrImportanceCheckBox.setName("jAttrImportanceCheckBox");
        this.jAttrImportanceCheckBox.setOpaque(false);
        this.jAttrImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jAttrImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTargetLabel.setText("Target");
        this.jTargetLabel.setName("jTargetLabel");
        this.jTargetComboBox.setName("jTargetComboBox");
        this.jTargetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jTargetComboBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceCheckBox.setText("Importance Cutoff");
        this.jImportanceCheckBox.setName("jImportanceCheckBox");
        this.jImportanceCheckBox.setOpaque(false);
        this.jImportanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jImportanceCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jImportanceSpinner.setModel(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.1));
        this.jImportanceSpinner.setName("jImportanceSpinner");
        this.jImportanceSpinner.setOpaque(false);
        this.jImportanceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jImportanceSpinnerStateChanged(changeEvent);
            }
        });
        this.jTopNCheckBox.setText("Top N");
        this.jTopNCheckBox.setName("jTopNCheckBox");
        this.jTopNCheckBox.setOpaque(false);
        this.jTopNCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jTopNCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jTopNSpinner.setModel(new SpinnerNumberModel((Number)10, Integer.valueOf(1), null, (Number)1));
        this.jTopNSpinner.setName("jTopNSpinner");
        this.jTopNSpinner.setOpaque(false);
        this.jTopNSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jTopNSpinnerStateChanged(changeEvent);
            }
        });
        this.jSamplingTypeLabel.setText("Sampling Technique:");
        this.jSamplingTypeLabel.setName("jSamplingTypeLabel");
        this.jSamplingTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSamplingTypeComboBox.setName("jSamplingTypeComboBox");
        this.jSamplingTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jSamplingTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.stratifiedCutoffLabel.setText("Stratified Cutoff");
        this.stratifiedCutoffLabel.setName("stratifiedCutoffLabel");
        this.jStratifiedCutoffSpinner.setModel(new SpinnerNumberModel((Number)10, null, null, (Number)1));
        this.jStratifiedCutoffSpinner.setName("jStratifiedCutoffSpinner");
        this.jStratifiedCutoffSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jStratifiedCutoffSpinnerStateChanged(changeEvent);
            }
        });
        this.jSamplingCheckBox.setText("Sampling");
        this.jSamplingCheckBox.setName("jSamplingCheckBox");
        this.jSamplingCheckBox.setOpaque(false);
        this.jSamplingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jSamplingCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSampleSizeSpinner.setModel(new SpinnerNumberModel((Number)2000, Integer.valueOf(1), null, (Number)1000));
        this.jSampleSizeSpinner.setName("jSampleSizeSpinner");
        this.jSampleSizeSpinner.setOpaque(false);
        this.jSampleSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SettingsPanel.this.jSampleSizeSpinnerStateChanged(changeEvent);
            }
        });
        this.jAttrDependencyCheckBox.setText("Attribute Dependency");
        this.jAttrDependencyCheckBox.setEnabled(false);
        this.jAttrDependencyCheckBox.setName("jAttrDependencyCheckBox");
        this.jAttrDependencyCheckBox.setOpaque(false);
        this.jAttrDependencyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsPanel.this.jAttrDependencyCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jRequiredSupervisedLabel.setText("(Required for supervised)");
        this.jRequiredSupervisedLabel.setName("jRequiredSupervisedLabel");
        this.systemSamplingRadioButton.setText("jRadioButton1");
        this.systemSamplingRadioButton.setName("systemSamplingRadioButton");
        this.userSamplingRadioButton.setText("jRadioButton2");
        this.userSamplingRadioButton.setName("userSamplingRadioButton");
        this.samplingLabel.setText("jLabel1");
        this.samplingLabel.setName("samplingLabel");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jUniquePercentCheckBox).addComponent(this.jConstantPercentCheckBox).addComponent(this.jImportanceCheckBox).addComponent(this.jTopNCheckBox).addComponent(this.jAttrDependencyCheckBox).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.stratifiedCutoffLabel)).addComponent(this.jSamplingTypeLabel).addGroup(groupLayout.createSequentialGroup().addComponent(this.userSamplingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.samplingLabel)).addComponent(this.systemSamplingRadioButton).addComponent(this.jNullPercentCheckBox)).addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSampleSizeSpinner, -2, 170, -2).addComponent(this.jConstantPercentSpinner, -2, 170, -2).addComponent(this.jUniquePercentSpinner, -2, 170, -2).addComponent(this.jNullPercentSpinner, -2, 170, -2).addComponent(this.jTargetComboBox, -2, 170, -2).addComponent(this.jImportanceSpinner, -2, 170, -2).addComponent(this.jTopNSpinner, -2, 170, -2).addComponent(this.jSamplingTypeComboBox, -2, 170, -2).addComponent(this.jStratifiedCutoffSpinner, -2, 170, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTargetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRequiredSupervisedLabel)))).addComponent(this.jDataQualityCheckBox).addComponent(this.jAttrImportanceCheckBox).addComponent(this.jSamplingCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jDataQualityCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNullPercentCheckBox).addComponent(this.jNullPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUniquePercentCheckBox).addComponent(this.jUniquePercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jConstantPercentCheckBox).addComponent(this.jConstantPercentSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jAttrImportanceCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLabel).addComponent(this.jRequiredSupervisedLabel).addComponent(this.jTargetComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jImportanceCheckBox).addComponent(this.jImportanceSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTopNCheckBox).addComponent(this.jTopNSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAttrDependencyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSamplingTypeLabel).addComponent(this.jSamplingTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stratifiedCutoffLabel).addComponent(this.jStratifiedCutoffSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSamplingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.systemSamplingRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userSamplingRadioButton).addComponent(this.samplingLabel).addComponent(this.jSampleSizeSpinner, -2, -1, -2)).addGap(0, 9, Short.MAX_VALUE)));
    }

    private void jDataQualityCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jDataQualityCheckBox.isSelected();
        this.jNullPercentCheckBox.setSelected(bl);
        this.jUniquePercentCheckBox.setSelected(bl);
        this.jConstantPercentCheckBox.setSelected(bl);
        this.jNullPercentCheckBoxActionPerformed(null);
        this.jUniquePercentCheckBoxActionPerformed(null);
        this.jConstantPercentCheckBoxActionPerformed(null);
    }

    private void jAttrImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAttrImportanceCheckBox.isSelected();
        if (!bl) {
            this.generatedAITableName = "NULL";
            this.jTargetComboBox.setSelectedItem(this.selectATarget);
        }
        this.jImportanceCheckBox.setSelected(bl);
        this.jTopNCheckBox.setSelected(bl);
        this.jAttrDependencyCheckBox.setSelected(bl);
        this.jTargetComboBoxActionPerformed(null);
        this.jImportanceCheckBoxActionPerformed(null);
        this.jTopNCheckBoxActionPerformed(null);
        this.jAttrDependencyCheckBoxActionPerformed(null);
    }

    private void jNullPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jNullPercentCheckBox.isSelected()) {
            d = (Double)this.jNullPercentSpinner.getValue();
        }
        this.columnFilterSettings.getDataQualitySettings().setNullsPercent(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("nullPercent", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getNullsPercent());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.NULL_PERCENT.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_NULL_PERCENT_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
        this.enableControls();
    }

    private void jUniquePercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jUniquePercentCheckBox.isSelected()) {
            d = (Double)this.jUniquePercentSpinner.getValue();
        }
        this.columnFilterSettings.getDataQualitySettings().setUniquePercent(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("uniquePercent", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getUniquePercent());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.UNIQUE_PERCENT.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_UNIQUE_PERCENT_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
        this.enableControls();
    }

    private void jConstantPercentCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        if (!(this.jNullPercentCheckBox.isSelected() || this.jUniquePercentCheckBox.isSelected() || this.jConstantPercentCheckBox.isSelected())) {
            this.jDataQualityCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jConstantPercentCheckBox.isSelected()) {
            d = (Double)this.jConstantPercentSpinner.getValue();
        }
        this.columnFilterSettings.getDataQualitySettings().setConstantPercent(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("constantPercent", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getDataQualitySettings().getConstantPercent());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.CONSTANT_PERCENT.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_CONSTANT_PERCENT_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
        this.enableControls();
    }

    private void jSamplingCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.systemSamplingRadioButton.setEnabled(this.jSamplingCheckBox.isSelected());
        this.userSamplingRadioButton.setEnabled(this.jSamplingCheckBox.isSelected());
        this.jSampleSizeSpinner.setEnabled(this.jSamplingCheckBox.isSelected());
        this.handleSampleSize();
        this.enableControls();
    }

    private void jNullPercentSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        if (this.jNullPercentCheckBox.isSelected()) {
            this.jNullPercentCheckBoxActionPerformed(null);
        }
    }

    private void jUniquePercentSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        if (this.jUniquePercentCheckBox.isSelected()) {
            this.jUniquePercentCheckBoxActionPerformed(null);
        }
    }

    private void jConstantPercentSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        if (this.jConstantPercentCheckBox.isSelected()) {
            this.jConstantPercentCheckBoxActionPerformed(null);
        }
    }

    private void jTopNSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        if (this.jTopNCheckBox.isSelected()) {
            this.jTopNCheckBoxActionPerformed(null);
        }
    }

    private void jSamplingTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isAdjusting) {
            return;
        }
        this.dirty = true;
        String string = (String)this.jSamplingTypeComboBox.getSelectedItem();
        string = ServerConstants.SamplingType.toSchema((String)string);
        this.columnFilterSettings.getAttrImportantSettings().setSamplingType(string);
        boolean bl = ServerConstants.SamplingType.isSysDetermined((String)string);
        this.jStratifiedCutoffSpinner.setVisible(bl);
        this.stratifiedCutoffLabel.setVisible(bl);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(1);
            ComplexProperty complexProperty = new ComplexProperty("samplingType", string);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getSamplingType());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.SAMPLING_TYPE.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_SAMPLING_TYPE_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
        this.enableControls();
    }

    private void jStratifiedCutoffSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        String string = this.jStratifiedCutoffSpinner.getValue().toString();
        BigInteger bigInteger = new BigInteger(string);
        this.columnFilterSettings.getAttrImportantSettings().setStratifiedCutoff(bigInteger);
        this.dirty = true;
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>(1);
            ComplexProperty complexProperty = new ComplexProperty("stratifiedCutoff", bigInteger);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getStratifiedCutoff());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.STRATIFIED_CUTOFF.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_STRATIFIED_CUTOFF_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
    }

    private void jSampleSizeSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        if (this.jSamplingCheckBox.isSelected()) {
            this.jSamplingCheckBoxActionPerformed(null);
        }
    }

    private void jAttrDependencyCheckBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isAdjusting) {
            return;
        }
        this.dirty = true;
        boolean bl = this.jAttrDependencyCheckBox.isSelected();
        this.columnFilterSettings.getAttrImportantSettings().setAttributeDependency(Boolean.valueOf(bl));
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("AttrDependency", bl);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().isAttributeDependency());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.ATTR_DEPENDENCY.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_RANK_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
    }

    private void jTargetComboBoxActionPerformed(ActionEvent actionEvent) {
        AITableNameGen aITableNameGen;
        if (this.isAdjusting) {
            return;
        }
        AttributeItem attributeItem = (AttributeItem)this.jTargetComboBox.getSelectedItem();
        if (this.jAttrImportanceCheckBox.isSelected()) {
            if ("NULL".equals(this.generatedAITableName) || this.generatedAITableName == null) {
                aITableNameGen = new AITableNameGen();
                aITableNameGen.setTitle(DialogsLrb.get("COLUMN_FILTER_AI_TABLE_GEN_TITLE"));
                aITableNameGen.setMessage(DialogsLrb.get("COLUMN_FILTER_AI_TABLE_GEN_DESC"));
                aITableNameGen.setCancelable(true);
                try {
                    aITableNameGen.start(true);
                    if (!aITableNameGen.isCanceled()) {
                        this.generatedAITableName = aITableNameGen.getTableName();
                    }
                }
                catch (ProgressException progressException) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("COLUMN_FILTER_NODE_EDIT_ERROR_MESG"), null);
                }
            }
        } else {
            this.generatedAITableName = "NULL";
            attributeItem = new AttributeItem(null);
        }
        this.dirty = true;
        if (this.isPIMode()) {
            aITableNameGen = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("AttrImportanceTable", this.generatedAITableName);
            complexProperty.setOldData(aITableNameGen.getColumnFilterResults().getAttrImportanceOutput());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.AI_TABLE.index), null, complexProperty, null, null));
            complexProperty = new ComplexProperty("target", attributeItem.getAttribute() != null && !attributeItem.getAttribute().getName().equals(DialogsLrb.get("TEST_NONE")) && !attributeItem.getAttribute().getName().equals(DialogsLrb.get("COLUMN_FILTER_SETTING_SELECT_A_TARGET")) ? attributeItem.getAttribute() : null);
            complexProperty.setOldData(aITableNameGen.getColumnFilterSettings().getAttrImportantSettings().getTargetAttribute());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.TARGET.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_TARGET_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        } else {
            this.columnFilterSettings.getAttrImportantSettings().setTargetAttribute(attributeItem.getAttribute() != null && !attributeItem.getAttribute().getName().equals(DialogsLrb.get("TEST_NONE")) && !attributeItem.getAttribute().getName().equals(DialogsLrb.get("COLUMN_FILTER_SETTING_SELECT_A_TARGET")) ? attributeItem.getAttribute() : null);
        }
        this.enableControls();
    }

    private void jImportanceSpinnerStateChanged(ChangeEvent changeEvent) {
        if (this.isAdjusting) {
            return;
        }
        if (this.jImportanceCheckBox.isSelected()) {
            this.jImportanceCheckBoxActionPerformed(null);
        }
    }

    private void jTopNCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.generatedAITableName = "NULL";
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        BigInteger bigInteger = null;
        Object object = this.jTopNSpinner.getValue();
        if (this.jTopNCheckBox.isSelected()) {
            bigInteger = object instanceof Integer ? BigInteger.valueOf(((Integer)object).intValue()) : (BigInteger)object;
        }
        this.columnFilterSettings.getAttrImportantSettings().setTopN(bigInteger);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("rank", bigInteger);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getTopN());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.RANK.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_RANK_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
        this.enableControls();
    }

    private void jImportanceCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        if (!this.jImportanceCheckBox.isSelected() && !this.jTopNCheckBox.isSelected()) {
            this.generatedAITableName = "NULL";
            this.jAttrImportanceCheckBox.setSelected(false);
        }
        Double d = null;
        if (this.jImportanceCheckBox.isSelected()) {
            d = (Double)this.jImportanceSpinner.getValue();
        }
        this.columnFilterSettings.getAttrImportantSettings().setCutOff(d);
        if (this.isPIMode()) {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)this.getData()).getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            ComplexProperty complexProperty = new ComplexProperty("importance", d);
            complexProperty.setOldData(columnFilterNodeType.getColumnFilterSettings().getAttrImportantSettings().getCutOff());
            arrayList.add(new Property(String.valueOf(ColumnFilterNodePropertyModel.IMPORTANCE.index), null, complexProperty, null, null));
            this.propertyModel.setValueAt(ColumnFilterPIPropertyLrb.get("PI_COLUMN_FILTER_GROUP_SETTING_IMPORTANCE_CHANGED_DESCRIPTION"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
        this.enableControls();
    }

    private class SystemSamplingListener
    implements ActionListener {
        private SystemSamplingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SettingsPanel.this.dirty = true;
            SettingsPanel.this.jSampleSizeSpinner.setEnabled(false);
            SettingsPanel.this.handleSampleSize();
        }
    }

    private class UserSamplingListener
    implements ActionListener {
        private UserSamplingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SettingsPanel.this.dirty = true;
            SettingsPanel.this.jSampleSizeSpinner.setEnabled(true);
            SettingsPanel.this.handleSampleSize();
        }
    }

    class AITableNameGen
    extends ProgressRunnable {
        private static final String AI_SUFFIX = "_AI";
        private boolean canceled;
        private String tableName;

        AITableNameGen() {
        }

        public String getTableName() {
            return this.tableName;
        }

        protected Object doWork() throws Exception {
            ColumnFilterNodeType columnFilterNodeType = (ColumnFilterNodeType)((ColumnFilterNode)SettingsPanel.this.getData()).getData();
            String string = columnFilterNodeType.getName().replace(' ', '_').toUpperCase();
            if (string.length() > 20) {
                string = string.substring(0, 20);
            }
            this.tableName = WorkflowUtils.getNewTableName(SettingsPanel.this._context, "ODMR$" + string + AI_SUFFIX);
            return this.tableName;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }
}

