/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.wizard.WizardModel;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;

public class TransformWizardModel
extends WizardModel {
    private volatile boolean _wizardIsCancelled;
    private WorkflowBuildTextNodePropertyProxyModel _propertyModel;
    private TextNodeType _textNodeType;
    private TextNodeType.Stoplists _stoplists;
    private TransformedAttributesType _transformedAttributes;
    private List<TransformationSourceAttribute> _selectedAttributes;
    private List<TransformationSourceAttribute> _editedAttributes;
    private List<MapTextTransformedSourceType> _mapTextTransformedSources;
    private Context _context;
    private BuildTextPanel _parent;
    private BuildTextNode _node;
    private boolean _isEdit;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private static String TRANSFORM_TOKEN = DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_TOKEN");
    private static String TRANSFORM_THEME = DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_THEME");
    private static String TRANSFORM_OUTPUT_TOKEN = "TOK";
    private static String TRANSFORM_OUTPUT_THEME = "THM";

    public TransformWizardModel(BuildTextPanel buildTextPanel, PropertyModel propertyModel, Context context, BuildTextNode buildTextNode, TextNodeType textNodeType, List<TransformationSourceAttribute> list) {
        this._context = context;
        this._propertyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        this._parent = buildTextPanel;
        this._node = buildTextNode;
        this._textNodeType = textNodeType;
        this._transformedAttributes = (TransformedAttributesType)MetaDataHelper.copyMetadataObject(this._textNodeType.getTransformedAttributes());
        this._stoplists = new TextNodeType.Stoplists();
        for (Object object : this._textNodeType.getStoplists().getStoplist()) {
            this._stoplists.getStoplist().add((StoplistType)MetaDataHelper.copyMetadataObject(object));
        }
        this._selectedAttributes = list;
        TransformationSourceAttribute transformationSourceAttribute = list.get(0);
        if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
            this._isEdit = true;
            this._editedAttributes = new ArrayList<TransformationSourceAttribute>();
            for (TransformationSourceAttribute transformationSourceAttribute2 : list) {
                for (MapTextTransformedSourceType mapTextTransformedSourceType : this._transformedAttributes.getMapTextTransformedSource()) {
                    if (!mapTextTransformedSourceType.getKey().getName().equals(transformationSourceAttribute2.getName())) continue;
                    this._editedAttributes.add((TransformationSourceAttribute)mapTextTransformedSourceType.getKey());
                }
            }
        } else {
            this._isEdit = false;
            this._mapTextTransformedSources = new ArrayList<MapTextTransformedSourceType>();
        }
    }

    public void setWizardCancelled(boolean bl) {
        boolean bl2 = this._wizardIsCancelled;
        this._wizardIsCancelled = bl;
        this._changeSupport.firePropertyChange("wizardCancelled", bl2, bl);
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    public JPanel getParent() {
        return this._parent;
    }

    public void generateOutputNames(String string) {
        String string2 = string.equals(TRANSFORM_TOKEN) ? TRANSFORM_OUTPUT_TOKEN : TRANSFORM_OUTPUT_THEME;
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)this._node.getData();
        BuildTextNode.UniqueNameGenerator uniqueNameGenerator = new BuildTextNode.UniqueNameGenerator(this.getContext(), buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType(), this._transformedAttributes.getMapTextTransformedSource());
        if (this._isEdit) {
            for (TransformationSourceAttribute transformationSourceAttribute : this._editedAttributes) {
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                String string3 = uniqueNameGenerator.generateUniqueName(textTransformationOutputAttributeType.getSource(), string2);
                textTransformationOutputAttributeType.setAlias(string3);
            }
        } else {
            uniqueNameGenerator.addNames(this._mapTextTransformedSources);
            for (MapTextTransformedSourceType mapTextTransformedSourceType : this._mapTextTransformedSources) {
                String string4 = uniqueNameGenerator.generateUniqueName(mapTextTransformedSourceType.getKey().getSource(), string2);
                mapTextTransformedSourceType.getKey().setName(string4);
            }
        }
    }

    public List<TransformationSourceAttribute> getEditAttributes() {
        return this._editedAttributes;
    }

    public List<MapTextTransformedSourceType> getNewAttributes() {
        return this._mapTextTransformedSources;
    }

    public void addDefaultStoplist(StoplistType stoplistType) {
        if (this._node.findDefaultStoplist(((StoplistType.StopTokens.Token)stoplistType.getStopTokens().getToken().get(0)).getLanguage()) == null) {
            this._stoplists.getStoplist().add(stoplistType);
        }
    }

    public void addStoplist(StoplistType stoplistType) {
        if (this._node.findStoplistWithName(stoplistType.getName()) == null) {
            this._stoplists.getStoplist().add(stoplistType);
        }
    }

    public void updateNode() {
        BuildTextNode buildTextNode = this._node;
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)buildTextNode.getData();
        if (!this._isEdit) {
            this._transformedAttributes.getMapTextTransformedSource().addAll(this._mapTextTransformedSources);
        }
        if (this._isEdit) {
            for (TransformationSourceAttribute object : this._editedAttributes) {
                object.setName(object.getAlias());
                object.setAlias(null);
            }
        }
        if (this._propertyModel != null) {
            var3_3 = new ArrayList();
            ComplexProperty complexProperty = new ComplexProperty("editStoplists", this._stoplists);
            complexProperty.setOldData(buildTextNodeType.getStoplists());
            var3_3.add(new Property(String.valueOf(BuildTextNodePropertyModel.EDIT_STOPLISTS.index), null, complexProperty, null, null));
            ComplexProperty complexProperty2 = new ComplexProperty("editColumns", this._transformedAttributes);
            complexProperty.setOldData(buildTextNodeType.getTransformedAttributes());
            var3_3.add(new Property(String.valueOf(BuildTextNodePropertyModel.EDIT_COLUMNS.index), null, complexProperty2, null, null));
            if (!this._isEdit) {
                Object object;
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
                TransformedAttributesType transformedAttributesType = this._transformedAttributes;
                if (transformedAttributesType != null && (object = transformedAttributesType.getMapTextTransformedSource()) != null && !object.isEmpty()) {
                    Iterator iterator = object.iterator();
                    block1: while (iterator.hasNext()) {
                        MapTextTransformedSourceType mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                        String string = mapTextTransformedSourceType.getKey().getSource();
                        for (TransformationSourceAttribute transformationSourceAttribute : buildTextNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                            if (string.compareTo(transformationSourceAttribute.getName()) != 0) continue;
                            hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute.isIsOutput());
                            hashMap2.put(transformationSourceAttribute.getName(), false);
                            continue block1;
                        }
                    }
                }
                object = new ComplexProperty("outputState", hashMap2);
                complexProperty.setOldData(hashMap);
                var3_3.add(new Property(String.valueOf(BuildTextNodePropertyModel.OUTPUT_STATE.index), null, object, null, null));
            }
            this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_EDIT_TRANSFORMATION_ELEMENT"), buildTextNode, (List<Property>)((Object)var3_3));
        } else {
            Object object;
            MapTextTransformedSourceType mapTextTransformedSourceType;
            Iterator iterator;
            Object object22;
            this._textNodeType.setStoplists(this._stoplists);
            var3_3 = new HashMap<String, Boolean>();
            for (Object object22 : this._stoplists.getStoplist()) {
                var3_3.put(object22.getId(), Boolean.TRUE);
            }
            TransformedAttributesType transformedAttributesType = this._textNodeType.getTransformedAttributes();
            if (transformedAttributesType != null && (object22 = transformedAttributesType.getMapTextTransformedSource()) != null && !object22.isEmpty()) {
                iterator = object22.iterator();
                while (iterator.hasNext()) {
                    Object object3;
                    mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                    object = mapTextTransformedSourceType.getKey().getTransformationElement().getToken();
                    if (object == null) {
                        object = mapTextTransformedSourceType.getKey().getTransformationElement().getTheme();
                    }
                    if ((object3 = object.getToken().getStoplistId()) == null || var3_3.containsKey(object3)) continue;
                    object.getToken().setStoplistId(null);
                }
            }
            this._textNodeType.setTransformedAttributes(this._transformedAttributes);
            if (this._transformedAttributes != null && (object22 = this._transformedAttributes.getMapTextTransformedSource()) != null && !object22.isEmpty()) {
                iterator = object22.iterator();
                while (iterator.hasNext()) {
                    mapTextTransformedSourceType = (MapTextTransformedSourceType)iterator.next();
                    object = mapTextTransformedSourceType.getKey().getSource();
                    for (TransformationSourceAttribute transformationSourceAttribute : this._textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType()) {
                        if (((String)object).compareTo(transformationSourceAttribute.getName()) != 0) continue;
                        transformationSourceAttribute.setIsOutput(false);
                    }
                }
            }
        }
    }

    public WorkflowBuildTextNodePropertyProxyModel getPropertyModel() {
        return this._propertyModel;
    }

    public BuildTextNode getNode() {
        return this._node;
    }

    public boolean isEdit() {
        return this._isEdit;
    }

    public TransformedAttributesType getTransformedAttributes() {
        return this._transformedAttributes;
    }

    public List<TransformationSourceAttribute> getSelectedAttributes() {
        return this._selectedAttributes;
    }

    public TextNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

