/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.extensible.r;

import java.awt.Component;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.extensible.r.RFunction;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.FunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class ScoreFunctionSelectionPanel
extends FunctionSelectionPanel {
    private RModelType.ScoreFunctions functions = new RModelType.ScoreFunctions();
    private DefaultComboBoxModel<RFunction> modelA;
    private DefaultComboBoxModel<RFunction> modelB;
    private JCheckBox includeAllSchemasCheckBox;
    private JLabel infoWeightIcon;
    private JComboBox<RFunction> jScoreChoice;
    private JTextArea jScoreDefinition;
    private JLabel jScoreDefinitionLabel;
    private JLabel jScoreLabel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JComboBox<RFunction> jSecondaryChoice;
    private JTextArea jSecondaryDefinition;
    private JLabel jSecondaryDefinitionLabel;
    private JLabel jSecondaryFunctionLabel;

    public ScoreFunctionSelectionPanel(Context context, RModelType.ScoreFunctions scoreFunctions) {
        super(context);
        if (scoreFunctions != null) {
            this.cloneBuildFunctions(scoreFunctions, this.functions);
        }
        this.determineUseOtherSchemas(this.functions.getPrimaryFunction(), this.functions.getSecondaryFunction());
        this.initializeComponents();
        this.initRes();
        this.initUI();
    }

    private void cloneBuildFunctions(RModelType.ScoreFunctions scoreFunctions, RModelType.ScoreFunctions scoreFunctions2) {
        scoreFunctions2.setPrimaryFunction(scoreFunctions.getPrimaryFunction());
        scoreFunctions2.setSecondaryFunction(scoreFunctions.getSecondaryFunction());
    }

    private void initComponents() {
        this.jScoreLabel = new JLabel();
        this.jScoreChoice = new JComboBox();
        this.jScoreDefinitionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jScoreDefinition = new JTextArea();
        this.jSecondaryFunctionLabel = new JLabel();
        this.jSecondaryChoice = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.jSecondaryDefinition = new JTextArea();
        this.jSecondaryDefinitionLabel = new JLabel();
        this.infoWeightIcon = new JLabel();
        this.includeAllSchemasCheckBox = new JCheckBox();
        this.jScoreLabel.setText("Score Function:");
        this.jScoreDefinitionLabel.setText("Function Definition:");
        this.jScoreDefinition.setColumns(20);
        this.jScoreDefinition.setRows(5);
        this.jScrollPane1.setViewportView(this.jScoreDefinition);
        this.jSecondaryFunctionLabel.setText("Secondary Function:");
        this.jSecondaryDefinition.setColumns(20);
        this.jSecondaryDefinition.setRows(5);
        this.jScrollPane2.setViewportView(this.jSecondaryDefinition);
        this.jSecondaryDefinitionLabel.setText("Function Definition:");
        this.infoWeightIcon.setText("infoIcon");
        this.includeAllSchemasCheckBox.setText("Include Other Schemas");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScoreChoice, -2, 300, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScoreLabel).addGap(341, 341, 341)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING, -1, 416, Short.MAX_VALUE).addComponent(this.jScoreDefinitionLabel, GroupLayout.Alignment.LEADING).addComponent(this.jSecondaryFunctionLabel, GroupLayout.Alignment.LEADING).addComponent(this.jSecondaryDefinitionLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jSecondaryChoice, -2, 300, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoWeightIcon)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING)).addComponent(this.includeAllSchemasCheckBox))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.includeAllSchemasCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScoreLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScoreChoice, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScoreDefinitionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 100, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jSecondaryFunctionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSecondaryChoice, -2, -1, -2).addComponent(this.infoWeightIcon)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSecondaryDefinitionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 101, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected void initializeComponents() {
        this.initComponents();
    }

    @Override
    protected void initRes() {
        ResourceUtils.resLabel((JLabel)this.jScoreLabel, this.jScoreChoice, (String)BuildEditorLrb.get("R_SCORE_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jScoreDefinitionLabel, (Component)this.jScoreDefinition, (String)BuildEditorLrb.get("R_FUNCTION_DEFINITION"));
        ResourceUtils.resLabel((JLabel)this.jSecondaryFunctionLabel, this.jSecondaryChoice, (String)BuildEditorLrb.get("R_WEIGHT_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jSecondaryDefinitionLabel, (Component)this.jSecondaryDefinition, (String)BuildEditorLrb.get("R_FUNCTION_DEFINITION"));
        ResourceUtils.resButton((AbstractButton)this.includeAllSchemasCheckBox, (String)BuildEditorLrb.get("R_FUNCTIONS_ALL_SCHEMAS"));
        this.infoWeightIcon.setToolTipText(BuildEditorLrb.get("R_WEIGHT_FUNCTION_REQUIRED"));
        this.infoWeightIcon.setIcon(OracleIcons.getIcon((String)"info.png"));
        this.infoWeightIcon.setText("");
    }

    @Override
    protected void initUI() {
        this.modelA = new DefaultComboBoxModel();
        this.jScoreChoice.setModel(this.modelA);
        this.jScoreChoice.setRenderer(new FunctionSelectionPanel.QualifiedFunctionRenderer());
        this.modelB = new DefaultComboBoxModel();
        this.jSecondaryChoice.setModel(this.modelB);
        this.jSecondaryChoice.setRenderer(new FunctionSelectionPanel.QualifiedFunctionRenderer());
        this.jScoreDefinition.setEditable(false);
        this.jSecondaryDefinition.setEditable(false);
        this.includeAllSchemasCheckBox.setSelected(this.isUsingOtherSchemas());
    }

    private void addActionListeners() {
        this.jScoreChoice.addActionListener(new ScoreFunctionChangeListener(this.modelA, this.jScoreDefinition));
        this.jSecondaryChoice.addActionListener(new WeightFunctionChangeListener(this.modelB, this.jSecondaryDefinition));
        this.includeAllSchemasCheckBox.addActionListener(new ScoringFunctionsAllSchemaListener());
    }

    @Override
    protected void afterSuccess() {
        this.populateComboModels(this.modelA, this.modelB);
        String string = this.functions.getPrimaryFunction();
        String string2 = this.functions.getSecondaryFunction();
        this.addActionListeners();
        this.setSelectedFunctionsFromMetaData(string, string2);
    }

    private void setSelectedFunctionsFromMetaData(String string, String string2) {
        if (StringUtils.isNotEmpty((String)string)) {
            this.setSelectedFunction(this.modelA, string);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.setSelectedFunction(this.modelB, string2);
        }
    }

    @Override
    protected void afterReloadSuccess() {
        this.populateComboModels(this.modelA, this.modelB);
        this.isReloading = false;
        String string = this.functions.getPrimaryFunction();
        String string2 = this.functions.getSecondaryFunction();
        this.setSelectedFunctionsFromMetaData(string, string2);
    }

    @Override
    protected String getWindowTitle() {
        return BuildEditorLrb.get("R_SCORE_FUNCTION");
    }

    @Override
    protected String getWindowHelpTopic() {
        return "r_score_function";
    }

    @Override
    protected boolean validateForm() {
        if (StringUtils.isNotEmpty((String)this.functions.getSecondaryFunction())) {
            return StringUtils.isNotEmpty((String)this.functions.getPrimaryFunction());
        }
        return true;
    }

    @Override
    protected String getValidationErrorMessage() {
        return BuildEditorLrb.get("R_INCOMPLETE_SCORE_FUNCTION");
    }

    @Override
    protected void cleanUp() {
        this.functions = null;
    }

    private RModelType.ScoreFunctions getScoreFunctions() {
        return this.functions;
    }

    public static Optional<RModelType.ScoreFunctions> addScoreFunctions(Context context, RModelType.ScoreFunctions scoreFunctions) {
        RModelType.ScoreFunctions scoreFunctions2 = null;
        ScoreFunctionSelectionPanel scoreFunctionSelectionPanel = new ScoreFunctionSelectionPanel(context, scoreFunctions);
        scoreFunctionSelectionPanel.load();
        DialogHelper dialogHelper = new DialogHelper(scoreFunctionSelectionPanel);
        if (dialogHelper.showAsDialog()) {
            scoreFunctions2 = scoreFunctionSelectionPanel.getScoreFunctions();
        }
        return Optional.ofNullable(scoreFunctions2);
    }

    @Override
    protected void afterFailure() {
        this.modelA = new DefaultComboBoxModel();
        this.modelA.addElement(DEFAULT_OPTION);
        this.jScoreChoice.setModel(this.modelA);
        this.jSecondaryChoice.setModel(this.modelA);
        this.jScoreChoice.setEnabled(false);
        this.jSecondaryChoice.setEnabled(false);
    }

    private class ScoreFunctionChangeListener
    extends FunctionSelectionPanel.FunctionChangeListener {
        private ScoreFunctionChangeListener(DefaultComboBoxModel<RFunction> defaultComboBoxModel, JTextArea jTextArea) {
            super(defaultComboBoxModel, jTextArea);
        }

        @Override
        protected void updateMetaData(String string) {
            ScoreFunctionSelectionPanel.this.functions.setPrimaryFunction(string);
        }
    }

    private class WeightFunctionChangeListener
    extends FunctionSelectionPanel.FunctionChangeListener {
        private WeightFunctionChangeListener(DefaultComboBoxModel<RFunction> defaultComboBoxModel, JTextArea jTextArea) {
            super(defaultComboBoxModel, jTextArea);
        }

        @Override
        protected void updateMetaData(String string) {
            ScoreFunctionSelectionPanel.this.functions.setSecondaryFunction(string);
        }
    }

    private class ScoringFunctionsAllSchemaListener
    extends FunctionSelectionPanel.QueryAllSchemasListener {
        private ScoringFunctionsAllSchemaListener() {
        }

        @Override
        protected void updateMetaData() {
            RFunction rFunction = (RFunction)ScoreFunctionSelectionPanel.this.modelA.getSelectedItem();
            String string = rFunction.getQualifiedName();
            ScoreFunctionSelectionPanel.this.functions.setPrimaryFunction(string);
            RFunction rFunction2 = (RFunction)ScoreFunctionSelectionPanel.this.modelB.getSelectedItem();
            string = rFunction2.getQualifiedName();
            ScoreFunctionSelectionPanel.this.functions.setSecondaryFunction(string);
        }
    }
}

