/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.extensible.r;

import java.awt.Component;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.extensible.r.GetRConfigurationQuery;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.BuildFunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.DetailsFunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.ScoreFunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.util.Version;

public class RModelSettingsPanel
extends AbstractPropertiesPanel {
    private ConnectionManager connectionManager;
    private SqlDataAccessObject dao;
    private Version dbVersion;
    private Context context;
    private RModelType.BuildFunctions modelBuildFunctions;
    private RModelType.ScoreFunctions modelScoreFunctions;
    private RModelType.DetailFunction modelDetailFunction;
    private BlockingComponent overlayPanel;
    private JLabel buildWarning;
    private JLabel detailsWarning;
    private JButton jBuildButton;
    private JTextField jBuildFunction;
    private JLabel jBuildLabel;
    private JButton jDetailsButton;
    private JTextField jDetailsFunction;
    private JLabel jDetailsLabel;
    private JButton jScoreButton;
    private JTextField jScoreFunction;
    private JLabel jScoreLabel;
    private JLabel scoreWarning;

    public RModelSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        assert (this.getParentPanel().getData() instanceof RBuildNode) : "This panel was designed for R build nodes only";
        assert (modelType instanceof RModelType) : "This panel was designed for R models only";
        this.modelBuildFunctions = new RModelType.BuildFunctions();
        this.modelScoreFunctions = new RModelType.ScoreFunctions();
        this.modelDetailFunction = new RModelType.DetailFunction();
        this.context = this.getParentPanel().getContext();
        this.connectionManager = ConnectionFolder.getConnectionFolder(this.context);
        this.dbVersion = this.connectionManager.getDbVersion();
        this.dao = new SqlDataAccessObject(this.connectionManager);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jBuildLabel = new JLabel();
        this.jScoreLabel = new JLabel();
        this.jDetailsLabel = new JLabel();
        this.jDetailsFunction = new JTextField();
        this.jScoreFunction = new JTextField();
        this.jBuildFunction = new JTextField();
        this.jBuildButton = new JButton();
        this.jScoreButton = new JButton();
        this.jDetailsButton = new JButton();
        this.detailsWarning = new JLabel();
        this.scoreWarning = new JLabel();
        this.buildWarning = new JLabel();
        this.jBuildLabel.setText("Build Function:");
        this.jScoreLabel.setText("Score Function:");
        this.jDetailsLabel.setText("Model Details Function:");
        this.jBuildButton.setText("Edit...");
        this.jScoreButton.setText("Edit...");
        this.jDetailsButton.setText("Edit...");
        this.detailsWarning.setText("warning");
        this.scoreWarning.setText("warning");
        this.buildWarning.setText("warning");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScoreLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jDetailsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jBuildLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScoreFunction, -1, 215, Short.MAX_VALUE).addComponent(this.jBuildFunction, GroupLayout.Alignment.LEADING).addComponent(this.jDetailsFunction)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scoreWarning)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jDetailsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailsWarning)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jBuildButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buildWarning))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBuildLabel).addComponent(this.jBuildFunction, -2, -1, -2).addComponent(this.jBuildButton).addComponent(this.buildWarning)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jScoreFunction, -2, -1, -2).addComponent(this.jScoreLabel).addComponent(this.jScoreButton).addComponent(this.scoreWarning)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDetailsFunction, -2, -1, -2).addComponent(this.jDetailsLabel).addComponent(this.jDetailsButton).addComponent(this.detailsWarning)).addContainerGap()));
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jBuildLabel, (Component)this.jBuildLabel, (String)BuildEditorLrb.get("R_BUILD_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jScoreLabel, (Component)this.jScoreLabel, (String)BuildEditorLrb.get("R_SCORE_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jDetailsLabel, (Component)this.jDetailsLabel, (String)BuildEditorLrb.get("R_DETAILS_FUNCTION"));
        ResourceUtils.resButton((AbstractButton)this.jBuildButton, (String)WorkflowEditorLrb.get("EDIT_NODE"));
        ResourceUtils.resButton((AbstractButton)this.jScoreButton, (String)WorkflowEditorLrb.get("EDIT_NODE"));
        ResourceUtils.resButton((AbstractButton)this.jDetailsButton, (String)WorkflowEditorLrb.get("EDIT_NODE"));
        this.buildWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.buildWarning.setText("");
        this.buildWarning.setToolTipText(BuildEditorLrb.get("R_BUILD_FUNCTIONS_MISSING"));
        this.scoreWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.scoreWarning.setText("");
        this.scoreWarning.setToolTipText(BuildEditorLrb.get("R_SCORE_FUNCTIONS_MISSING"));
        this.detailsWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.detailsWarning.setText("");
        this.detailsWarning.setToolTipText(BuildEditorLrb.get("R_DETAILS_FUNCTION_MISSING"));
    }

    private void initUI() {
        this.loadBuildFunctionFromState();
        this.loadScoringFunctionsFromState();
        this.loadModelDetailsFunctionFromState();
        this.loadMetaDataToTextFields();
        this.disableTextFields();
        this.hideWarningIcons();
        this.overlayPanel = new BlockingComponent((JComponent)this);
        this.addListeners();
    }

    private void loadBuildFunctionFromState() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        String string = commonSettingDataObject.getModelSettingStringValue("RALG_BUILD_FUNCTION");
        RModelType.BuildFunctions.Settings settings = (RModelType.BuildFunctions.Settings)commonSettingDataObject.getModelSettingObjectValue("RALG_BUILD_PARAMETER");
        commonSettingDataObject.setBackupValue("RALG_BUILD_FUNCTION", string);
        commonSettingDataObject.setBackupValue("RALG_BUILD_PARAMETER", settings);
        this.modelBuildFunctions.setPrimaryFunction(string);
        this.modelBuildFunctions.setSettings(settings);
    }

    private void loadScoringFunctionsFromState() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        String string = commonSettingDataObject.getModelSettingStringValue("RALG_SCORE_FUNCTION");
        String string2 = commonSettingDataObject.getModelSettingStringValue("RALG_WEIGHT_FUNCTION");
        commonSettingDataObject.setBackupValue("RALG_SCORE_FUNCTION", string);
        commonSettingDataObject.setBackupValue("RALG_WEIGHT_FUNCTION", string2);
        this.modelScoreFunctions.setPrimaryFunction(string);
        this.modelScoreFunctions.setSecondaryFunction(string2);
    }

    private void loadModelDetailsFunctionFromState() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        String string = commonSettingDataObject.getModelSettingStringValue("RALG_DETAILS_FUNCTION");
        RModelType.DetailFunction.Output output = (RModelType.DetailFunction.Output)commonSettingDataObject.getModelSettingObjectValue("RALG_DETAILS_FORMAT");
        commonSettingDataObject.setBackupValue("RALG_DETAILS_FUNCTION", string);
        commonSettingDataObject.setBackupValue("RALG_DETAILS_FORMAT", output);
        this.modelDetailFunction.setPrimaryFunction(string);
        this.modelDetailFunction.setOutput(output);
    }

    private void loadMetaDataToTextFields() {
        this.jBuildFunction.setText(this.modelBuildFunctions.getPrimaryFunction());
        this.jBuildFunction.setCaretPosition(0);
        this.jScoreFunction.setText(this.modelScoreFunctions.getPrimaryFunction());
        this.jScoreFunction.setCaretPosition(0);
        this.jDetailsFunction.setText(this.modelDetailFunction.getPrimaryFunction());
        this.jDetailsFunction.setCaretPosition(0);
    }

    private void disableTextFields() {
        this.jBuildFunction.setEditable(false);
        this.jScoreFunction.setEditable(false);
        this.jDetailsFunction.setEditable(false);
    }

    private void hideWarningIcons() {
        this.buildWarning.setVisible(StringUtils.isEmpty(this.modelBuildFunctions.getPrimaryFunction()));
        this.scoreWarning.setVisible(StringUtils.isEmpty(this.modelScoreFunctions.getPrimaryFunction()));
        this.detailsWarning.setVisible(StringUtils.isEmpty(this.modelDetailFunction.getPrimaryFunction()));
    }

    private void addListeners() {
        RBuildNode rBuildNode = (RBuildNode)this.getParentPanel().getData();
        this.jBuildButton.addActionListener(actionEvent -> {
            Optional<RModelType.BuildFunctions> optional = BuildFunctionSelectionPanel.addBuildFunctions(this.context, rBuildNode, this.modelBuildFunctions);
            if (optional.isPresent()) {
                if (this.modelBuildFunctions != null) {
                    this.modelBuildFunctions.setSettings(null);
                }
                this.modelBuildFunctions = optional.get();
                this.jBuildFunction.setText(this.modelBuildFunctions.getPrimaryFunction());
                this.jBuildFunction.setCaretPosition(0);
            }
            this.buildWarning.setVisible(this.modelBuildFunctions == null || StringUtils.isEmpty(this.modelBuildFunctions.getPrimaryFunction()));
        });
        this.jScoreButton.addActionListener(actionEvent -> {
            Optional<RModelType.ScoreFunctions> optional = ScoreFunctionSelectionPanel.addScoreFunctions(this.context, this.modelScoreFunctions);
            if (optional.isPresent()) {
                this.modelScoreFunctions = optional.get();
                this.jScoreFunction.setText(this.modelScoreFunctions.getPrimaryFunction());
                this.jScoreFunction.setCaretPosition(0);
            }
            this.scoreWarning.setVisible(this.modelScoreFunctions == null || StringUtils.isEmpty(this.modelScoreFunctions.getPrimaryFunction()));
        });
        this.jDetailsButton.addActionListener(actionEvent -> {
            Optional<RModelType.DetailFunction> optional = DetailsFunctionSelectionPanel.addDetailFunction(this.context, this.modelDetailFunction);
            if (optional.isPresent()) {
                if (this.modelDetailFunction != null) {
                    this.modelDetailFunction.setOutput(null);
                }
                this.modelDetailFunction = optional.get();
                this.jDetailsFunction.setText(this.modelDetailFunction.getPrimaryFunction());
                this.jDetailsFunction.setCaretPosition(0);
            }
            this.detailsWarning.setVisible(this.modelDetailFunction == null || StringUtils.isEmpty(this.modelDetailFunction.getPrimaryFunction()));
        });
    }

    @Override
    public void processInput() {
        if (!(this.isBuildFunctionValid() && this.areScoringFunctionsValid() && this.isModelDetailsDefinitionValid())) {
            return;
        }
    }

    private boolean isBuildFunctionValid() {
        String string = this.modelBuildFunctions.getPrimaryFunction();
        boolean bl = StringUtils.isNotEmpty(string);
        if (bl) {
            this.setObjectValue("RALG_BUILD_FUNCTION", string);
            this.setObjectValue("RALG_BUILD_PARAMETER", this.modelBuildFunctions.getSettings());
            return true;
        }
        this.setValidationErrorObjectValue(BuildEditorLrb.get("R_INVALID_BUILD_FUNCTION"));
        return false;
    }

    private boolean areScoringFunctionsValid() {
        String string = this.modelScoreFunctions.getPrimaryFunction();
        String string2 = this.modelScoreFunctions.getSecondaryFunction();
        boolean bl = StringUtils.isEmpty(string);
        boolean bl2 = StringUtils.isNotEmpty(string2);
        if (bl && bl2) {
            this.setValidationErrorObjectValue(BuildEditorLrb.get("R_INCOMPLETE_SCORE_FUNCTION"));
            return false;
        }
        this.setObjectValue("RALG_SCORE_FUNCTION", string);
        this.setObjectValue("RALG_WEIGHT_FUNCTION", string2);
        return true;
    }

    private boolean isModelDetailsDefinitionValid() {
        boolean bl;
        String string = this.modelDetailFunction.getPrimaryFunction();
        RModelType.DetailFunction.Output output = this.modelDetailFunction.getOutput();
        boolean bl2 = output != null && !output.getColumn().isEmpty();
        boolean bl3 = !bl2;
        boolean bl4 = StringUtils.isEmpty(string);
        boolean bl5 = bl = !bl4;
        if (bl4 && bl2) {
            this.setValidationErrorObjectValue(BuildEditorLrb.get("R_INVALID_DETAIL_FUNCTION"));
            return false;
        }
        if (bl && bl3) {
            this.setValidationErrorObjectValue(BuildEditorLrb.get("R_INCOMPLETE_OUTPUT_DEFINITION"));
            return false;
        }
        this.setObjectValue("RALG_DETAILS_FUNCTION", string);
        this.setObjectValue("RALG_DETAILS_FORMAT", output);
        return true;
    }

    @Override
    public void load() {
        LoadRConfig loadRConfig = new LoadRConfig();
        loadRConfig.execute();
    }

    private void blockFunctionSelectionButtons() {
        this.jBuildButton.setEnabled(false);
        this.jScoreButton.setEnabled(false);
        this.jDetailsButton.setEnabled(false);
        this.buildWarning.setVisible(true);
        this.scoreWarning.setVisible(true);
        this.detailsWarning.setVisible(true);
        this.buildWarning.setIcon(OracleIcons.getIcon((String)"error.png"));
        this.scoreWarning.setIcon(OracleIcons.getIcon((String)"error.png"));
        this.detailsWarning.setIcon(OracleIcons.getIcon((String)"error.png"));
        this.buildWarning.setToolTipText(BuildEditorLrb.get("R_NOT_AVAILABLE"));
        this.scoreWarning.setToolTipText(BuildEditorLrb.get("R_NOT_AVAILABLE"));
        this.detailsWarning.setToolTipText(BuildEditorLrb.get("R_NOT_AVAILABLE"));
    }

    protected class LoadRConfig
    extends ODMrSwingWorker<Map<String, Object>, Void> {
        private GetRConfigurationQuery query;

        protected LoadRConfig() {
            super(RModelSettingsPanel.this, RModelSettingsPanel.this.overlayPanel);
            this.query = new GetRConfigurationQuery(RModelSettingsPanel.this.dbVersion);
        }

        @Override
        protected void onSuccess(Map<String, Object> map) throws Exception {
            if (map.isEmpty()) {
                RModelSettingsPanel.this.blockFunctionSelectionButtons();
            }
            RModelSettingsPanel.this.overlayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }

        @Override
        protected Map<String, Object> doInBackground() throws Exception {
            return RModelSettingsPanel.this.dao.readItem((Query)this.query).orElse(Collections.emptyMap());
        }

        @Override
        protected void onFailure(Throwable throwable) {
            RModelSettingsPanel.this.blockFunctionSelectionButtons();
            RModelSettingsPanel.this.overlayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
    }
}

