/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.extensible.r;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.extensible.r.GetRFunctionsQuery;
import oracle.dmt.dataminer.core.model.extensible.r.RFunction;
import oracle.dmt.dataminer.core.utils.Patterns;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.ide.Context;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.util.Version;

public abstract class FunctionSelectionPanel
extends JPanel
implements DialogDisplayable {
    protected static final RFunction DEFAULT_OPTION = new RFunction(BuildEditorLrb.get("R_SELECT_FUNCTION"), "");
    protected String schema;
    protected boolean isReloading;
    protected boolean queryAllSchemas;
    private boolean userCancelled;
    protected RBuildNode node;
    protected List<RFunction> rFunctions;
    private BlockingComponent overlayPanel;
    private Version dbVersion;
    private SqlDataAccessObject dao;
    private GetRFunctionsQuery query;
    private ConnectionManager connectionManager;

    public FunctionSelectionPanel(Context context) {
        this.connectionManager = ConnectionFolder.getConnectionFolder(context);
        this.schema = ((ConnectionFolder)this.connectionManager).getUserAccountName();
        this.dbVersion = this.connectionManager.getDbVersion();
        this.dao = new SqlDataAccessObject(this.connectionManager);
        this.query = new GetRFunctionsQuery(this.dbVersion);
        this.overlayPanel = new BlockingComponent((JComponent)this);
    }

    public FunctionSelectionPanel(Context context, RBuildNode rBuildNode) {
        this(context);
        this.node = rBuildNode;
    }

    public void reloadFromAllSchemas() {
        this.queryAllSchemas = true;
        this.reload();
    }

    public void reloadFromCurrentSchema() {
        this.queryAllSchemas = false;
        this.reload();
    }

    protected void load() {
        LoadFunctions loadFunctions = new LoadFunctions();
        loadFunctions.execute();
    }

    private void reload() {
        ReloadFunctions reloadFunctions = new ReloadFunctions();
        reloadFunctions.execute();
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public String getTitle() {
                return FunctionSelectionPanel.this.getWindowTitle();
            }

            @Override
            public String getHelpTopic() {
                return FunctionSelectionPanel.this.getWindowHelpTopic();
            }

            @Override
            public void onCancel() {
                FunctionSelectionPanel.this.userCancelled = true;
                FunctionSelectionPanel.this.cleanUp();
            }

            @Override
            public JComponent getContent() {
                FunctionSelectionPanel.this.overlayPanel.setState(BlockingComponent.State.BLOCKED);
                return FunctionSelectionPanel.this.overlayPanel.getBlockingComponent();
            }

            @Override
            public void onOK() throws DialogExecutionException {
                if (!FunctionSelectionPanel.this.validateForm()) {
                    throw new DialogExecutionException(CommonLrb.get("ERROR"), FunctionSelectionPanel.this.getValidationErrorMessage(), null);
                }
            }
        };
    }

    protected abstract void initializeComponents();

    protected abstract void initRes();

    protected abstract void initUI();

    protected abstract void afterSuccess();

    protected abstract void afterReloadSuccess();

    protected abstract void afterFailure();

    protected abstract String getWindowTitle();

    protected abstract String getWindowHelpTopic();

    protected abstract boolean validateForm();

    protected abstract String getValidationErrorMessage();

    protected abstract void cleanUp();

    protected void populateComboModels(DefaultComboBoxModel<RFunction> ... defaultComboBoxModelArray) {
        for (DefaultComboBoxModel<RFunction> defaultComboBoxModel : defaultComboBoxModelArray) {
            defaultComboBoxModel.removeAllElements();
            defaultComboBoxModel.addElement(DEFAULT_OPTION);
        }
        this.rFunctions.forEach(rFunction -> {
            for (DefaultComboBoxModel defaultComboBoxModel : defaultComboBoxModelArray) {
                defaultComboBoxModel.addElement(rFunction);
            }
        });
    }

    protected void setSelectedFunction(DefaultComboBoxModel<RFunction> defaultComboBoxModel, String string) {
        String string2;
        String string3;
        Matcher matcher = Patterns.QUALIFIED_NAME.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            string3 = StringUtils.cleanQuotedString((String)matcher.group(2));
            string2 = StringUtils.cleanQuotedString((String)matcher.group(1));
        } else {
            string3 = string;
            string2 = this.schema;
        }
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            RFunction rFunction = defaultComboBoxModel.getElementAt(i);
            if (!string2.equals(rFunction.getOwner()) || !string3.equals(rFunction.getName())) continue;
            defaultComboBoxModel.setSelectedItem(rFunction);
            break;
        }
    }

    protected void determineUseOtherSchemas(String ... stringArray) {
        for (String string : stringArray) {
            if (StringUtils.isNotEmpty((String)string)) {
                Matcher matcher = Patterns.QUALIFIED_NAME.matcher(string);
                this.queryAllSchemas = matcher.find();
            } else {
                this.queryAllSchemas = false;
            }
            if (this.queryAllSchemas) break;
        }
    }

    protected boolean isUsingOtherSchemas() {
        return this.queryAllSchemas;
    }

    private void assignAndSortFunctions(List<RFunction> list) {
        this.rFunctions = list;
        Collections.sort(this.rFunctions, (rFunction, rFunction2) -> rFunction.getQualifiedName().compareTo(rFunction2.getQualifiedName()));
    }

    private class LoadFunctions
    extends ODMrSwingWorker<List<RFunction>, Void> {
        protected LoadFunctions() {
            super(FunctionSelectionPanel.this, FunctionSelectionPanel.this.overlayPanel);
        }

        @Override
        protected void onSuccess(List<RFunction> list) throws Exception {
            if (!FunctionSelectionPanel.this.userCancelled) {
                FunctionSelectionPanel.this.assignAndSortFunctions(list);
                FunctionSelectionPanel.this.afterSuccess();
            }
        }

        @Override
        protected List<RFunction> doInBackground() throws Exception {
            FunctionSelectionPanel.this.query.setSchema(FunctionSelectionPanel.this.queryAllSchemas ? null : FunctionSelectionPanel.this.schema);
            return FunctionSelectionPanel.this.dao.readItems((Query)FunctionSelectionPanel.this.query);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(FunctionSelectionPanel.this), (Throwable)throwable, (String)CommonLrb.get("ERROR"), (String)BuildEditorLrb.get("R_FUNCTIONS_RETRIEVAL_ERROR"), null);
            FunctionSelectionPanel.this.afterFailure();
        }
    }

    private class ReloadFunctions
    extends LoadFunctions {
        private ReloadFunctions() {
        }

        @Override
        protected List<RFunction> doInBackground() throws Exception {
            FunctionSelectionPanel.this.isReloading = true;
            return super.doInBackground();
        }

        @Override
        protected void onSuccess(List<RFunction> list) throws Exception {
            if (!FunctionSelectionPanel.this.userCancelled) {
                FunctionSelectionPanel.this.assignAndSortFunctions(list);
                FunctionSelectionPanel.this.afterReloadSuccess();
            }
        }
    }

    protected class QualifiedFunctionRenderer
    extends JLabel
    implements ListCellRenderer<RFunction> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        protected QualifiedFunctionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, RFunction rFunction, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)jList, rFunction, n, bl, bl2);
            if (rFunction != null) {
                String string = FunctionSelectionPanel.this.queryAllSchemas ? rFunction.getQualifiedName() : rFunction.getName();
                jLabel.setText(string);
            }
            return jLabel;
        }
    }

    protected abstract class FunctionChangeListener
    implements ActionListener {
        private DefaultComboBoxModel<RFunction> comboBoxModel;
        private JTextArea scriptArea;

        protected FunctionChangeListener(DefaultComboBoxModel<RFunction> defaultComboBoxModel, JTextArea jTextArea) {
            this.comboBoxModel = defaultComboBoxModel;
            this.scriptArea = jTextArea;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.comboBoxModel.getSelectedItem() == null || FunctionSelectionPanel.this.isReloading) {
                return;
            }
            RFunction rFunction = (RFunction)this.comboBoxModel.getSelectedItem();
            if (DEFAULT_OPTION.equals(rFunction)) {
                this.scriptArea.setText("");
                this.updateMetaData("");
            } else {
                if (DEFAULT_OPTION.equals(this.comboBoxModel.getElementAt(0))) {
                    this.afterFirstUserSelection();
                }
                this.scriptArea.setText(rFunction.getScript());
                this.updateMetaData(rFunction.getQualifiedName());
                this.scriptArea.setCaretPosition(0);
            }
        }

        protected void afterFirstUserSelection() {
            this.comboBoxModel.removeElementAt(0);
        }

        protected abstract void updateMetaData(String var1);
    }

    protected abstract class QueryAllSchemasListener
    implements ActionListener {
        protected QueryAllSchemasListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JCheckBox) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    FunctionSelectionPanel.this.reloadFromAllSchemas();
                } else {
                    FunctionSelectionPanel.this.reloadFromCurrentSchema();
                }
                this.updateMetaData();
            }
        }

        protected abstract void updateMetaData();
    }
}

