/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.GLMTargetValuesPanel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class TargetValueSelectorPanel
extends JPanel
implements DataminerGUIPanel {
    private static final Logger LOGGER = Logger.getLogger(TargetValueSelectorPanel.class.getName());
    private DefaultListModel<String> listModel;
    private DefaultListModel<String> messageModel;
    private GhostPointingPalette ownerDialog;
    private CommonSettingDataObject state;
    private boolean multiSelect = true;
    private GLMTargetValuesPanel parent;
    private ButtonGroup buttonGroup;
    private JButton jCancelBtn;
    private JRadioButton jContainsRadio;
    private JButton jOkBtn;
    private JCheckBox jSampleCheckBox;
    private JLabel jSampleLabel;
    private JSpinner jSampleSizeSpinner;
    private JScrollPane jScrollPane1;
    private JButton jSearchBtn;
    private JRadioButton jStartsWithRadio;
    private JLabel jValueLabel;
    private JTextField jValueTxt;
    private JList<String> jValuesList;

    public TargetValueSelectorPanel(CommonSettingDataObject commonSettingDataObject, GLMTargetValuesPanel gLMTargetValuesPanel, boolean bl) {
        this.state = commonSettingDataObject;
        this.multiSelect = bl;
        this.listModel = new DefaultListModel();
        this.messageModel = new DefaultListModel();
        this.parent = gLMTargetValuesPanel;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jValueLabel = new JLabel();
        this.jValueTxt = new JTextField();
        this.jSearchBtn = new JButton();
        this.jSampleCheckBox = new JCheckBox();
        this.jSampleLabel = new JLabel();
        this.jSampleSizeSpinner = new JSpinner();
        this.jStartsWithRadio = new JRadioButton();
        this.jContainsRadio = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jValuesList = new JList();
        this.jOkBtn = new JButton();
        this.jCancelBtn = new JButton();
        this.jValueLabel.setText("Value:");
        this.jSearchBtn.setText("Find");
        this.jSampleCheckBox.setText("Find Using Sample (Faster)");
        this.jSampleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TargetValueSelectorPanel.this.jSampleCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jSampleLabel.setLabelFor(this.jSampleSizeSpinner);
        this.jSampleLabel.setText("Sample Size:");
        this.buttonGroup.add(this.jStartsWithRadio);
        this.jStartsWithRadio.setSelected(true);
        this.jStartsWithRadio.setText("Starts With");
        this.buttonGroup.add(this.jContainsRadio);
        this.jContainsRadio.setText("Contains");
        this.jValuesList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jValuesList);
        this.jOkBtn.setText("OK");
        this.jOkBtn.setPreferredSize(new Dimension(65, 25));
        this.jCancelBtn.setText("Cancel");
        this.jCancelBtn.setPreferredSize(new Dimension(65, 25));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCancelBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOkBtn, -2, 65, -2)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jStartsWithRadio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jContainsRadio)).addComponent(this.jSampleCheckBox)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.jSampleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSampleSizeSpinner)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.jValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jValueTxt))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSearchBtn, -2, 65, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jValueLabel).addComponent(this.jValueTxt, -2, -1, -2).addComponent(this.jSearchBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSampleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSampleLabel).addComponent(this.jSampleSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStartsWithRadio).addComponent(this.jContainsRadio)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCancelBtn, -2, -1, -2).addComponent(this.jOkBtn, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jSampleCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.jSampleSizeSpinner.setEnabled(this.jSampleCheckBox.isSelected());
        this.jSampleLabel.setEnabled(this.jSampleCheckBox.isSelected());
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jValueLabel, (Component)this.jValueTxt, (String)AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jStartsWithRadio, (String)AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_STARTS"));
        ResourceUtils.resButton((AbstractButton)this.jContainsRadio, (String)AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_CONTAINS"));
        ResourceUtils.resButton((AbstractButton)this.jSearchBtn, (String)CommonLrb.get("FIND"));
        ResourceUtils.resLabel((JLabel)this.jSampleLabel, (Component)this.jSampleSizeSpinner, (String)AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_USING_SAMPLE"));
        ResourceUtils.resButton((AbstractButton)this.jSampleCheckBox, (String)AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_SAMPLE_SIZE"));
    }

    @Override
    public void initUI() {
        this.jOkBtn.setEnabled(false);
        this.jValueTxt.setText("");
        this.jSampleCheckBox.setSelected(true);
        this.jSampleSizeSpinner.setModel(new SpinnerNumberModel(2000, 1, 1000000, 1000));
        this.jValuesList.setSelectionMode(this.multiSelect ? 2 : 0);
        this.jOkBtn.addActionListener(new OkActionListener());
        this.jCancelBtn.addActionListener(new CancelActionListener());
        this.jValuesList.getSelectionModel().addListSelectionListener(new ValuesListSelectionListener());
        SearchActionListener searchActionListener = new SearchActionListener();
        this.jValueTxt.addActionListener(searchActionListener);
        this.jSearchBtn.addActionListener(searchActionListener);
    }

    public void showAsTooltipDialog(JComponent jComponent, String string) {
        if (this.ownerDialog != null && this.ownerDialog.isShowing()) {
            return;
        }
        this.jValueTxt.setText(string);
        this.ownerDialog = new GhostPointingPalette();
        this.ownerDialog.setTitle(AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_TITLE"));
        int n = jComponent.getSize().height - 2;
        this.ownerDialog.setPointing(jComponent, new Point(2, n));
        this.ownerDialog.setLook(UIConstants.Look.LIGHT);
        this.ownerDialog.setHideOnLoseFocus(true);
        this.ownerDialog.add((Component)this);
        this.ownerDialog.setCloseVisible(false);
        this.ownerDialog.setReceivesFocus(true);
        this.ownerDialog.pack();
        this.ownerDialog.show(true, true);
        Point point = jComponent.getLocation();
        Point point2 = this.ownerDialog.getLocation();
        int n2 = point.x - this.getWidth();
        this.ownerDialog.setLocation(n2, point2.y);
    }

    public void closeTooltipDialog(boolean bl) {
        if (this.ownerDialog != null && this.ownerDialog.isShowing()) {
            this.ownerDialog.hidePanel();
            if (bl) {
                this.clear();
            }
        }
    }

    private void clear() {
        this.jOkBtn.setEnabled(false);
        this.jSampleCheckBox.setSelected(false);
        this.jStartsWithRadio.setSelected(true);
        this.jValuesList.setModel(new DefaultListModel());
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<String> list = TargetValueSelectorPanel.this.jValuesList.getSelectedValuesList();
            TargetValueSelectorPanel.this.parent.commitValues(list, TargetValueSelectorPanel.this.jValueTxt.getText(), TargetValueSelectorPanel.this.jContainsRadio.isSelected());
            TargetValueSelectorPanel.this.ownerDialog.hidePanel();
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TargetValueSelectorPanel.this.ownerDialog.hidePanel();
        }
    }

    private class ValuesListSelectionListener
    implements ListSelectionListener {
        private ValuesListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            TargetValueSelectorPanel.this.jOkBtn.setEnabled(this.isValidSelection(listSelectionEvent));
        }

        private boolean isValidSelection(ListSelectionEvent listSelectionEvent) {
            return listSelectionEvent.getFirstIndex() >= 0 && TargetValueSelectorPanel.this.jValuesList.getModel() == TargetValueSelectorPanel.this.listModel;
        }
    }

    private class SearchActionListener
    implements ActionListener {
        private SearchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchWorker searchWorker = new SearchWorker();
            searchWorker.execute();
        }
    }

    private class SearchWorker
    extends ODMrSwingWorker<DefaultListModel<String>, Void> {
        private SQLHelper helper;

        private SearchWorker() {
            super(TargetValueSelectorPanel.this);
            TargetValueSelectorPanel.this.messageModel.clear();
            TargetValueSelectorPanel.this.messageModel.addElement(CommonLrb.get("LOADING"));
            TargetValueSelectorPanel.this.jValuesList.setModel(TargetValueSelectorPanel.this.messageModel);
        }

        @Override
        protected DefaultListModel<String> doInBackground() throws Exception {
            this.helper = new SQLHelper();
            try {
                DefaultListModel<String> defaultListModel = this.executeAndProcessQuery();
                return defaultListModel;
            }
            finally {
                this.helper.close();
            }
        }

        private DefaultListModel<String> executeAndProcessQuery() throws SQLException {
            this.helper.rs = this.executeQuery();
            return this.processResultSet(this.helper.rs);
        }

        private ResultSet executeQuery() throws SQLException {
            String string = TargetValueSelectorPanel.this.state.getSQLDistinctTargetValues(this.getSampleSize(), this.getSQLFilter());
            if (string == null) {
                return null;
            }
            this.helper.conn = ConnectionFolder.getConnection(TargetValueSelectorPanel.this.state.getContext());
            this.helper.pstmt = this.helper.conn.prepareStatement(string);
            return this.helper.pstmt.executeQuery();
        }

        private DefaultListModel<String> processResultSet(ResultSet resultSet) throws SQLException {
            TargetValueSelectorPanel.this.listModel.clear();
            if (resultSet != null) {
                while (resultSet.next()) {
                    TargetValueSelectorPanel.this.listModel.addElement(resultSet.getString(1));
                }
            }
            if (TargetValueSelectorPanel.this.listModel.isEmpty()) {
                TargetValueSelectorPanel.this.messageModel.clear();
                TargetValueSelectorPanel.this.messageModel.addElement(AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_NO_MATCH"));
                return TargetValueSelectorPanel.this.messageModel;
            }
            return TargetValueSelectorPanel.this.listModel;
        }

        @Override
        protected void onSuccess(DefaultListModel<String> defaultListModel) throws Exception {
            TargetValueSelectorPanel.this.jValuesList.setModel(defaultListModel);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            LOGGER.log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
            TargetValueSelectorPanel.this.messageModel.clear();
            TargetValueSelectorPanel.this.messageModel.addElement(AlgSettingsLrb.get("GLM_QUERY_SOURCE_FILTER_SELECTOR_NO_MATCH"));
            TargetValueSelectorPanel.this.jValuesList.setModel(TargetValueSelectorPanel.this.messageModel);
        }

        private Integer getSampleSize() {
            if (TargetValueSelectorPanel.this.jSampleCheckBox.isSelected()) {
                Integer n = (Integer)TargetValueSelectorPanel.this.jSampleSizeSpinner.getValue();
                return n;
            }
            return null;
        }

        private String getSQLFilter() {
            StringBuilder stringBuilder = new StringBuilder();
            if (TargetValueSelectorPanel.this.jContainsRadio.isSelected()) {
                stringBuilder.append("%");
            }
            stringBuilder.append(TargetValueSelectorPanel.this.jValueTxt.getText());
            stringBuilder.append("%");
            return stringBuilder.toString();
        }
    }
}

