/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractPropertiesPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelSVDPCABuildSettingsSolverPanel;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Version;

public class ModelSVDPCABuildSettingsPanel
extends AbstractPropertiesPanel {
    private String SYSTEM_DETERMINED = AlgSettingsLrb.get("SYSTEM_DETERMINED");
    private String overSampling;
    private String powerIteration;
    private String randomSeed;
    private Version _dbVersion;
    private boolean _isDatabaseVersion12_2andUp = false;
    private boolean isModelPartitioned = false;
    private JButton btnOption;
    private ButtonGroup buttonGroup1;
    private JComboBox cboSolver;
    private JComboBox jApproxComputationComboBox;
    private JLabel jApproxComputationLabel;
    private JLabel jNumOfFeaturesLabel;
    private JCheckBox jPersistUMatrixCheckBox;
    private JScrollPane jScrollPane1;
    private JRadioButton jSystemDeterminedRadioButton;
    private JRadioButton jUserSpecifiedRadioButton;
    private JTextField jUserSpecifiedTextField;
    private JLabel lblConvergenceTolerance;
    private JLabel lblSolver;
    private JRadioButton radBtnConvergenceSysDetermined;
    private JRadioButton radBtnConvergenceUserSpecified;
    private JTextField txtConvergenceUserSpecified;
    private JMultiLineLabel _jDescription = new JMultiLineLabel();

    public ModelSVDPCABuildSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, ModelType modelType) {
        super(advancedSettingsPanel, modelType);
        this._dbVersion = ConnectionFolder.getConnectionFolder(advancedSettingsPanel.getContext()).getDbVersion();
        this._isDatabaseVersion12_2andUp = DbVersionHelper.isDB122Up((Version)this._dbVersion);
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        PartitionExpressions partitionExpressions = commonSettingDataObject.getParentPanel().getMetadataCopy().getPartitionExpressions();
        if (partitionExpressions != null && partitionExpressions.getPartitionExpression() != null && partitionExpressions.getPartitionExpression().size() > 0) {
            this.isModelPartitioned = true;
        }
        this.initComponents();
        this.intRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jNumOfFeaturesLabel = new JLabel();
        this.jSystemDeterminedRadioButton = new JRadioButton();
        this.jUserSpecifiedRadioButton = new JRadioButton();
        this.jUserSpecifiedTextField = new NumberTextField();
        this.jApproxComputationLabel = new JLabel();
        this.jApproxComputationComboBox = new JComboBox();
        this.jPersistUMatrixCheckBox = new JCheckBox();
        this.lblSolver = new JLabel();
        this.cboSolver = new JComboBox();
        this.btnOption = new JButton();
        this.lblConvergenceTolerance = new JLabel();
        this.radBtnConvergenceSysDetermined = new JRadioButton();
        this.radBtnConvergenceUserSpecified = new JRadioButton();
        this.txtConvergenceUserSpecified = new NumberTextField();
        this.jScrollPane1.setBorder(null);
        this.jNumOfFeaturesLabel.setText("Number of Features");
        this.buttonGroup1.add(this.jSystemDeterminedRadioButton);
        this.jSystemDeterminedRadioButton.setText("System determined");
        this.jSystemDeterminedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelSVDPCABuildSettingsPanel.this.jSystemDeterminedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jUserSpecifiedRadioButton);
        this.jUserSpecifiedRadioButton.setText("User specified:");
        this.jUserSpecifiedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelSVDPCABuildSettingsPanel.this.jUserSpecifiedRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jApproxComputationLabel.setText("Approximate Computation:");
        this.jApproxComputationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"System Determined"}));
        this.jPersistUMatrixCheckBox.setText("Persist the U Matrix");
        this.jPersistUMatrixCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.lblSolver.setText("Solver:");
        this.cboSolver.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboSolver.setMinimumSize(new Dimension(58, 18));
        this.cboSolver.setPreferredSize(new Dimension(62, 22));
        this.btnOption.setText("option");
        this.lblConvergenceTolerance.setText("Convergence Tolerance");
        this.radBtnConvergenceSysDetermined.setText("System Determined");
        this.radBtnConvergenceUserSpecified.setText("User Specified:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(16, 16, 16)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.lblSolver).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnOption).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radBtnConvergenceSysDetermined).addGroup(groupLayout.createSequentialGroup().addComponent(this.radBtnConvergenceUserSpecified).addGap(18, 18, 18).addComponent(this.txtConvergenceUserSpecified)))).addComponent(this.jNumOfFeaturesLabel).addComponent(this.jPersistUMatrixCheckBox).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jApproxComputationLabel).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jUserSpecifiedRadioButton).addComponent(this.jSystemDeterminedRadioButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jUserSpecifiedTextField).addComponent(this.jApproxComputationComboBox, -2, -1, -2).addComponent(this.cboSolver, -2, 207, -2))).addComponent(this.lblConvergenceTolerance)).addContainerGap(80, Short.MAX_VALUE)))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 52, -2).addGap(18, 18, 18).addComponent(this.jNumOfFeaturesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSystemDeterminedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jUserSpecifiedRadioButton).addComponent(this.jUserSpecifiedTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jApproxComputationLabel).addComponent(this.jApproxComputationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPersistUMatrixCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSolver).addComponent(this.cboSolver, -2, -1, -2).addComponent(this.btnOption)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblConvergenceTolerance).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radBtnConvergenceSysDetermined).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radBtnConvergenceUserSpecified).addComponent(this.txtConvergenceUserSpecified, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jUserSpecifiedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.jUserSpecifiedTextField.setEnabled(this.jUserSpecifiedRadioButton.isSelected());
    }

    private void jSystemDeterminedRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.jUserSpecifiedTextField.setEnabled(this.jUserSpecifiedRadioButton.isSelected());
    }

    private void intRes() {
        ResourceUtils.resLabel((JLabel)this.jNumOfFeaturesLabel, null, (String)AlgSettingsLrb.get("FEAT_NUM_FEATURES"));
        ResourceUtils.resButton((AbstractButton)this.jSystemDeterminedRadioButton, (String)AlgSettingsLrb.get("SVD_SYSTEM_DETERMINED"));
        ResourceUtils.resButton((AbstractButton)this.jUserSpecifiedRadioButton, (String)AlgSettingsLrb.get("SVD_USER_SPECIFIED"));
        ResourceUtils.resLabel((JLabel)this.jApproxComputationLabel, (Component)this.jApproxComputationComboBox, (String)AlgSettingsLrb.get("SVD_APPROXIMATE_COMPUTATION"));
        ResourceUtils.resButton((AbstractButton)this.jPersistUMatrixCheckBox, (String)AlgSettingsLrb.get("SVD_PROJECTIONS"));
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            ResourceUtils.resLabel((JLabel)this.lblSolver, (Component)this.cboSolver, (String)AlgSettingsLrb.get("SVD_SOLVER"));
            ResourceUtils.resLabel((JLabel)this.lblConvergenceTolerance, (Component)this.radBtnConvergenceSysDetermined, (String)AlgSettingsLrb.get("SVD_CONVERGENCE_TOLERANCE"));
        }
    }

    private void initUI() {
        String string;
        final CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        this.loadDescription(this._jDescription, this.jScrollPane1);
        this.setDataType(this.jUserSpecifiedTextField, Integer.class);
        this.setSigned(this.jUserSpecifiedTextField, false);
        this.setLocale(this.jUserSpecifiedTextField, commonSettingDataObject.getLocale());
        this.jUserSpecifiedTextField.setToolTipText(AlgSettingsLrb.get("FEAT_NUM_FEATURES_TOOLTIP"));
        BigDecimal bigDecimal = commonSettingDataObject.getModelSettingNumValue("FEAT_NUM_FEATURES");
        commonSettingDataObject.setBackupValue("FEAT_NUM_FEATURES", bigDecimal);
        this.jSystemDeterminedRadioButton.setEnabled(true);
        this.jUserSpecifiedRadioButton.setEnabled(true);
        if (bigDecimal != null) {
            this.jUserSpecifiedRadioButton.setSelected(true);
            this.setNumber(this.jUserSpecifiedTextField, bigDecimal);
        } else {
            this.jSystemDeterminedRadioButton.setSelected(true);
        }
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            this.jApproxComputationComboBox.setVisible(false);
            this.jApproxComputationLabel.setVisible(false);
            this.overSampling = commonSettingDataObject.getModelSettingStringValue("SVDS_OVER_SAMPLING");
            this.powerIteration = commonSettingDataObject.getModelSettingStringValue("SVDS_POWER_ITERATIONS");
            this.btnOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelSVDPCABuildSettingsSolverPanel modelSVDPCABuildSettingsSolverPanel;
                    DialogHelper dialogHelper;
                    if (StringUtils.isEmpty((String)ModelSVDPCABuildSettingsPanel.this.overSampling)) {
                        ModelSVDPCABuildSettingsPanel.this.overSampling = commonSettingDataObject.getModelSettingStringValue("SVDS_OVER_SAMPLING");
                        if (StringUtils.isEmpty((String)ModelSVDPCABuildSettingsPanel.this.overSampling)) {
                            ModelSVDPCABuildSettingsPanel.this.overSampling = ServerConstants.SVDSettings.DEFAULTS.SVDS_OVER_SAMPLING.toString();
                        }
                    }
                    if (StringUtils.isEmpty((String)ModelSVDPCABuildSettingsPanel.this.powerIteration)) {
                        ModelSVDPCABuildSettingsPanel.this.powerIteration = commonSettingDataObject.getModelSettingStringValue("SVDS_POWER_ITERATIONS");
                        if (StringUtils.isEmpty((String)ModelSVDPCABuildSettingsPanel.this.powerIteration)) {
                            ModelSVDPCABuildSettingsPanel.this.powerIteration = ServerConstants.SVDSettings.DEFAULTS.SVDS_POWER_ITERATIONS.toString();
                        }
                    }
                    if (StringUtils.isEmpty((String)ModelSVDPCABuildSettingsPanel.this.randomSeed)) {
                        ModelSVDPCABuildSettingsPanel.this.randomSeed = commonSettingDataObject.getModelSettingStringValue("SVDS_RANDOM_SEED");
                        if (StringUtils.isEmpty((String)ModelSVDPCABuildSettingsPanel.this.randomSeed)) {
                            ModelSVDPCABuildSettingsPanel.this.randomSeed = ServerConstants.SVDSettings.DEFAULTS.SVDS_RANDOM_SEED.toString();
                        }
                    }
                    if ((dialogHelper = new DialogHelper(modelSVDPCABuildSettingsSolverPanel = new ModelSVDPCABuildSettingsSolverPanel(ModelSVDPCABuildSettingsPanel.this.overSampling, ModelSVDPCABuildSettingsPanel.this.powerIteration, ModelSVDPCABuildSettingsPanel.this.randomSeed))).showAsDialog()) {
                        ModelSVDPCABuildSettingsPanel.this.overSampling = modelSVDPCABuildSettingsSolverPanel.getOverSampling();
                        ModelSVDPCABuildSettingsPanel.this.powerIteration = modelSVDPCABuildSettingsSolverPanel.getPowerIteration();
                        ModelSVDPCABuildSettingsPanel.this.randomSeed = modelSVDPCABuildSettingsSolverPanel.getRandomSeed();
                    }
                }
            });
            this.btnOption.setEnabled(false);
            var4_3 = new String[]{DialogsLrb.get("SVDS_SYSTEM_DEFAULT"), DialogsLrb.get("SVDS_SOLVER_TSSVD"), DialogsLrb.get("SVDS_SOLVER_TSEIGEN"), DialogsLrb.get("SVDS_SOLVER_SSVD"), DialogsLrb.get("SVDS_SOLVER_STEIGEN")};
            this.cboSolver.setModel(new DefaultComboBoxModel<String>(var4_3));
            String string2 = commonSettingDataObject.getModelSettingStringValue("SVDS_SOLVER");
            if (string2.equals("SVDS_SOLVER_TSSVD")) {
                this.cboSolver.setSelectedIndex(1);
            } else if (string2.equals("SVDS_SOLVER_TSEIGEN")) {
                this.cboSolver.setSelectedIndex(2);
            } else if (string2.equals("SVDS_SOLVER_SSVD")) {
                this.btnOption.setEnabled(true);
                this.cboSolver.setSelectedIndex(3);
            } else if (string2.equals("SVDS_SOLVER_STEIGEN")) {
                this.cboSolver.setSelectedIndex(4);
            } else {
                this.cboSolver.setSelectedIndex(0);
            }
            commonSettingDataObject.setBackupValue("SVDS_SOLVER", string2);
            this.cboSolver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ModelSVDPCABuildSettingsPanel.this.cboSolver.getSelectedIndex() == 3) {
                        ModelSVDPCABuildSettingsPanel.this.btnOption.setEnabled(true);
                    } else {
                        ModelSVDPCABuildSettingsPanel.this.btnOption.setEnabled(false);
                    }
                }
            });
            ((NumberTextField)this.txtConvergenceUserSpecified).setDecimal(true);
            this.setDataType(this.txtConvergenceUserSpecified, Double.class);
            this.setSigned(this.txtConvergenceUserSpecified, false);
            this.setLocale(this.txtConvergenceUserSpecified, commonSettingDataObject.getLocale());
            BigDecimal bigDecimal2 = commonSettingDataObject.getModelSettingNumValue("SVDS_TOLERANCE");
            if (bigDecimal2 != null && bigDecimal2.intValue() != 0) {
                commonSettingDataObject.setBackupValue("SVDS_TOLERANCE", bigDecimal2.doubleValue());
                this.radBtnConvergenceSysDetermined.setSelected(false);
                this.radBtnConvergenceUserSpecified.setSelected(true);
                this.txtConvergenceUserSpecified.setEnabled(true);
                this.setNumber(this.txtConvergenceUserSpecified, bigDecimal2);
            } else {
                commonSettingDataObject.setBackupNullValue("SVDS_TOLERANCE");
                this.radBtnConvergenceSysDetermined.setSelected(true);
                this.radBtnConvergenceUserSpecified.setSelected(false);
                this.txtConvergenceUserSpecified.setEnabled(false);
            }
            this.radBtnConvergenceSysDetermined.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelSVDPCABuildSettingsPanel.this.radBtnConvergenceUserSpecified.setSelected(false);
                    ModelSVDPCABuildSettingsPanel.this.txtConvergenceUserSpecified.setEnabled(false);
                }
            });
            this.radBtnConvergenceUserSpecified.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ModelSVDPCABuildSettingsPanel.this.radBtnConvergenceSysDetermined.setSelected(false);
                    ModelSVDPCABuildSettingsPanel.this.txtConvergenceUserSpecified.setEnabled(true);
                }
            });
        } else {
            this.cboSolver.setVisible(false);
            this.lblSolver.setVisible(false);
            this.btnOption.setVisible(false);
            this.lblConvergenceTolerance.setVisible(false);
            this.radBtnConvergenceSysDetermined.setVisible(false);
            this.radBtnConvergenceUserSpecified.setVisible(false);
            this.txtConvergenceUserSpecified.setVisible(false);
            var4_3 = new DefaultComboBoxModel(new String[]{this.SYSTEM_DETERMINED, ServerConstants.NMFSettings.toHuman((String)"ODMS_APPR_COMP_ENABLE"), ServerConstants.NMFSettings.toHuman((String)"ODMS_APPR_COMP_DISABLE")});
            this.jApproxComputationComboBox.setModel(var4_3);
            string = commonSettingDataObject.getModelSettingStringValue("ODMS_APPROXIMATE_COMPUTATION");
            commonSettingDataObject.setBackupValue("ODMS_APPROXIMATE_COMPUTATION", string);
            if (string.isEmpty()) {
                this.jApproxComputationComboBox.setSelectedItem(this.SYSTEM_DETERMINED);
            } else {
                this.jApproxComputationComboBox.setSelectedItem(ServerConstants.NMFSettings.toHuman((String)string));
            }
            this.jApproxComputationLabel.setLabelFor(this.jApproxComputationComboBox);
        }
        string = commonSettingDataObject.getModelSettingStringValue("SVDS_U_MATRIX_OUTPUT");
        commonSettingDataObject.setBackupValue("SVDS_U_MATRIX_OUTPUT", string);
        boolean bl = string.equals("SVDS_U_MATRIX_ENABLE");
        this.jPersistUMatrixCheckBox.setSelected(bl);
        this.jUserSpecifiedTextField.setEnabled(this.jUserSpecifiedRadioButton.isSelected());
    }

    @Override
    public void processInput() {
        CommonSettingDataObject commonSettingDataObject = this.getPanelState();
        Number number = null;
        if (this.jSystemDeterminedRadioButton.isSelected()) {
            this.setObjectValue("FEAT_NUM_FEATURES", null);
        } else {
            number = this.getNumber(this.jUserSpecifiedTextField);
            if (null == number || 1 > number.intValue() || number.intValue() > 2500) {
                this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVD_NUM_FEATURES_INVALID"));
                return;
            }
            this.setObjectValue("FEAT_NUM_FEATURES", number);
        }
        if (DbVersionHelper.isDB122Up((Version)this._dbVersion)) {
            this.setObjectValue("SVDS_OVER_SAMPLING", this.overSampling);
            this.setObjectValue("SVDS_POWER_ITERATIONS", this.powerIteration);
            this.setObjectValue("SVDS_RANDOM_SEED", this.randomSeed);
            String string = this.cboSolver.getSelectedItem().toString();
            if (DialogsLrb.get("SVDS_SOLVER_TSSVD").equals(string)) {
                this.setObjectValue("SVDS_SOLVER", "SVDS_SOLVER_TSSVD");
            } else if (DialogsLrb.get("SVDS_SOLVER_TSEIGEN").equals(string)) {
                this.setObjectValue("SVDS_SOLVER", "SVDS_SOLVER_TSEIGEN");
            } else if (DialogsLrb.get("SVDS_SOLVER_SSVD").equals(string)) {
                this.setObjectValue("SVDS_SOLVER", "SVDS_SOLVER_SSVD");
            } else if (DialogsLrb.get("SVDS_SOLVER_STEIGEN").equals(string)) {
                this.setObjectValue("SVDS_SOLVER", "SVDS_SOLVER_STEIGEN");
            } else if (DialogsLrb.get("SVDS_SYSTEM_DEFAULT").equals(string)) {
                this.setObjectValue("SVDS_SOLVER", "SVDS_SOLVER_SSVD");
            }
            if (this.radBtnConvergenceSysDetermined.isSelected()) {
                this.setObjectValue("SVDS_TOLERANCE", null);
            } else {
                Number number2 = this.getNumber(this.txtConvergenceUserSpecified);
                if (number2 == null) {
                    number2 = ServerConstants.SVDSettings.DEFAULTS.SVDS_TOLERANCE;
                }
                if (number2.doubleValue() <= 0.0 || number2.doubleValue() > 1.0) {
                    this.setValidationErrorObjectValue(AlgSettingsLrb.get("SVD_CONV_TOLERANCE_INVALID"));
                    return;
                }
                this.setObjectValue("SVDS_TOLERANCE", number2);
            }
        } else {
            String string = (String)this.jApproxComputationComboBox.getSelectedItem();
            string = string.equals(ServerConstants.NMFSettings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_ENABLE.value()) ? "ODMS_APPR_COMP_ENABLE" : (string.equals(ServerConstants.NMFSettings.ODMS_APPROXIMATE_COMPUTATION_OPTION.ODMS_APPR_COMP_DISABLE.value()) ? "ODMS_APPR_COMP_DISABLE" : null);
            this.setObjectValue("ODMS_APPROXIMATE_COMPUTATION", string);
        }
        if (this.jPersistUMatrixCheckBox.isSelected()) {
            this.setObjectValue("SVDS_U_MATRIX_OUTPUT", "SVDS_U_MATRIX_ENABLE");
        } else {
            this.setObjectValue("SVDS_U_MATRIX_OUTPUT", "SVDS_U_MATRIX_DISABLE");
        }
    }
}

