/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerSearchControl;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.CommonSettingDataObject;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.TargetValueSelectorPanel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class GLMTargetValuesPanel
extends JPanel
implements DataminerGUIPanel,
ActionListener {
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JRadioButton jRadioAuto;
    private JRadioButton jRadioCustom;
    private JPanel jValueSearchPanel;
    private TargetValueSelectorPanel findPanel;
    private DataMinerTable genericTableTargets = new DataMinerTable();
    private JButton _removeBtn;
    private SystemDefaultTableAttributesModel _sysDefault = new SystemDefaultTableAttributesModel();
    private CommonSettingDataObject _state;
    private static String _TARGET_VALUE = AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_TARGET_VALUE");
    private static String _custom = AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_CUSTOM");
    private List<String> _glmClassRefValues = new ArrayList<String>();
    static String[] _columnNames = new String[]{_TARGET_VALUE};

    public GLMTargetValuesPanel(CommonSettingDataObject commonSettingDataObject) {
        this._state = commonSettingDataObject;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jRadioAuto = new JRadioButton();
        this.jValueSearchPanel = new CustomEditorPanel();
        this.jRadioCustom = new JRadioButton();
        this.jAttributesComponent = new ComponentWithTitlebar();
        buttonGroup.add(this.jRadioAuto);
        buttonGroup.add(this.jRadioCustom);
        this.jRadioAuto.setText("Auto");
        this.jRadioAuto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAuto.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout(this.jValueSearchPanel);
        this.jValueSearchPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 231, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAttributesComponent, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioAuto, -2, 105, -2).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jRadioCustom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jValueSearchPanel, -2, -1, -2))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jRadioAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jValueSearchPanel, -2, -1, -2).addComponent(this.jRadioCustom)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAttributesComponent, -1, 274, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        this.jRadioAuto.setText(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_AUTO"));
    }

    private CustomEditorPanel getValueSearchPanel() {
        return (CustomEditorPanel)this.jValueSearchPanel;
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)"glmc_choose_ref_val");
        String string = this._state.getCurClassRefValue();
        boolean bl = string.equals(CommonSettingDataObject.SYSTEM_DETERMINED);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.genericTableTargets));
        this.jAttributesComponent.setComponent((JComponent)jScrollPane);
        this.jAttributesComponent.setLabel(new JLabel(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_DLG_TARGET")));
        ControlBar controlBar = new ControlBar();
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(AlgSettingsLrb.get("GLM_TOOLTIP_QUERY_REMOVE_TARGET"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = GLMTargetValuesPanel.this.genericTableTargets.getSelectedRowsInModel();
                int n = nArray[0];
                TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)GLMTargetValuesPanel.this.genericTableTargets.getModel());
                Object object = tableAttributesModel.getValueAt(nArray[0], 0);
                ArrayList<String> arrayList = new ArrayList<String>(tableAttributesModel.getDataList());
                arrayList.remove(object);
                GLMTargetValuesPanel.this._glmClassRefValues.remove(object);
                TableAttributesModel tableAttributesModel2 = new TableAttributesModel(arrayList);
                GLMTargetValuesPanel.this.genericTableTargets.setModel((TableModel)((Object)tableAttributesModel2));
                n = n > 0 ? --n : 0;
                GLMTargetValuesPanel.this.genericTableTargets.setSelectedRowInModel(n);
            }
        });
        controlBar.add((Component)this._removeBtn);
        this.jAttributesComponent.setControlBar(controlBar);
        this.genericTableTargets.setFillsViewportHeight(true);
        this.jRadioAuto.setSelected(bl);
        this.jRadioCustom.setSelected(!bl);
        this.findPanel = new TargetValueSelectorPanel(this._state, this, true);
        this.getValueSearchPanel().addComponents();
        this.getValueSearchPanel().setEnabled(!bl);
        int n = 0;
        TableAttributesModel tableAttributesModel = null;
        if (!bl && this._state.isCurClassRefValueSelected()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (null != this._state.getGlmClassRefValues() && !this._state.getGlmClassRefValues().isEmpty()) {
                arrayList.addAll(this._state.getGlmClassRefValues());
            } else {
                arrayList.add(this._state.getCurClassRefValue());
            }
            tableAttributesModel = new TableAttributesModel(arrayList);
            this._glmClassRefValues.addAll(arrayList);
            n = tableAttributesModel.getDataList().indexOf(this._state.getCurClassRefValue());
            this._removeBtn.setEnabled(true);
        } else {
            tableAttributesModel = this._sysDefault;
            this._removeBtn.setEnabled(false);
        }
        this.setupTable(tableAttributesModel, n);
        this.jRadioAuto.addActionListener(this);
        if (this._state.isDataSourcePresent() && this._state.isTargetSelected()) {
            this.jRadioCustom.addActionListener(this);
        } else {
            this.jRadioCustom.setEnabled(false);
        }
    }

    private void setupTable(TableAttributesModel tableAttributesModel, int n) {
        this.genericTableTargets.setModel((TableModel)((Object)tableAttributesModel));
        this.genericTableTargets.setSelectionMode(0);
        if (n != -1) {
            this.genericTableTargets.setSelectedRowsInModel(new int[]{n});
        }
        this.genericTableTargets.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = false;
                int[] nArray = GLMTargetValuesPanel.this.genericTableTargets.getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)GLMTargetValuesPanel.this.genericTableTargets.getModel());
                    Object object = tableAttributesModel.getValueAt(nArray[0], 0);
                    bl = !object.equals(CommonSettingDataObject.SYSTEM_DETERMINED) && !object.equals("");
                }
                GLMTargetValuesPanel.this._removeBtn.setEnabled(bl);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)object;
            if (jRadioButton.equals(this.jRadioCustom)) {
                this.getValueSearchPanel().setEnabled(true);
                TableAttributesModel tableAttributesModel = new TableAttributesModel(this._glmClassRefValues);
                this.genericTableTargets.setModel((TableModel)((Object)tableAttributesModel));
                int n = tableAttributesModel.getDataList().indexOf(this._state.getCurClassRefValue());
                if (n != -1) {
                    this.genericTableTargets.setSelectedRowsInModel(new int[]{n});
                }
            } else if (jRadioButton.equals(this.jRadioAuto)) {
                this.getValueSearchPanel().setEnabled(false);
                this.findPanel.closeTooltipDialog(true);
                this.genericTableTargets.setModel((TableModel)((Object)this._sysDefault));
                this.genericTableTargets.setSelectedRowsInModel(new int[]{0});
            }
        }
    }

    public void commitValues(List<String> list, String string, boolean bl) {
        if (list != null && list.size() > 0) {
            for (String string2 : list) {
                if (this._glmClassRefValues.contains(string2)) continue;
                this._glmClassRefValues.add(string2);
            }
            this.setupTable(new TableAttributesModel(this._glmClassRefValues), -1);
        }
        this._state.setGlmTargetValSeachCriteria(string);
        this.getValueSearchPanel().searchControl.setSearchText(string);
    }

    public boolean doWork() throws DialogExecutionException {
        boolean bl;
        if (this._state.isGlmClassRefValuesLoaded()) {
            this._state.getGlmClassRefValues().clear();
        }
        if (bl = this.jRadioAuto.isSelected()) {
            this._state.setCurClassRefValue(CommonSettingDataObject.SYSTEM_DETERMINED);
            return true;
        }
        int n = this.genericTableTargets.getSelectedRow();
        if (n == -1) {
            throw new DialogExecutionException(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_MSG"), AlgSettingsLrb.get("GLM_REFERENCE_SELECT_TARGET"), null);
        }
        TableAttributesModel tableAttributesModel = (TableAttributesModel)((Object)this.genericTableTargets.getModel());
        if (tableAttributesModel.getDataList().isEmpty()) {
            throw new DialogExecutionException(AlgSettingsLrb.get("GLMS_REFERENCE_CLASS_NAME_DIALOG_FAIL_MSG"), AlgSettingsLrb.get("GLM_REFERENCE_SELECT_TARGET"), null);
        }
        String string = tableAttributesModel.getDataList().get(n);
        this._state.setCurClassRefValue(string);
        this._state.setGlmClassRefValues(this._glmClassRefValues);
        return true;
    }

    class SystemDefaultTableAttributesModel
    extends TableAttributesModel {
        public SystemDefaultTableAttributesModel() {
            super(CommonSettingDataObject.SYSTEM_DETERMINED);
        }
    }

    private class CustomEditorPanel
    extends JPanel {
        private DataMinerSearchControl searchControl = new DataMinerSearchControl();

        private CustomEditorPanel() {
        }

        public void addComponents() {
            this.searchControl.useMagnifyingGlassIcon();
            this.searchControl.setLabelText(_custom);
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.searchControl);
            String string = GLMTargetValuesPanel.this._state.getCurClassRefValue();
            boolean bl = string.equals(CommonSettingDataObject.SYSTEM_DETERMINED);
            if (!bl) {
                this.searchControl.setSearchText(GLMTargetValuesPanel.this._state.getGlmTargetValSeachCriteria());
            }
            this.searchControl.addActionListener(false, actionEvent -> GLMTargetValuesPanel.this.findPanel.showAsTooltipDialog(this.searchControl.getSearchButton(), this.searchControl.getSearchText()));
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.searchControl.setTextFieldEnabled(bl);
            if (bl) {
                this.searchControl.getTextField().requestFocusInWindow();
            }
            this.searchControl.getSearchButton().setEnabled(bl);
        }
    }

    class TableAttributesModel
    extends SimpleBaseTableModel {
        protected List<String> _data = new ArrayList<String>();
        protected final int COLUMN_COUNT = 1;
        public static final int VALUE = 0;

        protected TableAttributesModel(String string) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>();
            this._data.add(string);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        protected TableAttributesModel(List<String> list) {
            this.setColumnIdentifiers(_columnNames);
            this._data = new ArrayList<String>(list.size());
            this._data.addAll(list);
            this.setRowCount(this._data.size());
            this.setColumnCount(1);
        }

        public Object getValueAt(int n, int n2) {
            if (this._data.isEmpty()) {
                return "";
            }
            String string = null;
            switch (n2) {
                case 0: {
                    string = this._data.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public List<String> getDataList() {
            return this._data;
        }
    }
}

