/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.CheckBoxTableListener;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.LabeledCheckBoxRenderer;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.wizard.AbstractWizardPage;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizardModel;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;

public class StoplistDefinitionPage
extends AbstractWizardPage
implements DataminerGUIPanel {
    private StoplistWizardModel _wizModel;
    private GenericTable _jStoplistsTable = new DataMinerTable();
    private StoplistTableModel _models;
    private ToggleToolButton _showDefault;
    private ToggleToolButton _showWorkflow;
    private ToggleToolButton _showDatabase;
    private boolean _bShowDefault;
    private boolean _bShowWorkflow;
    private boolean _bShowDatabase;
    private transient RowFilter<StoplistTableModel, Integer> _nodeFilter;
    private LabeledCheckBoxRenderer _tableCellRenderer = new LabeledCheckBoxRenderer();
    private CheckListener _tableListener = new CheckListener(this._tableCellRenderer);
    private static int SHOW_STOPLIST_DEFAULT = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.buildText.default");
    private static int SHOW_STOPLIST_WORKFLOW = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.buildText.workflow");
    private static int SHOW_STOPLIST_DATABASE = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.buildText.database");
    private ComponentWithTitlebar<JComponent> StoplistComponentWithTitlebar;
    private ButtonGroup buttonGroup;
    private JRadioButton jEmptyStoplistRadioButton;
    private JComboBox jLanguageComboBox;
    private JLabel jLanguageLabel;
    private JLabel jNameLabel;
    private JTextField jNameTextField;
    private JRadioButton jStoplistRadioButton;

    public StoplistDefinitionPage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jNameLabel, (Component)this.jNameTextField, (String)DialogsLrb.get("STOPLIST_WIZ_NAME"));
        ResourceUtils.resButton((AbstractButton)this.jStoplistRadioButton, (String)DialogsLrb.get("STOPLIST_WIZ_EXTENDS_EXISTING_STOPLISTS"));
        ResourceUtils.resButton((AbstractButton)this.jEmptyStoplistRadioButton, (String)DialogsLrb.get("STOPLIST_WIZ_EMPTY_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jLanguageComboBox, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGES"));
    }

    @Override
    public void initUI() {
        ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG2;
        this._wizModel = (StoplistWizardModel)this.getTraversableContext().get("wizardModel");
        this.jNameTextField.setText(this._wizModel.getStoplistName());
        Vector<String> vector = new Vector<String>();
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG bASIC_LEXER_LANG2 : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG.values()) {
            vector.add(bASIC_LEXER_LANG2.value());
        }
        this.jLanguageComboBox.setModel(new DefaultComboBoxModel(vector));
        this.jLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)"ENGLISH"));
        this.jStoplistRadioButton.setSelected(true);
        this._wizModel.setEmptyStoplist(false);
        this._bShowDefault = true;
        this._bShowWorkflow = true;
        this._bShowDatabase = true;
        JScrollPane jScrollPane = new JScrollPane((Component)this._jStoplistsTable);
        this.StoplistComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.StoplistComponentWithTitlebar.setControlBar(controlBar);
        this.StoplistComponentWithTitlebar.setLabel(new JLabel(DialogsLrb.get("STOPLIST_WIZ_TABLE_TITLE")));
        IdeAction ideAction = IdeAction.get((int)SHOW_STOPLIST_DEFAULT);
        this._showDefault = new ToggleToolButton((ToggleAction)ideAction);
        this._showDefault.setIcon(OracleIcons.getIcon((String)"viewObject.png"));
        this._showDefault.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_DEFAULT_TIP"));
        this.StoplistComponentWithTitlebar.getControlBar().add((Component)this._showDefault);
        this._showDefault.setSelected(this._bShowDefault);
        this._showDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                StoplistDefinitionPage.this._bShowDefault = toggleToolButton.isSelected();
                StoplistDefinitionPage.this.configureSorting();
            }
        });
        bASIC_LEXER_LANG2 = IdeAction.get((int)SHOW_STOPLIST_WORKFLOW);
        this._showWorkflow = new ToggleToolButton((ToggleAction)bASIC_LEXER_LANG2);
        this._showWorkflow.setIcon(OracleIcons.getIcon((String)"tree.png"));
        this._showWorkflow.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_WORKFLOW_TIP"));
        this.StoplistComponentWithTitlebar.getControlBar().add((Component)this._showWorkflow);
        this._showWorkflow.setSelected(this._bShowWorkflow);
        this._showWorkflow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                StoplistDefinitionPage.this._bShowWorkflow = toggleToolButton.isSelected();
                StoplistDefinitionPage.this.configureSorting();
            }
        });
        IdeAction ideAction2 = IdeAction.get((int)SHOW_STOPLIST_DATABASE);
        this._showDatabase = new ToggleToolButton((ToggleAction)ideAction2);
        this._showDatabase.setIcon(OracleIcons.getIcon((String)"database.png"));
        this._showDatabase.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_DATABASE_TIP"));
        this.StoplistComponentWithTitlebar.getControlBar().add((Component)this._showDatabase);
        this.StoplistComponentWithTitlebar.getControlBar().addSeparator();
        this._showDatabase.setSelected(this._bShowDatabase);
        this._showDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                StoplistDefinitionPage.this._bShowDatabase = toggleToolButton.isSelected();
                StoplistDefinitionPage.this.configureSorting();
            }
        });
        LoadUI loadUI = new LoadUI(this._wizModel);
        loadUI.execute();
    }

    public void configureSorting() {
        TableRowSorter<StoplistTableModel> tableRowSorter = (TableRowSorter<StoplistTableModel>)this._jStoplistsTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<StoplistTableModel>(this._models);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._nodeFilter);
        this._jStoplistsTable.setRowSorter(tableRowSorter);
    }

    @Override
    public String getPageDirtyKey() {
        return "definitionDirty";
    }

    private boolean validateStoplistName(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_EMPTY"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (!this._wizModel.isNameUnique(string)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_DUPLICATE_NAME"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (!AttributeNameValidator.isNameLengthValidInDB(this._wizModel.getContext(), string, false)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NAME_TOO_LONG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (StringUtils.checkDataLossWithMsg(this._wizModel.getContext(), string, DialogsLrb.get("ERROR_TITLE"))) {
            return false;
        }
        return bl;
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        boolean bl = this.jEmptyStoplistRadioButton.isSelected();
        this._wizModel.setEmptyStoplist(bl);
        if (bl) {
            this._wizModel.setEmptyStoplistLanguage((String)this.jLanguageComboBox.getSelectedItem());
        } else {
            ArrayList<StoplistWizardModel.Entry> arrayList = new ArrayList<StoplistWizardModel.Entry>();
            for (ColumnData columnData : this._models.getData()) {
                StoplistWizardModel.Entry entry = (StoplistWizardModel.Entry)columnData.getData();
                if (!entry.getSelected().booleanValue()) continue;
                arrayList.add(entry);
            }
            if (arrayList.size() == 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("STOPLIST_WIZ_NO_STOPLIST_SELECTED"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                return false;
            }
        }
        this.setDirty(true, "reviewDirty");
        return this.validateAndWriteToState(this._wizModel);
    }

    public boolean validateAndWriteToState(StoplistWizardModel stoplistWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread(stoplistWizardModel);
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            bl = false;
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        return bl;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jNameLabel = new JLabel();
        this.jNameTextField = new JTextField();
        this.jStoplistRadioButton = new JRadioButton();
        this.StoplistComponentWithTitlebar = new ComponentWithTitlebar();
        this.jEmptyStoplistRadioButton = new JRadioButton();
        this.jLanguageLabel = new JLabel();
        this.jLanguageComboBox = new JComboBox();
        this.jNameLabel.setText("Name:");
        this.jNameTextField.setText("jTextField1");
        this.buttonGroup.add(this.jStoplistRadioButton);
        this.jStoplistRadioButton.setText("Stoplist extends from the following stoplists");
        this.buttonGroup.add(this.jEmptyStoplistRadioButton);
        this.jEmptyStoplistRadioButton.setText("Empty Stoplist");
        this.jLanguageLabel.setText("Language:");
        this.jLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(31, 31, 31).addComponent((Component)this.StoplistComponentWithTitlebar, -1, 459, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jEmptyStoplistRadioButton, -2, 480, -2).addComponent(this.jStoplistRadioButton).addGroup(groupLayout.createSequentialGroup().addComponent(this.jNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jNameTextField, -2, 237, -2)).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLanguageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLanguageComboBox, -2, 217, -2))))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNameLabel).addComponent(this.jNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jStoplistRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.StoplistComponentWithTitlebar, -1, 235, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jEmptyStoplistRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageComboBox, -2, -1, -2).addComponent(this.jLanguageLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class CheckListener
    extends CheckBoxTableListener {
        public CheckListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
            super(labeledCheckBoxRenderer);
        }

        @Override
        protected void itemChecked(int n) {
            StoplistTableModel stoplistTableModel = (StoplistTableModel)((Object)StoplistDefinitionPage.this._jStoplistsTable.getModel());
            ColumnData columnData = (ColumnData)stoplistTableModel.getValueAt(StoplistDefinitionPage.this._jStoplistsTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.TRUE);
            StoplistWizardModel.Entry entry = (StoplistWizardModel.Entry)columnData.getData();
            entry.setSelected(Boolean.TRUE);
        }

        @Override
        public void itemUnchecked(int n) {
            StoplistTableModel stoplistTableModel = (StoplistTableModel)((Object)StoplistDefinitionPage.this._jStoplistsTable.getModel());
            ColumnData columnData = (ColumnData)stoplistTableModel.getValueAt(StoplistDefinitionPage.this._jStoplistsTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.FALSE);
            StoplistWizardModel.Entry entry = (StoplistWizardModel.Entry)columnData.getData();
            entry.setSelected(Boolean.FALSE);
        }
    }

    private class LoadUI
    extends SwingWorker {
        private StoplistWizardModel _wizModel;
        private List<StoplistWizardModel.Entry> _entry;
        private Exception _ex = null;
        private boolean _success = false;

        public LoadUI(StoplistWizardModel stoplistWizardModel) {
            this._wizModel = stoplistWizardModel;
        }

        protected Object doInBackground() throws Exception {
            try {
                this._entry = this._wizModel.loadStoplists();
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._entry;
        }

        @Override
        protected void done() {
            block5: {
                super.done();
                try {
                    if (this._success && this._ex == null) {
                        StoplistDefinitionPage.this._models = new StoplistTableModel(this._entry);
                        StoplistDefinitionPage.this._jStoplistsTable.setModel((TableModel)((Object)StoplistDefinitionPage.this._models));
                        StoplistDefinitionPage.this._jStoplistsTable.setResizeColumnOnDoubleClick(true);
                        StoplistDefinitionPage.this._jStoplistsTable.getSelectionModel().setSelectionMode(2);
                        StoplistDefinitionPage.this._jStoplistsTable.addMouseListener((MouseListener)StoplistDefinitionPage.this._tableListener);
                        StoplistDefinitionPage.this._jStoplistsTable.addKeyListener((KeyListener)StoplistDefinitionPage.this._tableListener);
                        TableColumn tableColumn = StoplistDefinitionPage.this._jStoplistsTable.getColumnModel().getColumn(0);
                        tableColumn.setCellRenderer(StoplistDefinitionPage.this._tableCellRenderer);
                        StoplistDefinitionPage.this._nodeFilter = new RowFilter<StoplistTableModel, Integer>(){

                            @Override
                            public boolean include(RowFilter.Entry<? extends StoplistTableModel, ? extends Integer> entry) {
                                Integer n = entry.getIdentifier();
                                StoplistTableModel stoplistTableModel = entry.getModel();
                                String string = (String)stoplistTableModel.getValueAt(n, -2);
                                return StoplistDefinitionPage.this._bShowDefault && "Default".equals(string) || StoplistDefinitionPage.this._bShowWorkflow && "WF".equals(string) || StoplistDefinitionPage.this._bShowDatabase && "DB".equals(string);
                            }
                        };
                        StoplistDefinitionPage.this.configureSorting();
                        break block5;
                    }
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILD_TEXT_NODE_EDIT_ERROR_MESG"), null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILD_TEXT_NODE_EDIT_ERROR_MESG"), null);
                }
            }
        }
    }

    static class StoplistTableModel
    extends SimpleBaseTableModel {
        static String[] _columnNames = new String[]{DialogsLrb.get("STOPLIST_COLUMN_NAME"), DialogsLrb.get("STOPLIST_COLUMN_SOURCE"), DialogsLrb.get("STOPLIST_COLUMN_LANGUAGE")};
        static final int NAME_COLUMN = 0;
        static final int SOURCE_COLUMN = 1;
        static final int LANGUAGE_COLUMN = 2;
        static final int COLUMN_COUNT = 3;
        static final int SELECT_COLUMN = -1;
        static final int SOURCE_TYPE_COLUMN = -2;
        private List<ColumnData> _data = new ArrayList<ColumnData>();

        private void determineState(List<StoplistWizardModel.Entry> list) {
            for (StoplistWizardModel.Entry entry : list) {
                ColumnData columnData = new ColumnData(entry);
                if (entry.getSelected().booleanValue()) {
                    columnData.setCheckBoxState(TriStateBoolean.TRUE);
                }
                this._data.add(columnData);
            }
        }

        public StoplistTableModel(List<StoplistWizardModel.Entry> list) {
            this.determineState(list);
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._data != null ? this._data.size() : 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == -1) {
                ColumnData columnData = this._data.get(n);
                StoplistWizardModel.Entry entry = (StoplistWizardModel.Entry)columnData.getData();
                entry.setSelected((Boolean)object);
            }
        }

        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return "Loading...";
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ColumnData columnData = this._data.get(n);
            Object object = null;
            StoplistWizardModel.Entry entry = (StoplistWizardModel.Entry)columnData.getData();
            switch (n2) {
                case -1: {
                    object = entry.getSelected();
                    break;
                }
                case 0: {
                    object = columnData;
                    break;
                }
                case 1: {
                    object = entry.getSource();
                    break;
                }
                case 2: {
                    object = ServerConstants.StoplistLanguage.toHuman((String)entry.getLanguage());
                    break;
                }
                case -2: {
                    object = entry.getSourceType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public List<ColumnData> getData() {
            return this._data;
        }
    }

    static class ColumnData
    extends CheckedItemData {
        public ColumnData(StoplistWizardModel.Entry entry) {
            super(entry);
        }

        @Override
        public String toString() {
            return ((StoplistWizardModel.Entry)this.getData()).getName();
        }
    }

    class ValidateWriteThread
    extends ProgressRunnable {
        private StoplistWizardModel _model;
        boolean _validated = true;
        private boolean _canceled = false;
        private boolean _forceUpdate = false;

        public ValidateWriteThread(StoplistWizardModel stoplistWizardModel) {
            this._model = stoplistWizardModel;
        }

        public boolean getForceUpdate() {
            return this._forceUpdate;
        }

        public void setForceUpdate(boolean bl) {
            this._forceUpdate = bl;
        }

        public boolean getValidation() {
            String string = StoplistDefinitionPage.this.jNameTextField.getText().trim();
            this._validated = StoplistDefinitionPage.this.validateStoplistName(StringUtils.trimDoubleQuotes(string));
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
                String string = StoplistDefinitionPage.this.jNameTextField.getText();
                StoplistDefinitionPage.this._wizModel.setStoplistName(StringUtils.trimDoubleQuotes(string));
                if (this._model.isEmptyStoplist()) {
                    StoplistDefinitionPage.this._wizModel.generateEmptyStopwords(StoplistDefinitionPage.this._wizModel.getEmptyStoplistLanguage());
                } else {
                    ArrayList<StoplistWizardModel.Entry> arrayList = new ArrayList<StoplistWizardModel.Entry>();
                    for (ColumnData columnData : StoplistDefinitionPage.this._models.getData()) {
                        StoplistWizardModel.Entry entry = (StoplistWizardModel.Entry)columnData.getData();
                        if (!entry.getSelected().booleanValue()) continue;
                        arrayList.add(entry);
                    }
                    StoplistDefinitionPage.this._wizModel.generateStopwords(arrayList);
                }
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }

        protected void finish(Object object) {
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

