/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.dialog.build.BuildTextRowDetail;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.SelectNodeTableModel;
import oracle.dmt.dataminer.workflow.dialog.build.WorkflowFilterType;
import oracle.dmt.dataminer.workflow.dialog.text.TextDialogLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericTable;

public class SelectNodePanel
extends DialogDisplayer<AbstractBuildNode>
implements SearchListener {
    private boolean _dirty = false;
    private SelectNodeTableModel _tableModel;
    private GenericTable _nodeTable = new DataMinerTable();
    RowFilter<SelectNodeTableModel, Integer> _rowfilter;
    private SearchField _searchField;
    private String _searchText;
    private SearchCategory _defaultSearchCategory;
    private SearchCategory _searchCategory = this._defaultSearchCategory = new SearchCategory(TextDialogLrb.get("SELECT_NODE_COLUMN_NODE_NAME"));
    private WorkflowFilterType _currentWorkflowFilterType = WorkflowFilterType.CURRENT_WORKFLOW;
    private BuildTextNodeType _selBuildTextNodeNode;
    private ComponentWithTitlebar<JComponent> jAvailableNodesComponent;
    private JComboBox jWorkflowComboBox;
    private JLabel jWorkflowComboLabel;

    public SelectNodePanel(Context context, AbstractBuildNode abstractBuildNode) {
        super(context, abstractBuildNode);
        this.init();
    }

    private void initComponents() {
        this.jWorkflowComboLabel = new JLabel();
        this.jWorkflowComboBox = new JComboBox();
        this.jAvailableNodesComponent = new ComponentWithTitlebar();
        this.jWorkflowComboLabel.setText("Show:");
        this.jWorkflowComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jAvailableNodesComponent, -1, 587, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jWorkflowComboLabel, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jWorkflowComboBox, -2, 137, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jWorkflowComboLabel).addComponent(this.jWorkflowComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jAvailableNodesComponent, -1, 339, Short.MAX_VALUE).addContainerGap()));
    }

    private void init() {
        this._dirty = false;
        this.initSettings();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initSettings() {
        this._tableModel = new SelectNodeTableModel(this._context, (AbstractBuildNode)this._data);
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jWorkflowComboLabel, (Component)this.jWorkflowComboBox, (String)TextDialogLrb.get("SHOW_WORKFLOW_LABEL"));
        this.jWorkflowComboLabel.getAccessibleContext().setAccessibleDescription(TextDialogLrb.get("SHOW_WORKFLOW_LABEL_ADA"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.initComboBox();
        JScrollPane jScrollPane = new JScrollPane((Component)this._nodeTable);
        this.jAvailableNodesComponent.setComponent((JComponent)jScrollPane);
        this._nodeTable.setModel((TableModel)((Object)this._tableModel));
        this.setupTable();
        ControlBar controlBar = new ControlBar();
        this.jAvailableNodesComponent.setControlBar(controlBar);
        this.jAvailableNodesComponent.setLabel(new JLabel(TextDialogLrb.get("BUILD_TEXT_NODES")));
        this.initTitleBar(controlBar);
        this._nodeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
                if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.setupRowFilter();
        this.loadTable();
    }

    private void setupTable() {
        this._nodeTable.getSelectionModel().setSelectionMode(0);
    }

    private void setupRowFilter() {
        this._rowfilter = new RowFilter<SelectNodeTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SelectNodeTableModel, ? extends Integer> entry) {
                boolean bl = false;
                SelectNodeTableModel selectNodeTableModel = entry.getModel();
                BuildTextRowDetail buildTextRowDetail = selectNodeTableModel.getRowDetailAt(entry.getIdentifier());
                String string = SelectNodePanel.this._searchField.getText();
                if (string != null && string.trim().length() > 0) {
                    SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string, (boolean)true);
                    String string2 = "";
                    if (SelectNodePanel.this._searchCategory.getLabel().equals(TextDialogLrb.get("SELECT_NODE_COLUMN_PROJ_NAME"))) {
                        string2 = buildTextRowDetail.getProjectName();
                    } else if (SelectNodePanel.this._searchCategory.getLabel().equals(TextDialogLrb.get("SELECT_NODE_COLUMN_WK_NAME"))) {
                        string2 = buildTextRowDetail.getWorkflowName();
                    } else if (SelectNodePanel.this._searchCategory.getLabel().equals(TextDialogLrb.get("SELECT_NODE_COLUMN_NODE_NAME"))) {
                        string2 = buildTextRowDetail.getNodeName();
                    }
                    bl = searchMatcher.matches((CharSequence)string2);
                } else {
                    bl = true;
                }
                return bl;
            }
        };
    }

    private void initTitleBar(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{this._defaultSearchCategory, new SearchCategory(TextDialogLrb.get("SELECT_NODE_COLUMN_WK_NAME")), new SearchCategory(TextDialogLrb.get("SELECT_NODE_COLUMN_PROJ_NAME"))}) {
            this._searchField.addCategory(searchCategory);
        }
        this._searchField.setSelectedCategory(this._searchCategory);
        controlBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        if (searchEvent.getSearchCategory() != null) {
            this._searchCategory = searchEvent.getSearchCategory();
        }
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._nodeTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._nodeTable.scrollToSelection();
    }

    public void configureSorting() {
        TableRowSorter<SelectNodeTableModel> tableRowSorter = (TableRowSorter<SelectNodeTableModel>)this._nodeTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<SelectNodeTableModel>(this._tableModel);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            arrayList.add(new RowSorter.SortKey(2, SortOrder.ASCENDING));
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._rowfilter);
        this._nodeTable.setRowSorter(tableRowSorter);
    }

    private void initComboBox() {
        this.jWorkflowComboBox.setModel(new DefaultComboBoxModel<WorkflowFilterType>(WorkflowFilterType.values()));
        this.jWorkflowComboBox.setSelectedItem((Object)this._currentWorkflowFilterType);
        this.jWorkflowComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SelectNodePanel.this._currentWorkflowFilterType != SelectNodePanel.this.jWorkflowComboBox.getSelectedItem()) {
                    SelectNodePanel.this._currentWorkflowFilterType = (WorkflowFilterType)((Object)SelectNodePanel.this.jWorkflowComboBox.getSelectedItem());
                    SelectNodePanel.this.loadTable();
                }
            }
        });
    }

    private void loadTable() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    @Override
    public boolean doWork() {
        int[] nArray = this._nodeTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)TextDialogLrb.get("SELECT_NODE_ERR_NO_NODE_SELECTED"), (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        int n = this._nodeTable.convertRowIndexToModel(this._nodeTable.getSelectedRowInModel());
        BuildTextRowDetail buildTextRowDetail = ((SelectNodeTableModel)((Object)this._nodeTable.getModel())).getSelectedReferenceObject(n);
        if (buildTextRowDetail.getStatus() == NodeStatusType.FAILURE || buildTextRowDetail.getStatus() == NodeStatusType.INVALID || buildTextRowDetail.getStatus() == NodeStatusType.READY) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)TextDialogLrb.get("SELECT_NODE_ERR_ONLY_COMPLETED_NODES"), (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        if (this._currentWorkflowFilterType == WorkflowFilterType.CURRENT_WORKFLOW || this._tableModel.isCurrrentWorkflow(buildTextRowDetail.getWorkflowId())) {
            this._selBuildTextNodeNode = ((SelectNodeTableModel)((Object)this._nodeTable.getModel())).getSelectedRowNodeObject(n);
            this._dirty = true;
        } else if (this._currentWorkflowFilterType == WorkflowFilterType.ALL_WORKFLOWS) {
            LoadNode loadNode = new LoadNode(buildTextRowDetail);
            loadNode.setTitle(TextDialogLrb.get("RETRIEVING_NODE_CONTENTS_TITLE"));
            loadNode.setMessage(TextDialogLrb.get("RETRIEVING_NODE_CONTENTS_MESSAGE"));
            try {
                loadNode.start(true);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("ERROR_TITLE"), (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
            }
            if (loadNode.isCanceled()) {
                return false;
            }
            if (loadNode.isSuccessful().booleanValue()) {
                this._selBuildTextNodeNode = loadNode.getBuildTextNodeType();
                this._dirty = true;
            } else {
                if (loadNode.getException() != null) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)loadNode.getException(), (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("ERROR_TITLE"), (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
                }
                return false;
            }
        }
        return true;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public BuildTextNodeType getSelBuildTextNodeNode() {
        return this._selBuildTextNodeNode;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("SELECT_NODE_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "select_build_text_node";
    }

    @Override
    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        jEWTDialog.setOKButtonText(DialogsLrb.get("SELECT_NODE_BTN_CONTINUE"));
    }

    private class LoadUI
    extends SwingWorker {
        private Exception _ex = null;
        private boolean _success = false;

        protected Object doInBackground() throws Exception {
            try {
                SelectNodePanel.this._tableModel.load(SelectNodePanel.this._currentWorkflowFilterType);
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return null;
        }

        @Override
        protected void done() {
            block5: {
                super.done();
                try {
                    if (this._success && this._ex == null) {
                        SelectNodePanel.this.setupTable();
                        break block5;
                    }
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)this._ex, (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("ERROR_TITLE"), (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("ERROR_TITLE"), (String)oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
                }
            }
        }
    }

    private class LoadNode
    extends ProgressRunnable {
        private boolean _canceled = false;
        private Exception _ex = null;
        private Boolean _success = false;
        private BuildTextRowDetail _row;
        private BuildTextNodeType _node = null;

        public LoadNode(BuildTextRowDetail buildTextRowDetail) {
            this._row = buildTextRowDetail;
        }

        public BuildTextNodeType getBuildTextNodeType() {
            return this._node;
        }

        public Boolean isSuccessful() {
            return this._success;
        }

        public Object doWork() {
            try {
                BuildTextNodeType buildTextNodeType = SelectNodeTableModel.loadNodeFromServer(this._row, SelectNodePanel.this._context);
                this._node = buildTextNodeType instanceof BuildTextNodeType ? buildTextNodeType : null;
                this._success = this._node != null;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return this._node;
        }

        public Exception getException() {
            return this._ex;
        }

        protected void doCancel() {
            super.doCancel();
            this._canceled = true;
        }

        public boolean isCanceled() {
            return this._canceled;
        }
    }
}

