/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.expressionbuilder2.SQLContext;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractEditPanel;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.EditChangeListener;
import oracle.dmt.dataminer.workflow.dialog.build.PartitionAdvanceSettingPanel;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.AddPartitionColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionCustomCellRenderer;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionTableModel;
import oracle.dmt.dataminer.workflow.inspect.ModelPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowModelPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.anomaly.AnomalyPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.anomaly.WorkflowAnomalyPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.association.AssociationPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.association.WorkflowAssociationPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.clustering.ClusteringPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.clustering.WorkflowClusteringPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.efe.ExplicitFeatureExtractionPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.efe.WorkflowExplicitFeatureExtractionPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.feature.FeatureExtractionPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.feature.WorkflowFeatureExtractionPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.r.RPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.r.WorkflowRPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.regression.RegressionPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.regression.WorkflowRegressionPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class PartitionPanel
extends AbstractEditPanel {
    private PropertyModel propertyModel;
    private boolean isAdjusting;
    private BuildNodeType nodeData;
    private BuildNodeType nodeDataCopy;
    private PartitionExpressions partitionExpressions;
    private PartitionTableModel tableModelPartitions;
    private Map<String, Boolean> partExpNames = new HashMap<String, Boolean>();
    private boolean dirty = false;
    private static String PARTITION_EXPRESSION_TEMPLATE = BuildEditorLrb.get("BUILD_PARTITION_EXPRESSION_NAME_TEMPLATE");
    private static int TEMPLATE_LENGTH = PARTITION_EXPRESSION_TEMPLATE.length();
    private String partitionBuildType;
    private HyperlinkButton hyperlinkButton1;
    private JLabel jMaxPartitionLabel;
    private JSpinner jMaxPartitionValueSpinner;
    private JPanel jPartitionPanel;
    private DataMinerTablePanel partitionsTablePanel;
    private JButton moveUpPartitionColumnBtn;
    private JButton moveDownPartitionColumnBtn;
    private JButton moveTopPartitionColumnBtn;
    private JButton moveBottomPartitionColumnBtn;
    private JButton addPartitionColumnBtn;
    private JButton removePartitionExprBtn;

    public PartitionPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType) {
        super(context, abstractBuildNode);
        this.nodeData = (BuildNodeType)abstractBuildNode.getData();
        this.nodeDataCopy = buildNodeType;
        this.partitionExpressions = buildNodeType.getPartitionExpressions() == null ? new PartitionExpressions() : buildNodeType.getPartitionExpressions();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public PartitionPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for build node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.propertyModel = propertyModel;
        this.nodeData = (BuildNodeType)((AbstractBuildNode)this._data).getData();
        this.nodeDataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(this.nodeData);
        this.partitionExpressions = this.nodeDataCopy.getPartitionExpressions() == null ? new PartitionExpressions() : this.nodeDataCopy.getPartitionExpressions();
        this.addAncestorListener(new PIAncestorListener(this));
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jMaxPartitionLabel = new JLabel();
        this.jMaxPartitionValueSpinner = new JSpinner();
        this.jPartitionPanel = new JPanel();
        this.hyperlinkButton1 = new HyperlinkButton();
        this.jMaxPartitionLabel.setText("Maximum Number of Partition:");
        this.jMaxPartitionValueSpinner.setToolTipText("");
        this.jMaxPartitionValueSpinner.setName("partitionSpinner");
        this.jMaxPartitionValueSpinner.setOpaque(false);
        this.jMaxPartitionValueSpinner.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PartitionPanel.this.jMaxPartitionValueSpinnerFocusLost(focusEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jPartitionPanel);
        this.jPartitionPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 514, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 308, Short.MAX_VALUE));
        this.hyperlinkButton1.setText("Settings");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPartitionPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jMaxPartitionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jMaxPartitionValueSpinner, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.hyperlinkButton1, -2, -1, -2))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxPartitionLabel).addComponent(this.jMaxPartitionValueSpinner, -2, -1, -2).addComponent((Component)this.hyperlinkButton1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPartitionPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jMaxPartitionValueSpinnerFocusLost(FocusEvent focusEvent) {
        if (this.isAdjusting) {
            return;
        }
        this.dirty = true;
        this.updateMaxNumPartitions();
    }

    @Override
    public boolean isWritable() {
        WorkflowNode workflowNode = (WorkflowNode)this.getContext().getNode();
        return !workflowNode.isReadOnly();
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)workflowNodeInspectorElement.getNode();
        if (abstractBuildNode == null) {
            return;
        }
        this.propertyModel = propertyModel;
        this._context = context;
        this._data = abstractBuildNode;
        this.dirty = false;
        this.nodeData = (BuildNodeType)abstractBuildNode.getData();
        this.nodeDataCopy = (BuildNodeType)MetaDataHelper.copyMetadataObject(this.nodeData);
        this.refreshUI();
    }

    private void refreshUI() {
        this.isAdjusting = true;
        this.partitionExpressions = this.nodeDataCopy.getPartitionExpressions() == null ? new PartitionExpressions() : this.nodeDataCopy.getPartitionExpressions();
        this.tableModelPartitions.RefreshModel(this.partitionExpressions);
        this.notifiyListeners();
        BigInteger bigInteger = this.nodeDataCopy.getMaxNumPartitions();
        this.jMaxPartitionValueSpinner.setValue(bigInteger.intValue());
        this.partExpNames.clear();
        for (PartitionExpressionType partitionExpressionType : this.partitionExpressions.getPartitionExpression()) {
            this.partExpNames.put(partitionExpressionType.getPartitionAttribute().getName(), Boolean.TRUE);
        }
        for (PartitionExpressionType partitionExpressionType : this.nodeDataCopy.getMiningAttributes().getMiningAttribute()) {
            this.partExpNames.put(partitionExpressionType.getName(), Boolean.TRUE);
        }
        this.isAdjusting = false;
        this.enableControls();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildNodeType) {
            return (AbstractBuildNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateMaxNumPartitions() {
        if (this.dirty && this.propertyModel != null) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.getData();
            Integer n = (Integer)this.jMaxPartitionValueSpinner.getValue();
            BigInteger bigInteger = BigInteger.valueOf(n.intValue());
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (this.propertyModel instanceof WorkflowModelPartitionedBuildNodePropertyProxyModel) {
                ModelPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowAnomalyPartitionedBuildNodePropertyProxyModel) {
                AnomalyPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowAssociationPartitionedBuildNodePropertyProxyModel) {
                AssociationPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowClusteringPartitionedBuildNodePropertyProxyModel) {
                ClusteringPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowFeatureExtractionPartitionedBuildNodePropertyProxyModel) {
                FeatureExtractionPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowRegressionPartitionedBuildNodePropertyProxyModel) {
                RegressionPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowExplicitFeatureExtractionPartitionedBuildNodePropertyProxyModel) {
                ExplicitFeatureExtractionPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowRPartitionedBuildNodePropertyProxyModel) {
                RPartitionedBuildNodePropertyModel.updateMaxNumPartitions(arrayList, abstractBuildNode, bigInteger, this.nodeData.getMaxNumPartitions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), abstractBuildNode, arrayList);
            }
        }
    }

    private void updatePartitionColumns() {
        if (this.dirty && this.propertyModel != null) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.getData();
            ArrayList<Property> arrayList = new ArrayList<Property>();
            PartitionExpressions partitionExpressions = this.tableModelPartitions.getModel();
            if (this.propertyModel instanceof WorkflowModelPartitionedBuildNodePropertyProxyModel) {
                ModelPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowAnomalyPartitionedBuildNodePropertyProxyModel) {
                AnomalyPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowAssociationPartitionedBuildNodePropertyProxyModel) {
                AssociationPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowClusteringPartitionedBuildNodePropertyProxyModel) {
                ClusteringPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowFeatureExtractionPartitionedBuildNodePropertyProxyModel) {
                FeatureExtractionPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowRegressionPartitionedBuildNodePropertyProxyModel) {
                RegressionPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowExplicitFeatureExtractionPartitionedBuildNodePropertyProxyModel) {
                ExplicitFeatureExtractionPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowRPartitionedBuildNodePropertyProxyModel) {
                RPartitionedBuildNodePropertyModel.updatePartitionColumns(arrayList, abstractBuildNode, partitionExpressions, this.nodeData.getPartitionExpressions());
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), abstractBuildNode, arrayList);
            }
        }
    }

    @Override
    public void initRes() {
        this.hyperlinkButton1.setText(DataDialogsLrb.get("PARTITION_ADVANCED_SETTINGS"));
    }

    @Override
    public void initUI() {
        this.partitionsTablePanel = new DataMinerTablePanel();
        this.jPartitionPanel.setLayout(new BorderLayout());
        this.jPartitionPanel.add(this.partitionsTablePanel);
        this.partitionsTablePanel.setTitle(PartitionLrb.get("PARTITION_EDITOR_PANEL_TITLE"));
        this.partitionsTablePanel.removeSearchField();
        this.moveTopPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"first.png"));
        this.moveTopPartitionColumnBtn.setToolTipText(BuildEditorLrb.get("BUILD_PARTITION_TOOLTIP_MOVE_TOP_COLUMN"));
        this.moveTopPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.handleMoveTopPartitionColumns();
            }
        });
        this.moveUpPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"previous.png"));
        this.moveUpPartitionColumnBtn.setToolTipText(BuildEditorLrb.get("BUILD_PARTITION_TOOLTIP_MOVE_UP_COLUMN"));
        this.moveUpPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.handleMoveUpPartitionColumns();
            }
        });
        this.moveDownPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"next.png"));
        this.moveDownPartitionColumnBtn.setToolTipText(BuildEditorLrb.get("BUILD_PARTITION_TOOLTIP_MOVE_DOWN_COLUMN"));
        this.moveDownPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.handleMoveDownPartitionColumns();
            }
        });
        this.moveBottomPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"last.png"));
        this.moveBottomPartitionColumnBtn.setToolTipText(BuildEditorLrb.get("BUILD_PARTITION_TOOLTIP_MOVE_BOTTOM_COLUMN"));
        this.moveBottomPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.handleMoveBottomPartitionColumns();
            }
        });
        this.addPartitionColumnBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addPartitionColumnBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_ADD_PARTITION_COLUMN"));
        this.addPartitionColumnBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.handleAddPartitionColumns();
            }
        });
        this.removePartitionExprBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removePartitionExprBtn.setToolTipText(PartitionLrb.get("PARTITION_EDITOR_TOOLTIP_REMOVE_PARTITION"));
        this.removePartitionExprBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionPanel.this.handleRemovePartition();
            }
        });
        this.partitionsTablePanel.addControlBarComponents(this.moveTopPartitionColumnBtn, this.moveUpPartitionColumnBtn, this.moveDownPartitionColumnBtn, this.moveBottomPartitionColumnBtn, this.addPartitionColumnBtn, this.removePartitionExprBtn);
        this.setupPartitionsTable();
        ResourceUtils.resSpinner((JLabel)this.jMaxPartitionLabel, (JSpinner)this.jMaxPartitionValueSpinner, (String)BuildEditorLrb.get("BUILD_PARTITION_MAX_PARTITION"));
        this.jMaxPartitionValueSpinner.setToolTipText(BuildEditorLrb.get("BUILD_PARTITION_TOOLTIP_MAX_PARTITION"));
        BigInteger bigInteger = this.nodeDataCopy.getMaxNumPartitions();
        bigInteger = bigInteger == null ? BigInteger.valueOf(1000L) : bigInteger;
        this.jMaxPartitionValueSpinner.setModel(new SpinnerNumberModel(bigInteger.intValue(), 1, 1000000, 100));
        this.jMaxPartitionValueSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (PartitionPanel.this.isAdjusting) {
                    return;
                }
                PartitionPanel.this.dirty = true;
                PartitionPanel.this.updateMaxNumPartitions();
            }
        });
        for (PartitionExpressionType partitionExpressionType : this.partitionExpressions.getPartitionExpression()) {
            this.partExpNames.put(partitionExpressionType.getPartitionAttribute().getName(), Boolean.TRUE);
        }
        for (PartitionExpressionType partitionExpressionType : this.nodeDataCopy.getMiningAttributes().getMiningAttribute()) {
            this.partExpNames.put(partitionExpressionType.getName(), Boolean.TRUE);
        }
        this.hyperlinkButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractBuildNode abstractBuildNode = PartitionPanel.this.getTargetNode(PartitionPanel.this.propertyModel);
                PartitionAdvanceSettingPanel partitionAdvanceSettingPanel = new PartitionAdvanceSettingPanel(PartitionPanel.this.propertyModel, abstractBuildNode, PartitionPanel.this.nodeDataCopy);
                DialogHelper dialogHelper = new DialogHelper(partitionAdvanceSettingPanel);
                if (dialogHelper.showAsDialog(PartitionPanel.this)) {
                    PartitionPanel.this.partitionBuildType = partitionAdvanceSettingPanel.getPartitionBuildType();
                    if (StringUtils.isNotEmpty((String)PartitionPanel.this.partitionBuildType)) {
                        PartitionPanel.this.nodeDataCopy.setODMSPARTITIONBUILDTYPE(PartitionPanel.this.partitionBuildType);
                    }
                }
            }
        });
        this.enableControls();
    }

    private void enableControls() {
        this.jMaxPartitionValueSpinner.setEnabled(this.isWritable());
        this.moveTopPartitionColumnBtn.setEnabled(false);
        this.moveUpPartitionColumnBtn.setEnabled(false);
        this.moveDownPartitionColumnBtn.setEnabled(false);
        this.moveBottomPartitionColumnBtn.setEnabled(false);
        this.addPartitionColumnBtn.setEnabled(this.isWritable());
        this.removePartitionExprBtn.setEnabled(false);
    }

    private void setupPartitionsTable() {
        this.tableModelPartitions = new PartitionTableModel(this.partitionExpressions);
        this.partitionsTablePanel.getTable().setModel((TableModel)((Object)this.tableModelPartitions));
        this.partitionsTablePanel.getTable().setShowGrid(true);
        this.partitionsTablePanel.getTable().setSorted(false);
        this.partitionsTablePanel.getTable().getSelectionModel().addListSelectionListener(new PartitionSelectionHandler());
        TableColumn tableColumn = this.partitionsTablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new CustomCellRenderer());
    }

    public String generatePartitionExpressionName() {
        String string;
        String string2;
        PartitionExpressions partitionExpressions;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(PARTITION_EXPRESSION_TEMPLATE);
        if (this.partitionExpressions != null) {
            partitionExpressions = this.partitionExpressions;
            for (PartitionExpressionType partitionExpressionType : partitionExpressions.getPartitionExpression()) {
                if (!partitionExpressionType.getPartitionAttribute().getName().startsWith(PARTITION_EXPRESSION_TEMPLATE)) continue;
                string2 = partitionExpressionType.getPartitionAttribute().getName();
                string = string2.substring(TEMPLATE_LENGTH, string2.length());
                n = Math.max(n, Integer.parseInt(string));
            }
        }
        partitionExpressions = this.nodeDataCopy.getMiningAttributes();
        for (PartitionExpressionType partitionExpressionType : partitionExpressions.getMiningAttribute()) {
            if (!partitionExpressionType.getName().startsWith(PARTITION_EXPRESSION_TEMPLATE)) continue;
            string2 = partitionExpressionType.getName();
            string = string2.substring(TEMPLATE_LENGTH, string2.length());
            n = Math.max(n, Integer.parseInt(string));
        }
        stringBuilder.append(n + 1);
        this.partExpNames.put(stringBuilder.toString(), Boolean.TRUE);
        return stringBuilder.toString();
    }

    public List<PartitionExpressionType> getListOfPartitionColumnsToRemove(List<MiningAttributeType> list) {
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        ArrayList<PartitionExpressionType> arrayList2 = new ArrayList<PartitionExpressionType>();
        for (Object object : this.partitionExpressions.getPartitionExpression()) {
            if (null != object.getSQLExpression()) continue;
            arrayList2.add((PartitionExpressionType)object);
        }
        if (list == null || list.isEmpty()) {
            return arrayList2;
        }
        HashMap hashMap = new HashMap();
        for (MiningAttributeType miningAttributeType : list) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (PartitionExpressionType partitionExpressionType : arrayList2) {
            if (null != hashMap.get(partitionExpressionType.getPartitionAttribute().getName())) continue;
            arrayList.add(partitionExpressionType);
        }
        return arrayList;
    }

    public void removeExpressionsFromList(List<PartitionExpressionType> list) {
        if (list != null && !list.isEmpty()) {
            List list2 = this.partitionExpressions.getPartitionExpression();
            list2.removeAll(list);
            for (PartitionExpressionType partitionExpressionType : list) {
                String string = partitionExpressionType.getPartitionAttribute().getName();
                if (null == this.partExpNames.get(string)) continue;
                this.partExpNames.remove(string);
            }
        }
    }

    public List<PartitionExpressionType> getListOfPartitionColumnsToAdd(List<MiningAttributeType> list) {
        PartitionExpressionType partitionExpressionType;
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        HashMap<String, PartitionExpressionType> hashMap = new HashMap<String, PartitionExpressionType>();
        if (this.partitionExpressions != null) {
            List list2 = this.partitionExpressions.getPartitionExpression();
            MiningAttributeType miningAttributeType = list2.iterator();
            while (miningAttributeType.hasNext()) {
                partitionExpressionType = (PartitionExpressionType)miningAttributeType.next();
                if (null != partitionExpressionType.getSQLExpression()) continue;
                hashMap.put(partitionExpressionType.getPartitionAttribute().getName(), partitionExpressionType);
            }
        }
        for (MiningAttributeType miningAttributeType : list) {
            if (null != hashMap.get(miningAttributeType.getName())) continue;
            partitionExpressionType = new PartitionExpressionType();
            partitionExpressionType.setPartitionAttribute(MetaDataHelper.createAttributeFrom(miningAttributeType));
            arrayList.add(partitionExpressionType);
        }
        return arrayList;
    }

    private void handleMoveUpPartitionColumns() {
        int n = this.partitionsTablePanel.getTable().getSelectedRow();
        if (n != 0) {
            int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
            PartitionTableModel partitionTableModel = (PartitionTableModel)((Object)this.partitionsTablePanel.getTable().getModel());
            partitionTableModel.moveRow2(nArray[0], nArray[0] - 1);
            this.partitionsTablePanel.getTable().setRowSelectionInterval(n - 1, n - 1);
            this.dirty = true;
            this.updatePartitionColumns();
        }
    }

    private void handleMoveDownPartitionColumns() {
        int n;
        int n2 = this.partitionsTablePanel.getTable().getSelectedRow();
        if (n2 != (n = this.partitionsTablePanel.getTable().getRowCount() - 1)) {
            int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
            PartitionTableModel partitionTableModel = (PartitionTableModel)((Object)this.partitionsTablePanel.getTable().getModel());
            partitionTableModel.moveRow2(nArray[0], nArray[0] + 1);
            this.partitionsTablePanel.getTable().setRowSelectionInterval(n2 + 1, n2 + 1);
            this.dirty = true;
            this.updatePartitionColumns();
        }
    }

    private void handleMoveTopPartitionColumns() {
        int n = this.partitionsTablePanel.getTable().getSelectedRow();
        if (n != 0) {
            int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
            PartitionTableModel partitionTableModel = (PartitionTableModel)((Object)this.partitionsTablePanel.getTable().getModel());
            partitionTableModel.moveRow2(nArray[0], 0);
            this.partitionsTablePanel.getTable().setRowSelectionInterval(0, 0);
            this.dirty = true;
            this.updatePartitionColumns();
        }
    }

    private void handleMoveBottomPartitionColumns() {
        int n;
        int n2 = this.partitionsTablePanel.getTable().getSelectedRow();
        if (n2 != (n = this.partitionsTablePanel.getTable().getRowCount() - 1)) {
            int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
            PartitionTableModel partitionTableModel = (PartitionTableModel)((Object)this.partitionsTablePanel.getTable().getModel());
            partitionTableModel.moveRow2(nArray[0], n);
            this.partitionsTablePanel.getTable().setRowSelectionInterval(n, n);
            this.dirty = true;
            this.updatePartitionColumns();
        }
    }

    public void addPartitionExpressions(List<PartitionExpressionType> list) {
        this.partitionExpressions.getPartitionExpression().addAll(list);
        this.tableModelPartitions.RefreshModel(this.partitionExpressions);
        this.notifiyListeners();
        this.dirty = true;
    }

    public void setPartitionExpression(PartitionExpressionType partitionExpressionType) {
        int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
        if (nArray == null || nArray.length != 1) {
            return;
        }
        int n = nArray[0];
        this.partitionExpressions.getPartitionExpression().set(n, partitionExpressionType);
        this.tableModelPartitions.RefreshModel(this.partitionExpressions);
        this.notifiyListeners();
        this.dirty = true;
    }

    private void notifiyListeners() {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (PartitionExpressionType object : this.partitionExpressions.getPartitionExpression()) {
            if (object.getSQLExpression() != null) continue;
            AttributeType attributeType = object.getPartitionAttribute();
            hashMap.put(attributeType.getName(), attributeType);
        }
        for (EditChangeListener editChangeListener : this.getChangeListeners()) {
            editChangeListener.partitionKeysChanged(hashMap);
        }
    }

    private void handleAddPartitionColumns() {
        Object object3;
        Object object2;
        SuperviseBuildNodeType superviseBuildNodeType;
        ArrayList<MiningAttributeType> arrayList = null;
        if (this.nodeDataCopy instanceof SuperviseBuildNodeType) {
            superviseBuildNodeType = (SuperviseBuildNodeType)this.nodeDataCopy;
            object2 = superviseBuildNodeType.getTargetAttribute();
            arrayList = new ArrayList<MiningAttributeType>();
            if (object2 != null) {
                object3 = new MiningAttributeType();
                object3.setName(object2.getName());
                object3.setDataType(object2.getDataType());
                object3.setStatus(object2.getStatus());
                arrayList.add((MiningAttributeType)object3);
            }
        }
        superviseBuildNodeType = new MiningAttributes();
        for (Object object3 : this.nodeDataCopy.getMiningAttributes().getMiningAttribute()) {
            if (!DatabaseMetadataUtils.isPartitionKeyDataTypeSupported(object3.getDataType())) continue;
            superviseBuildNodeType.getMiningAttribute().add(object3);
        }
        object2 = new AddPartitionColumnPanel(this.getContext(), (AbstractNode)this.getData(), (MiningAttributes)superviseBuildNodeType, this.partitionExpressions, (List<MiningAttributeType>)arrayList, this.nodeDataCopy.getCaseAttributes());
        if (((DialogDisplayer)object2).showAsDialog(this) && ((AddPartitionColumnPanel)object2).isDirty()) {
            object3 = ((AddPartitionColumnPanel)object2).getSelectedAttrsCache();
            List<PartitionExpressionType> list = this.getListOfPartitionColumnsToRemove((List<MiningAttributeType>)object3);
            this.removeExpressionsFromList(list);
            List<PartitionExpressionType> list2 = this.getListOfPartitionColumnsToAdd((List<MiningAttributeType>)object3);
            this.addPartitionExpressions(list2);
            this.updatePartitionColumns();
        }
    }

    private void handleRemovePartition() {
        int[] nArray = this.partitionsTablePanel.getTable().getSelectedRowsInModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        List list = this.tableModelPartitions.getSrcData();
        ArrayList<PartitionExpressionType> arrayList = new ArrayList<PartitionExpressionType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add((PartitionExpressionType)list.get(nArray[i]));
        }
        List list2 = this.partitionExpressions.getPartitionExpression();
        list2.removeAll(arrayList);
        this.tableModelPartitions.RefreshModel(this.partitionExpressions);
        for (PartitionExpressionType partitionExpressionType : arrayList) {
            String string = partitionExpressionType.getPartitionAttribute().getName();
            if (null == this.partExpNames.get(string)) continue;
            this.partExpNames.remove(string);
        }
        this.notifiyListeners();
        this.dirty = true;
        this.updatePartitionColumns();
    }

    public String getStackSQLExpression(SQLContext sQLContext, String string) throws Exception {
        AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.getData();
        return abstractBuildNode.getStackSQLExpression(sQLContext, string);
    }

    public boolean doWork() {
        boolean bl = true;
        try {
            if (this.dirty && this.propertyModel == null) {
                PartitionExpressions partitionExpressions = this.tableModelPartitions.getModel();
                if (partitionExpressions.getPartitionExpression().size() > 16) {
                    throw new ValidationException(BuildEditorLrb.get("BUILD_PARTITION_MAX_NUM_PARTITION_KEYS_OUT_OF_RANGE"));
                }
                Integer n = (Integer)this.jMaxPartitionValueSpinner.getValue();
                if (n > 1000000 || n < 1) {
                    throw new ValidationException(BuildEditorLrb.get("BUILD_PARTITION_MAX_PARTITION_OUT_OF_RANGE"));
                }
                this.nodeDataCopy.setMaxNumPartitions(BigInteger.valueOf(n.intValue()));
                this.nodeDataCopy.setPartitionExpressions(partitionExpressions);
            }
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)this.getParent(), (Object)validationException.getLocalizedMessage(), (String)BuildEditorLrb.get("BUILD_PARTITION_ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    class PartitionSelectionHandler
    implements ListSelectionListener {
        PartitionSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = PartitionPanel.this.partitionsTablePanel.getTable().getSelectedRowsInModel();
            boolean bl = nArray != null && nArray.length > 0;
            PartitionPanel.this.removePartitionExprBtn.setEnabled(PartitionPanel.this.isWritable() && bl);
            boolean bl2 = nArray != null && nArray.length == 1;
            int n = PartitionPanel.this.partitionsTablePanel.getTable().getSelectedRow();
            PartitionPanel.this.moveTopPartitionColumnBtn.setEnabled(PartitionPanel.this.isWritable() && bl2 && n != 0);
            PartitionPanel.this.moveUpPartitionColumnBtn.setEnabled(PartitionPanel.this.isWritable() && bl2 && n != 0);
            PartitionPanel.this.moveDownPartitionColumnBtn.setEnabled(PartitionPanel.this.isWritable() && bl2 && n != PartitionPanel.this.partitionsTablePanel.getTable().getRowCount() - 1);
            PartitionPanel.this.moveBottomPartitionColumnBtn.setEnabled(PartitionPanel.this.isWritable() && bl2 && n != PartitionPanel.this.partitionsTablePanel.getTable().getRowCount() - 1);
            boolean bl3 = false;
            if (bl2) {
                List list = PartitionPanel.this.tableModelPartitions.getSrcData();
                PartitionExpressionType partitionExpressionType = (PartitionExpressionType)list.get(nArray[0]);
                bl3 = null != partitionExpressionType.getSQLExpression();
            }
        }
    }

    private class CustomCellRenderer
    extends PartitionCustomCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Icon getValidIcon() {
            return DataMinerIcons.get(Icons.PARTITION_KEY_ICON);
        }

        @Override
        public Icon getInvalidIcon() {
            return OracleIcons.getIcon((String)"warning.png");
        }

        @Override
        public PartitionExpressionType getPartitionExpression(String string) {
            PartitionExpressionType partitionExpressionType = null;
            List list = PartitionPanel.this.tableModelPartitions.getSrcData();
            for (PartitionExpressionType partitionExpressionType2 : list) {
                if (null != partitionExpressionType2.getSQLExpression() || !partitionExpressionType2.getPartitionAttribute().getName().equals(string)) continue;
                partitionExpressionType = partitionExpressionType2;
                break;
            }
            return partitionExpressionType;
        }
    }
}

