/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.CheckBoxTableListener;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.LabeledCheckBoxRenderer;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetTextAttributesFeaturesQuery;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.common.build.TextAttribute;
import oracle.dmt.dataminer.core.model.common.build.TextFeature;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;

public class AddStopwordsFromFeaturesPanel
extends DialogDisplayer<AbstractBuildNode> {
    private static final int SHOW_STOPWORDS = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.build.showWords");
    private static final int SHOW_STOPTHEMES = Ide.findOrCreateCmdID((String)"oracle.dataminer.workflow.dialog.build.showThemes");
    private boolean dirty;
    private boolean showWords;
    private boolean showThemes;
    private StopwordTableModel tableModel;
    private JPanel parentPanel;
    private BuildNodeType nodeMetadata;
    private StoplistType stoplistMetadata;
    private ToggleToolButton showWordsButton;
    private ToggleToolButton showThemesButton;
    private CheckListener tableListener;
    private Map<String, Boolean> allTokens;
    private LabeledCheckBoxRenderer tableCellRenderer;
    private DataMinerTablePanel dataMinerTablePanel;
    private JLabel jLanguageLabel;
    private JLabel jStoplistLabel;
    private JLabel languageLabel;
    private JTextField stoplistTextField;

    public AddStopwordsFromFeaturesPanel(Context context, JPanel jPanel, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, StoplistType stoplistType) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "AbstractBuildNode node must not be null.";
        this.initComponents();
        this.initObjects(jPanel, buildNodeType, stoplistType);
        this.initRes();
        this.initUI();
    }

    private void initObjects(JPanel jPanel, BuildNodeType buildNodeType, StoplistType stoplistType) {
        this.showWords = true;
        this.showThemes = true;
        this.parentPanel = jPanel;
        this.nodeMetadata = buildNodeType;
        this.stoplistMetadata = (StoplistType)MetaDataHelper.copyMetadataObject(stoplistType);
        this.allTokens = new HashMap<String, Boolean>();
        for (StoplistType.StopTokens.Token token : this.stoplistMetadata.getStopTokens().getToken()) {
            String string = token.getLanguage();
            String string2 = token.getItem();
            String string3 = token.getType();
            String string4 = string + ":" + string3 + ":" + string2;
            this.allTokens.put(string4, Boolean.TRUE);
        }
        this.tableCellRenderer = new LabeledCheckBoxRenderer();
        this.tableListener = new CheckListener(this.tableCellRenderer);
    }

    private void initComponents() {
        this.jStoplistLabel = new JLabel();
        this.stoplistTextField = new JTextField();
        this.jLanguageLabel = new JLabel();
        this.languageLabel = new JLabel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.setPreferredSize(new Dimension(464, 364));
        this.jStoplistLabel.setText("Stoplist:");
        this.jLanguageLabel.setText("Language:");
        this.languageLabel.setText("jLabel3");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dataMinerTablePanel, -1, 433, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jStoplistLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jLanguageLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.languageLabel, -1, -1, Short.MAX_VALUE).addComponent(this.stoplistTextField, -1, 213, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStoplistLabel).addComponent(this.stoplistTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.languageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.dataMinerTablePanel, -1, 294, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, (Component)this.stoplistTextField, (String)DialogsLrb.get("ADD_STOPWORD_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.languageLabel, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGES"));
    }

    @Override
    public void initUI() {
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        this.stoplistTextField.setText(this.stoplistMetadata.getName());
        this.stoplistTextField.setEditable(false);
        String string = null;
        string = this.stoplistMetadata.getType().equals("Basic") ? ServerConstants.StoplistLanguage.toHuman((String)this.stoplistMetadata.getLanguage()) : ServerConstants.StoplistLanguage.toHuman((String)"Multi");
        this.languageLabel.setText(string);
        this.initControlBar();
        this.initTable();
    }

    private void initTable() {
        this.tableModel = new StopwordTableModel();
        this.dataMinerTablePanel.setup((TableModel)((Object)this.tableModel), "", 1, true);
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        dataMinerTable.setResizeColumnOnDoubleClick(true);
        dataMinerTable.getSelectionModel().setSelectionMode(2);
        dataMinerTable.addMouseListener(this.tableListener);
        dataMinerTable.addKeyListener(this.tableListener);
        TableColumn tableColumn = dataMinerTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.tableCellRenderer);
        this.configureSorting();
    }

    private void configureSorting() {
        DataMinerTable dataMinerTable = this.dataMinerTablePanel.getTable();
        TableRowSorter<StopwordTableModel> tableRowSorter = (TableRowSorter<StopwordTableModel>)dataMinerTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<StopwordTableModel>(this.tableModel);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
            arrayList.add(new RowSorter.SortKey(3, SortOrder.DESCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(new TokenFilter());
        dataMinerTable.setRowSorter(tableRowSorter);
    }

    public void load() {
        LoadUI loadUI = new LoadUI(this.nodeMetadata);
        loadUI.execute();
    }

    private void initControlBar() {
        IdeAction ideAction = IdeAction.get((int)SHOW_STOPWORDS);
        this.showWordsButton = new ToggleToolButton((ToggleAction)ideAction);
        this.showWordsButton.setIcon(OracleIcons.getIcon((String)"text.png"));
        this.showWordsButton.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPWORDS_TIP"));
        this.showWordsButton.setSelected(this.showWords);
        this.showWordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                AddStopwordsFromFeaturesPanel.this.showWords = toggleToolButton.isSelected();
            }
        });
        IdeAction ideAction2 = IdeAction.get((int)SHOW_STOPTHEMES);
        this.showThemesButton = new ToggleToolButton((ToggleAction)ideAction2);
        this.showThemesButton.setIcon(OracleIcons.getIcon((String)"catalog.png"));
        this.showThemesButton.setToolTipText(DialogsLrb.get("STOPLIST_SHOW_STOPTHEMES_TIP"));
        this.showThemesButton.setSelected(this.showThemes);
        this.showThemesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToggleToolButton toggleToolButton = (ToggleToolButton)actionEvent.getSource();
                AddStopwordsFromFeaturesPanel.this.showThemes = toggleToolButton.isSelected();
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(new Component[]{this.showWordsButton, this.showThemesButton});
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        List list = this.tableModel.getSrcData();
        for (ColumnData columnData : list) {
            String string;
            String string2;
            if (!((Entry)columnData.getData()).getSelected().booleanValue()) continue;
            TextFeature textFeature = (TextFeature)((Entry)columnData.getData()).getUserObject();
            String string3 = this.stoplistMetadata.getLanguage();
            string3 = "Multi".equals(string3) ? "All" : string3;
            String string4 = string3 + ":" + (string2 = textFeature.getType()) + ":" + (string = textFeature.getName());
            if (this.allTokens.containsKey(string4)) continue;
            StoplistType.StopTokens.Token token = new StoplistType.StopTokens.Token();
            token.setLanguage(string3);
            token.setType(string2);
            token.setItem(string);
            this.stoplistMetadata.getStopTokens().getToken().add(token);
            this.allTokens.put(string4, Boolean.TRUE);
            this.dirty = true;
        }
        return bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public StoplistType getStoplist() {
        return this.stoplistMetadata;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("ADD_STOPWORD_FEATURE_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "add_stopwords_from_features";
    }

    private class CheckListener
    extends CheckBoxTableListener {
        public CheckListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
            super(labeledCheckBoxRenderer);
        }

        @Override
        protected void itemChecked(int n) {
            DataMinerTable dataMinerTable = AddStopwordsFromFeaturesPanel.this.dataMinerTablePanel.getTable();
            ColumnData columnData = (ColumnData)AddStopwordsFromFeaturesPanel.this.tableModel.getValueAt(dataMinerTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.TRUE);
            Entry entry = (Entry)columnData.getData();
            entry.setSelected(Boolean.TRUE);
        }

        @Override
        public void itemUnchecked(int n) {
            DataMinerTable dataMinerTable = AddStopwordsFromFeaturesPanel.this.dataMinerTablePanel.getTable();
            ColumnData columnData = (ColumnData)AddStopwordsFromFeaturesPanel.this.tableModel.getValueAt(dataMinerTable.convertRowIndexToModel(n), 0);
            columnData.setCheckBoxState(TriStateBoolean.FALSE);
            Entry entry = (Entry)columnData.getData();
            entry.setSelected(Boolean.FALSE);
        }
    }

    private static class StopwordTableModel
    extends ODMrTableModel<ColumnData> {
        private static final int STOPWORD_ATTR = 0;
        private static final int STOPWORD_NAME = 1;
        private static final int STOPWORD_TYPE = 2;
        private static final int STOPWORD_FREQUENCY = 3;
        private static final int SELECT_COLUMN = -1;
        private static final String[] STOP_WORD_COLUMN_NAMES = new String[]{DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_ATTR"), DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_NAME"), DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_TYPE"), DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_FREQ")};

        public StopwordTableModel() {
            super(STOP_WORD_COLUMN_NAMES);
        }

        public void addTextFeatures(List<TextFeature> list) {
            for (TextFeature textFeature : list) {
                Entry entry = new Entry();
                entry.setUserObject(textFeature);
                ColumnData columnData = new ColumnData(entry);
                if (entry.getSelected().booleanValue()) {
                    columnData.setCheckBoxState(TriStateBoolean.TRUE);
                }
                this.srcData.add(columnData);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 3) {
                return Integer.class;
            }
            if (n == 0) {
                return ColumnData.class;
            }
            return String.class;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == -1) {
                ColumnData columnData = (ColumnData)this.srcData.get(n);
                Entry entry = (Entry)columnData.getData();
                entry.setSelected((Boolean)object);
            }
        }

        public Object getValueAt(int n, int n2) {
            if (this.srcData == null) {
                return "Loading...";
            }
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            ColumnData columnData = (ColumnData)this.srcData.get(n);
            Entry entry = (Entry)columnData.getData();
            TextFeature textFeature = (TextFeature)entry.getUserObject();
            Object object = null;
            switch (n2) {
                case -1: {
                    object = entry.getSelected();
                    break;
                }
                case 0: {
                    object = columnData;
                    break;
                }
                case 1: {
                    object = textFeature.getName();
                    break;
                }
                case 2: {
                    object = ServerConstants.StopTokenType.toHuman((String)textFeature.getType());
                    break;
                }
                case 3: {
                    object = textFeature.getFrequency();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        @Override
        public String getStringValueAt(int n, int n2) {
            Object object = this.getValueAt(n, n2);
            String string = "";
            if (object != null) {
                string = object.toString();
            }
            return string;
        }
    }

    private class TokenFilter
    extends RowFilter<StopwordTableModel, Integer> {
        private TokenFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends StopwordTableModel, ? extends Integer> entry) {
            String string;
            String string2 = AddStopwordsFromFeaturesPanel.this.dataMinerTablePanel.getSearchField().getText();
            SearchCategory searchCategory = AddStopwordsFromFeaturesPanel.this.dataMinerTablePanel.getSearchField().getSelectedCategory();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = string2 != null && searchCategory != null;
            Integer n = entry.getIdentifier();
            StopwordTableModel stopwordTableModel = entry.getModel();
            String string3 = (String)stopwordTableModel.getValueAt(n, 2);
            if (AddStopwordsFromFeaturesPanel.this.showWords && ServerConstants.StopTokenType.isWord((String)string3) || AddStopwordsFromFeaturesPanel.this.showThemes && ServerConstants.StopTokenType.isTheme((String)string3) || ServerConstants.StopTokenType.isUnknown((String)string3)) {
                bl2 = true;
            }
            String string4 = string = string2 != null ? string2.toLowerCase() : null;
            if (bl2 && bl3 && searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_ATTR"))) {
                ColumnData columnData = (ColumnData)stopwordTableModel.getValueAt(n, 0);
                Entry entry2 = (Entry)columnData.getData();
                TextFeature textFeature = (TextFeature)entry2.getUserObject();
                if (textFeature.getColumn().toLowerCase().startsWith(string)) {
                    bl = true;
                }
            } else if (bl2 && bl3 && searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_NAME"))) {
                String string5 = (String)stopwordTableModel.getValueAt(n, 1);
                if (string5.toLowerCase().startsWith(string)) {
                    bl = true;
                }
            } else if (bl2 && bl3 && searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_TYPE"))) {
                String string6 = (String)stopwordTableModel.getValueAt(n, 2);
                if (string6.toLowerCase().startsWith(string)) {
                    bl = true;
                }
            } else if (bl2 && bl3 && searchCategory.getLabel().equals(DialogsLrb.get("ADD_STOPWORD_FEATURE_COL_FREQ"))) {
                Integer n2 = (Integer)stopwordTableModel.getValueAt(n, 3);
                if (n2.toString().startsWith(string)) {
                    bl = true;
                }
            } else if (bl2) {
                bl = true;
            }
            return bl;
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<List<TextFeature>, Void> {
        private Query<TextFeature> query;
        private SqlDataAccessObject dao;
        private BuildNodeType nodeMetadata;
        private List<TextFeature> textFeatures;
        private ConnectionManager connectionManager;

        public LoadUI(BuildNodeType buildNodeType) {
            super(AddStopwordsFromFeaturesPanel.this);
            this.nodeMetadata = buildNodeType;
            this.textFeatures = new ArrayList<TextFeature>();
            this.connectionManager = ConnectionFolder.getConnectionFolder(AddStopwordsFromFeaturesPanel.this._context);
            this.dao = new SqlDataAccessObject(this.connectionManager);
        }

        @Override
        protected List<TextFeature> doInBackground() throws Exception {
            List<TextAttribute> list = AbstractBuildNode.getDefaultTextAttributes(this.nodeMetadata);
            if (!list.isEmpty()) {
                this.query = new GetTextAttributesFeaturesQuery(this.connectionManager.getDbVersion(), list);
                List list2 = this.dao.readItems(this.query);
                for (TextFeature textFeature : list2) {
                    String string;
                    String string2;
                    String string3 = AddStopwordsFromFeaturesPanel.this.stoplistMetadata.getLanguage();
                    string3 = "Multi".equals(string3) ? "All" : string3;
                    String string4 = string3 + ":" + (string2 = textFeature.getType()) + ":" + (string = textFeature.getName());
                    if (AddStopwordsFromFeaturesPanel.this.allTokens.containsKey(string4)) continue;
                    this.textFeatures.add(textFeature);
                }
            }
            return this.textFeatures;
        }

        @Override
        protected void onSuccess(List<TextFeature> list) throws Exception {
            AddStopwordsFromFeaturesPanel.this.tableModel.addTextFeatures(list);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILD_TEXT_NODE_EDIT_ERROR_MESG"), null);
        }
    }

    private static class ColumnData
    extends CheckedItemData {
        public ColumnData(Entry entry) {
            super(entry);
        }

        @Override
        public String toString() {
            TextFeature textFeature = (TextFeature)((Entry)this.getData()).getUserObject();
            return textFeature.getColumn();
        }
    }

    private static class Entry {
        private Boolean selected = Boolean.FALSE;
        private Object userObject;

        public void setSelected(Boolean bl) {
            this.selected = bl;
        }

        public Boolean getSelected() {
            return this.selected;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public Object getUserObject() {
            return this.userObject;
        }
    }
}

