/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardModel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizardPage;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ModelProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class ApplyNodePage
extends ApplyWizardPage
implements DataminerGUIPanel {
    private NodesTableModel _models;
    private DataMinerTablePanel tablePanel;

    public ApplyNodePage() {
        this.initComponents();
        this.initRes();
    }

    @Override
    public void initUI() {
        ApplyWizardModel applyWizardModel = this.getModel(this.getTraversableContext());
        this._models = new NodesTableModel(applyWizardModel);
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("PAGE_NODE_TITLE"), 0);
        this.tablePanel.getTable().setSelectionMode(0);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ApplyNodePage.this.handleModelSelectionChanged();
            }
        });
    }

    @Override
    public void initRes() {
    }

    private void initComponents() {
        this.tablePanel = new DataMinerTablePanel();
        this.tablePanel.setName("tablePanel");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, 504, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.tablePanel, -1, 366, Short.MAX_VALUE).addContainerGap()));
    }

    private void handleModelSelectionChanged() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        int n = this.tablePanel.getTable().convertRowIndexToModel(nArray[0]);
        ApplyWizardModel applyWizardModel = this.getModel(this.getTraversableContext());
        List<AbstractNode> list = applyWizardModel.getAvailModelNodes();
        applyWizardModel.setSelectedModelNode(list.get(n));
        this.setDirty(true, "modelDirty");
    }

    @Override
    public String getPageDirtyKey() {
        return "nodeDirty";
    }

    @Override
    protected boolean doValidation(TraversableContext traversableContext) {
        ApplyWizardModel applyWizardModel = this.getModel(traversableContext);
        if (traversableContext.getDirection() == 2) {
            return true;
        }
        AbstractNode abstractNode = applyWizardModel.getSelectedModelNode();
        if (abstractNode == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("PAGE_NODE_NO_SELECTION"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            return false;
        }
        return this.validateAndWriteToState(applyWizardModel);
    }

    public boolean validateAndWriteToState(ApplyWizardModel applyWizardModel) {
        boolean bl = true;
        ValidateWriteThread validateWriteThread = new ValidateWriteThread();
        validateWriteThread.setMessage(MessageFormat.format(GroupLrb.get("VALIDATING_GROUP_TABLES_DETAILS"), new Object[]{null}));
        validateWriteThread.setCancelable(false);
        try {
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)GroupLrb.get("CREATE_GROUP_FAILURE_TITLE"), (String)GroupLrb.get("CREATE_GROUP_FAILURE_MESG"), null);
        }
        return bl;
    }

    private static class NodesTableModel
    extends SimpleBaseTableModel {
        private ApplyWizardModel _wizModel;
        public static String[] _columnNames = new String[]{DialogsLrb.get("PAGE_NODE_NAME_COL"), DialogsLrb.get("PAGE_NODE_FUNCTION_COL"), DialogsLrb.get("PAGE_NODE_TARGET_COL")};
        public static final int NAME_COLUMN = 0;
        public static final int FUNCTION_COLUMN = 1;
        public static final int TARGET_COLUMN = 2;
        public static final int COLUMN_COUNT = 3;

        public NodesTableModel(ApplyWizardModel applyWizardModel) {
            this._wizModel = applyWizardModel;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(3);
        }

        public int getRowCount() {
            return this._wizModel != null ? this._wizModel.getAvailModelNodes().size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            List<AbstractNode> list = this._wizModel.getAvailModelNodes();
            ModelProvider modelProvider = null;
            String string = null;
            switch (n2) {
                case 0: {
                    string = list.get(n).getData().getName();
                    break;
                }
                case 1: {
                    modelProvider = (ModelProvider)((Object)list.get(n));
                    string = ServerConstants.MiningFunction.getUIFunctionName((String)modelProvider.getMiningFunctionTypeSupported().value());
                    break;
                }
                case 2: {
                    modelProvider = (ModelProvider)((Object)list.get(n));
                    AttributeType attributeType = modelProvider.getTargetAttribute();
                    string = attributeType == null ? null : modelProvider.getTargetAttribute().getName();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }

    private static class ValidateWriteThread
    extends ProgressRunnable {
        boolean _validated = true;

        private ValidateWriteThread() {
        }

        public boolean getValidation() {
            return this._validated;
        }

        protected Object doWork() throws Exception {
            try {
                this._validated = true;
            }
            catch (Exception exception) {
                this._validated = false;
            }
            return null;
        }
    }
}

