/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.aggregate;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.expressionbuilder.AggregateMainGroupBy;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderMainPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateValidation;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateValidationProgress;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.jdbc.OracleCallableStatement;

public class AggregateEditExpressionPanel
extends JPanel
implements DataminerGUIPanel,
DataConsumerPanel,
AggregateValidation {
    private Context _context;
    private GroupingElementType _mainGroupByElement;
    private GroupingElementType _currentGroupByElement;
    private AggregationNodeType _cachedAggregationNodeData;
    private AggregationElementType _currentAggregationElement;
    private DataProvider _parentNode;
    private Boolean _wizard = Boolean.FALSE;
    private ComponentWithTitlebar<JComponent> jAvailAttrComponentWithTitlebar;
    private JButton jBtnValidate;
    private JTextArea jTextExpression = new JTextArea();
    private JButton _editBtn;
    private static String DBMS_SQL_PARSE_2 = "DECLARE   curid          INTEGER;\n  ret_value      INTEGER;\n  TYPE\n    LSTMT_REC_TYPE      IS RECORD (\n      lstmt                 dbms_sql.VARCHAR2A,\n      lb                    BINARY_INTEGER DEFAULT 1,\n      ub                    BINARY_INTEGER DEFAULT 0);\n  v_tmp_lstmt     LSTMT_REC_TYPE;\nBEGIN\n  curid := DBMS_SQL.OPEN_CURSOR;\n  v_tmp_lstmt.ub := 0;\n [SQL_EXPRESSION]  \nDBMS_SQL.PARSE(curid, v_tmp_lstmt.lstmt, v_tmp_lstmt.lb, v_tmp_lstmt.ub, FALSE, DBMS_SQL.NATIVE);\n  DBMS_SQL.CLOSE_CURSOR(curid);\n  EXCEPTION WHEN OTHERS THEN\n    DBMS_SQL.CLOSE_CURSOR(curid);\n    RAISE;  \nEND;\n";

    public AggregateEditExpressionPanel(Context context, DataProvider dataProvider, AggregationNodeType aggregationNodeType, GroupingElementType groupingElementType) {
        this._context = context;
        this._parentNode = dataProvider;
        this._currentGroupByElement = groupingElementType;
        this._cachedAggregationNodeData = aggregationNodeType;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public AggregateEditExpressionPanel(Context context, DataProvider dataProvider, AggregationElementType aggregationElementType, GroupingElementType groupingElementType, GroupingElementType groupingElementType2) {
        this(context, dataProvider, aggregationElementType, groupingElementType, groupingElementType2, Boolean.FALSE);
    }

    public AggregateEditExpressionPanel(Context context, DataProvider dataProvider, AggregationElementType aggregationElementType, GroupingElementType groupingElementType, GroupingElementType groupingElementType2, Boolean bl) {
        this._context = context;
        this._parentNode = dataProvider;
        this._currentGroupByElement = groupingElementType2;
        this._currentAggregationElement = aggregationElementType;
        this._mainGroupByElement = groupingElementType;
        this._wizard = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jBtnValidate = new JButton();
        this.jAvailAttrComponentWithTitlebar = new ComponentWithTitlebar();
        this.jBtnValidate.setText("Validate");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jBtnValidate).addContainerGap(509, Short.MAX_VALUE)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAvailAttrComponentWithTitlebar, -1, 570, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(266, Short.MAX_VALUE).addComponent(this.jBtnValidate).addContainerGap()).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAvailAttrComponentWithTitlebar, -2, 242, -2).addGap(47, 47, 47))));
    }

    @Override
    public void initRes() {
        if (this._wizard.equals(Boolean.FALSE)) {
            ResourceUtils.resButton((AbstractButton)this.jBtnValidate, (String)AggregateDialogsLrb.get("ADD_AGGREGATION_ADD_GROUP_BY_DLG_TYPE_EXPRESSION_VALIDATE"));
        } else {
            this.jBtnValidate.setVisible(false);
        }
    }

    @Override
    public void initUI() {
        JScrollPane jScrollPane = new JScrollPane(this.jTextExpression);
        this.jAvailAttrComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.jAvailAttrComponentWithTitlebar.setLabel(new JLabel(AggregateDialogsLrb.get("ADD_AGGREGATION_ADD_GROUP_BY_DLG_TYPE_EXPRESSION")));
        this._editBtn = new JButton(OracleIcons.getIcon((String)"edit.png"));
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._editBtn);
        this._editBtn.setToolTipText(AggregateDialogsLrb.get("ADD_AGGREGATION_EXPRESSION_BUILDER"));
        this._editBtn.setEnabled(true);
        this.jAvailAttrComponentWithTitlebar.setControlBar(controlBar);
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = AggregateEditExpressionPanel.this.jTextExpression.getText();
                AggregateMainGroupBy aggregateMainGroupBy = new AggregateMainGroupBy(AggregateEditExpressionPanel.this._parentNode.getInputSQL(), (AbstractNode)((Object)AggregateEditExpressionPanel.this._parentNode), string);
                ExpressionBuilderMainPanel expressionBuilderMainPanel = new ExpressionBuilderMainPanel(AggregateEditExpressionPanel.this._context, aggregateMainGroupBy);
                DialogHelper dialogHelper = new DialogHelper(expressionBuilderMainPanel);
                if (dialogHelper.showAsDialog(AggregateEditExpressionPanel.this)) {
                    string = expressionBuilderMainPanel.getExpression();
                    AggregateEditExpressionPanel.this.jTextExpression.setText(string != null ? string : "");
                }
            }
        });
        String string = this._currentGroupByElement.getExpression();
        this.jTextExpression.setText(string != null ? string : "");
        if (this._wizard.equals(Boolean.FALSE)) {
            this.jBtnValidate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AggregateValidationProgress.startLongRunningOperation(AggregateEditExpressionPanel.this, true);
                }
            });
        }
    }

    private String getExpression() {
        String string = null;
        this.jTextExpression.setEditable(true);
        if (null != this._currentGroupByElement) {
            string = this._currentGroupByElement.getExpression();
        }
        return string;
    }

    public void updatePanelStatus() {
        String string = null;
        boolean bl = true;
        if (null != this._cachedAggregationNodeData) {
            AggregationElements aggregationElements = this._cachedAggregationNodeData.getAggregationElements();
            if (null == aggregationElements || null == aggregationElements.getAggregationElement()) {
                string = AggregateDialogsLrb.get("ADD_AGGREGATION_ADD_GROUP_BY_DLG_TYPE_EXPRESSION_NO_AGGREGATION_ELEMENTS");
                this.jTextExpression.setEditable(false);
                bl = false;
            } else {
                string = this.getExpression();
            }
        } else {
            string = this.getExpression();
        }
        this.jBtnValidate.setEnabled(bl);
        this.jTextExpression.setText(string != null ? string : "");
    }

    public String getExpressionString() {
        return this.jTextExpression.getText().trim();
    }

    @Override
    public boolean doWork() {
        String string = this.jTextExpression.getText().trim();
        if (string == null || string.isEmpty()) {
            if (this._wizard.equals(Boolean.TRUE)) {
                return true;
            }
            MessageDialog.error((Component)this, (Object)AggregateDialogsLrb.get("SQL_EXPRESSION_IS_EMPTY"), (String)AggregateDialogsLrb.get("SQL_EXPRESSION_IS_EMPTY_TITLE"), null);
            return false;
        }
        if (this._wizard.equals(Boolean.TRUE)) {
            string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
            string = StringUtils.removeLineSeparator(string);
            this._currentGroupByElement.setExpression(string);
            this._currentGroupByElement.setAttributes(null);
            return true;
        }
        Boolean bl = AggregateValidationProgress.startLongRunningOperation(this, false);
        if (bl.equals(Boolean.TRUE)) {
            string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
            string = StringUtils.removeLineSeparator(string);
            this._currentGroupByElement.setExpression(string);
            this._currentGroupByElement.setAttributes(null);
        }
        return bl;
    }

    @Override
    public boolean isValidExpression(boolean bl) throws Exception {
        boolean bl2 = false;
        String string = this.jTextExpression.getText().trim();
        if (string == null || string.isEmpty()) {
            return bl2;
        }
        string = !StringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
        String string2 = null;
        if (null != this._cachedAggregationNodeData) {
            GroupingElementType groupingElementType = new GroupingElementType();
            String string3 = string;
            string3 = StringUtils.removeLineSeparator(string3);
            groupingElementType.setExpression(string3);
            string2 = AttributeTypeHelper.generateSQLExpression(this._context, this._cachedAggregationNodeData.getAggregationElements(), groupingElementType, this._parentNode.getInputSQL(), true);
        } else if (null != this._currentAggregationElement && null != this._mainGroupByElement) {
            string2 = AttributeTypeHelper.getValidationSQLForGroupByExpression(this._context, this._mainGroupByElement, this._currentAggregationElement, string, "", this._parentNode.getInputSQL());
        }
        if (string2 != null) {
            bl2 = AttributeTypeHelper.executeSQLAggregate(this._context, string2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeSQL(Context context, String string) throws SQLException {
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string2 = StringUtils.escapeSingleQuotesForSQL(string);
            String[] stringArray = string2.split("\n");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append("\nv_tmp_lstmt.ub := v_tmp_lstmt.ub + 1;");
                stringBuilder.append("\nv_tmp_lstmt.lstmt(v_tmp_lstmt.ub) := ");
                stringBuilder.append("'");
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(" ';");
            }
            stringBuilder.append("\n");
            String string3 = StringUtils.getReplacedString(DBMS_SQL_PARSE_2, "[SQL_EXPRESSION]", stringBuilder.toString());
            sQLHelper.conn = ConnectionFolder.getConnection(context, ConnectionProperties.ALTER_SESSION_FIXES);
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall(string3);
            sQLHelper.cstmt.execute();
            bl = true;
        }
        return bl;
    }
}

