/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.dmt.dataminer.DataMinerDiagramEditor;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.WorkflowContextMenu;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.WorkflowMainMenuController;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.Layout;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.thumbnail.ThumbnailDockable;
import oracle.ide.util.MenuSpec;

public class WorkflowEditorAddin
extends EditorAddin
implements ShutdownHook {
    private static final Logger theLogger = Logger.getLogger(DataMinerDiagramEditor.class.getName());
    private MenuSpec m_menuSpec = null;

    public boolean isDefault() {
        return true;
    }

    public Class getEditorClass() {
        return WorkflowEditor.class;
    }

    public MenuSpec getMenuSpecification() {
        if (this.m_menuSpec == null) {
            this.m_menuSpec = new MenuSpec("Workflow Editor", Integer.valueOf("S".charAt(0)), null);
        }
        return this.m_menuSpec;
    }

    public void initialize() {
        super.initialize();
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.register((EditorAddin)this, new Class[]{WorkflowNode.class});
        editorManager.registerPreferredLayoutListener(WorkflowNode.class, WorkflowEditor.class, "Workflow Layout", (PreferredLayoutListener)new WorkflowPreferredLayoutListener());
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/dmt/dataminer/accelerators.xml");
        WorkflowMainMenuController workflowMainMenuController = new WorkflowMainMenuController();
        final IdeAction ideAction = IdeAction.get((int)WorkflowContextMenu.CONNECT_ACTION_ID, null, (String)"Connect", (String)IdeMainWindow.ACTION_CATEGORY_EDIT, (Integer)78, null, null, (boolean)false);
        ideAction.addController((Controller)workflowMainMenuController);
        IdeAction.find((int)17).addController((Controller)workflowMainMenuController);
        IdeAction.find((int)20).addController((Controller)workflowMainMenuController);
        IdeAction.find((int)19).addController((Controller)workflowMainMenuController);
        IdeAction.find((int)22).addController((Controller)workflowMainMenuController);
        IdeAction.find((int)78).addController((Controller)workflowMainMenuController);
        Ide.getMainWindow().addDynamicMenuListener(new DynamicMenuListener(){

            public JComponent[] gatherDynamicActions(Context context) {
                if (context.getView() instanceof WorkflowEditor) {
                    return new JComponent[]{Ide.getMenubar().createMenuItem((ToggleAction)ideAction, 0.0f), new JPopupMenu.Separator()};
                }
                return new JComponent[0];
            }
        });
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public boolean isDuplicable() {
        return false;
    }

    public float getEditorWeight(Element element) {
        return element instanceof WorkflowNode ? 0.5f : Float.NaN;
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        final List list = EditorManager.getEditorManager().getAllEditors();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (Object e : list) {
                        if (!(e instanceof WorkflowEditor)) continue;
                        ((WorkflowEditor)e).close();
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            theLogger.log(Level.SEVERE, invocationTargetException.getMessage(), invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            theLogger.log(Level.SEVERE, interruptedException.getMessage(), interruptedException);
        }
    }

    private static class WorkflowPreferredLayoutListener
    implements PreferredLayoutListener {
        private WorkflowPreferredLayoutListener() {
        }

        public void onInitializeLayout(PreferredLayoutEvent preferredLayoutEvent) {
            Layout layout = preferredLayoutEvent.getLayout();
            layout.setProperty("Layout.ShowPalette2", Boolean.TRUE.toString());
            layout.setProperty("Layout.ShowUnifiedThumbnail", Boolean.TRUE.toString());
            layout.setProperty("Layout.ShowInspector", Boolean.TRUE.toString());
            layout.setProperty("Layout.ShowStructure", Boolean.TRUE.toString());
        }

        public void onPreferredLayoutActivate(PreferredLayoutEvent preferredLayoutEvent) {
            Dockable dockable;
            ThumbnailDockable thumbnailDockable;
            DockStation dockStation = DockStation.getDockStation();
            Dockable dockable2 = dockStation.getDockable(InspectorManager.getInspectorManager().getDefaultViewId());
            if (dockable2 != null && dockable2.getSite() != null) {
                thumbnailDockable = new DockingParam();
                thumbnailDockable.setPosition(3);
                dockStation.dock(dockable2, (DockingParam)thumbnailDockable);
                dockStation.activateDockable(dockable2);
            }
            if ((thumbnailDockable = (ThumbnailDockable)dockStation.getDockable(ThumbnailDockable.VIEW_ID)) != null && thumbnailDockable.getSite() != null) {
                dockable = new DockingParam();
                dockable.setPosition(1);
                dockStation.dock((Dockable)thumbnailDockable, (DockingParam)dockable);
                dockStation.activateDockable((Dockable)thumbnailDockable);
            }
            if ((dockable = dockStation.getDockable(ExplorerManager.getExplorerManager().getDefaultViewId())) != null) {
                DockingParam dockingParam = new DockingParam();
                dockingParam.setPosition(0);
                dockStation.dock(dockable, dockingParam);
                dockStation.activateDockable(dockable);
            }
        }
    }
}

