/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.wizard.project;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.TextFieldLimit;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.navigator.BaseDeferredFilter;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.ConnectionFolderFilter;
import oracle.dmt.dataminer.navigator.ProjectFolder;
import oracle.dmt.dataminer.repository.WorkflowProject;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.wizard.project.ProjectLrb;
import oracle.dmt.dataminer.wizard.project.ProjectModel;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.ResourceUtils;

public class ProjectPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private Context context;
    private ProjectModel state;
    private boolean editMode;
    private JTextArea _jComment;
    private JLabel _jCommentLabel;
    private JTextField _jName;
    private JLabel _jNameLabel;
    private JScrollPane jScrollPane1;

    public ProjectPanel(Context context) {
        this.context = context;
        this.state = this.buildState();
        this.editMode = this.state.isProjectModelEditMode();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public ProjectPanel(Context context, boolean bl) {
        this.context = context;
        this.state = this.buildState();
        this.editMode = bl;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jNameLabel = new JLabel();
        this._jName = new JTextField();
        this._jCommentLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this._jComment = new JTextArea();
        this.setMinimumSize(new Dimension(100, 100));
        this._jNameLabel.setDisplayedMnemonic('N');
        this._jNameLabel.setLabelFor(this._jName);
        this._jNameLabel.setText("Name:");
        this._jCommentLabel.setDisplayedMnemonic('C');
        this._jCommentLabel.setLabelFor(this._jComment);
        this._jCommentLabel.setText("Comment:");
        this._jComment.setColumns(20);
        this._jComment.setRows(3);
        this._jComment.setLineWrap(true);
        this.jScrollPane1.setViewportView(this._jComment);
        this._jComment.getAccessibleContext().setAccessibleDescription("Project comment");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._jCommentLabel).addComponent(this._jNameLabel, -1, 49, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 347, Short.MAX_VALUE).addComponent(this._jName, -1, 347, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jNameLabel).addComponent(this._jName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this._jCommentLabel).addContainerGap(60, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 74, Short.MAX_VALUE))));
        this._jName.getAccessibleContext().setAccessibleDescription("Project name");
    }

    @Override
    public void initUI() {
        this._jNameLabel.setVisible(!this.editMode);
        this._jName.setVisible(!this.editMode);
        this._jName.setText(this.state.getName());
        if (this.state.getComment() == null) {
            this._jComment.setText("");
        } else {
            this._jComment.setText(this.state.getComment());
        }
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jNameLabel, (Component)this._jName, (String)ProjectLrb.get("CREATE_PROJECT_NAME"));
        this._jNameLabel.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_NAME_ADA"));
        this._jNameLabel.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_NAME"));
        this._jName.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_NAME_ADA"));
        this._jName.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_NAME"));
        this._jName.setDocument(new TextFieldLimit(30));
        ResourceUtils.resLabel((JLabel)this._jCommentLabel, (Component)this._jComment, (String)ProjectLrb.get("CREATE_PROJECT_COMMENT"));
        this._jCommentLabel.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_COMMENT_ADA"));
        this._jCommentLabel.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_COMMENT"));
        this._jComment.getAccessibleContext().setAccessibleDescription(ProjectLrb.get("CREATE_PROJECT_COMMENT_ADA"));
        this._jComment.getAccessibleContext().setAccessibleName(ProjectLrb.get("CREATE_PROJECT_COMMENT"));
        this._jComment.setDocument(new TextFieldLimit(4000));
    }

    public void validateAndWriteToState() {
        boolean bl = false;
        try {
            String string = this.editMode ? ProjectLrb.get("EDIT_PROJECT_FAILURE_TITLE") : ProjectLrb.get("CREATE_PROJECT_FAILURE_TITLE");
            String string2 = this.editMode ? ProjectLrb.get("WIZARD_EDITING_PROJECT_TITLE") : ProjectLrb.get("WIZARD_CREATING_PROJECT_TITLE");
            String string3 = this.editMode ? ProjectLrb.get("WIZARD_EDITING_PROJECT_MESG") : ProjectLrb.get("WIZARD_CREATING_PROJECT_MESG");
            ValidateWriteThread validateWriteThread = new ValidateWriteThread();
            validateWriteThread.setTitle(string2);
            validateWriteThread.setMessage(string3);
            validateWriteThread.setCancelable(false);
            validateWriteThread.start(true);
            bl = validateWriteThread.getValidation();
            if (!bl) {
                throw new DataMinerException(string, ProjectLrb.get("ERR_PROJECT_VALIDATION"));
            }
            WorkflowProject workflowProject = validateWriteThread.getProjectObj();
            if (!this.editMode) {
                if (workflowProject == null) {
                    throw new DataMinerException(string, ProjectLrb.get("ERR_PROJECT_IS_NULL"));
                }
                BaseTreeNode baseTreeNode = (BaseTreeNode)this.context.getElement();
                TreeExplorer treeExplorer = ((NavigatorWindow)this.context.getView()).getTreeExplorer();
                TNode tNode = this.findConnectionFolder(treeExplorer, baseTreeNode, this.context);
                ProjectFolder projectFolder = this.createProjectNode(tNode, workflowProject);
                this.addProjectNode(this.context, tNode, projectFolder);
            }
        }
        catch (ProgressException progressException) {
            String string = this.editMode ? ProjectLrb.get("EDIT_PROJECT_FAILURE_MESG") : ProjectLrb.get("CREATE_PROJECT_FAILURE_MESG");
            throw new RuntimeException(string, progressException.getCause());
        }
    }

    private ProjectFolder createProjectNode(TNode tNode, WorkflowProject workflowProject) {
        ConnectionFolder connectionFolder = (ConnectionFolder)tNode.getData();
        ProjectFolder projectFolder = ConnectionFolderFilter.getProjectFolder(connectionFolder.getURL().getPath() + "/" + workflowProject.getName(), true);
        projectFolder.setRepositoryData(workflowProject);
        projectFolder.setId(workflowProject.getId());
        projectFolder.setParent(tNode);
        return projectFolder;
    }

    private TNode findConnectionFolder(TreeExplorer treeExplorer, BaseTreeNode baseTreeNode, Context context) {
        TNode tNode = null;
        TNode tNode2 = null;
        if (!(baseTreeNode instanceof ConnectionFolder)) {
            if (baseTreeNode instanceof ProjectFolder) {
                tNode = treeExplorer.searchTNode((Element)baseTreeNode, treeExplorer.getRoot(), context);
                tNode2 = tNode.getAncestorTNode(ConnectionFolder.class, false);
                assert (tNode2 != null) : "Did not find TNode for ConnectionFolder!";
            } else {
                tNode2 = baseTreeNode.getParent().getAncestorTNode(ConnectionFolder.class, false);
            }
        } else {
            tNode2 = treeExplorer.searchTNode((Element)baseTreeNode, baseTreeNode.getParent(), context);
        }
        BaseDeferredFilter.getChildTreeNodes(tNode2);
        return tNode2;
    }

    private void addProjectNode(Context context, TNode tNode, ProjectFolder projectFolder) {
        ConnectionFolder connectionFolder = (ConnectionFolder)tNode.getData();
        connectionFolder.add((Element)projectFolder, true);
        connectionFolder.markDirty(false);
        projectFolder.selectInTree(context);
    }

    private ProjectModel buildState() {
        ProjectModel projectModel = null;
        if (this.editMode) {
            Element[] elementArray = this.context.getSelection();
            BaseTreeNode baseTreeNode = (BaseTreeNode)elementArray[0];
            WorkflowProject workflowProject = (WorkflowProject)baseTreeNode.getRepositoryData();
            assert (workflowProject != null) : "Project repository object is null.";
            try {
                projectModel = new ProjectModel(this.context, workflowProject);
            }
            catch (Exception exception) {
                throw new RuntimeException(ProjectLrb.get("ERR_PROJECT_MODEL_CREATE"), exception);
            }
        } else {
            projectModel = new ProjectModel(this.context);
        }
        return projectModel;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                ProjectPanel.this.validateAndWriteToState();
            }

            @Override
            public String getTitle() {
                return ProjectPanel.this.editMode ? ProjectLrb.get("EDIT_PROJECT_DIALOG_TITLE") : ProjectLrb.get("CREATE_PROJECT_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return ProjectPanel.this.editMode ? "project_properties" : "project_create";
            }

            @Override
            public JComponent getContent() {
                return ProjectPanel.this;
            }

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                DialogHeader dialogHeader = new DialogHeader();
                dialogHeader.setHeaderImage(DataMinerIcons.get(Icons.CREATE_WORKFLOW_DIALOG).getImage());
                dialogHeader.setHeaderDescription(this.getHeaderDescription());
                jEWTDialog.setDialogHeader((Component)dialogHeader);
            }

            private String getHeaderDescription() {
                return ProjectPanel.this.editMode ? ProjectLrb.get("EDIT_PROJECT_DESCRIPTION") : ProjectLrb.get("CREATE_PROJECT_DESCRIPTION");
            }
        };
    }

    private class ValidateWriteThread
    extends ProgressRunnable {
        private boolean validated = true;
        private WorkflowProject _projectObj = null;
        private String projectName;
        private String projectComment;

        private ValidateWriteThread() {
        }

        public boolean getValidation() {
            return this.validated;
        }

        public WorkflowProject getProjectObj() {
            return this._projectObj;
        }

        protected Object doWork() throws Exception {
            boolean bl = false;
            boolean bl2 = false;
            this.projectName = ProjectPanel.this._jName.getText();
            this.projectName = this.projectName.trim();
            this.projectComment = ProjectPanel.this._jComment.getText().trim();
            if (ProjectPanel.this.editMode) {
                bl = true;
                if (ProjectPanel.this.state.getComment().equals(this.projectComment)) {
                    bl2 = true;
                }
            }
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(ProjectPanel.this.context);
            if (!bl && !ProjectModel.validateProjectName(connectionFolder, this.projectName)) {
                this.validated = false;
            }
            if (!this.validated) {
                return this.validated;
            }
            if (!bl2 && !ProjectModel.validateProjectComment(connectionFolder, this.projectComment)) {
                this.validated = false;
            }
            if (this.validated) {
                ProjectPanel.this.state.setName(this.getProjectName());
                ProjectPanel.this.state.setComment(this.projectComment);
                this._projectObj = ProjectPanel.this.state.finish();
            }
            return this.validated;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

