/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;

public class UIResourceHelper {
    private static final Logger theLogger = Logger.getLogger(UIResourceHelper.class.getName());

    private UIResourceHelper() {
    }

    public static void setComponentText(Map<String, JComponent> map) {
        for (Map.Entry<String, JComponent> entry : map.entrySet()) {
            String string = entry.getKey();
            JComponent jComponent = entry.getValue();
            String string2 = StringUtils.stripMnemonic((String)string);
            int n = StringUtils.getMnemonicKeyCode((String)string);
            if (jComponent instanceof JLabel) {
                ((JLabel)jComponent).setText(string2);
                if (n != 0) {
                    ((JLabel)jComponent).setDisplayedMnemonic(n);
                }
            } else if (jComponent instanceof JCheckBox) {
                ((JCheckBox)jComponent).setText(string2);
                if (n != 0) {
                    ((JCheckBox)jComponent).setMnemonic(n);
                }
            } else if (jComponent instanceof JButton) {
                ((JButton)jComponent).setText(string2);
                if (n != 0) {
                    ((JButton)jComponent).setMnemonic(n);
                }
            } else if (jComponent instanceof JRadioButton) {
                ((JRadioButton)jComponent).setText(string2);
                if (n != 0) {
                    ((JRadioButton)jComponent).setMnemonic(n);
                }
            } else {
                throw new RuntimeException("Unknown component type.  Please add a new type handler as needed.");
            }
            jComponent.getAccessibleContext().setAccessibleName(string2);
        }
    }

    public static String getAbsoluteResourcePath(Class clazz, String string) {
        Object object = clazz.getPackage().getName();
        object = "/" + ((String)object).replace('.', '/') + "/" + string;
        theLogger.log(Level.FINEST, (String)object);
        return object;
    }

    public static ImageIcon getImageIcon(Class clazz, String string) {
        return new ImageIcon(clazz.getResource(string));
    }

    public static String trucateUIStringMiddle(String string, int n) {
        if (string.length() < n) {
            return string;
        }
        int n2 = (n - 3) / 2;
        int n3 = n - 3 - n2;
        int n4 = string.length() - 1 - n3;
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n4, string.length());
        return string2 + "..." + string3;
    }

    public static String trucateUIStringEnd(String string, int n) {
        if (string.length() < n) {
            return string;
        }
        String string2 = string.substring(0, n - 3);
        return string2 + "...";
    }
}

