/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.OutputRedirector;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.core.dal.sql.ReusableConnection;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.net.DMURLFormatHelper;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.runner.RunManager;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.ConfigurationLogDialog;
import oracle.dmt.dataminer.utils.InstallJSONSchemaGen;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.utils.UtilsLrb;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.model.NodeFactory;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

class ConfigurationWorkerPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(ConfigurationWorkerPanel.class.getName());
    private static String scriptsPath = System.getProperty("oracle.home") + "/dataminer/scripts/";
    private ConfigUtils.RunMode runMode;
    private ConfigExecutorTask currentTask;
    private Connection connection;
    private String connectionName;
    private String reposSchema = "ODMRSYS";
    private String sysAccountName;
    private boolean installDemoData;
    private BasicDocument logDoc;
    private BasicEditorPane editor;
    private String logFileName;
    private BufferedOutputStream bos;
    private boolean logFileInitialized = false;
    private JDialog dialog = null;
    private Boolean _result = true;
    private boolean _done = false;
    private boolean _canceled = false;
    private boolean _isCanceling = false;
    private boolean _isRunning = false;
    private List<ScriptItem> _scriptList;
    private int _currentScriptIndex;
    private String defaultTablespace;
    private String defaultTempTablespace;
    private boolean migrateWorkflowORToBinary = false;
    private String migrationASMTableSpace = null;
    private Context context;
    public final String LOAD_JAVA = "LoadJava";
    public static final String DEPLOY_JSON_PARSER = "DeployJSONParser";
    public static final String UNDEPLOY_JSON_PARSER = "UndeployJSONParser";
    public static final String GRANT_JSON_PARSER = "GrantJSONParser";
    public static final String UPGRADE_JSON_PARSER = "UpgradeJSONParser";
    private JButton actionButton;
    private JButton closeButton;
    private JLabel detailedStatusLabel;
    private JCheckBox installDataChk;
    private JProgressBar progressBar;
    private JLabel statusLabel;

    public ConfigurationWorkerPanel(JDialog jDialog, Connection connection, String string, ConfigUtils.RunMode runMode, String string2, String string3, boolean bl, String string4, String string5, Context context) {
        this.dialog = jDialog;
        this.connection = connection;
        this.connectionName = string;
        this.runMode = runMode;
        this.defaultTablespace = string2;
        this.defaultTempTablespace = string3;
        this.sysAccountName = string5;
        this.installDemoData = true;
        this.migrateWorkflowORToBinary = bl;
        this.migrationASMTableSpace = string4;
        this.context = context;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }

    public boolean isDone() {
        return this._done;
    }

    private boolean getFinalResult() {
        return this._result;
    }

    private void setIsRunning() {
        this._isRunning = true;
        this.actionButton.setText(UtilsLrb.get("CANCEL"));
        this.actionButton.setVisible(false);
        this.statusLabel.setText(UtilsLrb.get("CONFIG_REPOS"));
        this.closeButton.setEnabled(false);
    }

    private boolean isRunning() {
        return this._isRunning;
    }

    private boolean isCanceling() {
        return this._isCanceling;
    }

    public void cancel() {
        if (this.isCanceling()) {
            MessageDialog.information((Component)this, (Object)UtilsLrb.get("CANCELING_MSG"), (String)UtilsLrb.get("CANCELING_TITLE"), null);
            return;
        }
        if (!MessageDialog.confirm((Component)this, (Object)UtilsLrb.get("CANCEL_CONFIRM"), (String)UtilsLrb.get("CANCEL_CONFIRM_TITLE"), null)) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        this._isCanceling = true;
        if (this.currentTask != null) {
            this.currentTask.requestCancel();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigurationWorkerPanel.this.statusLabel.setText("");
                ConfigurationWorkerPanel.this.detailedStatusLabel.setText(UtilsLrb.get("CANCELING_TASK"));
            }
        });
    }

    private boolean isCanceled() {
        return this._canceled;
    }

    private void setFinalResult(final boolean bl) {
        this._result = bl;
        this._done = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigurationWorkerPanel.this.closeButton.setEnabled(true);
                ConfigurationWorkerPanel.this.progressBar.setVisible(false);
                ConfigurationWorkerPanel.this.installDataChk.setVisible(false);
                ConfigurationWorkerPanel.this.actionButton.setText(UtilsLrb.get("SHOW_LOG"));
                ConfigurationWorkerPanel.this.actionButton.setVisible(true);
                ConfigurationWorkerPanel.this.detailedStatusLabel.setText("");
                if (!bl) {
                    ConfigurationWorkerPanel.this.statusLabel.setText(UtilsLrb.get("CONFIG_FAILED"));
                    ConfigurationWorkerPanel.this.statusLabel.setIcon(OracleIcons.getIcon((String)"error.png"));
                } else {
                    ConfigurationWorkerPanel.this.statusLabel.setText(UtilsLrb.get("CONFIG_SUCCESS"));
                }
            }
        });
        if (!bl) {
            if (this.runMode != ConfigUtils.RunMode.INSTALLSCHEMA_OR && this.runMode != ConfigUtils.RunMode.INSTALLSCHEMA_BINARY && this.runMode != ConfigUtils.RunMode.DROP_REPOS && this.runMode != ConfigUtils.RunMode.UPGRADE_REPOS_OR && this.runMode == ConfigUtils.RunMode.UPGRADE_REPOS_BINARY) {
                // empty if block
            }
        } else {
            try {
                AddinManager addinManager = AddinManager.getAddinManager();
                RunManager runManager = (RunManager)addinManager.getAddin(RunManager.class);
                runManager.forceActive(this.connectionName);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        ConfigUtils.setDBRestricted(this.connection, false);
        try {
            this.bos.flush();
            this.bos.close();
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
    }

    private void setIsCanceled() {
        this._canceled = true;
        this._done = true;
        this._result = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigurationWorkerPanel.this.closeButton.setVisible(true);
                ConfigurationWorkerPanel.this.closeButton.setEnabled(true);
                ConfigurationWorkerPanel.this.progressBar.setVisible(false);
                ConfigurationWorkerPanel.this.statusLabel.setText("");
                ConfigurationWorkerPanel.this.detailedStatusLabel.setText(UtilsLrb.get("CONFIG_CANCELED"));
                ConfigurationWorkerPanel.this.actionButton.setText(UtilsLrb.get("SHOW_LOG"));
                ConfigurationWorkerPanel.this.actionButton.setVisible(true);
            }
        });
        try {
            this.bos.flush();
            this.bos.close();
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.actionButton = new JButton();
        this.statusLabel = new JLabel();
        this.detailedStatusLabel = new JLabel();
        this.closeButton = new JButton();
        this.installDataChk = new JCheckBox();
        this.setMinimumSize(new Dimension(498, 127));
        this.actionButton.setText("Start");
        this.statusLabel.setText("Configuring Repository");
        this.detailedStatusLabel.setText("Detail Status");
        this.closeButton.setText("Close");
        this.installDataChk.setText("Install Demo Data");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -1, 478, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.statusLabel, -1, 367, Short.MAX_VALUE).addGap(111, 111, 111)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.detailedStatusLabel, -1, 415, Short.MAX_VALUE).addComponent(this.installDataChk)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.actionButton, GroupLayout.Alignment.TRAILING).addComponent(this.closeButton, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.actionButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.closeButton)).addGroup(groupLayout.createSequentialGroup().addComponent(this.detailedStatusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.installDataChk).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
    }

    private void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(UtilsLrb.get("LOG_CLOSE"), this.closeButton);
        hashMap.put(UtilsLrb.get("INSTALL_START"), this.actionButton);
        hashMap.put(UtilsLrb.get("INSTALL_STATUS"), this.statusLabel);
        hashMap.put(UtilsLrb.get("INSTALL_DETAIL_STATUS"), this.detailedStatusLabel);
        hashMap.put(UtilsLrb.get("INSTALL_SAMPLE_DATA"), this.installDataChk);
        UIResourceHelper.setComponentText(hashMap);
        this.initHelp();
    }

    private void initHelp() {
        HelpUtils.setHelpID((JComponent)this, (String)"configurationLog");
    }

    private void initUI() {
        this.installDataChk.setSelected(this.installDemoData);
        if (this.runMode != ConfigUtils.RunMode.INSTALLSCHEMA_OR && this.runMode != ConfigUtils.RunMode.INSTALLSCHEMA_BINARY && this.runMode != ConfigUtils.RunMode.GRANTS) {
            this.installDataChk.setVisible(false);
            this.installDemoData = false;
        } else if (!this.isDemoScriptsPresent().booleanValue()) {
            this.installDemoData = false;
            this.installDataChk.setVisible(false);
        } else {
            this.installDataChk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    ConfigurationWorkerPanel.this.installDemoData = jCheckBox.isSelected();
                }
            });
        }
        this.actionButton.setText(UtilsLrb.get("START"));
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConfigurationWorkerPanel.this.isDone()) {
                    new ConfigurationLogDialog(ConfigurationWorkerPanel.this, ConfigurationWorkerPanel.this.editor, ConfigurationWorkerPanel.this.logFileName);
                } else if (ConfigurationWorkerPanel.this.isRunning()) {
                    ConfigurationWorkerPanel.this.cancel();
                } else {
                    if ((ConfigurationWorkerPanel.this.runMode == ConfigUtils.RunMode.INSTALLSCHEMA_OR || ConfigurationWorkerPanel.this.runMode == ConfigUtils.RunMode.INSTALLSCHEMA_BINARY) && ConfigUtils.dbHasSchema(ConfigurationWorkerPanel.this.connection, "ODMRSYS") && !ConfigurationWorkerPanel.this.displayODMRSYSWillBeDropped()) {
                        return;
                    }
                    ConfigurationWorkerPanel.this.startConfiguration();
                }
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationWorkerPanel.this.dialog.setVisible(false);
            }
        });
        this.statusLabel.setText(UtilsLrb.get("PRESS_START"));
        this.detailedStatusLabel.setText("");
        this.logDoc = new BasicDocument();
        this.editor = new BasicEditorPane();
        this.editor.setDocument((Document)this.logDoc);
    }

    private void initScripts() {
        this.installDataChk.setEnabled(false);
        this._scriptList = new ArrayList<ScriptItem>();
        this._currentScriptIndex = 0;
        Version version = null;
        try {
            version = ((ReusableConnection)this.connection).getDatabaseVersion();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean bl = DbVersionHelper.isDB12102Up(version);
        boolean bl2 = DbVersionHelper.isDB122Up((Version)version);
        boolean bl3 = ConfigUtils.isJVMInstalled(this.connection);
        if (this.runMode == ConfigUtils.RunMode.INSTALLSCHEMA_OR || this.runMode == ConfigUtils.RunMode.INSTALLSCHEMA_BINARY) {
            if (ConfigUtils.dbHasSchema(this.connection, "ODMRSYS")) {
                this._scriptList.add(new ScriptItem(scriptsPath + "disconnectODMRSessions.sql", this.sysAccountName, UtilsLrb.get("DISCONNECT_ODMRUSER"), new String[]{"DR", "T"}));
                this._scriptList.add(new ScriptItem(scriptsPath + "usergrantshelper.sql", this.sysAccountName, UtilsLrb.get("REVOKE_ODMRUSER_ROLE"), new String[]{"REVOKE", "ODMRUSER"}));
                this._scriptList.add(new ScriptItem(scriptsPath + "disconnectODMRSessions.sql", this.sysAccountName, UtilsLrb.get("DISCONNECT_ODMRUSER"), new String[]{"DR", "T"}));
                this._scriptList.add(new ScriptItem(scriptsPath + "dropPublicSynonyms.sql", this.sysAccountName, UtilsLrb.get("DROPSYNONYMS"), new String[0]));
                this._scriptList.add(new ScriptItem(scriptsPath + "dropSchema.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[0]));
                this._scriptList.add(new ScriptItem(scriptsPath + "dropRepository.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[0]));
            } else {
                this._scriptList.add(new ScriptItem(scriptsPath + "dropPublicSynonyms.sql", this.sysAccountName, UtilsLrb.get("DROPSYNONYMS"), new String[0]));
                this._scriptList.add(new ScriptItem(scriptsPath + "dropRole.sql", this.sysAccountName, UtilsLrb.get("DROPROLE"), new String[0]));
            }
            this._scriptList.add(new ScriptItem(scriptsPath + "checkEnvironment.sql", this.sysAccountName, UtilsLrb.get("CHECK_ENVIROMENT"), new String[]{this.defaultTablespace}));
            this._scriptList.add(new ScriptItem(scriptsPath + "instodmrsys.sql", this.sysAccountName, UtilsLrb.get("INSTALLODMRSYS"), new String[]{this.defaultTablespace, this.defaultTempTablespace}));
            this._scriptList.add(new ScriptItem(scriptsPath + "instschema_g.sql", this.reposSchema, UtilsLrb.get("INSTALLSCHEMA"), new String[0]));
            if (bl3 && bl && !bl2) {
                this._scriptList.add(new ScriptItem("", this.reposSchema, UtilsLrb.get("INSTALLING_JAVA_OBJECTS"), new String[]{"LoadJava", DEPLOY_JSON_PARSER}));
            }
            this._scriptList.add(new ScriptItem(scriptsPath + "instobjects.sql", this.reposSchema, UtilsLrb.get("INSTALLOBJECTS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "displayVersion.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[]{""}));
            this._scriptList.add(new ScriptItem(scriptsPath + "inststopwords.sql", this.reposSchema, UtilsLrb.get("INSTALLSTOPWORDS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instmessages.sql", this.reposSchema, UtilsLrb.get("INSTALLMESSAGES"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instpackages.sql", this.reposSchema, UtilsLrb.get("INSTALLPACKAGES"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instsynonyms.sql", this.reposSchema, UtilsLrb.get("INSTALLSYNONYMS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instscheduler.sql", this.reposSchema, UtilsLrb.get("INSTALLSCHEDULER"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instgrants.sql", this.reposSchema, UtilsLrb.get("INSTALLGRANTS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "validateODMRSYS.sql", this.sysAccountName, UtilsLrb.get("VALIDATE_SCHEMA"), new String[]{"ALL"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "updateRepositoryProperty.sql", this.sysAccountName, UtilsLrb.get("REPOSITORY_LOADED"), new String[]{"REPOSITORY_STATUS", "LOADED"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "usergrants.sql", this.sysAccountName, UtilsLrb.get("INSTALLUSERGRANTS"), new String[]{this.getContextUser(this.connectionName)}));
            if (this.isInstallDemoData()) {
                if (ConfigUtils.dbHasSchema(this.connection, "SH")) {
                    if (!ConfigUtils.checkSHTableExistance(this.connection)) {
                        this.displaySHTableMissing();
                    }
                    this._scriptList.add(new ScriptItem(scriptsPath + "dmshgrants.sql", this.sysAccountName, UtilsLrb.get("INSTALLDEMOGRANTS"), new String[]{this.getContextUser(this.connectionName)}));
                    this._scriptList.add(new ScriptItem(scriptsPath + "dropSHDemoData.sql", this.getContextUser(this.connectionName), UtilsLrb.get("INSTALLDEMO"), new String[]{this.getContextUser(this.connectionName)}));
                    this._scriptList.add(new ScriptItem(scriptsPath + "dmsh.sql", this.getContextUser(this.connectionName), UtilsLrb.get("INSTALLDEMO"), new String[]{this.getContextUser(this.connectionName)}));
                } else if (!this.confirmSHMissing()) {
                    this.cancel();
                }
                this._scriptList.add(new ScriptItem(scriptsPath + "instDemoData.sql", this.getContextUser(this.connectionName), UtilsLrb.get("INSTALLDEMO"), new String[]{this.getContextUser(this.connectionName)}));
            }
        } else if (this.runMode == ConfigUtils.RunMode.GRANTS) {
            this._scriptList.add(new ScriptItem(scriptsPath + "displayVersion.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[]{""}));
            this._scriptList.add(new ScriptItem(scriptsPath + "usergrants.sql", this.sysAccountName, UtilsLrb.get("INSTALLUSERGRANTS"), new String[]{this.getContextUser(this.connectionName)}));
            if (this.isInstallDemoData()) {
                if (ConfigUtils.dbHasSchema(this.connection, "SH")) {
                    if (!ConfigUtils.checkSHTableExistance(this.connection)) {
                        this.displaySHTableMissing();
                    }
                    this._scriptList.add(new ScriptItem(scriptsPath + "dmshgrants.sql", this.sysAccountName, UtilsLrb.get("INSTALLDEMOGRANTS"), new String[]{this.getContextUser(this.connectionName)}));
                    this._scriptList.add(new ScriptItem(scriptsPath + "dropSHDemoData.sql", this.getContextUser(this.connectionName), UtilsLrb.get("INSTALLDEMO"), new String[]{this.getContextUser(this.connectionName)}));
                    this._scriptList.add(new ScriptItem(scriptsPath + "dmsh.sql", this.getContextUser(this.connectionName), UtilsLrb.get("INSTALLDEMO"), new String[]{this.getContextUser(this.connectionName)}));
                } else if (!this.confirmSHMissing()) {
                    this.cancel();
                }
                this._scriptList.add(new ScriptItem(scriptsPath + "instDemoData.sql", this.getContextUser(this.connectionName), UtilsLrb.get("INSTALLDEMO"), new String[]{this.getContextUser(this.connectionName)}));
            }
        } else if (this.runMode == ConfigUtils.RunMode.UPGRADE_REPOS_OR || this.runMode == ConfigUtils.RunMode.UPGRADE_REPOS_BINARY) {
            this._scriptList.add(new ScriptItem(scriptsPath + "insureWorkflowsInactive.sql", this.sysAccountName, UtilsLrb.get("ARE_WORKFLOWS_ACTIVE"), new String[0]));
            if (this.runMode == ConfigUtils.RunMode.UPGRADE_REPOS_BINARY && this.migrationASMTableSpace != null && this.migrateWorkflowORToBinary) {
                this._scriptList.add(new ScriptItem(scriptsPath + "isBinaryXMLMigrationAllowed.sql", this.sysAccountName, UtilsLrb.get("IS_BINARY_XML_SUPPORTED"), new String[]{this.migrationASMTableSpace}));
            }
            this._scriptList.add(new ScriptItem(scriptsPath + "disconnectODMRSessions.sql", this.sysAccountName, UtilsLrb.get("DISCONNECT_ODMRUSER"), new String[]{"DR", "T"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "createusersgrantbackup.sql", this.sysAccountName, UtilsLrb.get("BACKUP_USER_GRANTS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "usergrantshelper.sql", this.sysAccountName, UtilsLrb.get("REVOKE_ODMRUSER_ROLE"), new String[]{"REVOKE", "ODMRUSER"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "disconnectODMRSessions.sql", this.sysAccountName, UtilsLrb.get("DISCONNECT_ODMRUSER"), new String[]{"DR", "T"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "updateRepositoryProperty.sql", this.sysAccountName, UtilsLrb.get("UPDATE_REPOSITORY_STATUS"), new String[]{"REPOSITORY_STATUS", "NOT_LOADED"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "createxmlworkflowsbackup.sql", this.reposSchema, UtilsLrb.get("BACKUPWORKFLOWS"), new String[0]));
            if (this.runMode == ConfigUtils.RunMode.UPGRADE_REPOS_BINARY && this.migrateWorkflowORToBinary) {
                if (this.migrationASMTableSpace != null) {
                    this._scriptList.add(new ScriptItem(scriptsPath + "upgradeTablespaceForBinary.sql", this.sysAccountName, UtilsLrb.get("CONVERT_WORKFLOWS_TO_BINARY"), new String[]{this.migrationASMTableSpace}));
                } else {
                    this._scriptList.add(new ScriptItem(scriptsPath + "upgradeSchemaFromORToBinary.sql", this.sysAccountName, UtilsLrb.get("CONVERT_WORKFLOWS_TO_BINARY"), new String[0]));
                }
            } else if (this.runMode == ConfigUtils.RunMode.UPGRADE_REPOS_OR) {
                this._scriptList.add(new ScriptItem(scriptsPath + "upgradeORSchema.sql", this.sysAccountName, UtilsLrb.get("MIGRATING_WORKFLOW_SCHEMA"), new String[0]));
            }
            if (bl3 && bl && !bl2) {
                this._scriptList.add(new ScriptItem("", this.reposSchema, UtilsLrb.get("MIGRATING_JAVA_OBJECTS"), new String[]{"LoadJava", UPGRADE_JSON_PARSER}));
            }
            this._scriptList.add(new ScriptItem(scriptsPath + "upgradexmlschema.sql", this.sysAccountName, UtilsLrb.get("MIGRATING_WORKFLOW_SCHEMA"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "upgradeRepository.sql", this.reposSchema, UtilsLrb.get("MIGRATING_REPOSITORY_TABLES"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "inststopwords.sql", this.reposSchema, UtilsLrb.get("INSTALLSTOPWORDS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instmessages.sql", this.reposSchema, UtilsLrb.get("INSTALLMESSAGES"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instpackages.sql", this.reposSchema, UtilsLrb.get("INSTALLPACKAGES"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "instgrants.sql", this.reposSchema, UtilsLrb.get("INSTALLGRANTS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "validateODMRSYS.sql", this.sysAccountName, UtilsLrb.get("VALIDATE_SCHEMA"), new String[]{"ALL"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "validateVersionUpgrade.sql", this.reposSchema, UtilsLrb.get("VALIDATE_SCHEMA"), new String[]{ConfigUtils.getCurrentRepositoryVersion(), ConfigUtils.getCurrentXMLSchemaInClient()}));
            this._scriptList.add(new ScriptItem(scriptsPath + "updateRepositoryProperty.sql", this.sysAccountName, UtilsLrb.get("REPOSITORY_LOADED"), new String[]{"REPOSITORY_STATUS", "LOADED"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "usergrantshelper.sql", this.sysAccountName, UtilsLrb.get("GRANT_ODMRUSER_ROLE"), new String[]{"GRANT", "USE_BACKUP_TABLE"}));
        } else if (this.runMode == ConfigUtils.RunMode.DROP_REPOS) {
            this._scriptList.add(new ScriptItem(scriptsPath + "displayVersion.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "disconnectODMRSessions.sql", this.sysAccountName, UtilsLrb.get("DISCONNECT_ODMRUSER"), new String[]{"DR", "T"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "alterscheduledworkflows.sql", this.sysAccountName, UtilsLrb.get("DISABLE_SCHEDULED_WORKFLOWS"), new String[]{"D"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "usergrantshelper.sql", this.sysAccountName, UtilsLrb.get("REVOKE_ODMRUSER_ROLE"), new String[]{"REVOKE", "ODMRUSER"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "disconnectODMRSessions.sql", this.sysAccountName, UtilsLrb.get("DISCONNECT_ODMRUSER"), new String[]{"DR", "T"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "dropUserTablesViews.sql", this.sysAccountName, UtilsLrb.get("DROPUSERTABLES"), new String[]{"DR"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "dropSchedulerObjects.sql", this.sysAccountName, UtilsLrb.get("DROPCHAINS"), new String[]{"DR"}));
            this._scriptList.add(new ScriptItem(scriptsPath + "dropPublicSynonyms.sql", this.sysAccountName, UtilsLrb.get("DROPSYNONYMS"), new String[0]));
            if (bl3 && bl) {
                this._scriptList.add(new ScriptItem("", this.reposSchema, UtilsLrb.get("DROPPING_JAVA_OBJECTS"), new String[]{"LoadJava", UNDEPLOY_JSON_PARSER}));
            }
            this._scriptList.add(new ScriptItem(scriptsPath + "dropSchema.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "dropRepository.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[0]));
            this._scriptList.add(new ScriptItem(scriptsPath + "dbHasSchema.sql", this.sysAccountName, UtilsLrb.get("DROPODMRSYS"), new String[0]));
        }
    }

    private Boolean isDemoScriptsPresent() {
        File file = new File(scriptsPath + "instDemoData.sql");
        return file.exists();
    }

    private String getContextUser(String string) {
        String string2 = null;
        try {
            String string3;
            Properties properties = DatabaseConnections.getInstance().getProperties(string);
            Boolean bl = Boolean.valueOf(properties.getProperty("IS_PROXY"));
            string2 = bl != false ? properties.getProperty("PROXY_USER_NAME") : properties.getProperty("user");
            if (StringUtils.getTargetUserFromProxyTNSUser(string2).length() > 0 && (string3 = StringUtils.getTargetUserFromProxyTNSUser(string2)).length() > 0) {
                string2 = string3;
            }
            String string4 = string2 = StringUtils.isDoubleQuotedString(string2) ? StringUtils.trimDoubleQuotes(string2) : string2.toUpperCase();
            if (string2.indexOf(" ") > 0) {
                string2 = StringUtils.addDoubleQuotes(string2);
            }
        }
        catch (ConnectionException connectionException) {
            throw new RuntimeException(connectionException);
        }
        return string2;
    }

    private int getCurrentScriptIndex() {
        return this._currentScriptIndex;
    }

    private ScriptItem getCurrentScript() {
        return this._scriptList.get(this._currentScriptIndex);
    }

    private boolean haveNextScript() {
        return this._currentScriptIndex + 1 < this._scriptList.size();
    }

    private boolean runNextScript() throws CustomInstallStepException {
        ScriptItem scriptItem = null;
        if (!this.haveNextScript()) {
            this._currentScriptIndex = -1;
            return false;
        }
        scriptItem = this._scriptList.get(++this._currentScriptIndex);
        String[] stringArray = scriptItem.getArgs();
        if (stringArray.length > 0 && stringArray[0].equals("LoadJava")) {
            this.runLoadJava(scriptItem);
            return this.runNextScript();
        }
        return this.runScript(scriptItem);
    }

    private void startConfiguration() {
        try {
            this.logFileName = this.createLogFile();
            this.bos = new BufferedOutputStream(new FileOutputStream(this.logFileName, true));
            this.logFileInitialized = true;
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, iOException.getMessage(), iOException);
            this.logFileName = null;
            this.logFileInitialized = false;
        }
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(1000000);
        this.initScripts();
        if (!this.runScript(this.getCurrentScript())) {
            this.setFinalResult(false);
        }
    }

    private String createLogFile() throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy-MM-dd.HHmm");
        Calendar calendar = Calendar.getInstance();
        String string = Ide.getUserSettingsDirectory();
        String string2 = "dataminer_" + simpleDateFormat.format(calendar.getTime()) + ".log";
        File file = new File(this.getLogFilePath(string, string2));
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            string = Ide.getTrueUserHomeDirectory();
            file = new File(this.getLogFilePath(string, string2));
            file.createNewFile();
        }
        return this.getLogFilePath(string, string2);
    }

    private String getLogFilePath(String string, String string2) {
        String string3 = string.endsWith(System.getProperty("file.separator")) ? string + string2 : string + System.getProperty("file.separator") + string2;
        return string3;
    }

    private boolean runLoadJava(ScriptItem scriptItem) {
        assert (scriptItem.getArgs().length == 2);
        final String string = scriptItem.getDescription();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConfigurationWorkerPanel.this.detailedStatusLabel.setText(string);
            }
        });
        theLogger.log(Level.FINER, "--- " + this.getTimeStamp() + " Running LoadJava");
        ConfigUtils.writeToInstallLog(this.bos, UtilsLrb.get("LOAD_JAVA_STARTING") + scriptItem.getDescription());
        boolean bl = false;
        String string2 = scriptItem.getArgs()[1];
        bl = this.runJSONParser(string2, this.bos);
        ConfigUtils.writeToInstallLog(this.bos, UtilsLrb.get("LOAD_JAVA_FINISHED") + UtilsLrb.get("LOAD_JAVA_RESULT") + bl);
        theLogger.log(Level.FINER, "--- " + this.getTimeStamp() + (bl ? " Completed LoadJava - success" : " Failed LoadJava!"));
        return bl;
    }

    private boolean runJSONParser(String string, BufferedOutputStream bufferedOutputStream) {
        InstallJSONSchemaGen installJSONSchemaGen = new InstallJSONSchemaGen(this.connection, this.context, bufferedOutputStream);
        return installJSONSchemaGen.doWork(string);
    }

    private boolean runScript(ScriptItem scriptItem) {
        boolean bl = false;
        try {
            ConfigExecutorTask configExecutorTask;
            this.currentTask = configExecutorTask = new ConfigExecutorTask(scriptItem, "ODMR Repository Task", IRaptorTaskRunMode.NO_GUI, false, true);
            RaptorTaskManager.getInstance().addTask((RaptorTask)configExecutorTask);
            this.setIsRunning();
            MessagePage messagePage = (MessagePage)LogManager.getLogManager().getMsgPage();
            if (messagePage == null) {
                messagePage = new MessagePage();
                LogManager.getLogManager().addPage((LogPage)messagePage);
            }
            bl = true;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
        }
        return bl;
    }

    private boolean confirmSHMissing() {
        return MessageDialog.confirm((Component)this, (Object)UtilsLrb.get("SH_MISSING_MESSAGE"), (String)UtilsLrb.get("INSTALLDEMO"), null);
    }

    private void displaySHTableMissing() {
        MessageDialog.optionalInformation((String)(this.getClass().getName() + "displaySHTableMissing"), (Component)this, (Object)UtilsLrb.get("SH_TABLES_MISSING_MESSAGE"), (String)UtilsLrb.get("SH_TABLES_MISSING_TITLE"), null);
    }

    private boolean displayODMRSYSWillBeDropped() {
        return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtilsLrb.get("ODMRSYS_TO_BE_DROPPED_CONFIRM"), (String)UtilsLrb.get("WIZARD_TITLE"), null, (boolean)true);
    }

    private void alterSessionCurrentSchema(String string) throws Exception {
        if (this.connection == null) {
            return;
        }
        if (StringUtils.isDoubleQuotedString(string)) {
            string = StringUtils.trimDoubleQuotes(string);
        }
        SQLHelper sQLHelper = new SQLHelper();
        sQLHelper.pstmt = this.connection.prepareStatement("alter session set current_schema = \"" + string + "\"");
        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
        sQLHelper.close();
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    public boolean isInstallDemoData() {
        return this.installDemoData;
    }

    String getTimeStamp() {
        return SimpleDateFormat.getTimeInstance(2).format(Calendar.getInstance().getTime());
    }

    class ConfigExecutorTask
    extends ScriptExecutorTask {
        private ScriptItem scriptItem;
        private OutputRedirector outRedirector;

        public ConfigExecutorTask(ScriptItem scriptItem, String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
            super(string, iRaptorTaskRunMode, bl, bl2);
            this.scriptItem = scriptItem;
        }

        @Override
        protected Void doWork() {
            return super.doWork();
        }

        @Override
        protected void startup() throws ExecutionException {
            try {
                Object object;
                Closeable closeable;
                Object object2;
                if (!ConfigurationWorkerPanel.this.logFileInitialized) {
                    object2 = new PipedInputStream();
                    closeable = new PipedOutputStream((PipedInputStream)object2);
                    ConfigurationWorkerPanel.this.bos = new BufferedOutputStream((OutputStream)closeable);
                    this.outRedirector = new OutputRedirector((PipedInputStream)object2, (Document)ConfigurationWorkerPanel.this.logDoc, ConfigurationWorkerPanel.this.editor, null);
                    this.outRedirector.start();
                }
                object2 = this.scriptItem.getPath();
                closeable = new FileInputStream(new File((String)object2));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable, "UTF-8");
                String string = ((String)object2).substring(0, ((String)object2).lastIndexOf("/"));
                ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                scriptRunnerContext.setEcho(true);
                scriptRunnerContext.setVerify(false);
                scriptRunnerContext.setEncoding("UTF-8");
                ScriptRunnerContext.setOutputEncoding((String)"UTF-8");
                scriptRunnerContext.setIsRunScript(true);
                scriptRunnerContext.putProperty("script.runner.using.systemout", (Object)Boolean.TRUE);
                scriptRunnerContext.node = NodeFactory.findOrCreate(ConnectionFolder.class, (URL)DMURLFormatHelper.getURL(ConfigurationWorkerPanel.this.connectionName));
                String[] stringArray = this.scriptItem.getArgs();
                if (stringArray.length != 0) {
                    object = scriptRunnerContext.getMap();
                    for (int i = 0; i < stringArray.length; ++i) {
                        object.put(Integer.toString(i + 1), stringArray[i]);
                    }
                }
                this.setStmt(inputStreamReader);
                this.setDirectory(string);
                this.setOut(ConfigurationWorkerPanel.this.bos);
                this.setScriptRunnerContext(scriptRunnerContext);
                this.setConnection(ConfigurationWorkerPanel.this.connection);
                this.setCancellable(true);
                this.setPausable(false);
                object = new SchemaTaskListener("ODMR Repository Task", this.getConnection(), false);
                this.getDescriptor().addListener((IRaptorTaskListener)object);
                String string2 = this.getCurrentSchema();
                if (!string2.equals(this.scriptItem.getRunAs())) {
                    ConfigurationWorkerPanel.this.alterSessionCurrentSchema(this.scriptItem.getRunAs());
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)CommonLrb.get("MSG_EXCEPTION"));
            }
            super.startup();
            theLogger.log(Level.FINER, "--- Starting script: " + this.scriptItem.getPath());
        }

        private String getCurrentSchema() throws Exception {
            if (ConfigurationWorkerPanel.this.connection == null) {
                return null;
            }
            String string = null;
            SQLHelper sQLHelper = new SQLHelper();
            sQLHelper.pstmt = ConfigurationWorkerPanel.this.connection.prepareStatement("select sys_context('USERENV','SESSION_SCHEMA') from dual");
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                string = sQLHelper.rs.getString(1);
            }
            sQLHelper.close();
            return string;
        }

        @Override
        protected void beforeRunStatementProcessing() throws ExecutionException {
            super.beforeRunStatementProcessing();
            if (ConfigurationWorkerPanel.this.isCanceling() && !ConfigurationWorkerPanel.this.isCanceled()) {
                this.requestCancel();
            }
            ISQLCommand iSQLCommand = this.getCurrentStatement();
            String string = iSQLCommand.getSQLOrig();
            theLogger.log(Level.FINER, "+++ " + ConfigurationWorkerPanel.this.getTimeStamp() + " Next statement: " + string);
            string = string.replaceAll(" ", "").toUpperCase();
            String string2 = string.startsWith("CREATETABLEODMR$WORKFLOWS") ? UtilsLrb.get("INSTALLWFSTORE") : (string.startsWith("DROPUSERODMRSYS") ? UtilsLrb.get("DROPODMRSYS") : ConfigurationWorkerPanel.this.getCurrentScript().getDescription());
            final String string3 = string2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationWorkerPanel.this.detailedStatusLabel.setText(string3);
                }
            });
        }

        private int getUnitsCompleted() {
            float f = 0.0f;
            ScriptRunnerContext scriptRunnerContext = this.getScriptRunnerContext();
            Integer n = (Integer)scriptRunnerContext.getProperty("total_cmd_count");
            Integer n2 = (Integer)scriptRunnerContext.getProperty("current_cmd_count");
            int n3 = ConfigurationWorkerPanel.this._scriptList.size();
            float f2 = 100 / n3;
            float f3 = (float)ConfigurationWorkerPanel.this.getCurrentScriptIndex() * f2;
            float f4 = f2 / (float)n.intValue();
            f = f3 + f4 * (float)n2.intValue();
            Float f5 = Float.valueOf(f * 10000.0f);
            return f5.intValue();
        }

        @Override
        protected void afterRunStatementProcessing() throws ExecutionException {
            super.afterRunStatementProcessing();
            ScriptRunnerContext scriptRunnerContext = this.getScriptRunnerContext();
            ISQLCommand iSQLCommand = this.getCurrentStatement();
            Object object = iSQLCommand.getProperty("EXECUTEFAILED");
            Boolean bl = (Boolean)scriptRunnerContext.getProperty("sqldev.error");
            String string = (String)scriptRunnerContext.getProperty("sqldev.last.err.message");
            String string2 = this.getSQLCode(string);
            theLogger.log(Level.FINER, "--- " + ConfigurationWorkerPanel.this.getTimeStamp() + " Statement completed");
            if (object != null || bl.booleanValue()) {
                if (string2 != null && this.isHardFailure(string2)) {
                    ConfigurationWorkerPanel.this.setFinalResult(false);
                    throw new ExecutionException("SQL command failed", new Exception(string));
                }
                if (string2 == null) {
                    ConfigurationWorkerPanel.this.setFinalResult(false);
                    throw new ExecutionException("SQL command failed", new Exception(UtilsLrb.get("FAILURE_WITHOUT_MESSAGE")));
                }
            }
            final int n = this.getUnitsCompleted();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConfigurationWorkerPanel.this.progressBar.setValue(n);
                    theLogger.log(Level.FINEST, "Scaled units completed: " + n + " out of " + ConfigurationWorkerPanel.this.progressBar.getMaximum());
                }
            });
        }

        private String getSQLCode(String string) {
            if (string == null) {
                return null;
            }
            int n = string.indexOf("ORA-");
            if (n == -1) {
                return null;
            }
            String string2 = string.substring(n);
            int n2 = string2.indexOf(":");
            if (n2 == -1) {
                return null;
            }
            String string3 = string2.substring(0, n2);
            return string3;
        }

        private boolean isHardFailure(String string) {
            boolean bl = true;
            return bl;
        }

        @Override
        public void afterLoopProcessing() throws ExecutionException {
            super.afterLoopProcessing();
        }

        @Override
        public void beforeLoopProcessing() throws ExecutionException {
            super.beforeLoopProcessing();
        }

        @Override
        protected void run(ISQLCommand iSQLCommand) throws IOException {
            super.run(iSQLCommand);
            theLogger.log(Level.FINER, "--- Running: " + iSQLCommand.getSQLOrig());
        }

        @Override
        protected void cleanup() throws ExecutionException {
            super.cleanup();
            theLogger.log(Level.FINER, "--- Cleanining up");
        }
    }

    private static class ScriptItem {
        private String path;
        private String description;
        private String runAs;
        private String[] args;

        ScriptItem(String string, String string2, String string3, String[] stringArray) {
            this.path = string;
            this.runAs = string2;
            this.description = string3;
            this.args = stringArray;
        }

        public String getPath() {
            return this.path;
        }

        public String getDescription() {
            return this.description;
        }

        public String getRunAs() {
            return this.runAs;
        }

        public String[] getArgs() {
            return this.args;
        }
    }

    private static class CustomInstallStepException
    extends Exception {
    }

    class ScriptExecutorTask
    extends RaptorTask<Void> {
        private Connection m_connection;
        private ISQLCommand[] m_cmds;
        private ScriptRunner m_runner;
        private boolean m_interrupted;
        private int m_currentCommand;
        private ScriptRunnerContext m_scriptRunnerContext;
        private BufferedOutputStream m_out;
        private URL m_baseURL;
        private String m_directory;
        Logger m_logger;

        public ScriptExecutorTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
            this(string, iRaptorTaskRunMode, bl, bl2, true);
        }

        public ScriptExecutorTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3) {
            super(string, bl3, iRaptorTaskRunMode);
            this.m_currentCommand = -1;
            this.m_logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            this.setMessage(string);
            this.setPausable(bl);
            this.setCancellable(bl2);
        }

        public void setConnection(Connection connection) {
            this.m_connection = connection;
            if (this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getCurrentConnection() == null) {
                this.m_scriptRunnerContext.setCurrentConnection(connection);
            }
            if (this.m_scriptRunnerContext != null && this.m_scriptRunnerContext.getBaseConnection() == null) {
                this.m_scriptRunnerContext.setBaseConnection(connection);
            }
        }

        public Connection getConnection() {
            return this.m_connection;
        }

        public String getQuery() {
            return "";
        }

        public void setStmt(String string) {
            ScriptParser scriptParser = new ScriptParser(string, this.m_connection);
            scriptParser.parse();
            this.m_cmds = scriptParser.getSqlStatements();
        }

        public void setStmt(InputStream inputStream) {
            this.setStmt(new InputStreamReader(inputStream));
        }

        public void setStmt(InputStream inputStream, String string) throws UnsupportedEncodingException {
            this.setStmt(new InputStreamReader(inputStream, string));
        }

        public void setStmt(Reader reader) {
            ScriptParser scriptParser = new ScriptParser(reader, this.m_connection);
            scriptParser.parse();
            this.m_cmds = scriptParser.getSqlStatements();
        }

        public ScriptRunnerContext getScriptRunnerContext() {
            return this.m_scriptRunnerContext;
        }

        public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
            this.m_scriptRunnerContext = scriptRunnerContext;
        }

        public BufferedOutputStream getOut() {
            return this.m_out;
        }

        public void setOut(BufferedOutputStream bufferedOutputStream) {
            this.m_out = bufferedOutputStream;
        }

        public void flushOut(boolean bl) {
            try {
                if (bl) {
                    this.m_out.flush();
                    this.m_out.close();
                } else {
                    this.m_out.flush();
                }
            }
            catch (IOException iOException) {
                theLogger.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
            }
        }

        protected Void doWork() {
            try {
                this.startup();
                try {
                    this.checkCanProceed();
                    this.loopThroughAllStatements();
                }
                finally {
                    this.cleanup();
                    this.setMessage(Messages.getString((String)"IRaptorTaskStatus.4"));
                }
            }
            catch (ExecutionException executionException) {
                theLogger.log(Level.SEVERE, executionException.getLocalizedMessage(), executionException);
            }
            return null;
        }

        protected void loopThroughAllStatements() throws ExecutionException {
            this.beforeLoopProcessing();
            try {
                this.m_currentCommand = 0;
                while (this.m_currentCommand < this.m_cmds.length && !this.isInterupted()) {
                    this.incrementCMDCount();
                    this.checkCanProceed();
                    if (!this.isInterupted()) {
                        this.checkCanProceed();
                        this.beforeRunStatementProcessing();
                        this.run(this.m_cmds[this.m_currentCommand]);
                        this.afterRunStatementProcessing();
                        if (this.m_scriptRunnerContext.getExited()) break;
                    }
                    ++this.m_currentCommand;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                try {
                    this.m_out.close();
                }
                catch (Exception exception2) {
                    theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception2);
                }
            }
            this.afterLoopProcessing();
        }

        protected void beforeRunStatementProcessing() throws ExecutionException {
            this.m_scriptRunnerContext.putProperty("sqldev.error", (Object)Boolean.FALSE);
            this.m_scriptRunnerContext.putProperty("sqldev.last.err.message", null);
            this.m_scriptRunnerContext.setOutputStreamWrapper(this.m_out);
            this.m_scriptRunnerContext.putProperty("current_cmd_count", (Object)this.m_currentCommand);
        }

        protected void afterRunStatementProcessing() throws ExecutionException {
        }

        protected ISQLCommand getCurrentStatement() {
            if (this.m_cmds != null && this.m_currentCommand >= 0) {
                return this.m_cmds[this.m_currentCommand];
            }
            return null;
        }

        protected boolean wasErrorEncountered() {
            return this.m_scriptRunnerContext != null && (Boolean)this.m_scriptRunnerContext.getProperty("sqldev.error") != false;
        }

        protected String getStatementErrorMessage() {
            if (this.getCurrentStatement() != null && this.wasErrorEncountered()) {
                return (String)this.m_scriptRunnerContext.getProperty("sqldev.last.err.message");
            }
            return "";
        }

        protected void startup() throws ExecutionException {
            if (this.m_scriptRunnerContext == null) {
                this.m_scriptRunnerContext = new ScriptRunnerContext();
            }
            if (this.m_scriptRunnerContext.getTopLevel()) {
                this.m_scriptRunnerContext.setBaseConnection(this.m_connection);
                this.m_scriptRunnerContext.setCurrentConnection(this.m_connection);
            }
            if (this.m_baseURL != null) {
                this.m_scriptRunnerContext.setLastUrl(this.m_baseURL);
            }
            this.m_scriptRunnerContext.putProperty("script.runner.base.url", (Object)this.m_baseURL);
            this.m_scriptRunnerContext.putProperty("total_cmd_count", (Object)this.m_cmds.length);
            if (this.m_out == null) {
                this.m_out = this.m_scriptRunnerContext.getOutputStream() != null ? this.m_scriptRunnerContext.getOutputStream().getMainStream() : new BufferedOutputStream(System.out);
                this.m_scriptRunnerContext.putProperty("script.runner.using.systemout", (Object)Boolean.TRUE);
            }
        }

        protected void cleanup() throws ExecutionException {
            block9: {
                if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
                    this.m_scriptRunnerContext.writeDisconnectWarning();
                }
                if (this.m_scriptRunnerContext.getTopLevel() && this.m_scriptRunnerContext.getCloseConnection()) {
                    try {
                        this.m_connection.commit();
                    }
                    catch (SQLException sQLException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    SQLHelper.close(this.m_connection);
                }
                try {
                    this.m_out.flush();
                }
                catch (IOException iOException) {
                    if (this.m_interrupted) break block9;
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
            if (this.m_scriptRunnerContext.getTopLevel()) {
                if (this.m_scriptRunnerContext.getExited()) {
                    this.m_scriptRunnerContext.reInitOnExit();
                } else {
                    this.m_scriptRunnerContext.reInitNoExit();
                }
            }
        }

        protected void run(ISQLCommand iSQLCommand) throws IOException {
            if (this.m_runner == null) {
                this.m_runner = new ScriptRunner(this.m_connection, this.m_out, this.m_scriptRunnerContext);
                this.m_runner.setDirectory(this.getDirectory());
            }
            this.m_runner.run(iSQLCommand);
        }

        public String getConnectionName() {
            return "";
        }

        public void setDirectory(String string) {
            this.m_directory = string;
        }

        public String getDirectory() {
            return this.m_directory;
        }

        boolean isInterupted() {
            return Thread.currentThread().isInterrupted();
        }

        protected void checkCanProceed() throws ExecutionException {
            super.checkCanProceed();
        }

        private void incrementCMDCount() {
            int n = this.getNotNullCMDCount();
            this.m_scriptRunnerContext.putProperty("current_cmd_count", (Object)(n + 1));
        }

        private int getNotNullCMDCount() {
            Integer n = (Integer)this.m_scriptRunnerContext.getProperty("current_cmd_count");
            if (n == null) {
                n = 0;
            }
            return n;
        }

        public void beforeLoopProcessing() throws ExecutionException {
            CommandRegistry.fireBeginScriptListeners((Connection)this.m_connection, (ScriptRunnerContext)this.getScriptRunnerContext());
        }

        public void afterLoopProcessing() throws ExecutionException {
            CommandRegistry.fireEndScriptListeners((Connection)this.m_connection, (ScriptRunnerContext)this.getScriptRunnerContext());
        }
    }

    class SchemaTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private Connection _conn;
        private boolean _sendToWorksheet;

        SchemaTaskListener(String string, Connection connection, Boolean bl) {
            this._taskFullName = string;
            this._conn = connection;
            this._sendToWorksheet = bl;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            try {
                ConfigurationWorkerPanel.this.setFinalResult(false);
                this._conn.rollback();
                this._conn.close();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
            theLogger.log(Level.FINER, "--- Task failed");
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            ConfigurationWorkerPanel.this.setIsCanceled();
            try {
                this._conn.rollback();
                ConfigUtils.setDBRestricted(ConfigurationWorkerPanel.this.connection, false);
                this._conn.close();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
            theLogger.log(Level.FINER, "--- Task cancelled");
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            theLogger.log(Level.FINER, "--- Task finished");
            if (!ConfigurationWorkerPanel.this.getFinalResult()) {
                try {
                    this._conn.rollback();
                    this._conn.close();
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
                return;
            }
            try {
                if (this._conn.isClosed()) {
                    ConfigurationWorkerPanel.this.setFinalResult(false);
                }
                this._conn.commit();
            }
            catch (Exception exception) {
                ConfigurationWorkerPanel.this.setFinalResult(false);
                return;
            }
            ConfigurationWorkerPanel.this.currentTask.getDescriptor().removeListener((IRaptorTaskListener)this);
            ConfigurationWorkerPanel.this.currentTask = null;
            try {
                if (!ConfigurationWorkerPanel.this.runNextScript()) {
                    ConfigurationWorkerPanel.this.setFinalResult(true);
                    SQLHelper.close(this._conn);
                }
            }
            catch (CustomInstallStepException customInstallStepException) {
                try {
                    this._conn.rollback();
                    this._conn.close();
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                }
                ConfigurationWorkerPanel.this.setFinalResult(false);
                theLogger.log(Level.SEVERE, customInstallStepException.getMessage(), customInstallStepException);
            }
        }

        public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
            super.progressChanged(raptorTaskEvent);
        }

        public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
            super.messageChanged(raptorTaskEvent);
        }

        public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
            super.stateChanged(raptorTaskEvent);
        }

        public void taskPaused(RaptorTaskEvent raptorTaskEvent) {
            super.taskPaused(raptorTaskEvent);
        }

        public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
            super.taskRunning(raptorTaskEvent);
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            super.taskScheduled(raptorTaskEvent);
        }
    }
}

