/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.roc;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.roc.ROCData;
import oracle.dmt.dataminer.tviewer.roc.StatisticsData;

public class ROCGraphModel {
    private Map<String, List<ROCData>> _rocData;
    private Map<String, StatisticsData> _statData;
    private Object[][] _graphData;
    private Object[] _graphRowLabel;
    private Object[] _graphColLabel;

    public ROCGraphModel(Map<String, List<ROCData>> map, Map<String, StatisticsData> map2) {
        this._rocData = map;
        this._statData = map2;
    }

    public void load() {
        List<ROCData> list;
        int n = this._rocData.size();
        int n2 = 0;
        for (String string : this._rocData.keySet()) {
            List<ROCData> list2 = this._rocData.get(string);
            int n3 = list2.size();
            if (n2 >= n3) continue;
            n2 = n3;
        }
        this._graphData = new Object[n2 * 2][n * 5];
        this._graphRowLabel = new Object[n * 5];
        int n4 = 0;
        int n5 = 0;
        for (String string : this._rocData.keySet()) {
            list = this._rocData.get(string);
            n5 = 0;
            for (int i = 0; i < list.size(); ++i) {
                this._graphData[n5++][n4] = list.get(i).getFalsePositivesFraction();
                this._graphData[n5++][n4] = list.get(i).getTruePositivesFraction();
            }
            this._graphRowLabel[n4] = TestViewerLrb.get("ROC_GRAPH_DATA_ROC") + " " + string;
            ++n4;
        }
        for (String string : this._rocData.keySet()) {
            list = this._rocData.get(string);
            StatisticsData statisticsData = this._statData.get(string);
            n5 = 0;
            this._graphData[n5++][n4] = list.get(statisticsData.getMaxOverallAccuracyIdx()).getFalsePositivesFraction();
            this._graphData[n5++][n4] = list.get(statisticsData.getMaxOverallAccuracyIdx()).getTruePositivesFraction();
            this._graphRowLabel[n4] = TestViewerLrb.get("ROC_GRAPH_DATA_MAX_OVERALL_ACC") + " " + string;
            n5 = 0;
            this._graphData[n5++][++n4] = list.get(statisticsData.getMaxAvgAccuracyIdx()).getFalsePositivesFraction();
            this._graphData[n5++][n4] = list.get(statisticsData.getMaxAvgAccuracyIdx()).getTruePositivesFraction();
            this._graphRowLabel[n4] = TestViewerLrb.get("ROC_GRAPH_DATA_MAX_AVG_ACC") + " " + string;
            n5 = 0;
            this._graphData[n5++][++n4] = list.get(statisticsData.getCustomAccuracyIdx()).getFalsePositivesFraction();
            this._graphData[n5++][n4] = list.get(statisticsData.getCustomAccuracyIdx()).getTruePositivesFraction();
            this._graphRowLabel[n4] = TestViewerLrb.get("ROC_GRAPH_DATA_CUSTOM_ACC") + " " + string;
            n5 = 0;
            this._graphData[n5++][++n4] = list.get(statisticsData.getModelAccuracyIdx()).getFalsePositivesFraction();
            this._graphData[n5++][n4] = list.get(statisticsData.getModelAccuracyIdx()).getTruePositivesFraction();
            this._graphRowLabel[n4] = TestViewerLrb.get("ROC_GRAPH_DATA_MODEL_ACC") + " " + string;
            ++n4;
        }
        this._graphColLabel = new Object[n2 * 2];
        for (int i = 0; i < this._graphColLabel.length; ++i) {
            this._graphColLabel[i] = "";
        }
    }

    public Object[][] getGraphData() {
        return this._graphData;
    }

    public Object[] getGraphRowLabel() {
        return this._graphRowLabel;
    }

    public Object[] getGraphColLabel() {
        return this._graphColLabel;
    }
}

