/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.residual;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public class ResidualTabState {
    private static final Logger theLogger = Logger.getLogger(ResidualTabState.class.getName());
    private SharedTestEditorState _parentTestViewerState;
    private Context _context;
    private List<TestResult> _testResults;
    private String _caseAttr = null;
    private String _caseAttrDataType = "NUMBER";
    private boolean _enableCaseIdSelection = false;
    private String _selectedPlotYValue;
    private String _selectedPlotXValue;
    private int _sampleSize;
    private boolean _resample;
    private String _selectedTestResult1;
    private String _selectedTestResult2;
    private Map<String, Integer> _resultDataSize;
    private Map<String, List<Object>> _resultData;
    private boolean _showChartForResult1;
    private boolean _showChartForResult2;
    private ResidualSummaryModel _residualSummaryModel;
    public static final String RESULT_NONE = "RESULT_NONE";
    public static final String PLOT_RESIDUAL = "PLOT_RESIDUAL";
    public static final String PLOT_CASEID = "PLOT_CASEID";
    public static final String PLOT_PREDICTION = "PLOT_PREDICTION";
    public static final String PLOT_TARGET = "PLOT_TARGET";
    public static final int REFRESH_GRAPH_ALL = 0;
    public static final int REFRESH_GRAPH_1 = 1;
    public static final int REFRESH_GRAPH_2 = 2;
    private static final String _plotdata = "select CASEID, TARGET, PREDICTION, RESIDUAL from ( select * from <plotTable> where <partition_clause> ORDER BY ORA_HASH(CASEID, (select count(*) from <plotTable>), 0) ) where rownum <= <sampleSize>";
    private static final String _plottablecount = "select COUNT(*) from <plotTable>";
    private static String partitioned_metrics = "Select metric_name, metric_num_value from <performanceTable>  where <partition_clause> and metric_name  in ( 'PREDICTIVE_CONFIDENCE', 'MEAN_RMS_ERROR', 'MEAN_ABSOLUTE_ERROR', 'MEAN_PREDICATED_VALUE', 'MEAN_ACTUAL_VALUE')";

    public SharedTestEditorState getParentTestViewerState() {
        return this._parentTestViewerState;
    }

    public ResidualTabState(SharedTestEditorState sharedTestEditorState, Context context) {
        this._parentTestViewerState = sharedTestEditorState;
        this._context = context;
        this._residualSummaryModel = null;
        CaseAttributes caseAttributes = null;
        this._testResults = this._parentTestViewerState.getTestResults();
        TestNodeType testNodeType = this._testResults.get(0).getTest();
        if (testNodeType == null) {
            BuildNodeType buildNodeType = this._testResults.get(0).getBuild();
            caseAttributes = buildNodeType.getCaseAttributes();
        } else {
            caseAttributes = testNodeType.getCaseAttributes();
        }
        if (caseAttributes.getAttribute().size() == 1) {
            this._caseAttr = ((AttributeType)caseAttributes.getAttribute().get(0)).getName();
            this._caseAttrDataType = ((AttributeType)caseAttributes.getAttribute().get(0)).getDataType();
            if (this._caseAttrDataType.equals("FLOAT") || this._caseAttrDataType.equals("LONG") || this._caseAttrDataType.equals("NUMBER") || this._caseAttrDataType.equals("BINARY_DOUBLE") || this._caseAttrDataType.equals("BINARY_FLOAT")) {
                this._enableCaseIdSelection = true;
            }
        }
        this._selectedPlotYValue = PLOT_RESIDUAL;
        this._selectedPlotXValue = PLOT_PREDICTION;
        this._selectedTestResult1 = this._testResults.get(0).getName();
        this._selectedTestResult2 = null;
        this._showChartForResult1 = true;
        this._showChartForResult2 = true;
        this._resultData = new HashMap<String, List<Object>>();
        this._resultDataSize = new HashMap<String, Integer>();
        this._sampleSize = 2000;
        this._resample = false;
    }

    public RegressTestResult getRegressTestResult(String string) {
        for (TestResult testResult : this._testResults) {
            RegressTestResult regressTestResult = (RegressTestResult)testResult;
            if (string.compareTo(regressTestResult.getName()) != 0) continue;
            return regressTestResult;
        }
        return null;
    }

    public Vector<String> getRegressTestResults() {
        Vector<String> vector = new Vector<String>();
        for (TestResult testResult : this._testResults) {
            RegressTestResult regressTestResult = (RegressTestResult)testResult;
            vector.add(regressTestResult.getName());
        }
        return vector;
    }

    public DefaultGraphDataModel getGraphDataModel(String string) {
        List<Object> list;
        DefaultGraphDataModel defaultGraphDataModel = null;
        String string2 = string;
        if (string2 == null) {
            string2 = this._selectedTestResult1;
        }
        if ((list = this._resultData.get(string2)) != null) {
            defaultGraphDataModel = (DefaultGraphDataModel)list.get(0);
        }
        return defaultGraphDataModel;
    }

    public ResidualPlotModel getResidualPlotModel(String string) {
        List<Object> list;
        ResidualPlotModel residualPlotModel = null;
        String string2 = string;
        if (string2 == null) {
            string2 = this._selectedTestResult1;
        }
        if ((list = this._resultData.get(string2)) != null) {
            residualPlotModel = (ResidualPlotModel)((Object)list.get(1));
        }
        return residualPlotModel;
    }

    public int getResidualPlotSize(String string) {
        return this._resultDataSize.containsKey(string) ? this._resultDataSize.get(string) : 0;
    }

    public void refreshSummary(boolean bl) throws SQLException {
        this._testResults = this._parentTestViewerState.getTestResults();
        try {
            if (bl) {
                this.loadPartitionedSummary();
            } else {
                this.loadSummary();
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
        try {
            this.refreshGraph(0, bl);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
    }

    public void refreshGraph(int n, boolean bl) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            Serializable serializable;
            Object object;
            Object object2;
            Object object3;
            if (n == 0 || n == 1) {
                object3 = this.getRegressTestResult(this._selectedTestResult1);
                if (object3 == null) {
                    this._selectedTestResult1 = this._testResults.get(0).getName();
                }
                object2 = this.getResidualPlotModel(this._selectedTestResult1);
                if (this._resample || object2 == null) {
                    object3 = this.getRegressTestResult(this._selectedTestResult1);
                    object2 = bl ? this.loadPartitionedPlot((RegressTestResult)object3) : this.loadPlot((RegressTestResult)object3);
                    bl2 = true;
                }
                object = this.getGraphDataModel(this._selectedTestResult1);
                if (this._resample || object == null) {
                    object = this.loadGraph(this._selectedTestResult1, (ResidualPlotModel)((Object)object2), this._selectedPlotXValue, this._selectedPlotYValue);
                    bl3 = true;
                }
                if (bl2 || bl3) {
                    serializable = new ArrayList();
                    if (bl3) {
                        serializable.add(0, object);
                    }
                    if (bl2) {
                        serializable.add(1, object2);
                    }
                    this._resultData.put(this._selectedTestResult1, (List<Object>)((Object)serializable));
                }
            }
            if ((n == 0 || n == 2) && this._selectedTestResult2 != null) {
                object3 = this.getRegressTestResult(this._selectedTestResult2);
                if (object3 == null) {
                    this._selectedTestResult2 = this._testResults.get(0).getName();
                }
                bl2 = false;
                bl3 = false;
                object2 = this.getResidualPlotModel(this._selectedTestResult2);
                if (this._resample || object2 == null) {
                    object3 = this.getRegressTestResult(this._selectedTestResult2);
                    object2 = bl ? this.loadPartitionedPlot((RegressTestResult)object3) : this.loadPlot((RegressTestResult)object3);
                    bl2 = true;
                }
                object = this.getGraphDataModel(this._selectedTestResult2);
                if (this._resample || object == null) {
                    object = this.loadGraph(this._selectedTestResult2, (ResidualPlotModel)((Object)object2), this._selectedPlotXValue, this._selectedPlotYValue);
                    bl3 = true;
                }
                if (bl2 || bl3) {
                    serializable = new ArrayList();
                    if (bl3) {
                        serializable.add(0, object);
                    }
                    if (bl2) {
                        serializable.add(1, object2);
                    }
                    this._resultData.put(this._selectedTestResult2, (List<Object>)((Object)serializable));
                }
            }
            object3 = this.getGraphDataModel(this._selectedTestResult1);
            object2 = (Double)((DefaultGraphDataModel)object3).minX1Value();
            object = (Double)((DefaultGraphDataModel)object3).maxX1Value();
            serializable = (Double)((DefaultGraphDataModel)object3).minY1Value();
            Double d = (Double)((DefaultGraphDataModel)object3).maxY1Value();
            ((DefaultGraphDataModel)object3).setX1(((DefaultGraphDataModel)object3).getX1Title(), object2, object);
            ((DefaultGraphDataModel)object3).setY1(((DefaultGraphDataModel)object3).getY1Title(), serializable, d);
            this._resample = false;
            if (this._selectedTestResult2 != null) {
                DefaultGraphDataModel defaultGraphDataModel = this.getGraphDataModel(this._selectedTestResult2);
                Double d2 = (Double)defaultGraphDataModel.minX1Value();
                Double d3 = (Double)defaultGraphDataModel.maxX1Value();
                Double d4 = (Double)defaultGraphDataModel.minY1Value();
                Double d5 = (Double)defaultGraphDataModel.maxY1Value();
                Object object4 = (Double)object2 < d2 ? object2 : d2;
                Object object5 = (Double)object < d3 ? d3 : object;
                Serializable serializable2 = (Double)serializable < d4 ? serializable : d4;
                Double d6 = d < d5 ? d5 : d;
                ((DefaultGraphDataModel)object3).setX1(((DefaultGraphDataModel)object3).getX1Title(), object4, object5);
                ((DefaultGraphDataModel)object3).setY1(((DefaultGraphDataModel)object3).getY1Title(), serializable2, d6);
                defaultGraphDataModel.setX1(defaultGraphDataModel.getX1Title(), object4, object5);
                defaultGraphDataModel.setY1(defaultGraphDataModel.getY1Title(), serializable2, d6);
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
    }

    private ResidualPlotModel loadPlot(RegressTestResult regressTestResult) throws SQLException {
        ArrayList<ResidualData> arrayList = new ArrayList<ResidualData>();
        String string = regressTestResult.getResidualPlotTable();
        String string2 = "select CASEID, TARGET, PREDICTION, RESIDUAL from ( select * from " + string + " ORDER BY ORA_HASH(CASEID, (select count(*) from " + string + "), 0) ) where rownum <= " + this._sampleSize;
        String string3 = "select COUNT(*) from " + string;
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object object;
            sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                object = sQLHelper.rs.getInt(1);
                this._resultDataSize.put(regressTestResult.getResultName(), (Integer)object);
            }
            sQLHelper.close();
            sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.pstmt.setFetchSize(this._sampleSize > 1000 ? 1000 : this._sampleSize);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = null;
                if (this._caseAttr != null) {
                    object = this._caseAttrDataType.indexOf("CHAR") != -1 ? sQLHelper.rs.getString("CASEID") : (this._caseAttrDataType.indexOf("DATE") != -1 ? sQLHelper.rs.getDate("CASEID") : sQLHelper.rs.getBigDecimal("CASEID"));
                }
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("RESIDUAL");
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("PREDICTION");
                BigDecimal bigDecimal3 = sQLHelper.rs.getBigDecimal("TARGET");
                ResidualData residualData = null;
                residualData = object == null ? new ResidualData(bigDecimal, bigDecimal2, bigDecimal3) : new ResidualDataWithId(object, bigDecimal, bigDecimal2, bigDecimal3);
                arrayList.add(residualData);
            }
        }
        return new ResidualPlotModel(arrayList);
    }

    private ResidualPlotModel loadPartitionedPlot(RegressTestResult regressTestResult) throws SQLException {
        ArrayList<ResidualData> arrayList = new ArrayList<ResidualData>();
        String string = regressTestResult.getResidualPlotTable();
        String string2 = StringUtils.getReplacedString(_plotdata, "<plotTable>", string);
        string2 = StringUtils.getReplacedString(string2, "<sampleSize>", String.valueOf(this._sampleSize));
        String string3 = this._parentTestViewerState.getSelectedPartition();
        string2 = SharedTestEditorState.setPartitionClause(string2, string3);
        String string4 = StringUtils.getReplacedString(_plottablecount, "<plotTable>", string);
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object object;
            sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                object = sQLHelper.rs.getInt(1);
                this._resultDataSize.put(regressTestResult.getResultName(), (Integer)object);
            }
            sQLHelper.close();
            sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.pstmt.setFetchSize(this._sampleSize > 1000 ? 1000 : this._sampleSize);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                object = null;
                if (this._caseAttr != null) {
                    object = this._caseAttrDataType.indexOf("CHAR") != -1 ? sQLHelper.rs.getString("CASEID") : (this._caseAttrDataType.indexOf("DATE") != -1 ? sQLHelper.rs.getDate("CASEID") : sQLHelper.rs.getBigDecimal("CASEID"));
                }
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal("RESIDUAL");
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("PREDICTION");
                BigDecimal bigDecimal3 = sQLHelper.rs.getBigDecimal("TARGET");
                ResidualData residualData = null;
                residualData = object == null ? new ResidualData(bigDecimal, bigDecimal2, bigDecimal3) : new ResidualDataWithId(object, bigDecimal, bigDecimal2, bigDecimal3);
                arrayList.add(residualData);
            }
        }
        return new ResidualPlotModel(arrayList);
    }

    private void loadPartitionedSummary() throws SQLException {
        TreeMap<String, StatisticsData> treeMap = new TreeMap<String, StatisticsData>();
        for (TestResult testResult : this._testResults) {
            String string = testResult.getName();
            String string2 = testResult.getPerformanceMatrixTable();
            String string3 = StringUtils.getReplacedString(partitioned_metrics, "<performanceTable>", string2);
            String string4 = this._parentTestViewerState.getSelectedPartition();
            string3 = SharedTestEditorState.setPartitionClause(string3, string4);
            try (SQLHelper sQLHelper = new SQLHelper();){
                Object object;
                sQLHelper.conn = ConnectionFolder.getConnection(this._context);
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                BigDecimal bigDecimal = null;
                BigDecimal bigDecimal2 = null;
                BigDecimal bigDecimal3 = null;
                BigDecimal bigDecimal4 = null;
                BigDecimal bigDecimal5 = null;
                while (sQLHelper.rs.next()) {
                    object = sQLHelper.rs.getString(1);
                    BigDecimal bigDecimal6 = sQLHelper.rs.getBigDecimal(2);
                    if ("PREDICTIVE_CONFIDENCE".equals(object)) {
                        bigDecimal = bigDecimal6;
                        continue;
                    }
                    if ("MEAN_RMS_ERROR".equals(object)) {
                        bigDecimal2 = bigDecimal6;
                        continue;
                    }
                    if ("MEAN_ABSOLUTE_ERROR".equals(object)) {
                        bigDecimal3 = bigDecimal6;
                        continue;
                    }
                    if ("MEAN_PREDICATED_VALUE".equals(object)) {
                        bigDecimal4 = bigDecimal6;
                        continue;
                    }
                    if (!"MEAN_ACTUAL_VALUE".equals(object)) continue;
                    bigDecimal5 = bigDecimal6;
                }
                object = new StatisticsData(bigDecimal, bigDecimal3, bigDecimal2, bigDecimal4, bigDecimal5, testResult.getMiningAlgorithm(), testResult.getCreationTime());
                treeMap.put(string, (StatisticsData)object);
            }
        }
        this._residualSummaryModel = new ResidualSummaryModel(treeMap);
    }

    private void loadSummary() throws SQLException {
        TreeMap<String, StatisticsData> treeMap = new TreeMap<String, StatisticsData>();
        for (TestResult testResult : this._testResults) {
            String string = testResult.getName();
            String string2 = testResult.getPerformanceMatrixTable();
            String string3 = "Select metric_name, metric_num_value from " + string2 + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'MEAN_RMS_ERROR', 'MEAN_ABSOLUTE_ERROR', 'MEAN_PREDICATED_VALUE', 'MEAN_ACTUAL_VALUE')";
            try (SQLHelper sQLHelper = new SQLHelper();){
                Object object;
                sQLHelper.conn = ConnectionFolder.getConnection(this.getContext());
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                BigDecimal bigDecimal = null;
                BigDecimal bigDecimal2 = null;
                BigDecimal bigDecimal3 = null;
                BigDecimal bigDecimal4 = null;
                BigDecimal bigDecimal5 = null;
                while (sQLHelper.rs.next()) {
                    object = sQLHelper.rs.getString(1);
                    BigDecimal bigDecimal6 = sQLHelper.rs.getBigDecimal(2);
                    if ("PREDICTIVE_CONFIDENCE".equals(object)) {
                        bigDecimal = bigDecimal6;
                        continue;
                    }
                    if ("MEAN_RMS_ERROR".equals(object)) {
                        bigDecimal2 = bigDecimal6;
                        continue;
                    }
                    if ("MEAN_ABSOLUTE_ERROR".equals(object)) {
                        bigDecimal3 = bigDecimal6;
                        continue;
                    }
                    if ("MEAN_PREDICATED_VALUE".equals(object)) {
                        bigDecimal4 = bigDecimal6;
                        continue;
                    }
                    if (!"MEAN_ACTUAL_VALUE".equals(object)) continue;
                    bigDecimal5 = bigDecimal6;
                }
                object = new StatisticsData(bigDecimal, bigDecimal3, bigDecimal2, bigDecimal4, bigDecimal5, testResult.getMiningAlgorithm(), testResult.getCreationTime());
                treeMap.put(string, (StatisticsData)object);
            }
        }
        this._residualSummaryModel = new ResidualSummaryModel(treeMap);
    }

    private DefaultGraphDataModel loadGraph(String string, ResidualPlotModel residualPlotModel, String string2, String string3) {
        double d = 2.147483647E9;
        double d2 = -2.147483648E9;
        double d3 = 2.147483647E9;
        double d4 = -2.147483648E9;
        String string4 = null;
        String string5 = null;
        DefaultGraphDataModel defaultGraphDataModel = new DefaultGraphDataModel(null, 61, null, null, null);
        defaultGraphDataModel.setTitle(string);
        int n = 0;
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (TestResult testResult : this._testResults) {
            if (testResult.getName().compareTo(string) == 0) {
                Color color = this._parentTestViewerState.getTestResultGraphColors().get(n);
                arrayList.add(color);
                break;
            }
            ++n;
        }
        defaultGraphDataModel.addRowColors(arrayList.toArray(new Color[arrayList.size()]));
        int n2 = 1;
        Object[][] objectArray = new Object[n2][];
        Object[] objectArray2 = new Object[n2];
        Object[] objectArray3 = new Object[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        objectArray[n3] = new Object[residualPlotModel.getRowCount() * 2];
        if (string2.equals(PLOT_CASEID)) {
            n5 = 0;
            string4 = this._caseAttr;
        } else if (string2.equals(PLOT_PREDICTION)) {
            n5 = 2;
            string4 = TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE");
        } else if (string2.equals(PLOT_TARGET)) {
            n5 = 3;
            string4 = TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE");
        } else if (string2.equals(PLOT_RESIDUAL)) {
            n5 = 1;
            string4 = TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE");
        }
        if (string3.equals(PLOT_CASEID)) {
            n6 = 0;
            string5 = this._caseAttr;
        } else if (string3.equals(PLOT_PREDICTION)) {
            n6 = 2;
            string5 = TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE");
        } else if (string3.equals(PLOT_TARGET)) {
            n6 = 3;
            string5 = TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE");
        } else if (string3.equals(PLOT_RESIDUAL)) {
            n6 = 1;
            string5 = TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE");
        }
        for (int i = 0; i < residualPlotModel.getRowCount(); ++i) {
            Object object = residualPlotModel.getValueAt(i, n5);
            Object object2 = residualPlotModel.getValueAt(i, n6);
            double d5 = ((BigDecimal)object2).doubleValue();
            if (d5 < d3) {
                d3 = d5;
            }
            if (d5 > d4) {
                d4 = d5;
            }
            if ((d5 = ((BigDecimal)object).doubleValue()) < d) {
                d = d5;
            }
            if (d5 > d2) {
                d2 = d5;
            }
            objectArray[n3][n4++] = ((BigDecimal)object).doubleValue();
            objectArray[n3][n4++] = ((BigDecimal)object2).doubleValue();
        }
        objectArray2[n3] = string;
        objectArray3[n3] = 1;
        defaultGraphDataModel.setX1(string4, Math.floor(d), Math.ceil(d2));
        defaultGraphDataModel.setY1(string5, Math.floor(d3), Math.ceil(d4));
        defaultGraphDataModel.addRowLabels(objectArray2);
        defaultGraphDataModel.addRowMarkerShapes(objectArray3);
        defaultGraphDataModel.addGraphData(objectArray);
        return defaultGraphDataModel;
    }

    public ResidualSummaryModel getResidualSummaryModel() {
        return this._residualSummaryModel;
    }

    public Context getContext() {
        return this._context;
    }

    public void setSelectedPlotXValue(String string) {
        if (!this._selectedPlotXValue.equals(string)) {
            this._selectedPlotXValue = string;
            this._resample = true;
        }
    }

    public String getSelectedPlotXValue() {
        return this._selectedPlotXValue;
    }

    public void setSelectedPlotYValue(String string) {
        if (!this._selectedPlotYValue.equals(string)) {
            this._selectedPlotYValue = string;
            this._resample = true;
        }
    }

    public String getSelectedPlotYValue() {
        return this._selectedPlotYValue;
    }

    public void setSampleSize(int n) {
        if (this._sampleSize != n && n > 0) {
            this._sampleSize = n;
            this._resample = true;
        }
    }

    public int getSampleSize() {
        return this._sampleSize;
    }

    public void setSelectedTestResult1(String string) {
        this._selectedTestResult1 = string;
    }

    public String getSelectedTestResult1() {
        return this._selectedTestResult1;
    }

    public void setSelectedTestResult2(String string) {
        this._selectedTestResult2 = string;
    }

    public String getSelectedTestResult2() {
        return this._selectedTestResult2;
    }

    public void setShowChartForResult1(boolean bl) {
        this._showChartForResult1 = bl;
    }

    public boolean isShowChartForResult1() {
        return this._showChartForResult1;
    }

    public void setShowChartForResult2(boolean bl) {
        this._showChartForResult2 = bl;
    }

    public boolean isShowChartForResult2() {
        return this._showChartForResult2;
    }

    public String getCaseAttr() {
        return this._caseAttr;
    }

    public String getCaseAttrDataType() {
        return this._caseAttrDataType;
    }

    public boolean isCaseIdSelectionEnabled() {
        return this._enableCaseIdSelection;
    }

    static class ResidualSummaryModel
    extends SimpleBaseTableModel {
        public static final int MODEL = 0;
        public static final int PREDICTED_CONFIDENCE = 1;
        public static final int MEAN_ABS_ERROR = 2;
        public static final int ROOT_MEAN_SQ_ERROR = 3;
        public static final int MEAN_PREDICTED_VALUE = 4;
        public static final int MEAN_ACTUAL_VALUE = 5;
        public static final int ALGORITHM = 6;
        public static final int CREATION_DATE = 7;
        protected Map<String, StatisticsData> _statData = null;
        private String[] _columnNames = new String[]{TestViewerLrb.get("RESULT_NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"), TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"), TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"), TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE")};
        private final String LOADING = TestViewerLrb.get("LOADING");

        public ResidualSummaryModel() {
            this.setColumnIdentifiers(this._columnNames);
            this.setRowCount(1);
        }

        public ResidualSummaryModel(Map<String, StatisticsData> map) {
            this.setColumnIdentifiers(this._columnNames);
            this._statData = map;
            this.setRowCount(this._statData.size());
        }

        public Object getValueAt(int n, int n2) {
            if (this._statData == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._statData.keySet().toArray();
            if (n2 == 0) {
                return objectArray[n];
            }
            if (n2 == 1) {
                return this._statData.get(objectArray[n]).getPredictiveConfidence();
            }
            if (n2 == 2) {
                return this._statData.get(objectArray[n]).getMeanAbsoluteError();
            }
            if (n2 == 3) {
                return this._statData.get(objectArray[n]).getRootMeanSquareError();
            }
            if (n2 == 4) {
                return this._statData.get(objectArray[n]).getMeanPredictedValue();
            }
            if (n2 == 5) {
                return this._statData.get(objectArray[n]).getMeanActualValue();
            }
            if (n2 == 6) {
                return this._statData.get(objectArray[n]).getAlgorithm();
            }
            if (n2 == 7) {
                return this._statData.get(objectArray[n]).getCreationDate();
            }
            return "Undefined";
        }
    }

    class ResidualPlotModel
    extends SimpleBaseTableModel {
        public static final int RESIDUAL_CASE_ID = 0;
        public static final int RESIDUAL_RESIDUAL_VALUE = 1;
        public static final int RESIDUAL_PREDICTED_VALUE = 2;
        public static final int RESIDUAL_ACTUAL_VALUE = 3;
        protected List<ResidualData> _data = null;
        private String[] _columnNames;
        private final String LOADING;

        public ResidualPlotModel() {
            this._columnNames = new String[]{ResidualTabState.this._caseAttr, TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE"), TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"), TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE")};
            this.LOADING = TestViewerLrb.get("LOADING");
            this.setColumnIdentifiers(this._columnNames);
            this.setRowCount(1);
        }

        public ResidualPlotModel(List<ResidualData> list) {
            this._columnNames = new String[]{ResidualTabState.this._caseAttr, TestViewerLrb.get("RESIDUAL_RESIDUAL_VALUE"), TestViewerLrb.get("RESIDUAL_PREDICTED_VALUE"), TestViewerLrb.get("RESIDUAL_ACTUAL_VALUE")};
            this.LOADING = TestViewerLrb.get("LOADING");
            this.setColumnIdentifiers(this._columnNames);
            this._data = list;
            this.setRowCount(this._data.size());
        }

        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            ResidualData residualData = this._data.get(n);
            if (residualData instanceof ResidualDataWithId && n2 == 0) {
                ResidualDataWithId residualDataWithId = (ResidualDataWithId)residualData;
                return residualDataWithId.getCaseId();
            }
            if (n2 == 1) {
                return residualData.getResidual();
            }
            if (n2 == 2) {
                return residualData.getPredict();
            }
            if (n2 == 3) {
                return residualData.getActual();
            }
            return null;
        }

        public Comparator getColumnSortComparator(int n) {
            return NumberComparator.getComparator();
        }
    }

    class ResidualData {
        protected BigDecimal _residual;
        protected BigDecimal _predict;
        protected BigDecimal _actual;

        public ResidualData(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
            this._residual = bigDecimal;
            this._predict = bigDecimal2;
            this._actual = bigDecimal3;
        }

        public BigDecimal getResidual() {
            return this._residual;
        }

        public BigDecimal getPredict() {
            return this._predict;
        }

        public BigDecimal getActual() {
            return this._actual;
        }
    }

    class ResidualDataWithId
    extends ResidualData {
        protected Object _caseId;

        public ResidualDataWithId(Object object, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
            super(bigDecimal, bigDecimal2, bigDecimal3);
            this._caseId = object;
        }

        public Object getCaseId() {
            return this._caseId;
        }
    }

    static class StatisticsData {
        private BigDecimal _predictiveConfidence;
        private BigDecimal _meanAbsoluteError;
        private BigDecimal _rootMeanSquareError;
        private BigDecimal _meanPredictedValue;
        private BigDecimal _meanActualValue;
        private String _algorithm;
        private Date _creationDate;

        public StatisticsData(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5, String string, Date date) {
            this._predictiveConfidence = bigDecimal;
            this._meanAbsoluteError = bigDecimal2;
            this._rootMeanSquareError = bigDecimal3;
            this._meanPredictedValue = bigDecimal4;
            this._meanActualValue = bigDecimal5;
            this._algorithm = string;
            this._creationDate = date;
        }

        public BigDecimal getMeanAbsoluteError() {
            return this._meanAbsoluteError;
        }

        public BigDecimal getRootMeanSquareError() {
            return this._rootMeanSquareError;
        }

        public BigDecimal getMeanPredictedValue() {
            return this._meanPredictedValue;
        }

        public BigDecimal getMeanActualValue() {
            return this._meanActualValue;
        }

        public Date getCreationDate() {
            return this._creationDate;
        }

        public BigDecimal getPredictiveConfidence() {
            return this._predictiveConfidence;
        }

        public String getAlgorithm() {
            return this._algorithm;
        }
    }
}

