/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.profit;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.core.model.clas.common.ProfitInfo;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.ide.Context;

public class ProfitDetailPanel
extends DialogDisplayer {
    private List<ProfitInfo> _data;
    private ProfitTabState _state;
    private String testResult;
    private DataMinerTable ProfitDetailTable;
    private JScrollPane jScrollPane1;

    public ProfitDetailPanel(Context context, String string, ProfitTabState profitTabState, List<ProfitInfo> list) {
        super(context, null);
        this.testResult = string;
        this._state = profitTabState;
        this._data = list;
        this.initComponents();
        this.initTable();
    }

    @Override
    public void initUI() {
    }

    @Override
    public void initRes() {
    }

    private void initTable() {
        this.ProfitDetailTable.setModel((TableModel)((Object)new ProfitDetailModel(this._data)));
        this.ProfitDetailTable.setSorted(true);
        this.ProfitDetailTable.setUpdateSelectionOnSort(true);
        this.ProfitDetailTable.setRowSelectionAllowed(true);
        this.ProfitDetailTable.setColumnSelectionAllowed(false);
        this.ProfitDetailTable.setAutoResizeMode(0);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerPercentRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
        TableColumn tableColumn = this.ProfitDetailTable.getColumnModel().getColumn(3);
        tableColumn.setCellRenderer(tableCellRenderer);
        tableColumn = this.ProfitDetailTable.getColumnModel().getColumn(4);
        tableColumn.setCellRenderer(tableCellRenderer2);
        tableColumn = this.ProfitDetailTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(tableCellRenderer2);
        tableColumn = this.ProfitDetailTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(tableCellRenderer2);
        this.ProfitDetailTable.autoSizeColumnsToFit();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.ProfitDetailTable = new DataMinerTable();
        this.setPreferredSize(new Dimension(475, 400));
        this.ProfitDetailTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)((Object)this.ProfitDetailTable));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 580, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 378, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected String getDialogTitle() {
        return TestViewerLrb.get("PROFIT_DETAIL_DIALOG") + this.testResult;
    }

    @Override
    protected String getHelpTopic() {
        return "profit_detail";
    }

    @Override
    protected int getDialogButtonMask() {
        return 5;
    }

    public class ProfitDetailModel
    extends ODMrTableModel<ProfitInfo> {
        private static final int POPULATION = 0;
        private static final int PROFIT = 1;
        private static final int ROI = 2;
        private static final int PERCENTAGE_RECORDS_CUMULATIVE = 3;
        private static final int TARGET_DENSITY_CUMULATIVE = 4;
        private final String[] COLUMNS;

        public ProfitDetailModel() {
            this(null);
        }

        public ProfitDetailModel(List<ProfitInfo> list) {
            super(list);
            this.COLUMNS = new String[]{StringUtils.stripMnemonic((String)TestViewerLrb.get("POPULATION")), StringUtils.stripMnemonic((String)TestViewerLrb.get("PROFIT")), StringUtils.stripMnemonic((String)TestViewerLrb.get("ROI")), StringUtils.stripMnemonic((String)TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE")), StringUtils.stripMnemonic((String)TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"))};
            this.setColumnIdentifiers(this.COLUMNS);
        }

        @Override
        public int getRowCount() {
            int n = super.getRowCount();
            if (n > 1) {
                --n;
            }
            return n;
        }

        public Object getValueAt(int n, int n2) {
            int n3 = n + 1;
            int n4 = this.srcData.size();
            double d = ((ProfitInfo)this.srcData.get(n4 - 1)).getTargetCum() + ((ProfitInfo)this.srcData.get(n4 - 1)).getNonTargetCum();
            double d2 = ((ProfitInfo)this.srcData.get(n3)).getTargetCum();
            double d3 = ((ProfitInfo)this.srcData.get(n3)).getNonTargetCum();
            switch (n2) {
                case 0: {
                    return ((ProfitInfo)this.srcData.get(n3)).getQuantile();
                }
                case 1: {
                    double d4 = ProfitDetailPanel.this._state.getIncRevenue() * d2;
                    double d5 = ProfitDetailPanel.this._state.getIncCost() * (d2 + d3);
                    double d6 = -1.0 * ProfitDetailPanel.this._state.getStartupCost() + (d4 - d5) * ProfitDetailPanel.this._state.getPopulation() / d;
                    return d6;
                }
                case 2: {
                    double d7 = ProfitDetailPanel.this._state.getIncRevenue() * d2;
                    double d8 = ProfitDetailPanel.this._state.getIncCost() * (d2 + d3);
                    double d9 = (d7 - d8) / d8 * 100.0;
                    return d9;
                }
                case 3: {
                    return ((ProfitInfo)this.srcData.get(n3)).getPercentRecordsCum();
                }
                case 4: {
                    return ((ProfitInfo)this.srcData.get(n3)).getTargetDensityCum();
                }
            }
            assert (false) : "Invalid column";
            return "";
        }
    }
}

