/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.performance;

import java.awt.Color;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphicalPreferencesSettings;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetModelPerformanceMatrixQuery;
import oracle.dmt.dataminer.core.model.common.NameValue;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.RegressTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.performance.PerformanceMetric;
import oracle.dmt.dataminer.tviewer.performance.PerformanceTableModel;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.comparator.PerformanceMetricComparator;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class CPerformanceTabState {
    private static final String PREDICTIVE_CONFIDENCE = "PREDICTIVE_CONFIDENCE";
    private static final String AVG_ACCURACY = "AVG_ACCURACY";
    private static final String ACCURACY = "ACCURACY";
    private static final String COST = "COST";
    private static final String MEAN_ACTUAL_VALUE = "MEAN_ACTUAL_VALUE";
    private static final String MEAN_RMS_ERROR = "MEAN_RMS_ERROR";
    private static final String MEAN_ABSOLUTE_ERROR = "MEAN_ABSOLUTE_ERROR";
    private static final String MEAN_PREDICATED_VALUE = "MEAN_PREDICATED_VALUE";
    private static final String TEST_ROWS = "TEST_ROWS";
    private static final int _DEPTH_RADIUS = 50;
    private int depthRadius = 50;
    private long lastUpdateTime;
    private boolean hasCost;
    private SharedTestEditorState parentTestViewerState;
    private List<TestResult> testResults;
    private List<PerformanceMetric> metricsList;
    private GraphDataModel graphDataModel;
    private List<Measure> selectedGraphPerformanceMesaures = new ArrayList<Measure>();
    private List<Color> testResultColors;
    private PerformanceTableModel performanceTable;
    private NumberFormat percentageFormat = Formats.ModelViewer.getPercentage();
    private GraphicalPreferencesSettings graphPanelSettings = GraphicalPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private String styleSelection = DefaultGraphDataModel.DEFAULT_GRAPH_STYLE;
    private ConnectionManager connManager;
    private SqlDataAccessObject dao;

    public CPerformanceTabState(SharedTestEditorState sharedTestEditorState) {
        this(sharedTestEditorState, null);
    }

    public CPerformanceTabState(SharedTestEditorState sharedTestEditorState, List<Measure> list) {
        this.parentTestViewerState = sharedTestEditorState;
        this.testResults = this.parentTestViewerState.getTestResults();
        this.testResultColors = this.parentTestViewerState.getTestResultGraphColors();
        this.graphDataModel = new DefaultGraphDataModel(null, 17, null, null, null);
        this.graphDataModel.setX1(TestViewerLrb.get("TEST_RESULT"), null);
        this.graphDataModel.setY1(CommonLrb.get("VALUE"), (Object)100.0);
        if (this.testResultColors != null) {
            this.graphDataModel.addRowColors(this.testResultColors.toArray(new Color[this.testResultColors.size()]));
        }
        if (list == null || list.size() == 0) {
            this.selectedGraphPerformanceMesaures.add(Measure.PREDICTIVE_CONFIDENCE);
        } else {
            this.selectedGraphPerformanceMesaures = list;
        }
        this.styleSelection = this.graphPanelSettings.getGraphStyle();
        this.depthRadius = this.graphPanelSettings.getRadiusDepthValue();
        this.connManager = ConnectionFolder.getConnectionFolder(this.getParentTestViewerState().getContext());
        this.dao = new SqlDataAccessObject(this.connManager);
    }

    public SharedTestEditorState getParentTestViewerState() {
        return this.parentTestViewerState;
    }

    public void resetTime() {
        this.lastUpdateTime = 0L;
    }

    public synchronized List<PerformanceMetric> sortedResults(Measure measure, SortBy sortBy, SortDirection sortDirection) {
        Collections.sort(this.metricsList, new PerformanceMetricComparator(measure, sortBy, sortDirection));
        return this.metricsList;
    }

    public synchronized GraphDataModel sortedGraphDataModel(Measure measure, SortBy sortBy, SortDirection sortDirection, Object[] objectArray) {
        this.sortedResults(measure, sortBy, sortDirection);
        Object[] objectArray2 = new Object[this.metricsList.size()];
        Color[][] colorArray = null;
        Object[] objectArray3 = null;
        Object[] objectArray4 = null;
        Object[][] objectArray5 = null;
        this.graphDataModel.clear();
        this.graphDataModel.setGraphType(Integer.valueOf(17));
        if (measure == Measure.MEAN_PREDICTED_VALUE && this.metricsList.get(0).getCostOrMeanPredictValue() != null) {
            objectArray5 = new Object[this.metricsList.size()][2];
            objectArray4 = new Object[this.testResults.size() * 2];
            colorArray = new Color[objectArray2.length][2];
        } else {
            objectArray5 = new Object[this.metricsList.size()][1];
            objectArray3 = new Object[1];
            colorArray = new Color[objectArray2.length][1];
        }
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        for (PerformanceMetric performanceMetric : this.metricsList) {
            objectArray2[n] = performanceMetric.getTestResult().toString();
            switch (measure) {
                case MEAN_ACTUAL_VALUE: {
                    d = 100.0;
                    objectArray3[0] = TestViewerLrb.get(MEAN_ACTUAL_VALUE);
                    objectArray5[n][0] = performanceMetric.getMeanActualValue().doubleValue();
                    this.graphDataModel.setTitle(TestViewerLrb.get(MEAN_ACTUAL_VALUE));
                    colorArray[n][0] = performanceMetric.getColor();
                    break;
                }
                case TEST_ROWS: {
                    d = 100.0;
                    objectArray3[0] = TestViewerLrb.get(TEST_ROWS);
                    objectArray5[n][0] = performanceMetric.getTestRows().doubleValue();
                    this.graphDataModel.setTitle(TestViewerLrb.get(TEST_ROWS));
                    colorArray[n][0] = performanceMetric.getColor();
                    break;
                }
                case PREDICTIVE_CONFIDENCE: {
                    d = 100.0;
                    objectArray3[0] = TestViewerLrb.get(PREDICTIVE_CONFIDENCE);
                    colorArray[n][0] = performanceMetric.getColor();
                    objectArray5[n][0] = performanceMetric.getPredConfidence() != null ? Double.valueOf(performanceMetric.getPredConfidence().doubleValue()) : null;
                    this.graphDataModel.setTitle(TestViewerLrb.get("PERF_PC_GRAPH_TITLE"));
                    break;
                }
                case AVG_ACCURACY: 
                case ROOT_MEAN_SQRT_ERR: {
                    if (measure == Measure.ROOT_MEAN_SQRT_ERR) {
                        if (performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr().doubleValue() > d) {
                            d = performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr().doubleValue();
                        }
                        objectArray3[0] = TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR");
                    } else {
                        d = 100.0;
                        objectArray3[0] = TestViewerLrb.get(AVG_ACCURACY);
                    }
                    colorArray[n][0] = performanceMetric.getColor();
                    objectArray5[n][0] = performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr() != null ? Double.valueOf(performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr().doubleValue()) : null;
                    this.graphDataModel.setTitle(TestViewerLrb.get(measure == Measure.AVG_ACCURACY ? "PERF_AA_GRAPH_TITLE" : "PERF_RMSE_GRAPH_TITLE"));
                    break;
                }
                case OVERALL_ACCURACY: 
                case MEAN_ABS_ERR: {
                    if (measure == Measure.MEAN_ABS_ERR) {
                        if (performanceMetric.getOverallAccuracyOrMeanAbsErr().doubleValue() > d) {
                            d = performanceMetric.getOverallAccuracyOrMeanAbsErr().doubleValue();
                        }
                        objectArray3[0] = TestViewerLrb.get(MEAN_ABSOLUTE_ERROR);
                    } else {
                        d = 100.0;
                        objectArray3[0] = TestViewerLrb.get("OVERALL_ACCURACY");
                    }
                    colorArray[n][0] = performanceMetric.getColor();
                    objectArray5[n][0] = performanceMetric.getOverallAccuracyOrMeanAbsErr() != null ? Double.valueOf(performanceMetric.getOverallAccuracyOrMeanAbsErr().doubleValue()) : null;
                    this.graphDataModel.setTitle(TestViewerLrb.get(measure == Measure.OVERALL_ACCURACY ? "PERF_OA_GRAPH_TITLE" : "PERF_MAE_GRAPH_TITLE"));
                    break;
                }
                case COST: 
                case MEAN_PREDICTED_VALUE: {
                    if (performanceMetric.getCostOrMeanPredictValue() != null) {
                        if (measure == Measure.MEAN_PREDICTED_VALUE) {
                            if (performanceMetric.getCostOrMeanPredictValue().doubleValue() > d) {
                                d = performanceMetric.getCostOrMeanPredictValue().doubleValue();
                            }
                            if (performanceMetric.getMeanActualValue().doubleValue() > d) {
                                d = performanceMetric.getMeanActualValue().doubleValue();
                            }
                            objectArray3 = new Object[]{TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get(MEAN_ACTUAL_VALUE)};
                            objectArray4[n2++] = 1;
                            colorArray[n][0] = performanceMetric.getColor();
                            objectArray5[n][0] = performanceMetric.getCostOrMeanPredictValue().doubleValue();
                            objectArray4[n2++] = 2;
                            objectArray5[n][1] = performanceMetric.getMeanActualValue().doubleValue();
                            colorArray[n][1] = Color.RED;
                        } else {
                            double d2 = 0.0;
                            d2 = performanceMetric.getCostOrMeanPredictValue().scale() == 0 ? (double)performanceMetric.getCostOrMeanPredictValue().longValue() : performanceMetric.getCostOrMeanPredictValue().doubleValue();
                            if (d2 > d) {
                                d = d2;
                            }
                            objectArray3[0] = TestViewerLrb.get(COST);
                            colorArray[n][0] = performanceMetric.getColor();
                            objectArray5[n][0] = performanceMetric.getCostOrMeanPredictValue().doubleValue();
                        }
                    } else {
                        objectArray5[n][0] = null;
                    }
                    this.graphDataModel.setTitle(TestViewerLrb.get(measure == Measure.COST ? "PERF_CO_GRAPH_TITLE" : "PERF_MPV_GRAPH_TITLE"));
                    this.graphDataModel.setY1(CommonLrb.get("VALUE"), null);
                    break;
                }
                default: {
                    assert (false) : "Invalid option";
                    break;
                }
            }
            ++n;
        }
        this.graphDataModel.addRowLabels(objectArray3);
        this.graphDataModel.addColumnLabels(objectArray2);
        this.graphDataModel.addRowColors2(colorArray);
        if (objectArray4 != null) {
            this.graphDataModel.addRowMarkerTypes(objectArray4);
        }
        this.graphDataModel.addGraphData(objectArray5);
        this.graphDataModel.setY1(CommonLrb.get("VALUE"), (Object)d);
        this.graphDataModel.setDepthRadius(Integer.valueOf(this.depthRadius));
        this.graphDataModel.setStyleSelection(this.styleSelection);
        return this.graphDataModel;
    }

    public synchronized void load(String[] stringArray, CompareMode compareMode) throws ODMrDAOException {
        this.testResults = this.parentTestViewerState.getTestResults();
        if (this.parentTestViewerState.getPerformanceMetrics() == null || this.parentTestViewerState.getLastUpdateTime() != this.lastUpdateTime) {
            this.lastUpdateTime = this.parentTestViewerState.getLastUpdateTime();
            this.metricsList = new ArrayList<PerformanceMetric>();
            String string = this.parentTestViewerState.getSelectedPartition();
            Map<String, Integer> map = this.parentTestViewerState.getBuildRowsCount(string, CompareMode.isPartitioned((CompareMode)compareMode));
            for (TestResult testResult : this.testResults) {
                PerformanceMetric performanceMetric = new PerformanceMetric();
                performanceMetric.setTestResult(testResult);
                performanceMetric.setColor(this.parentTestViewerState.getTestResultGraphColor(testResult.toString()));
                GetModelPerformanceMatrixQuery.QueryMode queryMode = null;
                List list = new ArrayList();
                if (testResult instanceof ClassTestResult) {
                    queryMode = GetModelPerformanceMatrixQuery.QueryMode.CLASSIFICATION;
                } else if (testResult instanceof RegressTestResult) {
                    queryMode = GetModelPerformanceMatrixQuery.QueryMode.REGRESSION;
                    this.hasCost = true;
                }
                GetModelPerformanceMatrixQuery getModelPerformanceMatrixQuery = new GetModelPerformanceMatrixQuery(this.connManager.getDbVersion(), compareMode, queryMode, testResult.getPerformanceMatrixTable(), string);
                list = this.dao.readItems((Query)getModelPerformanceMatrixQuery);
                for (int i = 0; i < list.size(); ++i) {
                    String string2 = ((NameValue)list.get(i)).getName();
                    BigDecimal bigDecimal = ((NameValue)list.get(i)).getBigDecimalValue();
                    if (PREDICTIVE_CONFIDENCE.equals(string2)) {
                        performanceMetric.setPredConfidence(bigDecimal);
                        continue;
                    }
                    if (AVG_ACCURACY.equals(string2) || MEAN_RMS_ERROR.equals(string2)) {
                        performanceMetric.setAvgAccuracyOrRoorMeanSqrtErr(bigDecimal);
                        continue;
                    }
                    if (ACCURACY.equals(string2) || MEAN_ABSOLUTE_ERROR.equals(string2)) {
                        performanceMetric.setOverallAccuracyOrMeanAbsErr(bigDecimal);
                        continue;
                    }
                    if (COST.equals(string2) || MEAN_PREDICATED_VALUE.equals(string2)) {
                        performanceMetric.setCostOrMeanPredictValue(bigDecimal);
                        if (!(testResult instanceof ClassTestResult) || !(bigDecimal.doubleValue() > 0.0)) continue;
                        this.hasCost = true;
                        continue;
                    }
                    if (MEAN_ACTUAL_VALUE.equals(string2)) {
                        performanceMetric.setMeanActualValue(bigDecimal);
                        continue;
                    }
                    if (!TEST_ROWS.equals(string2)) continue;
                    performanceMetric.setTestRows(bigDecimal);
                }
                performanceMetric.setAlgorithm(testResult.getMiningAlgorithm());
                performanceMetric.setCreationDate(testResult.getCreationTime());
                Integer n = map.get(testResult.getName());
                performanceMetric.setBuildRows(n != null ? BigDecimal.valueOf(n.intValue()) : BigDecimal.valueOf(0L));
                this.metricsList.add(performanceMetric);
            }
            this.performanceTable = new PerformanceTableModel(stringArray, this.metricsList);
            ArrayList arrayList = new ArrayList(this.metricsList.size());
            arrayList.addAll(this.metricsList);
            this.parentTestViewerState.setPerformanceMetrics(arrayList);
        } else {
            List<PerformanceMetric> list = this.parentTestViewerState.getPerformanceMetrics();
            ArrayList<PerformanceMetric> arrayList = new ArrayList<PerformanceMetric>(list.size());
            arrayList.addAll(list);
            this.metricsList = arrayList;
        }
    }

    public GenericBaseTableModel getPerformanceTableModel() {
        return this.performanceTable;
    }

    public GraphDataModel getGraphDataModel() {
        return this.graphDataModel;
    }

    public boolean hasCost() {
        return this.hasCost;
    }

    public static enum Measure {
        PREDICTIVE_CONFIDENCE,
        AVG_ACCURACY,
        OVERALL_ACCURACY,
        COST,
        ROOT_MEAN_SQRT_ERR,
        MEAN_ABS_ERR,
        MEAN_ACTUAL_VALUE,
        MEAN_PREDICTED_VALUE,
        MULTIPLE_SELECTION,
        TEST_ROWS;

    }

    public static enum SortBy {
        MEASURE,
        CREATION_TIME,
        NAME;

    }
}

