/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.partitions;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionTestResult;
import oracle.dmt.dataminer.core.model.common.build.partition.RulesPartitionFilterData;
import oracle.dmt.dataminer.core.model.filter.SortDirection;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.navigator.AbstractTestNode;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNodeUtils;
import oracle.dmt.dataminer.partition.PartitionDetailsPanel;
import oracle.dmt.dataminer.partition.RulesPartitionFilterSortingPanel;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.tviewer.AbstractTestEditor;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorPanel;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.TestViewerPartitionToolbar;
import oracle.dmt.dataminer.tviewer.partitions.ModelPartitionsEditor;
import oracle.dmt.dataminer.tviewer.partitions.ModelPartitionsState;
import oracle.dmt.dataminer.tviewer.partitions.ModelPartitionsTableModel;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ColorIcon;

public class ModelPartitionsPanel
extends DataMinerViewGUI {
    private final ModelPartitionsState state;
    private ModelPartitionsTableModel tableModel;
    private RulesPartitionFilterSortingPanel filterSortingPanel;
    private JPanel jContainer;
    private ButtonGroup jSortGroup;
    private DataMinerTablePanel tablePanel;
    private JButton pinBtn = new JButton();
    private JButton parDetailsBtn = new JButton();
    private JButton modelDetailsBtn = new JButton();
    private JButton resultSelBtn = new JButton();

    public ModelPartitionsPanel(ModelPartitionsEditor modelPartitionsEditor) {
        super(modelPartitionsEditor, modelPartitionsEditor.getContext());
        this.state = new ModelPartitionsState(this.getContext());
        this.state.setSharedTestEditorState(modelPartitionsEditor.getCachedLegendState());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSortGroup = new ButtonGroup();
        this.jContainer = new JPanel();
        this.filterSortingPanel = new RulesPartitionFilterSortingPanel(this.getContext(), this.state.getModels(), true, this.state.isClassification());
        this.tablePanel = new DataMinerTablePanel();
        this.jContainer.setLayout(new BoxLayout(this.jContainer, 1));
        this.jContainer.add(this.filterSortingPanel);
        this.jContainer.add(this.tablePanel);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jContainer, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jContainer, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void initRes() {
        this.pinBtn.setIcon(OracleIcons.getIcon((String)"pin.png"));
        this.parDetailsBtn.setIcon(OracleIcons.getIcon((String)"settings.png"));
        this.modelDetailsBtn.setIcon(DataMinerIcons.get(Icons.PI_ATTR_GROUP_MODEL_VIEW_MODEL_ENA));
        this.resultSelBtn.setIcon(OracleIcons.getIcon((String)"compare.png"));
        this.pinBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_PIN"));
        this.parDetailsBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_DETAILS"));
        this.modelDetailsBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_MODEL_DETAILS"));
        this.resultSelBtn.setToolTipText(TestViewerLrb.get("PARTITION_TEST_RESULT_TOOLBAR_MODEL_SELECTOR"));
    }

    private void initUI() {
        this.pinBtn.setEnabled(false);
        this.parDetailsBtn.setEnabled(false);
        this.modelDetailsBtn.setEnabled(false);
        this.initUIListeners();
        this.initTable();
    }

    private void initUIListeners() {
        this.parDetailsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelPartitionsPanel.this.tablePanel.getTable().getSelectedRowInModel();
                if (n != -1) {
                    PartitionTestResult partitionTestResult = (PartitionTestResult)ModelPartitionsPanel.this.tableModel.getSrcData().get(n);
                    PartitionDetailsPanel partitionDetailsPanel = new PartitionDetailsPanel(partitionTestResult.getPartitionInfo());
                    partitionDetailsPanel.showAsTooltipDialog(ModelPartitionsPanel.this.parDetailsBtn);
                }
            }
        });
        this.pinBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelPartitionsPanel.this.tablePanel.getTable().getSelectedRowInModel();
                if (n != -1) {
                    PartitionTestResult partitionTestResult = (PartitionTestResult)ModelPartitionsPanel.this.tableModel.getSrcData().get(n);
                    AbstractTestNode abstractTestNode = ModelPartitionsPanel.this.state.getParentState().getTestCompareNode();
                    if (abstractTestNode == null) {
                        abstractTestNode = ModelPartitionsPanel.this.state.getParentState().getTestResultNode();
                    }
                    TestViewerPartitionToolbar.pinPartition(abstractTestNode, partitionTestResult.getPartitionInfo());
                    ModelPartitionsPanel.this.tableModel.fireTableDataChanged();
                }
            }
        });
        this.modelDetailsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModelPartitionsPanel.this.tablePanel.getTable().getSelectedRowInModel();
                if (n != -1) {
                    PartitionTestResult partitionTestResult = (PartitionTestResult)ModelPartitionsPanel.this.tableModel.getSrcData().get(n);
                    WorkflowNode workflowNode = WorkflowNode.findParentWorkflowNode(ModelPartitionsPanel.this.getContext());
                    String string = ModelPartitionsPanel.this.state.getDiagramNodeName();
                    BaseTreeNode baseTreeNode = ModelNodeUtils.findModelNode(workflowNode, string, partitionTestResult.getModelName());
                    ModelViewerPartitionToolbar.setSelectedPartitionForModel(baseTreeNode.getLongLabel(), partitionTestResult.getPartitionInfo());
                    EditorUtil.openDefaultEditorInFrame((Node)baseTreeNode);
                }
            }
        });
        this.resultSelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestResultsSelectorPanel testResultsSelectorPanel = new TestResultsSelectorPanel(ModelPartitionsPanel.this.getContext(), ModelPartitionsPanel.this.state.getParentState());
                if (testResultsSelectorPanel.showAsDialog(ModelPartitionsPanel.this)) {
                    List<TestResult> list = testResultsSelectorPanel.getSelectedTestResults();
                    ModelPartitionsPanel.this.state.getParentState().setTestResults(list);
                    String[] stringArray = new String[list.size()];
                    int n = 0;
                    for (TestResult testResult : list) {
                        stringArray[n++] = testResult.getModelName();
                    }
                    ModelPartitionsPanel.this.state.setModels(stringArray);
                    ModelPartitionsPanel.this.query();
                }
            }
        });
        this.filterSortingPanel.getQueryButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelPartitionsPanel.this.query();
            }
        });
    }

    private void initTable() {
        if (this.state.getParentState().getTestCompareNode() != null) {
            this.tablePanel.addControlBarComponents(this.pinBtn, this.parDetailsBtn, this.modelDetailsBtn, this.resultSelBtn);
        } else {
            this.tablePanel.addControlBarComponents(this.pinBtn, this.parDetailsBtn, this.modelDetailsBtn);
        }
        this.tablePanel.getTable().setColumnSelectorAvailable(true);
        this.tablePanel.getTable().getSelectionModel().setSelectionMode(0);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (listSelectionEvent.getFirstIndex() >= 0) {
                    ModelPartitionsPanel.this.pinBtn.setEnabled(true);
                    ModelPartitionsPanel.this.parDetailsBtn.setEnabled(true);
                    ModelPartitionsPanel.this.modelDetailsBtn.setEnabled(true);
                } else {
                    ModelPartitionsPanel.this.pinBtn.setEnabled(false);
                    ModelPartitionsPanel.this.parDetailsBtn.setEnabled(false);
                    ModelPartitionsPanel.this.modelDetailsBtn.setEnabled(false);
                }
            }
        });
    }

    private void setupTable(List<PartitionTestResult> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.state.isClassification()) {
            arrayList.addAll(Arrays.asList(ModelPartitionsTableModel.BASE_COLUMNS_CLASSIFICATION));
        } else {
            arrayList.addAll(Arrays.asList(ModelPartitionsTableModel.BASE_COLUMNS_REGRESSION));
        }
        arrayList.addAll(this.state.getTestResultsColumns());
        this.tableModel = new ModelPartitionsTableModel(arrayList.toArray(new String[arrayList.size()]), list, this.state.isClassification());
        this.tablePanel.setup((TableModel)((Object)this.tableModel), TestViewerLrb.get("PARTITION_TEST_RESULT_TABLE_TITLE"), ModelPartitionsTableModel.SEARCH_COLUMNS, 2);
        DataMinerTable dataMinerTable = this.tablePanel.getTable();
        dataMinerTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = dataMinerTable.getColumnModel();
        if (this.state.isClassification()) {
            this.setupTableClassification(tableColumnModel);
        } else {
            this.setupTableRegression(tableColumnModel);
        }
        this.sortTable();
    }

    private void sortTable() {
        DataMinerTable dataMinerTable = this.tablePanel.getTable();
        RulesPartitionFilterData rulesPartitionFilterData = this.filterSortingPanel.getCurrentFilterData();
        if (rulesPartitionFilterData.getSortColumn() != null) {
            int n = dataMinerTable.getColumnModel().getColumnIndex(rulesPartitionFilterData.getSortColumn().getLabel());
            dataMinerTable.setSortColumn(n, rulesPartitionFilterData.getSortOrder().equals((Object)SortDirection.ASCENDING));
        }
        dataMinerTable.autoSizeColumnsToFit();
    }

    private void updateTableModel(List<PartitionTestResult> list) {
        UITools.setTableModelData(this.tablePanel.getTable(), list);
        this.sortTable();
    }

    private void setupTableClassification(TableColumnModel tableColumnModel) {
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(100.0, true, DecimalFormat.getInstance());
        this.setupTableCommon(tableColumnModel, histogramBarRenderer);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getDateRenderer();
        TableColumn tableColumn = tableColumnModel.getColumn(4);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(5);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(11);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(12);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(10);
        tableColumn.setCellRenderer(tableCellRenderer);
        int n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n - 11];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 11 + i;
        }
        this.tablePanel.getTable().setHiddenColumns(nArray);
    }

    private void setupTableRegression(TableColumnModel tableColumnModel) {
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(100.0, true, DecimalFormat.getInstance());
        this.setupTableCommon(tableColumnModel, histogramBarRenderer);
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getDateRenderer();
        TableColumn tableColumn = tableColumnModel.getColumn(12);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(13);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(11);
        tableColumn.setCellRenderer(tableCellRenderer);
        int n = tableColumnModel.getColumnCount();
        int[] nArray = new int[n - 12];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 12 + i;
        }
        this.tablePanel.getTable().setHiddenColumns(nArray);
    }

    private void setupTableCommon(TableColumnModel tableColumnModel, HistogramBarRenderer histogramBarRenderer) {
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Color color = ModelPartitionsPanel.this.state.getParentState().getTestResultGraphColor(object.toString());
                return new ColorIcon(color);
            }
        }));
        tableColumn = tableColumnModel.getColumn(3);
        tableColumn.setCellRenderer(histogramBarRenderer);
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellRenderer(new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object.equals(TestViewerPartitionToolbar.getPingedPartitionForNode((AbstractTestNode)ModelPartitionsPanel.this.getContext().getNode()))) {
                    return OracleIcons.getIcon((String)"pin.png");
                }
                return null;
            }
        }));
    }

    @Override
    public void load() {
        this.state.setSharedTestEditorState(((AbstractTestEditor)this.getEditor()).getCachedLegendState());
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void query() {
        Query query = new Query();
        query.execute();
    }

    private class LoadUI
    extends ODMrSwingWorker<List<PartitionTestResult>, Void> {
        private LoadUI() {
            super(ModelPartitionsPanel.this, ModelPartitionsPanel.this.overLayPanel, ModelPartitionsPanel.this.tablePanel.getTable());
        }

        @Override
        protected List<PartitionTestResult> doInBackground() throws Exception {
            RulesPartitionFilterData rulesPartitionFilterData = ModelPartitionsPanel.this.filterSortingPanel.getCurrentFilterData();
            return ModelPartitionsPanel.this.state.load(rulesPartitionFilterData);
        }

        @Override
        protected void onSuccess(List<PartitionTestResult> list) throws Exception {
            ModelPartitionsPanel.this.filterSortingPanel.loadPartitionColumns();
            ModelPartitionsPanel.this.setupTable(list);
        }
    }

    private class Query
    extends ODMrSwingWorker<List<PartitionTestResult>, Void> {
        private Query() {
            super(ModelPartitionsPanel.this, ModelPartitionsPanel.this.overLayPanel, ModelPartitionsPanel.this.tablePanel.getTable());
        }

        @Override
        protected List<PartitionTestResult> doInBackground() throws Exception {
            RulesPartitionFilterData rulesPartitionFilterData = ModelPartitionsPanel.this.filterSortingPanel.getCurrentFilterData();
            return ModelPartitionsPanel.this.state.query(rulesPartitionFilterData);
        }

        @Override
        protected void onSuccess(List<PartitionTestResult> list) throws Exception {
            ModelPartitionsPanel.this.updateTableModel(list);
        }
    }
}

