/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.matrix.TargetPair;
import oracle.dmt.dataminer.utils.Formats;

class PMatrixDataProvider
implements BaseCostMatrixDataProvider {
    private int totalValues;
    private int actualNumOfTargets;
    private int colTotalActuals;
    private int colCorrectPercActuals;
    private int colCostActuals;
    private int rowTotalPredicted;
    private int rowCorrectPercPredicted;
    private int rowCostredicted;
    private boolean hideTotals;
    private Object[] targetValues;
    private Object[] targetValuesWithTotalsAndCosts;
    private List[] summaryInfo;
    private Map<TargetPair, BigDecimal> confusionMatrix;
    private NumberFormat integerFormat = Formats.getInteger();
    private NumberFormat numericalFormat = Formats.ModelViewer.getNumeric();
    private NumberFormat percentageFormat = Formats.ModelViewer.getPercentage();

    PMatrixDataProvider(Map<TargetPair, BigDecimal> map, List[] listArray, int n) {
        this.confusionMatrix = map;
        this.summaryInfo = listArray;
        if (this.summaryInfo[0] == null) {
            return;
        }
        this.actualNumOfTargets = this.summaryInfo[0].size();
        this.targetValuesWithTotalsAndCosts = new Object[this.summaryInfo[0].size() + 3];
        this.targetValues = this.summaryInfo[0].toArray();
        this.targetValuesWithTotalsAndCosts = this.summaryInfo[0].toArray(this.targetValuesWithTotalsAndCosts);
        this.targetValuesWithTotalsAndCosts[this.actualNumOfTargets] = TestViewerLrb.get("PMATRIX_TOTAL");
        this.targetValuesWithTotalsAndCosts[this.actualNumOfTargets + 1] = TestViewerLrb.get("PMATRIX_CORRECT_PERC");
        this.targetValuesWithTotalsAndCosts[this.actualNumOfTargets + 2] = TestViewerLrb.get("PMATRIX_COST");
        this.colTotalActuals = this.actualNumOfTargets;
        this.colCorrectPercActuals = this.colTotalActuals + 1;
        this.colCostActuals = this.colCorrectPercActuals + 1;
        this.rowTotalPredicted = this.colTotalActuals;
        this.rowCorrectPercPredicted = this.colCorrectPercActuals;
        this.rowCostredicted = this.colCostActuals;
        this.totalValues = n;
    }

    @Override
    public Object[] getTargetValues() {
        if (this.hideTotals) {
            return this.targetValues;
        }
        return this.targetValuesWithTotalsAndCosts;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n >= this.actualNumOfTargets && n2 >= this.actualNumOfTargets) {
            if (n == this.actualNumOfTargets && n2 == this.actualNumOfTargets) {
                return this.integerFormat.format(this.totalValues);
            }
            return null;
        }
        if (n < this.actualNumOfTargets && n2 < this.actualNumOfTargets) {
            BigDecimal bigDecimal = this.confusionMatrix.get(new TargetPair(this.targetValues[n], this.targetValues[n2]));
            if (bigDecimal == null) {
                return 0;
            }
            return this.integerFormat.format(bigDecimal);
        }
        if (n < this.actualNumOfTargets && n2 >= this.actualNumOfTargets) {
            if (n2 == this.colTotalActuals) {
                Object e = this.summaryInfo[1].get(n);
                if (e == null) {
                    return 0;
                }
                return this.integerFormat.format(e);
            }
            if (n2 == this.colCorrectPercActuals) {
                Object e = this.summaryInfo[5].get(n);
                if (e == null) {
                    return 0;
                }
                return this.percentageFormat.format(e);
            }
            if (n2 == this.colCostActuals) {
                Object e = this.summaryInfo[3].get(n);
                if (e == null) {
                    return e;
                }
                return this.percentageFormat.format(e);
            }
            return null;
        }
        if (n >= this.actualNumOfTargets && n2 < this.actualNumOfTargets) {
            if (n == this.rowTotalPredicted) {
                Object e = this.summaryInfo[2].get(n2);
                if (e == null) {
                    return 0;
                }
                return this.integerFormat.format(e);
            }
            if (n == this.rowCorrectPercPredicted) {
                Object e = this.summaryInfo[6].get(n2);
                if (e == null) {
                    return 0;
                }
                return this.percentageFormat.format(e);
            }
            if (n == this.rowCostredicted) {
                Object e = this.summaryInfo[4].get(n2);
                if (e == null) {
                    return e;
                }
                return this.percentageFormat.format(e);
            }
            return null;
        }
        return 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public int[] getTotalAndCostColumnIndexes() {
        return new int[]{this.colTotalActuals + 1, this.colCorrectPercActuals + 1, this.colCostActuals + 1};
    }

    public int[] getTotalAndCostRowIndexes() {
        return new int[]{this.colTotalActuals, this.colCorrectPercActuals, this.colCostActuals};
    }
}

