/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.aeditor.dialog.DialogsLrb;
import oracle.dmt.dataminer.controls.CheckBoxTableListener;
import oracle.dmt.dataminer.controls.CheckedItemData;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.LabeledCheckBoxRenderer;
import oracle.dmt.dataminer.repository.Result;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestResultsSelectorState;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ColorIcon;

public class TestResultsSelectorPanel
extends DialogDisplayer<AbstractNode> {
    private TestResultsSelectorState state;
    private JLabel jLblCompareTo;
    private JLabel jLblDescription;
    private JLabel jLblSelResultName;
    private JScrollPane jScrollPane1;
    private DataMinerTable table;

    public TestResultsSelectorPanel(Context context, SharedTestEditorState sharedTestEditorState) {
        super(context, null);
        this.state = new TestResultsSelectorState(sharedTestEditorState);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblCompareTo, null, (String)DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_COMPARE_TO"));
        ResourceUtils.resLabel((JLabel)this.jLblDescription, null, (String)DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_HEADER_DESCRIPTION"));
        if (this.state.isInitialMultipleSelection()) {
            this.jLblCompareTo.setVisible(false);
            this.jLblSelResultName.setVisible(false);
        } else {
            ResourceUtils.resLabel((JLabel)this.jLblSelResultName, null, (String)this.state.getSelectedResultName());
        }
    }

    @Override
    public void initUI() {
        CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
        CheckListener checkListener = new CheckListener(checkBoxRenderer);
        this.table.setModel((TableModel)((Object)new TestResultsTableModel(this.state.getLatestCompatibleTestResults())));
        this.table.addMouseListener(checkListener);
        this.table.addKeyListener(checkListener);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(checkBoxRenderer);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(FormatTableCellRenderer.getDateRenderer());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new DataMinerTable();
        this.jLblCompareTo = new JLabel();
        this.jLblSelResultName = new JLabel();
        this.jLblDescription = new JLabel();
        this.jScrollPane1.setViewportView((Component)((Object)this.table));
        this.jLblCompareTo.setText("Compare results relative to:");
        this.jLblSelResultName.setText("Selected Result Name");
        this.jLblDescription.setText("Check the boxes of one or more results to compare");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 420, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblCompareTo).addComponent(this.jLblSelResultName).addComponent(this.jLblDescription)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLblCompareTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLblSelResultName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLblDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 189, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "edit_test_selection_compare";
    }

    public List<TestResult> getSelectedTestResults() {
        return this.state.getSelectedTestResults();
    }

    @Override
    protected boolean doWork() {
        if (this.state.getSelectedTestResults().size() == 0) {
            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_ERROR_MSG"), (String)"", null);
            return false;
        }
        return true;
    }

    private class CheckBoxRenderer
    extends LabeledCheckBoxRenderer {
        @Override
        protected Icon getCellIcon(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ColumnData columnData = (ColumnData)object;
            Result result = (Result)columnData.getData();
            Color color = TestResultsSelectorPanel.this.state.getParentTestViewerState().getTestResultGraphColor(result.getModelName());
            return new ColorIcon(color);
        }
    }

    private class CheckListener
    extends CheckBoxTableListener {
        public CheckListener(LabeledCheckBoxRenderer labeledCheckBoxRenderer) {
            super(labeledCheckBoxRenderer);
        }

        @Override
        protected void itemChecked(int n) {
            TestResultsTableModel testResultsTableModel = (TestResultsTableModel)((Object)TestResultsSelectorPanel.this.table.getModel());
            TestResult testResult = testResultsTableModel.getTestResult(n);
            TestResultsSelectorPanel.this.state.selectTestResult(testResult, true);
        }

        @Override
        public void itemUnchecked(int n) {
            TestResultsTableModel testResultsTableModel = (TestResultsTableModel)((Object)TestResultsSelectorPanel.this.table.getModel());
            TestResult testResult = testResultsTableModel.getTestResult(n);
            TestResultsSelectorPanel.this.state.selectTestResult(testResult, false);
        }
    }

    private class TestResultsTableModel
    extends ODMrTableModel<ColumnData> {
        private static final int RESULT_NAME = 0;
        private static final int BUILT_ON = 1;

        private TestResultsTableModel(List<TestResult> list) {
            super(new String[]{DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TABLE_COL_MODEL"), DialogsLrb.get("COMPARE_TEST_RESULTS_DLG_TABLE_COL_BUILT_ON")});
            this.determineState(list);
        }

        private void determineState(List<TestResult> list) {
            for (TestResult testResult : list) {
                ColumnData columnData = new ColumnData(testResult);
                if (TestResultsSelectorPanel.this.state.isSelected(testResult)) {
                    columnData.setCheckBoxState(TriStateBoolean.TRUE);
                }
                this.srcData.add(columnData);
            }
        }

        private TestResult getTestResult(int n) {
            ColumnData columnData = (ColumnData)this.srcData.get(n);
            TestResult testResult = (TestResult)columnData.getData();
            return testResult;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            ColumnData columnData = (ColumnData)this.srcData.get(n);
            TestResult testResult = (TestResult)columnData.getData();
            Object object = null;
            switch (n2) {
                case 0: {
                    object = columnData;
                    break;
                }
                case 1: {
                    object = testResult.getCreationTime();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private static class ColumnData
    extends CheckedItemData {
        public ColumnData(TestResult testResult) {
            super(testResult);
        }

        @Override
        public String toString() {
            return ((TestResult)this.getData()).toString();
        }
    }
}

