/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.teditor.graph;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.teditor.graph.BarGraphQueryBuilder;
import oracle.dmt.dataminer.teditor.graph.BoxPlotQueryBuilder;
import oracle.dmt.dataminer.teditor.graph.GraphContainerPanel;
import oracle.dmt.dataminer.teditor.graph.GraphLrb;
import oracle.dmt.dataminer.teditor.graph.GraphQueryBuilder;
import oracle.dmt.dataminer.teditor.graph.GraphUtils;
import oracle.dmt.dataminer.teditor.graph.HistogramQueryBuilder;
import oracle.dmt.dataminer.teditor.graph.OdmrGraph;
import oracle.dmt.dataminer.teditor.graph.XYGraphQueryBuilder;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphType;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.LegendTitle;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.ide.Context;
import oracle.javatools.ui.BlockingComponent;

class GraphLoader
extends SwingWorker<Boolean, Object> {
    private static final Logger LOGGER = Logger.getLogger(GraphLoader.class.getName());
    private String graphName;
    private String yAxisLabel;
    private String generatedYAxis;
    private String extraFailureDetails;
    private Context context;
    private Exception exception;
    private BlockingComponent overLayPanel;
    private GraphSettingsType settings;
    private GraphQueryBuilder queryBuilder;
    private GraphContainerPanel graphPanel;
    private List<String> columnTitles;
    private List<Object[]> data;
    private List<Object[]> userReadableData;

    public GraphLoader(Context context, GraphContainerPanel graphContainerPanel, GraphSettingsType graphSettingsType, String string) {
        this.context = context;
        this.graphPanel = graphContainerPanel;
        this.settings = graphSettingsType;
        this.graphName = string;
        this.generatedYAxis = "";
        this.yAxisLabel = "";
        this.data = new ArrayList<Object[]>();
        this.columnTitles = new ArrayList<String>();
        this.userReadableData = new ArrayList<Object[]>();
    }

    public void setBlockingComponent(BlockingComponent blockingComponent) {
        this.overLayPanel = blockingComponent;
    }

    private void addBoxPlotData(List<Object[]> list, ResultSet resultSet, AttributeType attributeType, String string, boolean bl) throws Exception {
        Comparable<Date> comparable;
        Comparable<Double> comparable2;
        Comparable<Double> comparable3;
        Comparable<Double> comparable4;
        Comparable<Double> comparable5;
        Comparable<Double> comparable6;
        Comparable<Double> comparable7;
        if (GraphUtils.isNumericType(attributeType.getDataType())) {
            comparable7 = resultSet.getDouble("min_val");
            comparable6 = resultSet.getDouble("q1_val");
            comparable5 = resultSet.getDouble("median_val");
            comparable4 = resultSet.getDouble("q3_val");
            comparable3 = resultSet.getDouble("max_val");
            comparable2 = resultSet.getDouble("max_step");
            comparable = resultSet.getDouble("min_step");
            list.add(new Object[]{string, "series 1", comparable});
            list.add(new Object[]{string + "1", "series 1", comparable7});
            list.add(new Object[]{string + "2", "series 1", comparable6});
            list.add(new Object[]{string + "3", "series 1", comparable5});
            list.add(new Object[]{string + "4", "series 1", comparable4});
            list.add(new Object[]{string + "5", "series 1", comparable3});
            list.add(new Object[]{string + "6", "series 1", comparable2});
        } else if (attributeType.getDataType().equals("DATE")) {
            comparable7 = resultSet.getDate("min_val");
            comparable6 = resultSet.getDate("q1_val");
            comparable5 = resultSet.getDate("median_val");
            comparable4 = resultSet.getDate("q3_val");
            comparable3 = resultSet.getDate("max_val");
            comparable = resultSet.getDate("min_step");
            comparable2 = resultSet.getDate("max_step");
            list.add(new Object[]{string, "series 1", comparable});
            list.add(new Object[]{string + "1", "series 1", comparable7});
            list.add(new Object[]{string + "2", "series 1", comparable6});
            list.add(new Object[]{string + "3", "series 1", comparable5});
            list.add(new Object[]{string + "4", "series 1", comparable4});
            list.add(new Object[]{string + "5", "series 1", comparable3});
            list.add(new Object[]{string + "6", "series 1", comparable2});
        } else {
            String string2 = "Unexpected date type encountered while processing BOXPLOT graph data";
            LOGGER.severe(string2);
            throw new RuntimeException(string2);
        }
        this.userReadableData.add(this.createUserReadableRow(string, GraphLrb.get("BP_MIN_OUTLIER"), comparable, bl));
        this.userReadableData.add(this.createUserReadableRow(string, GraphLrb.get("BP_MIN"), comparable7, bl));
        this.userReadableData.add(this.createUserReadableRow(string, GraphLrb.get("BP_QUARTILE_1"), comparable6, bl));
        this.userReadableData.add(this.createUserReadableRow(string, GraphLrb.get("BP_MEDIAN"), comparable5, bl));
        this.userReadableData.add(this.createUserReadableRow(string, GraphLrb.get("BP_QUARTILE_3"), comparable4, bl));
        this.userReadableData.add(this.createUserReadableRow(string, GraphLrb.get("BP_MAX"), comparable3, bl));
        this.userReadableData.add(this.createUserReadableRow(string, GraphLrb.get("BP_MAX_OUTLIER"), comparable2, bl));
    }

    private Object[] createUserReadableRow(String string, String string2, Object object, Boolean bl) {
        Object[] objectArray;
        if (bl.booleanValue()) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = string;
            objectArray2[1] = string2;
            objectArray = objectArray2;
            objectArray2[2] = object;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = string2;
            objectArray = objectArray3;
            objectArray3[1] = object;
        }
        Object[] objectArray4 = objectArray;
        return objectArray4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Boolean doInBackground() {
        this.exception = null;
        BaseTreeNode baseTreeNode = (BaseTreeNode)this.context.getNode();
        WorkflowNode workflowNode = (WorkflowNode)baseTreeNode.getParent().getAncestor(WorkflowNode.class);
        WorkflowModel workflowModel = workflowNode.getWorkflowModel();
        if (workflowModel == null) {
            return Boolean.FALSE;
        }
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string = null;
            String string2 = GraphUtils.getSampleTableName(this.context);
            try {
                string = this.composeQuery(this.settings, string2);
            }
            catch (InvalidAttributeException invalidAttributeException) {
                this.extraFailureDetails = invalidAttributeException.getMessage();
                throw invalidAttributeException;
            }
            catch (NoDataFoundException noDataFoundException) {
                this.extraFailureDetails = noDataFoundException.getMessage();
                throw noDataFoundException;
            }
            sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setFetchSize(2000);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            String string3 = "group";
            long l = 0L;
            String string4 = "Default";
            while (sQLHelper.rs.next()) {
                Object object3;
                boolean bl;
                Object object2;
                if (GraphType.BOX_PLOT.equals((Object)this.settings.getType())) {
                    object2 = "";
                    object2 = this.settings.getGroupByOption().isGroupByEnabled() ? sQLHelper.rs.getString("grpByAttr") : this.settings.getXAttribute().getName();
                    this.addBoxPlotData(this.data, sQLHelper.rs, this.settings.getXAttribute(), (String)object2, this.settings.getGroupByOption().isGroupByEnabled());
                    continue;
                }
                object2 = 0.0;
                String string5 = "";
                boolean bl2 = bl = GraphUtils.isNumericType(this.settings.getXAttribute().getDataType()) && !this.settings.getXBinningSettings().isBinningEnabled();
                if (bl) {
                    object2 = sQLHelper.rs.getDouble(this.settings.getXAttribute().getName());
                } else {
                    string5 = sQLHelper.rs.getString(this.settings.getXAttribute().getName());
                }
                if (this.settings.getGroupByOption().isGroupByEnabled()) {
                    string4 = sQLHelper.rs.getString(this.settings.getGroupByOption().getGroupByAttribute().getName());
                }
                if (GraphUtils.isYRequired(this.settings.getType())) {
                    for (Object object3 : this.settings.getYAttributes().getYAttribute()) {
                        Double d = sQLHelper.rs.getDouble(object3.getName());
                        if (this.settings.getGroupByOption().isGroupByEnabled()) {
                            string4 = sQLHelper.rs.getString(this.settings.getGroupByOption().getGroupByAttribute().getName());
                        } else if (this.queryBuilder.isMultiSeries()) {
                            string4 = object3.getName();
                        }
                        if (GraphType.LINE.equals((Object)this.settings.getType()) || GraphType.BAR.equals((Object)this.settings.getType())) {
                            Object object4 = bl ? object2 : string5;
                            Double d2 = d;
                            this.data.add(new Object[]{object4, string4, d2});
                            if (!this.settings.getGroupByOption().isGroupByEnabled()) continue;
                            this.userReadableData.add(new Object[]{string4, object4, d2});
                            continue;
                        }
                        if (!GraphType.SCATTER.equals((Object)this.settings.getType())) continue;
                        double d3 = (Double)object2;
                        double d4 = d;
                        this.data.add(new Object[]{string3 + l++, string4, d3});
                        this.data.add(new Object[]{string3 + l++, string4, d4});
                        this.userReadableData.add(new Object[]{d3, string4, d4});
                    }
                    continue;
                }
                Double d = sQLHelper.rs.getDouble(this.generatedYAxis);
                if (this.settings.getGroupByOption().isGroupByEnabled()) {
                    string4 = sQLHelper.rs.getString(this.settings.getGroupByOption().getGroupByAttribute().getName());
                }
                object3 = bl ? object2 : string5;
                this.data.add(new Object[]{object3, string4, d});
                if (!this.settings.getGroupByOption().isGroupByEnabled()) continue;
                this.userReadableData.add(new Object[]{string4, object3, d});
            }
            boolean bl = false;
            if (GraphType.HISTOGRAM.equals((Object)this.settings.getType()) || GraphType.BAR.equals((Object)this.settings.getType())) {
                if (!this.settings.getGroupByOption().isGroupByEnabled()) {
                    bl = true;
                }
            } else if (GraphType.LINE.equals((Object)this.settings.getType()) || GraphType.HISTOGRAM.equals((Object)this.settings.getType()) || GraphType.BAR.equals((Object)this.settings.getType())) {
                bl = true;
            }
            if (bl) {
                this.userReadableData = this.data;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    protected void done() {
        Object object;
        super.done();
        boolean bl = this.settings.getGroupByOption().isGroupByEnabled();
        final String string = this.settings.getGroupByOption().getGroupByAttribute().getName();
        String string2 = this.settings.getXAttribute().getName();
        OdmrGraph odmrGraph = this.graphPanel.getGraph();
        if (this.graphPanel == null) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
            RuntimeException runtimeException = new RuntimeException("Unexpected state. Graph object is missing.");
            DataMinerEditor.handleEditorException(this.context, runtimeException, GraphLrb.get("LOADER_FAILED_TO_LOAD"), runtimeException.getMessage());
            return;
        }
        try {
            object = (Boolean)this.get();
            if (!((Boolean)object).booleanValue()) {
                odmrGraph.setTabularData(this.data);
                if (this.extraFailureDetails != null) {
                    odmrGraph.setNoDataErrorText(this.extraFailureDetails);
                } else {
                    odmrGraph.setNoDataErrorText(GraphLrb.get("LOADER_FAILED_TO_LOAD"));
                }
                if (this.overLayPanel != null) {
                    this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
                }
                return;
            }
        }
        catch (Exception exception) {
            DataMinerEditor.handleEditorException(this.context, exception, GraphLrb.get("LOADER_FAILED_TO_LOAD"), exception.getMessage());
        }
        if (this.data.isEmpty()) {
            odmrGraph.setNoDataErrorText(GraphLrb.get("LOADER_NO_DATA"));
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
            return;
        }
        this.graphPanel.setGraphData(this.data, this.userReadableData, this.columnTitles);
        odmrGraph.showLegend(bl || this.queryBuilder.isMultiSeries());
        odmrGraph.setLegendScrollbarPresence(1);
        odmrGraph.setMouseActions(5);
        if (GraphType.BOX_PLOT.equals((Object)this.settings.getType())) {
            odmrGraph.setGraphType(102);
            try {
                odmrGraph.getSeries().setMarkerShape(2, 0);
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                DataMinerEditor.handleEditorException(this.context, seriesOutOfRangeException, GraphLrb.get("LOADER_FAILED_TO_LOAD"), seriesOutOfRangeException.getMessage());
            }
            object = "";
            String string3 = "";
            if (bl) {
                object = string;
                string3 = string2;
            }
            odmrGraph.setAxisTitles((String)object, string3);
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
            }
            return;
        }
        odmrGraph.setSeriesEffect(2);
        odmrGraph.setCustomToolTipCallback(new CustomToolTipCallback(){

            public String getToolTipText(String string2, ComponentHandle componentHandle) {
                Object object = componentHandle.getComponent();
                if (object instanceof LegendTitle) {
                    return string;
                }
                return string2;
            }
        });
        object = odmrGraph.getLegendTitle();
        object.setText(bl ? UIResourceHelper.trucateUIStringEnd(string, 15) : "");
        object.setVisible(bl);
        String string4 = "";
        if (!this.queryBuilder.isMultiSeries() && GraphUtils.isYRequired(this.settings.getType())) {
            string4 = GraphType.BAR.equals((Object)this.settings.getType()) ? GraphUtils.getAggregatedAxisName(((AttributeType)this.settings.getYAttributes().getYAttribute().get(0)).getName(), this.settings.getYAttributes().getAggregationFunction()) : ((AttributeType)this.settings.getYAttributes().getYAttribute().get(0)).getName();
        } else if (GraphType.HISTOGRAM.equals((Object)this.settings.getType())) {
            string4 = this.yAxisLabel;
        }
        odmrGraph.setAxisTitles(string2, string4);
        this.graphPanel.enableControlBarButtons();
        if (this.overLayPanel != null) {
            this.overLayPanel.setState(BlockingComponent.State.UNBLOCKED);
        }
        this.queryBuilder = null;
    }

    private String composeQuery(GraphSettingsType graphSettingsType, String string) throws Exception, InvalidAttributeException, NoDataFoundException {
        if (graphSettingsType.getXAttribute().getStatus().equals((Object)AttributeStatus.INVALID)) {
            throw new InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        if (graphSettingsType.getGroupByOption().isGroupByEnabled() && graphSettingsType.getGroupByOption().getGroupByAttribute().getStatus().equals((Object)AttributeStatus.INVALID) && GraphUtils.isDummyGroupByAttr(graphSettingsType.getGroupByOption().getGroupByAttribute())) {
            throw new InvalidAttributeException(GraphLrb.get("INVALID_INPUTS_PRESENT"));
        }
        if (GraphUtils.isMultipleSeriesGraph(graphSettingsType.getType())) {
            this.queryBuilder = XYGraphQueryBuilder.getQueryGraphBuilder(this.context, string, graphSettingsType);
        } else if (graphSettingsType.getType().equals((Object)GraphType.BAR)) {
            this.queryBuilder = BarGraphQueryBuilder.getQueryGraphBuilder(this.context, string, graphSettingsType);
        } else if (graphSettingsType.getType().equals((Object)GraphType.HISTOGRAM)) {
            this.queryBuilder = HistogramQueryBuilder.getQueryGraphBuilder(this.context, string, graphSettingsType);
        } else if (graphSettingsType.getType().equals((Object)GraphType.BOX_PLOT)) {
            this.queryBuilder = BoxPlotQueryBuilder.getQueryGraphBuilder(this.context, string, graphSettingsType);
        }
        if (this.queryBuilder == null) {
            throw new Exception("No query builder created");
        }
        String string2 = this.queryBuilder.buildGraphQuery();
        this.columnTitles = this.queryBuilder.getColumnTitles();
        this.generatedYAxis = this.queryBuilder.getYAttributeName();
        this.yAxisLabel = this.queryBuilder.getYAxisLabel();
        return string2;
    }

    static class InvalidAttributeException
    extends Exception {
        public InvalidAttributeException(String string) {
            super(string);
        }
    }

    static class NoDataFoundException
    extends Exception {
        public NoDataFoundException(String string) {
            super(string);
        }
    }
}

