/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.utils.comparator.ToStringComparator;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsModelType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.javatools.util.Version;

public final class MiningDetailsOutputType
extends Enum<MiningDetailsOutputType> {
    public static final /* enum */ MiningDetailsOutputType RULES = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_RULES"));
    public static final /* enum */ MiningDetailsOutputType RULES_AGGREGATES = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_RULES_AGGREGATES"));
    public static final /* enum */ MiningDetailsOutputType ITEM_SETS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_ITEM_SETS"));
    public static final /* enum */ MiningDetailsOutputType ITEM_SETS_AGGREGATES = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_ITEM_SETS_AGGREGATES"));
    public static final /* enum */ MiningDetailsOutputType FULL_TREE = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_FULL_TREE"));
    public static final /* enum */ MiningDetailsOutputType FULL_TREE_XML = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_FULL_TREE_XML"));
    public static final /* enum */ MiningDetailsOutputType GLOBAL_DETAILS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_GLOBAL_DETAILS"));
    public static final /* enum */ MiningDetailsOutputType LEAF_NODES = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_LEAF_NODES"));
    public static final /* enum */ MiningDetailsOutputType COEFFICIENTS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_COEFFICIENTS"));
    public static final /* enum */ MiningDetailsOutputType ROW_DIAGNOSTICS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_ROW_DIAGNOSTICS"));
    public static final /* enum */ MiningDetailsOutputType PAIR_PROBABILITIES = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_PAIR_PROB"));
    public static final /* enum */ MiningDetailsOutputType ATTRIBUTE_HISTOGRAMS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_ATTRIBUTE_HISTOGRAMS"));
    public static final /* enum */ MiningDetailsOutputType COMPONENTS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_COMPONENTS"));
    public static final /* enum */ MiningDetailsOutputType PROJECTIONS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_PROJECTIONS"));
    public static final /* enum */ MiningDetailsOutputType FEATURES_TRANSACTIONAL = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_NMF_TRANSACTIONAL"));
    public static final /* enum */ MiningDetailsOutputType EIGENVALUES = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_EIGENVALUES"));
    public static final /* enum */ MiningDetailsOutputType SINGULAR_VALUES = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_SINGULAR_VALUES"));
    public static final /* enum */ MiningDetailsOutputType CENTROID = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_CENTROID"));
    public static final /* enum */ MiningDetailsOutputType CENTROID_SCORING = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_CENTROID_SCORING"));
    public static final /* enum */ MiningDetailsOutputType SCORING_SIGNATURE = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_MODEL_SIGNATURE"));
    public static final /* enum */ MiningDetailsOutputType STATISTICS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_STATISTICS"));
    public static final /* enum */ MiningDetailsOutputType COMPONENT_PRIORS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_COMPONENT_PRIORS"));
    public static final /* enum */ MiningDetailsOutputType COMPONENT_CLUSTERS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_COMPONENT_CLUSTERS"));
    public static final /* enum */ MiningDetailsOutputType ATTRIBUTE_GAUSSIAN = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_ATTRIBUTE_GAUSSIAN_DISTRIBUTION"));
    public static final /* enum */ MiningDetailsOutputType COMPONENT_BERNOULLI = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_COMPONENT_BERNOULLI_DISTRIBUTION"));
    public static final /* enum */ MiningDetailsOutputType R_MODEL_DETAILS = new MiningDetailsOutputType(CoreServerConstantsLrb.get((String)"MODEL_DETAILS_OUTPUT_TYPE_R_MODEL_DETAILS"));
    private final String translation;
    private static final Map<String, MiningDetailsOutputType> stringToEnum;
    private static final /* synthetic */ MiningDetailsOutputType[] $VALUES;

    public static MiningDetailsOutputType[] values() {
        return (MiningDetailsOutputType[])$VALUES.clone();
    }

    public static MiningDetailsOutputType valueOf(String string) {
        return Enum.valueOf(MiningDetailsOutputType.class, string);
    }

    private MiningDetailsOutputType(String string2) {
        this.translation = string2;
    }

    public static MiningDetailsOutputType fromString(String string) {
        return stringToEnum.get(string);
    }

    public String toString() {
        return this.translation;
    }

    public static List<MiningDetailsOutputType> getMiningDetailsOutputType(MiningDetailsModelType miningDetailsModelType) {
        ArrayList<MiningDetailsOutputType> arrayList = new ArrayList<MiningDetailsOutputType>();
        if (miningDetailsModelType.equals((Object)MiningDetailsModelType.ANOMALY_DETECTION) || miningDetailsModelType.equals((Object)MiningDetailsModelType.SVM_CLASSIFICATION) || miningDetailsModelType.equals((Object)MiningDetailsModelType.SVM_REGRESSION)) {
            arrayList.add(COEFFICIENTS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.DECISION_TREE)) {
            arrayList.add(FULL_TREE);
            arrayList.add(FULL_TREE_XML);
            arrayList.add(LEAF_NODES);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.GLM_CLASSIFICATION) || miningDetailsModelType.equals((Object)MiningDetailsModelType.GLM_REGRESSION)) {
            arrayList.add(STATISTICS);
            arrayList.add(ROW_DIAGNOSTICS);
            arrayList.add(GLOBAL_DETAILS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.ASSOCIATION)) {
            arrayList.add(RULES);
            arrayList.add(RULES_AGGREGATES);
            arrayList.add(ITEM_SETS);
            arrayList.add(ITEM_SETS_AGGREGATES);
            arrayList.add(GLOBAL_DETAILS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.CLUSTERING)) {
            arrayList.add(FULL_TREE);
            arrayList.add(RULES);
            arrayList.add(ATTRIBUTE_HISTOGRAMS);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.FEATURE_EXTRACTION) || miningDetailsModelType.equals((Object)MiningDetailsModelType.EXPLICIT_SEMANTIC_ANALYSIS)) {
            arrayList.add(FEATURES_TRANSACTIONAL);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.SCORING_MODELS)) {
            arrayList.add(SCORING_SIGNATURE);
        } else if (miningDetailsModelType.equals((Object)MiningDetailsModelType.EM_CLUSTERING)) {
            arrayList.add(FULL_TREE);
            arrayList.add(RULES);
            arrayList.add(COMPONENTS);
            arrayList.add(PROJECTIONS);
            arrayList.add(GLOBAL_DETAILS);
            arrayList.add(ATTRIBUTE_HISTOGRAMS);
            arrayList.add(COMPONENT_CLUSTERS);
            arrayList.add(COMPONENT_PRIORS);
            arrayList.add(ATTRIBUTE_GAUSSIAN);
            arrayList.add(COMPONENT_BERNOULLI);
        } else if (MiningDetailsModelType.R_EXTENSIBLE.equals((Object)miningDetailsModelType)) {
            arrayList.add(R_MODEL_DETAILS);
        }
        Collections.sort(arrayList, ToStringComparator.getComparator());
        return arrayList;
    }

    public static MiningDetailsOutputType getPreferredOutputTypeForModelDetailsNode(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        MiningDetailsOutputType miningDetailsOutputType = null;
        if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SUPPORT_VECTOR_MACHINE)) {
            miningDetailsOutputType = COEFFICIENTS;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NAIVE_BAYES)) {
            miningDetailsOutputType = PAIR_PROBABILITIES;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            miningDetailsOutputType = FULL_TREE;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.GENERALIZED_LINEAR_MODEL)) {
            miningDetailsOutputType = STATISTICS;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.APRIORI)) {
            miningDetailsOutputType = RULES;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.KMEANS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.OCLUSTER) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            miningDetailsOutputType = FULL_TREE;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NON_NEGATIVE_MATRIX_FACTORIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPLICIT_SEMANTIC_ANALYSIS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            miningDetailsOutputType = FEATURES_TRANSACTIONAL;
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION) || miningFunctions.equals((Object)MiningFunctions.REGRESSION))) {
            miningDetailsOutputType = SCORING_SIGNATURE;
        } else if (MiningAlgorithmOptions.R_EXTENSIBLE.equals((Object)miningAlgorithmOptions)) {
            miningDetailsOutputType = R_MODEL_DETAILS;
        }
        return miningDetailsOutputType;
    }

    public static MiningDetailsOutputType[] getMiningDetailsOutputType(Version version, MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        ArrayList<MiningDetailsOutputType> arrayList = new ArrayList<MiningDetailsOutputType>();
        if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SUPPORT_VECTOR_MACHINE) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
            arrayList.add(COEFFICIENTS);
            arrayList.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NAIVE_BAYES)) {
            arrayList.add(PAIR_PROBABILITIES);
            arrayList.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            arrayList.add(FULL_TREE);
            arrayList.add(FULL_TREE_XML);
            arrayList.add(LEAF_NODES);
            arrayList.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.GENERALIZED_LINEAR_MODEL)) {
            arrayList.add(STATISTICS);
            arrayList.add(ROW_DIAGNOSTICS);
            arrayList.add(SCORING_SIGNATURE);
            arrayList.add(GLOBAL_DETAILS);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.APRIORI)) {
            arrayList.add(RULES);
            arrayList.add(RULES_AGGREGATES);
            arrayList.add(ITEM_SETS);
            arrayList.add(ITEM_SETS_AGGREGATES);
            arrayList.add(GLOBAL_DETAILS);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.KMEANS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.OCLUSTER) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            arrayList.add(FULL_TREE);
            arrayList.add(RULES);
            arrayList.add(CENTROID);
            arrayList.add(ATTRIBUTE_HISTOGRAMS);
            arrayList.add(SCORING_SIGNATURE);
            if (MiningAlgorithmOptions.KMEANS.equals((Object)miningAlgorithmOptions) && DbVersionHelper.isDB122Up((Version)version)) {
                arrayList.add(CENTROID_SCORING);
            }
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION)) {
            arrayList.add(FULL_TREE);
            arrayList.add(RULES);
            arrayList.add(CENTROID);
            arrayList.add(COMPONENTS);
            arrayList.add(PROJECTIONS);
            arrayList.add(ATTRIBUTE_HISTOGRAMS);
            arrayList.add(GLOBAL_DETAILS);
            arrayList.add(SCORING_SIGNATURE);
            arrayList.add(COMPONENT_CLUSTERS);
            arrayList.add(COMPONENT_PRIORS);
            arrayList.add(ATTRIBUTE_GAUSSIAN);
            arrayList.add(COMPONENT_BERNOULLI);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.NON_NEGATIVE_MATRIX_FACTORIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION)) {
            arrayList.add(FEATURES_TRANSACTIONAL);
            arrayList.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS)) {
            arrayList.add(FEATURES_TRANSACTIONAL);
            arrayList.add(SCORING_SIGNATURE);
            arrayList.add(GLOBAL_DETAILS);
            arrayList.add(PROJECTIONS);
            arrayList.add(EIGENVALUES);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP)) {
            arrayList.add(FEATURES_TRANSACTIONAL);
            arrayList.add(SCORING_SIGNATURE);
            arrayList.add(GLOBAL_DETAILS);
            arrayList.add(PROJECTIONS);
            arrayList.add(SINGULAR_VALUES);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPLICIT_SEMANTIC_ANALYSIS)) {
            arrayList.add(FEATURES_TRANSACTIONAL);
            arrayList.add(SCORING_SIGNATURE);
        } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.ALL) && (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION) || miningFunctions.equals((Object)MiningFunctions.REGRESSION) || miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION) || miningFunctions.equals((Object)MiningFunctions.CLUSTERING) || miningFunctions.equals((Object)MiningFunctions.FEATURE_EXTRACTION))) {
            arrayList.add(SCORING_SIGNATURE);
        } else if (MiningAlgorithmOptions.R_EXTENSIBLE.equals((Object)miningAlgorithmOptions)) {
            arrayList.add(R_MODEL_DETAILS);
            arrayList.add(SCORING_SIGNATURE);
        }
        Collections.sort(arrayList, ToStringComparator.getComparator());
        return arrayList.toArray(new MiningDetailsOutputType[arrayList.size()]);
    }

    public static MiningDetailsOutputType getMiningDetailsOutputType(ModelDetailType modelDetailType) {
        MiningDetailsOutputType miningDetailsOutputType = null;
        if (modelDetailType == null) {
            return miningDetailsOutputType;
        }
        miningDetailsOutputType = modelDetailType.equals((Object)ModelDetailType.AD_COEFFICIENTS) ? COEFFICIENTS : (modelDetailType.equals((Object)ModelDetailType.AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION) ? ITEM_SETS : (modelDetailType.equals((Object)ModelDetailType.AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION) ? ITEM_SETS_AGGREGATES : (modelDetailType.equals((Object)ModelDetailType.AR_RULES_STRING_VERSION) ? RULES : (modelDetailType.equals((Object)ModelDetailType.AR_RULES_AGGREGATES_STRING_VERSION) ? RULES_AGGREGATES : (modelDetailType.equals((Object)ModelDetailType.CLUSTER_ATTRIBUTE_HISTOGRAMS) ? ATTRIBUTE_HISTOGRAMS : (modelDetailType.equals((Object)ModelDetailType.CLUSTER_DETAILS) ? FULL_TREE : (modelDetailType.equals((Object)ModelDetailType.CLUSTER_RULES) ? RULES : (modelDetailType.equals((Object)ModelDetailType.CENTROIDS) ? CENTROID : (ModelDetailType.CENTROID_SCORING.equals((Object)modelDetailType) ? CENTROID_SCORING : (modelDetailType.equals((Object)ModelDetailType.EM_COMPONENTS) ? COMPONENTS : (modelDetailType.equals((Object)ModelDetailType.EM_PROJECTIONS) ? PROJECTIONS : (modelDetailType.equals((Object)ModelDetailType.EM_CLUSTERS) ? COMPONENT_CLUSTERS : (modelDetailType.equals((Object)ModelDetailType.EM_PRIORS) ? COMPONENT_PRIORS : (modelDetailType.equals((Object)ModelDetailType.EM_GAUSSIAN_DETAILS) ? ATTRIBUTE_GAUSSIAN : (modelDetailType.equals((Object)ModelDetailType.EM_BERNOULLI_DETAILS) ? COMPONENT_BERNOULLI : (modelDetailType.equals((Object)ModelDetailType.DT_FULL_TREE) ? FULL_TREE : (modelDetailType.equals((Object)ModelDetailType.DT_FULL_TREE_XML_VERSION) ? FULL_TREE_XML : (modelDetailType.equals((Object)ModelDetailType.DT_LEAF_NODES_ONLY) ? LEAF_NODES : (modelDetailType.equals((Object)ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS) ? STATISTICS : (modelDetailType.equals((Object)ModelDetailType.GLMC_ROW_DIAGNOSTICS) ? ROW_DIAGNOSTICS : (modelDetailType.equals((Object)ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS) ? STATISTICS : (modelDetailType.equals((Object)ModelDetailType.GLMR_ROW_DIAGNOSTICS) ? ROW_DIAGNOSTICS : (modelDetailType.equals((Object)ModelDetailType.MODEL_SIGNATURE) ? SCORING_SIGNATURE : (modelDetailType.equals((Object)ModelDetailType.NB_PAIR_PROBABILITIES) ? PAIR_PROBABILITIES : (modelDetailType.equals((Object)ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION) ? FEATURES_TRANSACTIONAL : (modelDetailType.equals((Object)ModelDetailType.PCA_EIGENVALUES) ? EIGENVALUES : (modelDetailType.equals((Object)ModelDetailType.SVD_SINGULAR_VALUES) ? SINGULAR_VALUES : (modelDetailType.equals((Object)ModelDetailType.FEATURE_PROJECTIONS) ? PROJECTIONS : (modelDetailType.equals((Object)ModelDetailType.SVMC_COEFFICIENTS) ? COEFFICIENTS : (modelDetailType.equals((Object)ModelDetailType.SVMR_COEFFICIENTS) ? COEFFICIENTS : (modelDetailType.equals((Object)ModelDetailType.GLOBAL_DETAILS) ? GLOBAL_DETAILS : (modelDetailType.equals((Object)ModelDetailType.R_MODEL_DETAILS) ? R_MODEL_DETAILS : null))))))))))))))))))))))))))))))));
        return miningDetailsOutputType;
    }

    public static List<MiningAlgorithmType> getMiningAlgorithms(ModelDetailType modelDetailType) {
        ArrayList<MiningAlgorithmType> arrayList = new ArrayList<MiningAlgorithmType>();
        if (modelDetailType == null) {
            return arrayList;
        }
        switch (modelDetailType) {
            case AR_FREQUENT_ITEM_SETS_DM_ITEM_VERSION: 
            case AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION: 
            case AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION: 
            case AR_RULES_DM_PREDICATE_VERSION: 
            case AR_RULES_STRING_VERSION: 
            case AR_RULES_AGGREGATES_STRING_VERSION: {
                arrayList.add(MiningAlgorithmType.APRIORI_ASSOCIATION_RULES);
                break;
            }
            case CLUSTER_ALL: 
            case CLUSTER_ATTRIBUTE_HISTOGRAMS: 
            case CLUSTER_DETAILS: 
            case CLUSTER_RULES: 
            case CENTROIDS: {
                arrayList.add(MiningAlgorithmType.KMEANS);
                arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
                arrayList.add(MiningAlgorithmType.O_CLUSTER);
                break;
            }
            case CENTROID_SCORING: {
                arrayList.add(MiningAlgorithmType.KMEANS);
                break;
            }
            case EM_COMPONENTS: 
            case EM_PROJECTIONS: 
            case EM_CLUSTERS: 
            case EM_PRIORS: 
            case EM_GAUSSIAN_DETAILS: 
            case EM_BERNOULLI_DETAILS: {
                arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
                break;
            }
            case DT_FULL_TREE: 
            case DT_FULL_TREE_XML_VERSION: 
            case DT_LEAF_NODES_ONLY: 
            case DT_LEAF_NODES_ONLY_PROFILE_VERSION: {
                arrayList.add(MiningAlgorithmType.DECISION_TREE);
                break;
            }
            case GLMC_COEFFICIENTS_AND_STATISTICS: 
            case GLMC_ROW_DIAGNOSTICS: 
            case GLMR_COEFFICIENTS_AND_STATISTICS: 
            case GLMR_ROW_DIAGNOSTICS: {
                arrayList.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
                break;
            }
            case MODEL_SIGNATURE: {
                arrayList.add(MiningAlgorithmType.DECISION_TREE);
                arrayList.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
                arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
                arrayList.add(MiningAlgorithmType.KMEANS);
                arrayList.add(MiningAlgorithmType.O_CLUSTER);
                arrayList.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
                arrayList.add(MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR);
                arrayList.add(MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS);
                arrayList.add(MiningAlgorithmType.SINGULAR_VALUE_DECOMP);
                arrayList.add(MiningAlgorithmType.NAIVE_BAYES);
                arrayList.add(MiningAlgorithmType.EXPLICIT_SEMANTIC_ANALYSIS);
                arrayList.add(MiningAlgorithmType.R_EXTENSIBLE);
                break;
            }
            case NB_PAIR_PROBABILITIES: {
                arrayList.add(MiningAlgorithmType.NAIVE_BAYES);
                break;
            }
            case NMF_DETAILS_TRANSACTIONAL_VERSION: {
                arrayList.add(MiningAlgorithmType.NONNEGATIVE_MATRIX_FACTOR);
                arrayList.add(MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS);
                arrayList.add(MiningAlgorithmType.SINGULAR_VALUE_DECOMP);
                arrayList.add(MiningAlgorithmType.EXPLICIT_SEMANTIC_ANALYSIS);
                break;
            }
            case PCA_EIGENVALUES: {
                arrayList.add(MiningAlgorithmType.PRINCIPAL_COMPONENT_ANALYSIS);
                break;
            }
            case SVD_SINGULAR_VALUES: {
                arrayList.add(MiningAlgorithmType.SINGULAR_VALUE_DECOMP);
                break;
            }
            case AD_COEFFICIENTS: 
            case SVMC_COEFFICIENTS: 
            case SVMR_COEFFICIENTS: {
                arrayList.add(MiningAlgorithmType.SUPPORT_VECTOR_MACHINES);
                break;
            }
            case GLOBAL_DETAILS: {
                arrayList.add(MiningAlgorithmType.GENERALIZED_LINEAR_MODEL);
                arrayList.add(MiningAlgorithmType.EXPECTATION_MAXIMIZATION);
                arrayList.add(MiningAlgorithmType.APRIORI_ASSOCIATION_RULES);
                break;
            }
            default: {
                assert (false) : "Invalid option";
                break;
            }
        }
        return arrayList;
    }

    public static ModelDetailType getMiningDetailType(MiningDetailsOutputType miningDetailsOutputType, MiningAlgorithmOptions miningAlgorithmOptions, MiningFunctions miningFunctions) {
        ModelDetailType modelDetailType = null;
        if (miningDetailsOutputType.equals((Object)ATTRIBUTE_HISTOGRAMS)) {
            modelDetailType = ModelDetailType.CLUSTER_ATTRIBUTE_HISTOGRAMS;
        } else if (miningDetailsOutputType.equals((Object)RULES) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            modelDetailType = ModelDetailType.CLUSTER_RULES;
        } else if (miningDetailsOutputType.equals((Object)FULL_TREE) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            modelDetailType = ModelDetailType.CLUSTER_DETAILS;
        } else if (miningDetailsOutputType.equals((Object)CENTROID) && miningFunctions.equals((Object)MiningFunctions.CLUSTERING)) {
            modelDetailType = ModelDetailType.CENTROIDS;
        } else if (CENTROID_SCORING.equals((Object)miningDetailsOutputType) && MiningFunctions.CLUSTERING.equals((Object)miningFunctions)) {
            modelDetailType = ModelDetailType.CENTROID_SCORING;
        } else if (miningDetailsOutputType.equals((Object)COMPONENTS)) {
            modelDetailType = ModelDetailType.EM_COMPONENTS;
        } else if (miningDetailsOutputType.equals((Object)PROJECTIONS) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION)) {
            modelDetailType = ModelDetailType.EM_PROJECTIONS;
        } else if (miningDetailsOutputType.equals((Object)COMPONENT_CLUSTERS)) {
            modelDetailType = ModelDetailType.EM_CLUSTERS;
        } else if (miningDetailsOutputType.equals((Object)COMPONENT_PRIORS)) {
            modelDetailType = ModelDetailType.EM_PRIORS;
        } else if (miningDetailsOutputType.equals((Object)ATTRIBUTE_GAUSSIAN)) {
            modelDetailType = ModelDetailType.EM_GAUSSIAN_DETAILS;
        } else if (miningDetailsOutputType.equals((Object)COMPONENT_BERNOULLI)) {
            modelDetailType = ModelDetailType.EM_BERNOULLI_DETAILS;
        } else if (miningDetailsOutputType.equals((Object)PROJECTIONS) && (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP))) {
            modelDetailType = ModelDetailType.FEATURE_PROJECTIONS;
        } else if (miningDetailsOutputType.equals((Object)COEFFICIENTS) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SUPPORT_VECTOR_MACHINE)) {
            if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
                modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
            } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
                modelDetailType = ModelDetailType.SVMR_COEFFICIENTS;
            } else if (miningFunctions.equals((Object)MiningFunctions.ANOMALY_DETECTION)) {
                modelDetailType = ModelDetailType.SVMC_COEFFICIENTS;
            }
        } else if (miningDetailsOutputType.equals((Object)FEATURES_TRANSACTIONAL)) {
            modelDetailType = ModelDetailType.NMF_DETAILS_TRANSACTIONAL_VERSION;
        } else if (miningDetailsOutputType.equals((Object)SINGULAR_VALUES)) {
            modelDetailType = ModelDetailType.SVD_SINGULAR_VALUES;
        } else if (miningDetailsOutputType.equals((Object)EIGENVALUES)) {
            modelDetailType = ModelDetailType.PCA_EIGENVALUES;
        } else if (miningDetailsOutputType.equals((Object)FULL_TREE) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            modelDetailType = ModelDetailType.DT_FULL_TREE;
        } else if (miningDetailsOutputType.equals((Object)FULL_TREE_XML) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            modelDetailType = ModelDetailType.DT_FULL_TREE_XML_VERSION;
        } else if (miningDetailsOutputType.equals((Object)LEAF_NODES) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.DECISION_TREE)) {
            modelDetailType = ModelDetailType.DT_LEAF_NODES_ONLY;
        } else if (miningDetailsOutputType.equals((Object)ITEM_SETS)) {
            modelDetailType = ModelDetailType.AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION;
        } else if (miningDetailsOutputType.equals((Object)ITEM_SETS_AGGREGATES)) {
            modelDetailType = ModelDetailType.AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION;
        } else if (miningDetailsOutputType.equals((Object)PAIR_PROBABILITIES)) {
            modelDetailType = ModelDetailType.NB_PAIR_PROBABILITIES;
        } else if (miningDetailsOutputType.equals((Object)ROW_DIAGNOSTICS)) {
            if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
                modelDetailType = ModelDetailType.GLMC_ROW_DIAGNOSTICS;
            } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
                modelDetailType = ModelDetailType.GLMR_ROW_DIAGNOSTICS;
            }
        } else if (miningDetailsOutputType.equals((Object)RULES)) {
            modelDetailType = ModelDetailType.AR_RULES_STRING_VERSION;
        } else if (miningDetailsOutputType.equals((Object)RULES_AGGREGATES)) {
            modelDetailType = ModelDetailType.AR_RULES_AGGREGATES_STRING_VERSION;
        } else if (miningDetailsOutputType.equals((Object)SCORING_SIGNATURE)) {
            modelDetailType = ModelDetailType.MODEL_SIGNATURE;
        } else if (miningDetailsOutputType.equals((Object)STATISTICS)) {
            if (miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION)) {
                modelDetailType = ModelDetailType.GLMC_COEFFICIENTS_AND_STATISTICS;
            } else if (miningFunctions.equals((Object)MiningFunctions.REGRESSION)) {
                modelDetailType = ModelDetailType.GLMR_COEFFICIENTS_AND_STATISTICS;
            }
        } else if (miningDetailsOutputType.equals((Object)GLOBAL_DETAILS)) {
            if ((miningFunctions.equals((Object)MiningFunctions.CLASSIFICATION) || miningFunctions.equals((Object)MiningFunctions.REGRESSION)) && miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.GENERALIZED_LINEAR_MODEL)) {
                modelDetailType = ModelDetailType.GLOBAL_DETAILS;
            } else if (miningFunctions.equals((Object)MiningFunctions.ASSOCIATION_RULES)) {
                modelDetailType = ModelDetailType.GLOBAL_DETAILS;
            } else if (miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.EXPECTATION_MAXIMIZATION) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.SINGULAR_VALUE_DECOMP) || miningAlgorithmOptions.equals((Object)MiningAlgorithmOptions.PRINCIPAL_COMPONENT_ANALYSIS)) {
                modelDetailType = ModelDetailType.GLOBAL_DETAILS;
            }
        } else if (R_MODEL_DETAILS.equals((Object)miningDetailsOutputType)) {
            modelDetailType = ModelDetailType.R_MODEL_DETAILS;
        }
        return modelDetailType;
    }

    private static /* synthetic */ MiningDetailsOutputType[] $values() {
        return new MiningDetailsOutputType[]{RULES, RULES_AGGREGATES, ITEM_SETS, ITEM_SETS_AGGREGATES, FULL_TREE, FULL_TREE_XML, GLOBAL_DETAILS, LEAF_NODES, COEFFICIENTS, ROW_DIAGNOSTICS, PAIR_PROBABILITIES, ATTRIBUTE_HISTOGRAMS, COMPONENTS, PROJECTIONS, FEATURES_TRANSACTIONAL, EIGENVALUES, SINGULAR_VALUES, CENTROID, CENTROID_SCORING, SCORING_SIGNATURE, STATISTICS, COMPONENT_PRIORS, COMPONENT_CLUSTERS, ATTRIBUTE_GAUSSIAN, COMPONENT_BERNOULLI, R_MODEL_DETAILS};
    }

    static {
        $VALUES = MiningDetailsOutputType.$values();
        stringToEnum = new HashMap<String, MiningDetailsOutputType>();
        for (MiningDetailsOutputType miningDetailsOutputType : MiningDetailsOutputType.values()) {
            stringToEnum.put(miningDetailsOutputType.toString(), miningDetailsOutputType);
        }
    }
}

