/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.repository.WorkflowJobNode;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OracleResultSet;

public final class WorkflowJob {
    private static final String QUERY = "SELECT a.PROJECT_ID, a.PROJECT_NAME, a.WORKFLOW_ID, a.WORKFLOW_NAME, a.STATUS, a.JOB_SUBMITTED_TIME,\n  CASE WHEN a.JOB_STEPS_TOTAL IS NOT NULL\n       THEN TRUNC(a.JOB_STEPS_COMPLETED/a.JOB_STEPS_TOTAL*100)\n       ELSE 0 END \"PERCENT_PROGRESS\",\n  b.RUNNING_NODES, b.COMPLETED_NODES\nFROM ODMR_USER_PROJECT_WORKFLOW2 a, ODMR_USER_RUNNING_WORKFLOW b\nWHERE a.JOB_SUBMITTED_TIME > systimestamp - NUMTODSINTERVAL(?, 'HOUR' )  -- for example, jobs submitted in last 12 hours\nAND a.LAST_JOB_ID=b.JOB_NAME (+)";
    private static final Logger LOGGER = Logger.getLogger(WorkflowJob.class.getName());
    private BigDecimal workflowId;
    private String workflowName;
    private String projectName;
    private BigDecimal projectId;
    private Timestamp startTime;
    private String activityState;
    private Integer progress;
    private HashMap<String, WorkflowJobNode> nodes = new HashMap();
    private boolean hasFailedSteps = false;
    public static final String WORKFLOW_JOBS_TABLE = "odmr_user_workflow_jobs";
    public static final String WORKFLOW_NAME = "WORKFLOW_NAME";
    public static final String WORKFLOW_ID = "WORKFLOW_ID";
    public static final String WORKFLOW_STATUS = "STATUS";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String PERCENT_PROGRESS = "PERCENT_PROGRESS";
    public static final String RUNNING_NODES = "RUNNING_NODES";
    public static final String COMPLETED_NODES = "COMPLETED_NODES";
    public static final String JOB_SUBMITTED_TIME = "JOB_SUBMITTED_TIME";
    public static final String WORKFLOW_JOB_NODES_TABLE = "odmr_user_workflow_running";
    public static final String NODE_ID = "NODE_ID";
    public static final String NODE_STATUS = "NODE_STATUS";
    public static final String SUBNODE_ID = "SUBNODE_ID";
    public static final String SUBNODE_STATUS = "SUBNODE_STATUS";
    public static final String NODE_START_TIME = "NODE_START_TIME";
    public static final String NODE_RUN_TIME = "NODE_RUN_TIME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<BigDecimal, WorkflowJob> getJobs2(Connection connection, long l) throws SQLException {
        HashMap<BigDecimal, WorkflowJob> hashMap = new HashMap<BigDecimal, WorkflowJob>();
        String string = QUERY;
        try (SQLHelper sQLHelper = new SQLHelper();){
            Connection connection2 = connection;
            synchronized (connection2) {
                if (connection.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
                sQLHelper.pstmt = connection.prepareStatement(string);
                sQLHelper.pstmt.setLong(1, l);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                while (sQLHelper.ors.next()) {
                    WorkflowJobNode workflowJobNode;
                    BigDecimal bigDecimal = sQLHelper.ors.getBigDecimal(WORKFLOW_ID);
                    WorkflowJob workflowJob = (WorkflowJob)hashMap.get(bigDecimal);
                    if (workflowJob == null) {
                        workflowJob = new WorkflowJob();
                        hashMap.put(bigDecimal, workflowJob);
                    }
                    workflowJob.setState(sQLHelper.ors.getString(WORKFLOW_STATUS));
                    workflowJob.setStartTime(sQLHelper.ors.getTimestamp(JOB_SUBMITTED_TIME));
                    workflowJob.setProjectId(sQLHelper.ors.getBigDecimal(PROJECT_ID));
                    workflowJob.setProjectName(sQLHelper.ors.getString(PROJECT_NAME));
                    workflowJob.setProgress(sQLHelper.ors.getInt(PERCENT_PROGRESS));
                    workflowJob.setWorkflowId(bigDecimal);
                    workflowJob.setWorkflowName(sQLHelper.ors.getString(WORKFLOW_NAME));
                    String[] stringArray = new String[]{};
                    String[] stringArray2 = new String[]{};
                    String string2 = sQLHelper.ors.getString(RUNNING_NODES);
                    String string3 = sQLHelper.ors.getString(COMPLETED_NODES);
                    if (string2 != null) {
                        stringArray = string2.split("\\ ");
                    }
                    if (string3 != null) {
                        stringArray2 = string3.split("\\ ");
                    }
                    for (String string4 : stringArray) {
                        workflowJobNode = workflowJob.getNode(string4);
                        if (null == workflowJobNode) {
                            workflowJobNode = workflowJob.createAndAddNode(string4);
                        }
                        workflowJobNode.setState("RUNNING");
                    }
                    for (String string4 : stringArray2) {
                        workflowJobNode = workflowJob.getNode(string4);
                        if (null == workflowJobNode) {
                            workflowJobNode = workflowJob.createAndAddNode(string4);
                        }
                        workflowJobNode.setState("SUCCEEDED");
                    }
                    LOGGER.log(Level.FINEST, "WorkflowJob - Status: " + workflowJob.getState() + " Completed: " + string3 + " Running: " + string2);
                }
            }
        }
        return hashMap;
    }

    public boolean getHasFailedSteps() {
        return this.getState().equals("FAILED") || this.getState().equals("STOPPED");
    }

    public boolean equalsStateOf(WorkflowJob workflowJob) {
        boolean bl;
        boolean bl2 = workflowJob.getState() != null ? this.getState() == null : (bl = this.getState() != null);
        if (bl) {
            LOGGER.log(Level.FINEST, "RunItem: Job state diff: getState() != null check");
            return false;
        }
        if (workflowJob.getState() != null && this.getState() != null && !this.getState().equals(workflowJob.getState())) {
            LOGGER.log(Level.FINEST, "RunItem: Job state diff: state change check");
            return false;
        }
        if (workflowJob.getHasFailedSteps() != this.getHasFailedSteps()) {
            LOGGER.log(Level.FINEST, "RunItem: Job state diff: failed steps check");
            return false;
        }
        if (!this.compareNodes(workflowJob.getNodes())) {
            LOGGER.log(Level.FINEST, "RunItem: Job state diff: node diff check");
            return false;
        }
        return true;
    }

    public boolean isJobFinished() {
        boolean bl = false;
        if (this.getState().equals("STOPPED") || this.getState().equals("FAILED") || this.getState().equals("SUCCEEDED")) {
            LOGGER.log(Level.FINEST, "Job finished - its state is: " + this.getState());
            bl = true;
        }
        return bl;
    }

    public boolean isRunning() {
        return this.getState().equals("INACTIVE") || this.getState().equals("RUNNING") || this.getState().equals("STOPPING");
    }

    public boolean isScheduled() {
        return this.getState().equals("SCHEDULED");
    }

    private boolean compareNodes(Map<String, WorkflowJobNode> map) {
        boolean bl = true;
        if (map.isEmpty()) {
            return true;
        }
        HashMap<String, WorkflowJobNode> hashMap = this.getNodes();
        if (hashMap.values().size() != map.values().size()) {
            LOGGER.log(Level.FINEST, "New job has a different node count than in cached job");
            return false;
        }
        Iterator<Map.Entry<String, WorkflowJobNode>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            WorkflowJobNode workflowJobNode = iterator.next().getValue();
            WorkflowJobNode workflowJobNode2 = (WorkflowJobNode)hashMap.get(workflowJobNode.getId());
            if (workflowJobNode2 == null) {
                LOGGER.log(Level.FINEST, "New node present in new job but not in cached job");
                bl = false;
                break;
            }
            if (workflowJobNode2.getState().equals(workflowJobNode.getState())) continue;
            LOGGER.log(Level.FINEST, "Node states differ between cached job and latest job");
            bl = false;
            break;
        }
        return bl;
    }

    public void setWorkflowId(BigDecimal bigDecimal) {
        this.workflowId = bigDecimal;
    }

    public BigDecimal getWorkflowId() {
        return this.workflowId;
    }

    public void setProjectId(BigDecimal bigDecimal) {
        this.projectId = bigDecimal;
    }

    public BigDecimal getProjectId() {
        return this.projectId;
    }

    public void setStartTime(Timestamp timestamp) {
        this.startTime = timestamp;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setState(String string) {
        this.activityState = string;
    }

    public String getState() {
        return this.activityState;
    }

    public void addNode(WorkflowJobNode workflowJobNode) {
        this.nodes.put(workflowJobNode.getId(), workflowJobNode);
    }

    public WorkflowJobNode createAndAddNode(String string) {
        WorkflowJobNode workflowJobNode = new WorkflowJobNode();
        workflowJobNode.setId(string);
        workflowJobNode.setWorkflowId(this.getWorkflowId());
        workflowJobNode.setWorkflowName(this.getWorkflowName());
        workflowJobNode.setProjectName(this.getProjectName());
        this.addNode(workflowJobNode);
        return workflowJobNode;
    }

    public HashMap<String, WorkflowJobNode> getNodes() {
        return this.nodes;
    }

    public WorkflowJobNode getNode(String string) {
        return this.getNodes().get(string);
    }

    public void setWorkflowName(String string) {
        this.workflowName = string;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String toString() {
        String string = this.getState();
        if (string.equals("INACTIVE")) {
            if (this.getHasFailedSteps()) {
                return RunManagerLrb.get("JOB_FAILED");
            }
            return RunManagerLrb.get("JOB_SUCCESS");
        }
        if (string.equals("SUCCEEDED")) {
            return RunManagerLrb.get("JOB_SUCCESS");
        }
        if (string.equals("QUEUED")) {
            return RunManagerLrb.get("STATUS_INITIALIZING");
        }
        if (string.equals("STOPPING")) {
            return RunManagerLrb.get("STATUS_STOPPING");
        }
        if (string.equals("RUNNING")) {
            return "";
        }
        if (string.equals("FAILED")) {
            return RunManagerLrb.get("JOB_FAILED");
        }
        if (string.equals("STOPPED")) {
            return RunManagerLrb.get("STATUS_CANCELLED");
        }
        if (string.equals("SCHEDULED")) {
            return RunManagerLrb.get("STATUS_SCHEDULED");
        }
        return "";
    }

    public final void setProgress(Integer n) {
        this.progress = n;
    }

    public final Integer getProgress() {
        return this.progress;
    }
}

