/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.core.dal.sql.ReusableConnection;
import oracle.dmt.dataminer.core.model.generated.server.OdmrNodeReferenceSet;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectNames;
import oracle.dmt.dataminer.core.model.generated.server.OdmrWorkflow;
import oracle.dmt.dataminer.core.utils.ConfigUtils;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.LoadableRepositoryObject;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.WorkflowProcess;
import oracle.sql.CLOB;
import oracle.xdb.XMLType;
import org.w3c.dom.Document;

public class Workflow
extends LoadableRepositoryObject {
    private static final Logger theLogger = Logger.getLogger(Workflow.class.getName());
    private WorkflowProcess wfp;
    private boolean readOnly = false;
    private static volatile JAXBContext jaxbContext;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;
    private static String STANDARD_NLS_NUMERIC;
    public static final boolean REMOTE_DEBUG_ALL_SW = false;
    public static final boolean REMOTE_DEBUG_RUN_SW = false;
    public static final boolean REMOTE_DEBUG_SAVE_SW = false;
    public static final boolean REMOTE_DEBUG_RENAME_SW = false;
    public static final boolean REMOTE_DEBUG_LOAD_SW = false;
    public static final boolean REMOTE_DEBUG_UNLOCK_SW = false;
    public static final boolean REMOTE_DEBUG_DELETE_SW = false;
    public static final boolean REMOTE_DEBUG_CREATE_SW = false;
    public static final boolean REMOTE_DEBUG_CANCEL_SW = false;
    private static final String REMOTE_DEBUG_HOST = "XX.XXX.XXX.XXX";
    private static final String REMOTE_DEBUG_PORT = "4000";
    public static final String WORKFLOW_ID = "WORKFLOW_ID";
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String WORKFLOW_NAME = "WORKFLOW_NAME";
    public static final String WORKFLOW_DATA = "WORKFLOW_DATA";
    public static final String WF_CREATION_TIME = "WF_CREATION_TIME";
    public static final String STATUS = "STATUS";
    public static final String ODMR_USER_PROJECT_WORKFLOW = "ODMR_USER_PROJECT_WORKFLOW";
    public static final int NAME_MAX_LENGTH = 30;
    public static final int COMMENT_MAX_LENGTH = 4000;

    public Workflow(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        super(string, bigDecimal, bigDecimal2);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        unmarshaller = Workflow.getJAXBContextInstance().createUnmarshaller();
        return unmarshaller;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        marshaller = Workflow.getJAXBContextInstance().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        return marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JAXBContext getJAXBContextInstance() throws JAXBException {
        if (jaxbContext != null) return jaxbContext;
        Class<Workflow> clazz = Workflow.class;
        synchronized (Workflow.class) {
            if (jaxbContext != null) return jaxbContext;
            try {
                Workflow.class.getClassLoader().loadClass("oracle.dmt.dataminer.workflow.xmlschema.package-info");
            }
            catch (ClassNotFoundException classNotFoundException) {
                theLogger.log(Level.WARNING, classNotFoundException.getMessage(), classNotFoundException);
            }
            jaxbContext = JAXBContext.newInstance((String)"oracle.dmt.dataminer.workflow.xmlschema", (ClassLoader)Workflow.class.getClassLoader());
            // ** MonitorExit[var0] (shouldn't be in output)
            return jaxbContext;
        }
    }

    @Override
    public void load(ConnectionManager connectionManager) throws Exception {
        throw new Exception("Please use appropriate load() method");
    }

    public Timestamp loadReadLock(Connection connection, Timestamp timestamp) throws SQLException, JAXBException {
        return this.load(connection, timestamp, false, false, 0, 0);
    }

    public Timestamp loadWriteLockWithRetry(Connection connection, Timestamp timestamp, int n, int n2) throws SQLException, JAXBException {
        return this.load(connection, timestamp, true, true, n, n2);
    }

    public Timestamp loadWriteLock(Connection connection, Timestamp timestamp) throws SQLException, JAXBException {
        return this.load(connection, timestamp, true, false, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp load(Connection connection, Timestamp timestamp, boolean bl, boolean bl2, int n, int n2) throws SQLException, JAXBException {
        OdmrWorkflow odmrWorkflow = null;
        Timestamp[] timestampArray = null;
        Boolean bl3 = bl && bl2;
        try {
            String[] stringArray;
            odmrWorkflow = new OdmrWorkflow(connection);
            if (bl) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "W";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "R";
            }
            String[] stringArray4 = stringArray;
            timestampArray = new Timestamp[]{timestamp};
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            CLOB cLOB = odmrWorkflow.wfLoad(this.getId(), stringArray4, timestampArray);
            Reader reader = cLOB.getCharacterStream();
            if (stringArray4[0].getBytes()[0] == 82 && bl) {
                theLogger.log(Level.WARNING, "Unable to get a write lock, retrying");
                int n3 = 1;
                while (bl3.booleanValue()) {
                    try {
                        Thread.sleep(n2);
                        stringArray4 = new String[]{"W"};
                        cLOB = odmrWorkflow.wfLoad(this.getId(), stringArray4, timestampArray);
                        if (stringArray4[0].getBytes()[0] == 82) {
                            if (n3 >= n) {
                                bl3 = false;
                                theLogger.log(Level.SEVERE, "Failed to get a write lock, retry limit exceeded, read-only lock established");
                                continue;
                            }
                            ++n3;
                            theLogger.log(Level.INFO, "Failed to get a write lock, retry");
                            continue;
                        }
                        theLogger.log(Level.INFO, "Retry successful, write lock established");
                        bl3 = false;
                    }
                    catch (InterruptedException interruptedException) {
                        theLogger.log(Level.WARNING, interruptedException.getMessage(), interruptedException);
                    }
                }
            }
            this.setReadOnly(stringArray4[0].getBytes()[0] == 82);
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            this.wfp = (WorkflowProcess)unmarshaller.unmarshal(reader);
            this.setLoaded(true);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return timestampArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(Connection connection, String string, String string2) throws SQLException {
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfRename(this.getId(), string, string2);
            this._name = string;
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal create(Connection connection, BigDecimal bigDecimal, String string, String string2, Timestamp[] timestampArray) throws SQLException {
        BigDecimal bigDecimal2 = null;
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            bigDecimal2 = odmrWorkflow.wfCreate(bigDecimal, string, string2, timestampArray);
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return bigDecimal2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Connection connection, BigDecimal bigDecimal) throws SQLException {
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfDelete(bigDecimal);
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Map<WorkflowNode, Connection> map) throws Exception {
        Object var1_1 = null;
        try {
            if (map.size() == 1) {
                // empty if block
            }
            OdmrWorkflow odmrWorkflow = null;
            WorkflowNode workflowNode = null;
            try {
                for (Map.Entry<WorkflowNode, Connection> entry : map.entrySet()) {
                    workflowNode = entry.getKey();
                    odmrWorkflow = new OdmrWorkflow(entry.getValue());
                    odmrWorkflow.wfDelete(workflowNode.getId());
                    try {
                        odmrWorkflow.release();
                        odmrWorkflow = null;
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                    }
                }
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                if (n == 20003) {
                    WorkflowInUseException workflowInUseException = new WorkflowInUseException();
                    workflowInUseException.setNode(workflowNode);
                    throw workflowInUseException;
                }
                throw sQLException;
            }
            finally {
                if (odmrWorkflow != null) {
                    try {
                        odmrWorkflow.release();
                    }
                    catch (Exception exception) {
                        theLogger.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                    }
                }
            }
        }
        finally {
            if (var1_1 != null) {
                // empty if block
            }
        }
    }

    public static String createUniqueName(ConnectionManager connectionManager, BigDecimal bigDecimal, String string) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SQLHelper sQLHelper = new SQLHelper();
        String string2 = null;
        Object object = null;
        String[] stringArray = new String[]{WORKFLOW_NAME, WORKFLOW_ID};
        stringArray = Workflow.delimit(stringArray, ODMR_USER_PROJECT_WORKFLOW);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECT_WORKFLOW};
        string2 = SQLHelper.buildSimpleQuery(null, stringArray, stringArray2, "PROJECT_ID = ? AND WORKFLOW_ID IS NOT NULL");
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string2);
            sQLHelper.pstmt.setBigDecimal(1, bigDecimal);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string3 = sQLHelper.rs.getString(WORKFLOW_NAME);
                hashMap.put(string3, string3);
            }
            object = string;
            int n = 1;
            while (hashMap.containsKey(object)) {
                object = string + n++;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return object;
    }

    private static void validateAndInitializeNumericalNLSSeting(Connection connection) throws SQLException {
        if (ConnectionFolder.isNumericFormatChangeRequired()) {
            ConnectionFolder.setConnectionLocaleNumberFormat(connection, STANDARD_NLS_NUMERIC);
        }
    }

    private static void validateAndReInitializeNumericalNLSSeting(Connection connection) throws SQLException {
        if (ConnectionFolder.isNumericFormatChangeRequired()) {
            ConnectionFolder.setConnectionLocaleNumberFormat(connection, ConnectionFolder.getNumericFormatForLocale());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OdmrNodeReferenceSet[] getWorkflowNodesReferences(ConnectionManager connectionManager, String string) throws SQLException {
        OdmrWorkflow odmrWorkflow = null;
        OdmrNodeReferenceSet[] odmrNodeReferenceSetArray = new OdmrNodeReferenceSet[1];
        Connection connection = connectionManager.getConnection();
        try {
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfGetNodesByType(string, odmrNodeReferenceSetArray);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            SQLHelper.close(connection);
        }
        return odmrNodeReferenceSetArray;
    }

    public static Object getWorkflowNodeContent(ConnectionManager connectionManager, String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        Object object = null;
        Connection connection = connectionManager.getConnection();
        try {
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow = new OdmrWorkflow(connection);
            CLOB cLOB = odmrWorkflow.wfGetNodeContent(string, bigDecimal, bigDecimal2, bigDecimal3);
            XMLType xMLType = XMLType.createXML((Connection)connection, (CLOB)cLOB);
            String string2 = xMLType.getStringVal();
            StringReader stringReader = new StringReader(string2);
            Unmarshaller unmarshaller = Workflow.createUnmarshaller();
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((Source)new StreamSource(stringReader));
            object = jAXBElement.getValue();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
            SQLHelper.close(connection);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(Connection connection, String[] stringArray, Timestamp timestamp, boolean bl, RunMode runMode) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        String string = null;
        try {
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow = new OdmrWorkflow(connection);
            String string2 = runMode == RunMode.VALIDATE ? "UPSTREAM" : (bl ? "UPSTREAM" : "DOWNSTREAM");
            OdmrObjectNames[] odmrObjectNamesArray = new OdmrObjectNames[]{new OdmrObjectNames(stringArray)};
            odmrWorkflow.wfRun(this.getId().toString(), odmrObjectNamesArray, runMode.toString(), string2, null, null, null, null, null);
            this.setReadOnly(true);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Connection connection) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            odmrWorkflow.wfUnlock(this.getId());
            this.setReadOnly(true);
        }
        finally {
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp save(Connection connection, Timestamp timestamp, boolean bl) throws Exception {
        OdmrWorkflow odmrWorkflow = null;
        Timestamp[] timestampArray = null;
        try {
            odmrWorkflow = new OdmrWorkflow(connection);
            String string = ((ReusableConnection)connection).getDatabaseVersion().toString();
            this.wfp.setDBVersion(string);
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = Workflow.createMarshaller();
            marshaller.marshal((Object)this.wfp, (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            if (ConfigUtils.isDebugBuild()) {
                Workflow.validateWorkflowXML(stringBuffer.toString());
            }
            XMLType xMLType = XMLType.createXML((Connection)connection, (String)stringBuffer.toString());
            timestampArray = new Timestamp[]{timestamp};
            String string2 = "N";
            if (bl) {
                string2 = "Y";
            }
            Workflow.validateAndInitializeNumericalNLSSeting(connection);
            odmrWorkflow.wfSave(this.getId(), xMLType, timestampArray, "W", string2);
        }
        finally {
            Workflow.validateAndReInitializeNumericalNLSSeting(connection);
            if (odmrWorkflow != null) {
                try {
                    odmrWorkflow.release();
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            }
        }
        return timestampArray[0];
    }

    @Override
    public void unload() {
        this.wfp = null;
        this.setLoaded(false);
    }

    @Override
    public void refresh(ConnectionManager connectionManager) throws Exception {
        throw new Exception("Please use refresh(Connection, Timestamp)");
    }

    private static URL getURL(String string) {
        URL uRL = null;
        try {
            WorkflowNode workflowNode = new WorkflowNode();
            ClassLoader classLoader = workflowNode.getClass().getClassLoader();
            uRL = classLoader.getResource(string);
            if (null == uRL) {
                throw new Exception("Cannot find XSD template: " + string);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return uRL;
    }

    private static String getTemplateFromJar(URL uRL, String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(16384);
        try (BufferedReader bufferedReader = null;){
            String string2;
            WorkflowNode workflowNode = new WorkflowNode();
            ClassLoader classLoader = workflowNode.getClass().getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (null == inputStream) {
                throw new Exception("Cannot find template from jar: " + string);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2 + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private static String getTemplate(String string) throws Exception {
        String string2;
        String string3 = string;
        String string4 = null;
        URL uRL = Workflow.getURL(string3);
        if (null != uRL && ((string2 = uRL.getProtocol()).equals("jar") || string2.equals("JAR") || string2.equals("bundleresource"))) {
            string4 = Workflow.getTemplateFromJar(uRL, string3);
        }
        return string4;
    }

    public static void validateWorkflowXML(String string) throws Exception {
        String string2 = "/XMLSchema.xsd";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String string3 = Workflow.getTemplate(string2);
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(string3.getBytes("UTF-8")));
        Schema schema = schemaFactory.newSchema(streamSource);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
    }

    public void validateWorkflow(ConnectionManager connectionManager, Timestamp timestamp) throws Exception {
        Connection connection = connectionManager.getConnection(new ConnectionProperties[]{ConnectionProperties.ALTER_SESSION_FIXES});
        try {
            if (this.wfp == null) {
                this.loadReadLock(connection, timestamp);
            }
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = Workflow.createMarshaller();
            marshaller.marshal((Object)this.wfp, (Writer)stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            Workflow.validateWorkflowXML(stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            SQLHelper.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(Timestamp timestamp, ConnectionManager connectionManager, String string) throws Exception, JAXBException {
        String[] stringArray;
        StringBuffer stringBuffer;
        Object object;
        Object object2;
        boolean bl = false;
        Connection connection = connectionManager.getConnection();
        if (this.wfp == null) {
            this.loadReadLock(connection, timestamp);
            bl = true;
        }
        try {
            object2 = new StringWriter();
            object = Workflow.createMarshaller();
            String string2 = ((ReusableConnection)connection).getDatabaseVersion().toString();
            this.wfp.setDBVersion(string2);
            object.marshal((Object)this.wfp, (Writer)object2);
            stringBuffer = ((StringWriter)object2).getBuffer();
        }
        finally {
            SQLHelper.close(connection);
        }
        if (bl) {
            this.unload();
        }
        object2 = string;
        object = stringBuffer.toString().replaceAll("Schema=\"" + (String)object2 + "\"", "Schema=\"\"");
        object2 = ((String)object2).toUpperCase();
        object = ((String)object).replaceAll("Schema=\"" + (String)object2 + "\"", "Schema=\"\"");
        object2 = ((String)object2).toLowerCase();
        object = ((String)object).replaceAll("Schema=\"" + (String)object2 + "\"", "Schema=\"\"");
        int n = ((String)object).indexOf("<InputStatisticTable");
        while (-1 != n) {
            int n2 = ((String)object).indexOf("/>", n);
            stringArray = new StringBuilder((String)object);
            stringArray.replace(n, n2 + 2, "");
            object = stringArray.toString();
            n = ((String)object).indexOf("<InputStatisticTable");
        }
        String[] stringArray2 = new String[]{"View", "Sample"};
        stringArray = new String[]{"Dirty=\"false\"", "Dirty=\"true\""};
        for (String string3 : stringArray2) {
            String string4 = string3 + stringArray[0];
            String string5 = string3 + stringArray[1];
            int n3 = ((String)object).indexOf(string4);
            while (-1 != n3) {
                int n4 = n3 + string4.length();
                StringBuilder stringBuilder = new StringBuilder((String)object);
                stringBuilder.replace(n3, n4, string5);
                object = stringBuilder.toString();
                n3 = ((String)object).indexOf(string4);
            }
        }
        return object;
    }

    public WorkflowProcess getWorkflowProcess() {
        return this.wfp;
    }

    public static List<Workflow> getWorkflows(ConnectionManager connectionManager, BigDecimal bigDecimal) throws SQLException {
        ArrayList<Workflow> arrayList = new ArrayList<Workflow>();
        SQLHelper sQLHelper = new SQLHelper();
        String string = null;
        String[] stringArray = new String[]{WORKFLOW_NAME, WORKFLOW_ID};
        stringArray = Workflow.delimit(stringArray, ODMR_USER_PROJECT_WORKFLOW);
        String[] stringArray2 = new String[]{ODMR_USER_PROJECT_WORKFLOW};
        string = SQLHelper.buildSimpleQuery(null, stringArray, stringArray2, "PROJECT_ID = ? AND WORKFLOW_ID IS NOT NULL");
        try {
            sQLHelper.conn = connectionManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setBigDecimal(1, bigDecimal);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            while (sQLHelper.rs.next()) {
                String string2 = sQLHelper.rs.getString(WORKFLOW_NAME);
                BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal(WORKFLOW_ID);
                arrayList.add(new Workflow(string2, bigDecimal2, bigDecimal));
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.close();
        }
        return arrayList;
    }

    public static List<String> getWorkflowNames(ConnectionManager connectionManager, BigDecimal bigDecimal) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            List<Workflow> list = Workflow.getWorkflows(connectionManager, bigDecimal);
            for (Workflow workflow : list) {
                arrayList.add(workflow.getName());
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void startRemoteDebug(Connection connection) {
        Workflow.endRemoteDebug(connection);
        String string = "begin dbms_debug_jdwp.connect_tcp(?,?); end;";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.setString(1, REMOTE_DEBUG_HOST);
            sQLHelper.pstmt.setString(2, REMOTE_DEBUG_PORT);
            sQLHelper.pstmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void endRemoteDebug(Connection connection) {
        String string = "begin dbms_debug_jdwp.disconnect; end;";
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.pstmt = connection.prepareStatement(string);
            sQLHelper.pstmt.execute();
        }
    }

    public void setWorkflowProcess(WorkflowProcess workflowProcess) {
        this.wfp = workflowProcess;
    }

    static {
        STANDARD_NLS_NUMERIC = ".,";
    }

    public static class WorkflowInUseException
    extends Exception {
        private transient WorkflowNode node = null;

        public void setNode(WorkflowNode workflowNode) {
            this.node = workflowNode;
        }

        public WorkflowNode getNode() {
            return this.node;
        }
    }

    public static enum RunMode {
        RUN,
        VALIDATE;

    }

    public static enum ScheduleRunMode {
        RERUN,
        RERUN_NODE_ONLY,
        RERUN_NODE_PARENTS,
        RERUN_NODE_CHILDREN,
        RERUN_CHILDREN_ONLY;

    }
}

