/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.core.model.time.Duration;
import oracle.dmt.dataminer.repository.WorkflowJob;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;

public final class EventLog {
    public static final String ODMR_USER_WORKFLOW_LOG_TABLE = "ODMR_USER_WORKFLOW_LOG";
    public static final String LOG_ID = "LOG_ID";
    public static final String USER_NAME = "USER_NAME";
    public static final String JOB_NAME = "JOB_NAME";
    public static final String PROJ_NAME = "PROJ_NAME";
    public static final String PROJ_ID = "PROJ_ID";
    public static final String WF_NAME = "WF_NAME";
    public static final String WF_ID = "WF_ID";
    public static final String NODE_NAME = "NODE_NAME";
    public static final String NODE_ID = "NODE_ID";
    public static final String SUBNODE_NAME = "SUBNODE_NAME";
    public static final String SUBNODE_ID = "SUBNODE_ID";
    public static final String LOG_TIMESTAMP = "LOG_TIMESTAMP";
    public static final String LOG_TYPE = "LOG_TYPE";
    public static final String LOG_SUBTYPE = "LOG_SUBTYPE";
    public static final String LOG_TASK = "LOG_TASK";
    public static final String LOG_DURATION = "LOG_DURATION";
    public static final String DAYS_DURATION = "DAYS_DURATION";
    public static final String HOURS_DURATION = "HOURS_DURATION";
    public static final String MINUTES_DURATION = "MINUTES_DURATION";
    public static final String SECONDS_DURATION = "SECONDS_DURATION";
    public static final String LOG_MESSAGE = "LOG_MESSAGE";
    public static final String LOG_MESSAGE_DETAILS = "LOG_MESSAGE_DETAILS";
    private static String _base_query = "select LOG_TIMESTAMP, \nLOG_MESSAGE, \nLOG_MESSAGE_DETAILS, \nJOB_NAME, \nPROJ_NAME, \nPROJ_ID, \nWF_NAME, \nWF_ID, \nNODE_NAME, \nNODE_ID, \nSUBNODE_NAME, \nSUBNODE_ID, \nLOG_TYPE, \nLOG_SUBTYPE, \nLOG_TASK, \nLOG_DURATION, \nEXTRACT(DAY FROM LOG_DURATION) DAYS_DURATION,\nEXTRACT (HOUR FROM LOG_DURATION) HOURS_DURATION,\nEXTRACT (MINUTE FROM LOG_DURATION) MINUTES_DURATION,\nEXTRACT (SECOND FROM LOG_DURATION) SECONDS_DURATION\n from ODMR_USER_WORKFLOW_LOG \n";

    public static Entry getLastEntryFor(Connection connection, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) throws SQLException {
        Entry entry = null;
        SQLHelper sQLHelper = new SQLHelper();
        int n = 1;
        Object object = _base_query;
        String string2 = "PROJ_ID = ? AND WF_ID = ? AND NODE_ID = ? AND (LOG_MESSAGE IS NOT NULL OR LOG_MESSAGE_DETAILS IS NOT NULL)";
        object = (String)object + " where " + string2;
        object = (String)object + " order by LOG_TIMESTAMP desc";
        sQLHelper.pstmt = connection.prepareStatement((String)object);
        sQLHelper.pstmt.setBigDecimal(n++, bigDecimal);
        sQLHelper.pstmt.setBigDecimal(n++, bigDecimal2);
        sQLHelper.pstmt.setString(n, string);
        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
        if (sQLHelper.rs.next()) {
            entry = new Entry();
            entry.setTime(sQLHelper.rs.getTimestamp(LOG_TIMESTAMP));
            entry.setMessage(sQLHelper.rs.getString(LOG_MESSAGE));
            entry.setMessageDetails(sQLHelper.rs.getString(LOG_MESSAGE_DETAILS));
            entry.setJobName(sQLHelper.rs.getString(JOB_NAME));
            entry.setProjectName(sQLHelper.rs.getString(PROJ_NAME));
            entry.setProjectId(sQLHelper.rs.getBigDecimal(PROJ_ID));
            entry.setWorkflowName(sQLHelper.rs.getString(WF_NAME));
            entry.setWorkflowId(sQLHelper.rs.getBigDecimal(WF_ID));
            entry.setNodeName(sQLHelper.rs.getString(NODE_NAME));
            entry.setNodeId(sQLHelper.rs.getString(NODE_ID));
            entry.setSubNodeName(sQLHelper.rs.getString(SUBNODE_NAME));
            entry.setSubNodeId(sQLHelper.rs.getString(SUBNODE_ID));
            entry.setType(sQLHelper.rs.getString(LOG_TYPE));
            entry.setSubtype(sQLHelper.rs.getString(LOG_SUBTYPE));
            entry.setTask(sQLHelper.rs.getString(LOG_TASK));
            entry.setDuration(((OracleResultSet)sQLHelper.rs).getINTERVALDS(LOG_DURATION));
            BigDecimal bigDecimal3 = sQLHelper.rs.getBigDecimal(DAYS_DURATION);
            BigDecimal bigDecimal4 = sQLHelper.rs.getBigDecimal(HOURS_DURATION);
            BigDecimal bigDecimal5 = sQLHelper.rs.getBigDecimal(MINUTES_DURATION);
            BigDecimal bigDecimal6 = sQLHelper.rs.getBigDecimal(SECONDS_DURATION);
            entry.setDurationObject(Duration.newInstance((BigDecimal)bigDecimal3, (BigDecimal)bigDecimal4, (BigDecimal)bigDecimal5, (BigDecimal)bigDecimal6));
        }
        return entry;
    }

    public static List<Entry> getEntriesFor(Connection connection, BigDecimal bigDecimal, BigDecimal bigDecimal2) throws SQLException {
        return EventLog.getEntriesFor(connection, bigDecimal, bigDecimal2, null);
    }

    public static List<Entry> getEntriesFor(Connection connection, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) throws SQLException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        SQLHelper sQLHelper = new SQLHelper();
        int n = 1;
        Object object = _base_query;
        String string2 = string != null ? "PROJ_ID = ? AND WF_ID = ? AND NODE_ID = ?" : "PROJ_ID = ? AND WF_ID = ?";
        object = (String)object + " where " + string2;
        object = (String)object + " order by LOG_TIMESTAMP desc";
        sQLHelper.pstmt = connection.prepareStatement((String)object);
        sQLHelper.pstmt.setBigDecimal(n++, bigDecimal);
        sQLHelper.pstmt.setBigDecimal(n++, bigDecimal2);
        if (string != null) {
            sQLHelper.pstmt.setString(n, string);
        }
        sQLHelper.rs = sQLHelper.pstmt.executeQuery();
        while (sQLHelper.rs.next()) {
            Entry entry = new Entry();
            entry.setTime(sQLHelper.rs.getTimestamp(LOG_TIMESTAMP));
            entry.setMessage(sQLHelper.rs.getString(LOG_MESSAGE));
            entry.setMessageDetails(sQLHelper.rs.getString(LOG_MESSAGE_DETAILS));
            entry.setJobName(sQLHelper.rs.getString(JOB_NAME));
            entry.setProjectName(sQLHelper.rs.getString(PROJ_NAME));
            entry.setProjectId(sQLHelper.rs.getBigDecimal(PROJ_ID));
            entry.setWorkflowName(sQLHelper.rs.getString(WF_NAME));
            entry.setWorkflowId(sQLHelper.rs.getBigDecimal(WF_ID));
            entry.setNodeName(sQLHelper.rs.getString(NODE_NAME));
            entry.setNodeId(sQLHelper.rs.getString(NODE_ID));
            entry.setSubNodeName(sQLHelper.rs.getString(SUBNODE_NAME));
            entry.setSubNodeId(sQLHelper.rs.getString(SUBNODE_ID));
            entry.setType(sQLHelper.rs.getString(LOG_TYPE));
            entry.setSubtype(sQLHelper.rs.getString(LOG_SUBTYPE));
            entry.setTask(sQLHelper.rs.getString(LOG_TASK));
            entry.setDuration(((OracleResultSet)sQLHelper.rs).getINTERVALDS(LOG_DURATION));
            BigDecimal bigDecimal3 = sQLHelper.rs.getBigDecimal(DAYS_DURATION);
            BigDecimal bigDecimal4 = sQLHelper.rs.getBigDecimal(HOURS_DURATION);
            BigDecimal bigDecimal5 = sQLHelper.rs.getBigDecimal(MINUTES_DURATION);
            BigDecimal bigDecimal6 = sQLHelper.rs.getBigDecimal(SECONDS_DURATION);
            entry.setDurationObject(Duration.newInstance((BigDecimal)bigDecimal3, (BigDecimal)bigDecimal4, (BigDecimal)bigDecimal5, (BigDecimal)bigDecimal6));
            arrayList.add(entry);
        }
        return arrayList;
    }

    public static class Entry {
        private String projectName;
        private BigDecimal projectId;
        private String workflowName;
        private BigDecimal workflowId;
        private String nodeName;
        private String nodeId;
        private String subNodeName;
        private String subNodeId;
        private Timestamp time;
        private String type;
        private String subtype;
        private String task;
        private INTERVALDS duration;
        private String durationFormatted;
        private String message;
        private String messageDetails;
        private String jobName;
        private Duration durationObject;

        public String toString() {
            return this.getSubtype() + "(" + this.getTask() + ")";
        }

        public final void setProjectName(String string) {
            this.projectName = string;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectId(BigDecimal bigDecimal) {
            this.projectId = bigDecimal;
        }

        public final BigDecimal getProjectId() {
            return this.projectId;
        }

        public final void setWorkflowName(String string) {
            this.workflowName = string;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowId(BigDecimal bigDecimal) {
            this.workflowId = bigDecimal;
        }

        public final BigDecimal getWorkflowId() {
            return this.workflowId;
        }

        public final void setNodeName(String string) {
            this.nodeName = string;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeId(String string) {
            this.nodeId = string;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setSubNodeName(String string) {
            this.subNodeName = string;
        }

        public final String getSubNodeName() {
            return this.subNodeName;
        }

        public final void setSubNodeId(String string) {
            this.subNodeId = string;
        }

        public final String getSubNodeId() {
            return this.subNodeId;
        }

        public final void setTime(Timestamp timestamp) {
            this.time = timestamp;
        }

        public final Timestamp getTime() {
            return this.time;
        }

        public final void setType(String string) {
            this.type = string;
        }

        public final String getType() {
            return this.type;
        }

        public final void setMessage(String string) {
            this.message = string;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setJobName(String string) {
            this.jobName = string;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public void setSubtype(String string) {
            this.subtype = string;
        }

        public String getSubtype() {
            return this.subtype;
        }

        public void setTask(String string) {
            this.task = string;
        }

        public String getTask() {
            return this.task;
        }

        public void setDuration(INTERVALDS iNTERVALDS) {
            this.duration = iNTERVALDS;
        }

        public INTERVALDS getDuration() {
            return this.duration;
        }

        public void setMessageDetails(String string) {
            this.messageDetails = string;
        }

        public String getMessageDetails() {
            return this.messageDetails;
        }

        public String getDurationFormatted() {
            return this.durationFormatted;
        }

        public Duration getDurationObject() {
            return this.durationObject;
        }

        public void setDurationObject(Duration duration) {
            this.durationObject = duration;
            if (this.durationObject != null) {
                this.durationFormatted = this.durationObject.toString();
            }
        }
    }

    public static final class EntryInfo {
        private Entry entry;
        private BigDecimal jobId;
        private String jobName;
        private BigDecimal projectId;
        private String projectName;
        private BigDecimal workflowId;
        private String workflowName;
        private WorkflowJob job;
        private String nodeId;

        public EntryInfo(Entry entry) {
            this.entry = entry;
            this.job = null;
            this.jobName = null;
            this.jobId = null;
            this.nodeId = null;
            if (null != entry) {
                this.jobName = entry.getJobName();
                this.jobId = entry.getWorkflowId();
            }
        }

        public void setEntry(Entry entry) {
            this.entry = entry;
        }

        public Entry getEntry() {
            return this.entry;
        }

        public void setJobId(BigDecimal bigDecimal) {
            this.jobId = bigDecimal;
        }

        public BigDecimal getJobId() {
            return this.jobId;
        }

        public void setJobName(String string) {
            this.jobName = string;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJob(WorkflowJob workflowJob) {
            this.job = workflowJob;
        }

        public WorkflowJob getJob() {
            return this.job;
        }

        public void setProjectName(String string) {
            this.projectName = string;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setWorkflowName(String string) {
            this.workflowName = string;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public void setProjectId(BigDecimal bigDecimal) {
            this.projectId = bigDecimal;
        }

        public BigDecimal getProjectId() {
            return this.projectId;
        }

        public void setWorkflowId(BigDecimal bigDecimal) {
            this.workflowId = bigDecimal;
        }

        public BigDecimal getWorkflowId() {
            return this.workflowId;
        }

        public void setNodeId(String string) {
            this.nodeId = string;
        }

        public String getNodeId() {
            return this.nodeId;
        }
    }
}

