/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.repository;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.server.ServerConstantsLrb;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCs;
import oracle.dmt.dataminer.workflow.xmlschema.TargetResultType;
import oracle.dmt.dataminer.workflow.xmlschema.TestModelType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;

public class ClassTestResult
extends TestResult {
    private static final String CONFUSION_MATRIX_TABLE_NAME = "CONFUSION_MATRIX_TABLE_NAME";
    private static final String AVG_ACCURACY = "AVG_ACCURACY";
    private static final String ACCURACY = "ACCURACY";
    private static final String COST = "COST";
    private static final String LEAST_TARGET_VALUE = "LEAST_TARGET_VALUE";
    private static final String TEST_ROWS = "TEST_ROWS";
    private Map<String, String> _liftResultTables;
    private Map<String, String> _rocResultTables;
    private Map<String, Double> _rocAreaUnderCurves;
    private Map<String, String> _rocAreaUnderCurvesEx;
    private List<String> _targetValues;
    private ConnectionManager _connManager;
    private static String metrics_class_qry = "Select metric_name, metric_num_value, metric_varchar_value from <performanceTable> where <partition_clause> and metric_name in ( 'PREDICTIVE_CONFIDENCE', 'AVG_ACCURACY', 'ACCURACY', 'COST', 'LEAST_TARGET_VALUE', 'TEST_ROWS')";
    private static String _rocPartitionedAreasql = "SELECT AREA FROM <data_table> WHERE <partition_clause>";

    public ClassTestResult(ClassTestResult classTestResult) {
        super(classTestResult);
    }

    public ClassTestResult(Context context, BuildNodeType buildNodeType, MiningResultType miningResultType) {
        super(context, buildNodeType, miningResultType);
        RBuildNodeType rBuildNodeType;
        RBuildNodeType.Models models;
        List list;
        Optional<RModelType> optional;
        assert (miningResultType instanceof ClassificationResultType);
        this._connManager = ConnectionFolder.getConnectionFolder(context);
        if (buildNodeType instanceof ClassificationBuildNodeType) {
            CGeneralizedLinearModelType cGeneralizedLinearModelType;
            Object object;
            Object object22;
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
            ClassificationBuildNodeType.Models models2 = classificationBuildNodeType.getModels();
            List list2 = models2.getNaiveBayesModel();
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("CLASSIFICATION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            boolean bl = false;
            for (Object object22 : list2) {
                if (object22.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                this._data.put("MODEL_NAME", object22.getName());
                this._data.put("MODEL_ID", object22.getId());
                this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_NAIVE_BAYES"));
                bl = true;
                break;
            }
            if (!bl) {
                object = models2.getCGeneralizedLinearModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (CGeneralizedLinearModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_GENERALIZED_LINEAR_MODEL"));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                object = models2.getDecisionTreeModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (DecisionTreeModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_DECISION_TREE"));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                object = models2.getCSupportVectorMachineModel();
                object22 = object.iterator();
                while (object22.hasNext()) {
                    cGeneralizedLinearModelType = (CSupportVectorMachineModelType)object22.next();
                    if (cGeneralizedLinearModelType.getId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
                    this._data.put("MODEL_NAME", cGeneralizedLinearModelType.getName());
                    this._data.put("MODEL_ID", cGeneralizedLinearModelType.getId());
                    this._data.put("MINING_ALGORITHM", ServerConstantsLrb.get("ALGO_SUPPORT_VECTOR_MACHINE"));
                    bl = true;
                    break;
                }
            }
            this.putResultTablesToMap((ClassificationResultType)miningResultType);
        } else if (buildNodeType instanceof RBuildNodeType && (optional = (list = (models = (rBuildNodeType = (RBuildNodeType)buildNodeType).getModels()).getRModel()).stream().filter(rModelType -> rModelType.getId().equalsIgnoreCase(miningResultType.getModelId())).findAny()).isPresent()) {
            RModelType rModelType2 = optional.get();
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", CoreServerConstantsLrb.get((String)"CLASSIFICATION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            this._data.put("MODEL_NAME", rModelType2.getName());
            this._data.put("MODEL_ID", rModelType2.getId());
            this._data.put("MINING_ALGORITHM", CoreServerConstantsLrb.get((String)"ALGO_R_USER_DEFINED"));
            this.putResultTablesToMap((ClassificationResultType)miningResultType);
        }
    }

    private void putResultTablesToMap(ClassificationResultType classificationResultType) {
        if (classificationResultType.getTestMetrics() != null) {
            this._data.put("PERFORM_METRICS_TABLE_NAME", classificationResultType.getTestMetrics().getName());
        }
        if (classificationResultType.getConfusionMatrix() != null) {
            this._data.put(CONFUSION_MATRIX_TABLE_NAME, classificationResultType.getConfusionMatrix().getName());
        }
    }

    public ClassTestResult(Context context, TestNodeType testNodeType, MiningResultType miningResultType) {
        super(context, testNodeType, miningResultType);
        this._connManager = ConnectionFolder.getConnectionFolder(context);
        for (TestModelType.Model model : testNodeType.getTestModels().getModel()) {
            if (model.getModelId().compareToIgnoreCase(miningResultType.getModelId()) != 0) continue;
            this._data.put("RESULT_NAME", miningResultType.getName());
            this._data.put("MINING_FUNCTION", ServerConstantsLrb.get("CLASSIFICATION"));
            this._data.put("CREATION_TIME", miningResultType.getCreationDate());
            this._data.put("MODEL_SCHEMA", model.getSchema());
            this._data.put("MODEL_NAME", model.getName());
            this._data.put("MODEL_ID", model.getModelId());
            this._data.put("MINING_ALGORITHM", ServerConstants.Algorithm.getUIAlgorithmName((String)model.getMiningAlgorithm().value()));
            break;
        }
        this.putResultTablesToMap((ClassificationResultType)miningResultType);
    }

    public boolean isROCResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getROCs() != null && classificationResultType.getROCs().getROC().size() > 0;
        }
        return false;
    }

    public boolean isConfusionMatrixResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getConfusionMatrix() != null;
        }
        return false;
    }

    public boolean isAccuracyMetricsResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getTestMetrics() != null;
        }
        return false;
    }

    public boolean isLiftProfitResult() {
        if (this._result instanceof ClassificationResultType) {
            ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
            return classificationResultType.getLifts() != null && classificationResultType.getLifts().getLift().size() > 0;
        }
        return false;
    }

    private void loadResultsTables(boolean bl) {
        String string;
        String string2;
        List list;
        if (this._targetValues == null) {
            this._targetValues = new Vector<String>();
        }
        ClassificationResultType classificationResultType = (ClassificationResultType)this._result;
        if (this._liftResultTables == null) {
            this._liftResultTables = new HashMap<String, String>();
            list = null;
            if (classificationResultType.getLifts() != null) {
                list = classificationResultType.getLifts().getLift();
            }
            if (list != null) {
                for (Object object : list) {
                    string2 = object.getTargetValue();
                    string = object.getName();
                    this._liftResultTables.put(string2, string);
                    this._targetValues.add(string2);
                }
            }
        }
        if (this._rocResultTables == null) {
            this._rocResultTables = new HashMap<String, String>();
            list = null;
            if (classificationResultType.getROCs() != null) {
                list = classificationResultType.getROCs().getROC();
            }
            if (list != null) {
                for (Object object : list) {
                    string2 = object.getTargetValue();
                    string = object.getName();
                    this._rocResultTables.put(string2, string);
                    if (this._targetValues.contains(string2)) continue;
                    this._targetValues.add(string2);
                }
                if (bl) {
                    this._rocAreaUnderCurvesEx = new HashMap<String, String>();
                    var6_4 = classificationResultType.getROCs().getAreaUnderCurveEx();
                    object = var6_4.iterator();
                    while (object.hasNext()) {
                        TargetResultType targetResultType = (TargetResultType)object.next();
                        string2 = targetResultType.getTargetValue();
                        String string3 = targetResultType.getName();
                        this._rocAreaUnderCurvesEx.put(string2, string3);
                    }
                } else {
                    this._rocAreaUnderCurves = new HashMap<String, Double>();
                    var6_4 = classificationResultType.getROCs().getAreaUnderCurve();
                    object = var6_4.iterator();
                    while (object.hasNext()) {
                        ROCs.AreaUnderCurve areaUnderCurve = (ROCs.AreaUnderCurve)object.next();
                        string2 = areaUnderCurve.getTargetValue();
                        double d = areaUnderCurve.getArea();
                        this._rocAreaUnderCurves.put(string2, d);
                    }
                }
            }
        }
        if (this._targetValues != null && this._targetValues.size() > 0) {
            Collections.sort(this._targetValues, LetterNumberComparator.getComparator());
        }
    }

    private void loadNonPartitionedMetrics() throws ODMrDAOException {
        String string = null;
        String string2 = this.getPerformanceMatrixTable();
        if (string2 != null) {
            string = "Select metric_name, metric_num_value, metric_varchar_value from " + string2 + " where metric_name in ( 'PREDICTIVE_CONFIDENCE', 'AVG_ACCURACY', 'ACCURACY', 'COST', 'LEAST_TARGET_VALUE')";
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = this._connManager.getConnection();
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string3 = sQLHelper.rs.getString(1);
                    if ("PREDICTIVE_CONFIDENCE".equals(string3)) {
                        this._data.put("PREDICTIVE_CONFIDENCE", sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (AVG_ACCURACY.equals(string3)) {
                        this._data.put(AVG_ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (ACCURACY.equals(string3)) {
                        this._data.put(ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (COST.equals(string3)) {
                        this._data.put(COST, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (!LEAST_TARGET_VALUE.equals(string3)) continue;
                    this._data.put(LEAST_TARGET_VALUE, sQLHelper.rs.getString(3));
                }
            }
        }
    }

    private void loadPartitionedMetrics(String string) throws ODMrDAOException {
        String string2 = this.getPerformanceMatrixTable();
        if (string2 != null) {
            String string3 = StringUtils.getReplacedString(metrics_class_qry, "<performanceTable>", string2);
            string3 = SharedTestEditorState.setPartitionClause(string3, string);
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = this._connManager.getConnection();
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string3);
                sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                while (sQLHelper.rs.next()) {
                    String string4 = sQLHelper.rs.getString(1);
                    if ("PREDICTIVE_CONFIDENCE".equals(string4)) {
                        this._data.put("PREDICTIVE_CONFIDENCE", sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (AVG_ACCURACY.equals(string4)) {
                        this._data.put(AVG_ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (ACCURACY.equals(string4)) {
                        this._data.put(ACCURACY, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (COST.equals(string4)) {
                        this._data.put(COST, sQLHelper.rs.getBigDecimal(2));
                        continue;
                    }
                    if (LEAST_TARGET_VALUE.equals(string4)) {
                        this._data.put(LEAST_TARGET_VALUE, sQLHelper.rs.getString(3));
                        continue;
                    }
                    if (!TEST_ROWS.equals(string4)) continue;
                    this._data.put(TEST_ROWS, sQLHelper.rs.getInt("METRIC_NUM_VALUE"));
                }
            }
        }
    }

    public String geLiftResultTable(String string, boolean bl) {
        if (this._liftResultTables == null) {
            this.loadResultsTables(bl);
        }
        return this._liftResultTables.get(string);
    }

    public boolean liftResultExists(boolean bl) {
        if (this._liftResultTables == null) {
            this.loadResultsTables(bl);
        }
        return this._liftResultTables.size() > 0;
    }

    public String geRocResultTable(String string, boolean bl) {
        if (this._rocResultTables == null) {
            this.loadResultsTables(bl);
        }
        return this._rocResultTables.get(string);
    }

    public boolean rocResultExists(boolean bl) {
        if (this._rocResultTables == null) {
            this.loadResultsTables(bl);
        }
        return this._rocResultTables.size() > 0;
    }

    public Double getRocAreaUnderCurveNonPartitioned(String string) {
        if (this._rocAreaUnderCurves == null) {
            this.loadResultsTables(false);
        }
        return this._rocAreaUnderCurves.get(string);
    }

    public Double getRocAreaUnderCurvePartitioned(String string, String string2) throws ODMrDAOException {
        Double d = null;
        if (this._rocAreaUnderCurvesEx == null) {
            this.loadResultsTables(true);
        }
        String string3 = this._rocAreaUnderCurvesEx.get(string);
        String string4 = StringUtils.getReplacedString(_rocPartitionedAreasql, "<data_table>", string3);
        string4 = SharedTestEditorState.setPartitionClause(string4, string2);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = this._connManager.getConnection();
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
            sQLHelper.rs = sQLHelper.pstmt.executeQuery();
            if (sQLHelper.rs.next()) {
                d = sQLHelper.rs.getDouble(1);
            }
        }
        return d;
    }

    public String getConfusionMatrixTable() {
        return (String)this._data.get(CONFUSION_MATRIX_TABLE_NAME);
    }

    public boolean confusionMatrixExists() {
        return this._data.get(CONFUSION_MATRIX_TABLE_NAME) != null;
    }

    public List<String> getTargetValues(boolean bl) {
        if (this._targetValues == null) {
            this.loadResultsTables(bl);
        }
        return this._targetValues;
    }

    public String getLeastTargetValue(boolean bl, String string) throws ODMrDAOException {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (String)this._data.get(LEAST_TARGET_VALUE);
    }

    public BigDecimal getPredictiveConfidence(boolean bl, String string) throws ODMrDAOException {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get("PREDICTIVE_CONFIDENCE");
    }

    public BigDecimal getAvgAccuracy(boolean bl, String string) throws ODMrDAOException {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get(AVG_ACCURACY);
    }

    public Integer getTestRows(boolean bl, String string) throws ODMrDAOException {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (Integer)this._data.get(TEST_ROWS);
    }

    public BigDecimal getOverallAccuracy(boolean bl, String string) throws ODMrDAOException {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get(ACCURACY);
    }

    public BigDecimal getCost(boolean bl, String string) throws ODMrDAOException {
        String string2 = (String)this._data.get(LEAST_TARGET_VALUE);
        if (string2 == null) {
            if (bl) {
                this.loadPartitionedMetrics(string);
            } else {
                this.loadNonPartitionedMetrics();
            }
        }
        return (BigDecimal)this._data.get(COST);
    }
}

