/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.build.partition.Rule;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.ValueSelectorPanel;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

class ValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Context context;
    private String modelSqlList;
    private JPanel panel;
    private JTextField textField;
    private JButton searchButton;
    private Rule editingRule;

    public ValueCellEditor(Context context, String string) {
        this.context = context;
        this.modelSqlList = string;
        this.initUI();
    }

    private void initUI() {
        this.textField = new JTextField();
        this.searchButton = new JButton();
        this.panel = new CustomEditorPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.panel.add(this.textField);
        this.panel.add(this.searchButton);
        this.panel.setBackground(this.textField.getBackground());
        this.panel.setBorder(this.textField.getBorder());
        this.textField.setBorder(null);
        this.searchButton.setIcon(OracleIcons.getIcon((String)"search.png"));
        this.searchButton.addActionListener(new SearchButtonActionListener());
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.editingRule = (Rule)((ODMrTableModel)((Object)jTable.getModel())).getSrcData().get(n);
        this.textField.setText(object.toString());
        this.textField.requestFocus();
        this.textField.setInputVerifier(new EditorInputVerifier());
        this.searchButton.setVisible(this.editingRule.getOperator() == Rule.OPERATORS.IS || this.editingRule.getOperator() == Rule.OPERATORS.IS_NOT);
        return this.panel;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.isCellContentInvalid()) {
            return false;
        }
        return super.stopCellEditing();
    }

    private boolean isCellContentInvalid() {
        return !this.textField.getInputVerifier().shouldYieldFocus(this.textField);
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() == 2;
        }
        return super.isCellEditable(eventObject);
    }

    public void commitValue(String string) {
        this.textField.setText(string);
        this.stopCellEditing();
    }

    Context getContext() {
        return this.context;
    }

    String getModelSqlList() {
        return this.modelSqlList;
    }

    String getPartitionColumName() {
        return this.editingRule.getPartitionKey().getColumnName();
    }

    private class CustomEditorPanel
    extends JPanel {
        private CustomEditorPanel() {
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return this.isTabKeyPressed(keyStroke) ? this.processTabKey() : this.processKeyPressed(keyStroke, n);
        }

        private boolean isTabKeyPressed(KeyStroke keyStroke) {
            return keyStroke.getKeyCode() == 9;
        }

        private boolean processTabKey() {
            ValueCellEditor.this.searchButton.requestFocus();
            return true;
        }

        private boolean processKeyPressed(KeyStroke keyStroke, int n) {
            return this.hasAssociatedAction(keyStroke, n) ? this.setFocusOnTextField() : false;
        }

        private boolean hasAssociatedAction(KeyStroke keyStroke, int n) {
            boolean bl = false;
            InputMap inputMap = ValueCellEditor.this.textField.getInputMap(n);
            ActionMap actionMap = ValueCellEditor.this.textField.getActionMap();
            if (inputMap != null && actionMap != null && this.isEnabled()) {
                Object object = inputMap.get(keyStroke);
                Action action = object == null ? null : actionMap.get(object);
                bl = action != null;
            }
            return bl;
        }

        private boolean setFocusOnTextField() {
            ValueCellEditor.this.textField.requestFocus();
            return true;
        }
    }

    private class SearchButtonActionListener
    implements ActionListener {
        private SearchButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ValueSelectorPanel valueSelectorPanel = new ValueSelectorPanel(ValueCellEditor.this);
            valueSelectorPanel.showAsTooltipDialog(ValueCellEditor.this.panel);
        }
    }

    private class EditorInputVerifier
    extends InputVerifier {
        private EditorInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            boolean bl;
            boolean bl2 = bl = this.isStringType() ? true : this.isNumber();
            if (!bl) {
                JOptionPane.showMessageDialog(ValueCellEditor.this.panel, PartitionsLrb.get("FILTER_VALIDATION_NUMBER"));
            }
            return bl;
        }

        private boolean isStringType() {
            return ValueCellEditor.this.editingRule.getOperator().isStringOperator() && ValueCellEditor.this.editingRule.getPartitionKey().isStringDataType();
        }

        private boolean isNumber() {
            return Pattern.matches("\\d*(\\.\\d+)?", ValueCellEditor.this.textField.getText());
        }
    }
}

