/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.partition;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelPartitionsCountQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.common.build.GetModelPartitionsQuery;
import oracle.dmt.dataminer.core.model.common.build.partition.ModelPartitions;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.model.common.build.partition.RulesPartitionFilterData;
import oracle.dmt.dataminer.core.utils.comparator.StringEndingWithNumberComparator;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.partition.RulesPartitionFilterSortingPanel;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.ide.Context;

public class ModelPartitionChooserPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private Context context;
    private PartitionsTableModel model;
    private PartitionVO selectedPartition;
    private String[] models;
    private boolean multiModel;
    private DataMinerTablePanel partitionsTablePanel;
    private RulesPartitionFilterSortingPanel rulesPartitionFilterSortingPanel1;

    public ModelPartitionChooserPanel(Context context, String[] stringArray) {
        this.context = context;
        this.models = Arrays.copyOf(stringArray, stringArray.length);
        this.multiModel = stringArray.length > 1;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.rulesPartitionFilterSortingPanel1 = new RulesPartitionFilterSortingPanel(this.getContext(), this.models);
        this.partitionsTablePanel = new DataMinerTablePanel();
        this.setPreferredSize(new Dimension(630, 400));
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.rulesPartitionFilterSortingPanel1);
        this.add(this.partitionsTablePanel);
    }

    @Override
    public void initRes() {
    }

    @Override
    public void initUI() {
        this.rulesPartitionFilterSortingPanel1.getQueryButton().addActionListener(new QueryButtonActionListener());
        this.partitionsTablePanel.getTable().setColumnSelectorAvailable(true);
        this.partitionsTablePanel.getTable().getSelectionModel().addListSelectionListener(new PartitionsTableSelectionListener());
        this.loadModelPartitions();
    }

    private void loadModelPartitions() {
        LoadModelPartitions loadModelPartitions = new LoadModelPartitions();
        loadModelPartitions.execute();
    }

    public PartitionVO getSelectedPartition() {
        return this.selectedPartition;
    }

    private Context getContext() {
        return this.context;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                DataMinerTable dataMinerTable = ModelPartitionChooserPanel.this.partitionsTablePanel.getTable();
                ModelPartitionChooserPanel.this.selectedPartition = (PartitionVO)ModelPartitionChooserPanel.this.model.getSrcData().get(dataMinerTable.getSelectedRowInModel());
            }

            @Override
            public String getTitle() {
                return PartitionsLrb.get("FILTER_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return null;
            }

            @Override
            public int getButtonMask() {
                return 3;
            }

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                jEWTDialog.setPreferredSize(new Dimension(800, 700));
                jEWTDialog.setOKButtonEnabled(false);
            }

            @Override
            public JComponent getContent() {
                return ModelPartitionChooserPanel.this;
            }
        };
    }

    private class QueryButtonActionListener
    implements ActionListener {
        private QueryButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelPartitionChooserPanel.this.loadModelPartitions();
        }
    }

    private class PartitionsTableSelectionListener
    implements ListSelectionListener {
        private PartitionsTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl = listSelectionEvent.getFirstIndex() != -1;
            UITools.getParentDialog(ModelPartitionChooserPanel.this).setOKButtonEnabled(bl);
        }
    }

    private class LoadModelPartitions
    extends ODMrSwingWorker<ModelPartitions, Void> {
        private ConnectionManager connManager;
        private RulesPartitionFilterData filterData;
        private SqlDataAccessObject dao;

        private LoadModelPartitions() {
            super(ModelPartitionChooserPanel.this, null, ModelPartitionChooserPanel.this.partitionsTablePanel.getTable());
            this.filterData = ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getCurrentFilterData();
            this.connManager = ConnectionFolder.getConnectionFolder(ModelPartitionChooserPanel.this.context);
            this.dao = new SqlDataAccessObject(this.connManager);
        }

        @Override
        protected void beforeExecute() {
            ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getQueryButton().setEnabled(false);
            JEWTDialog jEWTDialog = UITools.getParentDialog(ModelPartitionChooserPanel.this);
            if (jEWTDialog != null) {
                jEWTDialog.setOKButtonEnabled(false);
            }
        }

        @Override
        protected ModelPartitions doInBackground() throws Exception {
            ModelPartitions modelPartitions = this.getModelPartitions();
            int n = this.getPartitionCount();
            modelPartitions.setPartitionCount(n);
            return modelPartitions;
        }

        private Integer getPartitionCount() throws ODMrDAOException {
            GetModelPartitionsCountQuery getModelPartitionsCountQuery = new GetModelPartitionsCountQuery(this.connManager.getDbVersion(), ModelPartitionChooserPanel.this.models);
            return this.dao.readItem((Query)getModelPartitionsCountQuery).orElse(0);
        }

        private ModelPartitions getModelPartitions() throws ODMrDAOException {
            GetModelPartitionsQuery getModelPartitionsQuery = new GetModelPartitionsQuery(this.connManager.getDbVersion(), ModelPartitionChooserPanel.this.models).setFilterData(this.filterData);
            return this.dao.readItem((Query)getModelPartitionsQuery).orElse(new ModelPartitions());
        }

        @Override
        protected void onSuccess(ModelPartitions modelPartitions) throws Exception {
            String string = MessageFormat.format(PartitionsLrb.get("PARTITIONS_TABLE_TITLE"), modelPartitions.getRows().size(), modelPartitions.getPartitionCount());
            if (ModelPartitionChooserPanel.this.model == null) {
                ModelPartitionChooserPanel.this.partitionsTablePanel.getTable().setFixedColumns(ModelPartitionChooserPanel.this.multiModel ? 1 : 2, 150, 150);
                int n = modelPartitions.getColumnNames().size();
                ModelPartitionChooserPanel.this.model = new PartitionsTableModel(modelPartitions.getColumnNames().toArray(new String[n]), modelPartitions.getRows(), ModelPartitionChooserPanel.this.multiModel);
                ModelPartitionChooserPanel.this.partitionsTablePanel.setup((TableModel)((Object)ModelPartitionChooserPanel.this.model), string, 0, true);
            } else {
                ModelPartitionChooserPanel.this.partitionsTablePanel.setTitle(string);
                ModelPartitionChooserPanel.this.model.setSrcData(modelPartitions.getRows());
            }
            ModelPartitionChooserPanel.this.partitionsTablePanel.getTable().setSortColumn(0, true);
            ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.loadPartitionColumns();
        }

        @Override
        protected void onFinally() {
            ModelPartitionChooserPanel.this.rulesPartitionFilterSortingPanel1.getQueryButton().setEnabled(true);
        }
    }

    private static class PartitionsTableModel
    extends ODMrTableModel<PartitionVO> {
        private final boolean multiModel;

        private PartitionsTableModel(String[] stringArray, List<PartitionVO> list, boolean bl) {
            super(stringArray, list);
            this.multiModel = bl;
        }

        public Object getValueAt(int n, int n2) {
            PartitionVO partitionVO = (PartitionVO)this.srcData.get(n);
            return this.multiModel ? this.getMultiModelValue(partitionVO, n2) : this.getSingleModelValue(partitionVO, n2);
        }

        private Object getMultiModelValue(PartitionVO partitionVO, int n) {
            switch (n) {
                case 0: {
                    return partitionVO.getPartitionName();
                }
            }
            return ((PartitionColumn)partitionVO.getColumns().get(n - 1)).getValue();
        }

        private Object getSingleModelValue(PartitionVO partitionVO, int n) {
            switch (n) {
                case 0: {
                    return partitionVO.getPartitionID();
                }
                case 1: {
                    return partitionVO.getPartitionName();
                }
            }
            return ((PartitionColumn)partitionVO.getColumns().get(n - 2)).getValue();
        }

        public Comparator getColumnSortComparator(int n) {
            return StringEndingWithNumberComparator.getComparator();
        }
    }
}

