/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.features;

import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class ESAFeatureViewerSettings
extends DataMinerPreferenceSettings {
    public static final int DESCENDING_ORDER = 1;
    public static final int ASCENDING_ORDER = 0;
    public static final int ALPHABETICAL_SORT = 0;
    public static final int NUMERICAL_SORT = 1;
    private static final String DATA_KEY = "oracle.dmt.dataminer.mviewer.features.ESAFeatureViewerSettings";
    private static final String COEFFICIENT_SHOW_FILTERED_ONLY = "ESA_Only_Show_Filtered_Coefficients";
    private static final String COEFFICIENT_SORT_DIRECTION = "ESA_Coefficient_Sort_Direction";
    private static final String COEFFICIENT_SORT_TYPE = "ESA_Coefficient_Sort_Type";
    private static final String FEATURE_SORT_DIRECTION = "ESA_Feature_Sort_Direction";
    private static final String ITEM_AGG_FETCH_SIZE = "ESA_Item_Agg_Fetch_Size";

    public ESAFeatureViewerSettings(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static ESAFeatureViewerSettings getInstance() {
        return ESAFeatureViewerSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    public static ESAFeatureViewerSettings getInstance(PropertyStorage propertyStorage) {
        return new ESAFeatureViewerSettings(ESAFeatureViewerSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void setCoefficientsFiltered(boolean bl) {
        this._hash.putBoolean(COEFFICIENT_SHOW_FILTERED_ONLY, bl);
    }

    public boolean areCoefficientsFiltered() {
        return this._hash.getBoolean(COEFFICIENT_SHOW_FILTERED_ONLY, true);
    }

    public void setCoefficientSortDirection(int n) {
        this._hash.putInt(COEFFICIENT_SORT_DIRECTION, n);
    }

    public int getCoefficientSortDirection() {
        return this._hash.getInt(COEFFICIENT_SORT_DIRECTION);
    }

    public void setCoefficientSortType(int n) {
        this._hash.putInt(COEFFICIENT_SORT_TYPE, n);
    }

    public int getCoefficientSortType() {
        return this._hash.getInt(COEFFICIENT_SORT_TYPE);
    }

    public void setFeatureSortDirection(int n) {
        this._hash.putInt(FEATURE_SORT_DIRECTION, n);
    }

    public int getFeatureSortDirection() {
        return this._hash.getInt(FEATURE_SORT_DIRECTION);
    }

    public void setItemAggregationFetchSize(int n) {
        this._hash.putInt(ITEM_AGG_FETCH_SIZE, n);
    }

    public int getItemAggregationFetchSize() {
        return this._hash.getInt(ITEM_AGG_FETCH_SIZE, 50);
    }
}

