/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.dtree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.mviewer.dtree.DTTreeRule;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreeEditorLrb;
import oracle.dmt.dataminer.mviewer.dtree.DecisionTreePreferencesSettings;
import oracle.dmt.dataminer.mviewer.dtree.model.DTTreeNode;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;

public class RulePane
extends JPanel
implements DataminerGUIPanel {
    private DTTreeNode treeNode;
    private JEditorPane ruleViewPane;
    private JScrollPane ruleViewScrollPane;
    private JCheckBox wrapCheckbox;
    private JLabel componentLabel;
    private JPanel contentPanel;

    public RulePane(DTTreeNode dTTreeNode) {
        this.treeNode = dTTreeNode;
        this.wrapCheckbox = new JCheckBox();
        this.componentLabel = new JLabel();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 2));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 440, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contentPanel, -1, 100, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DecisionTreeEditorLrb.get("RULE_PANEL_LABEL"), this.componentLabel);
        hashMap.put(DecisionTreeEditorLrb.get("WRAP_RULE_OPTION"), this.wrapCheckbox);
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        final DecisionTreePreferencesSettings decisionTreePreferencesSettings = DecisionTreePreferencesSettings.getInstance();
        this.ruleViewScrollPane = new JScrollPane();
        this.ruleViewPane = new JEditorPane();
        this.ruleViewScrollPane.setViewportView(this.ruleViewPane);
        ControlBar controlBar = new ControlBar();
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setControlBar(controlBar);
        componentWithTitlebar.setLabel(this.componentLabel);
        componentWithTitlebar.add((Component)this.ruleViewScrollPane);
        controlBar.add((Component)this.wrapCheckbox);
        this.contentPanel.add((Component)componentWithTitlebar);
        this.wrapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = decisionTreePreferencesSettings.getWrapNodeRules();
                bl = !bl;
                decisionTreePreferencesSettings.setWrapNodeRules(bl);
                String string = DTTreeRule.getRulesHtml(RulePane.this.treeNode, bl);
                RulePane.this.displayRules(string);
            }
        });
        boolean bl = decisionTreePreferencesSettings.getWrapNodeRules();
        this.wrapCheckbox.setSelected(bl);
        String string = DTTreeRule.getRulesHtml(this.treeNode, bl);
        this.displayRules(string);
    }

    private void displayRules(String string) {
        this.ruleViewPane.setContentType("text/html");
        this.ruleViewPane.setText(string);
        this.ruleViewPane.select(0, 0);
        this.ruleViewPane.setEditable(false);
    }
}

