/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.coefficients;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.controls.DataMinerFindValuesPanel;
import oracle.dmt.dataminer.controls.DataMinerSearchControl;
import oracle.dmt.dataminer.core.dal.sql.queries.StringSearchQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.fe.common.SearchFeatureIdQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionVO;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerMainPanel;
import oracle.dmt.dataminer.mviewer.coefficients.CoefViewerState;
import oracle.dmt.dataminer.mviewer.coefficients.CoefficientsLrb;
import oracle.dmt.dataminer.mviewer.coefficients.GeneralCoefficientFilterPanel;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.modelnodes.ModelNode;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;

public final class ESACoefficientFilterPanel
extends GeneralCoefficientFilterPanel {
    private Version dbVersion;
    private SearchFeatureIdQuery featureIdsQuery;
    private DataMinerFindValuesPanel findPanel;
    private JButton applyFilterButton;
    private JLabel fetchSizeLabel;
    private JSpinner fetchSizeSpinner;
    private ModelViewerPartitionToolbar partitionToolbar;
    private DataMinerSearchControl searchControl;

    public ESACoefficientFilterPanel() {
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    public ESACoefficientFilterPanel(CoefViewerMainPanel coefViewerMainPanel, CoefViewerState coefViewerState) {
        super(coefViewerMainPanel, coefViewerState);
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this.state.getContext());
        this.dbVersion = connectionFolder.getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.applyFilterButton = new JButton();
        this.partitionToolbar = new ModelViewerPartitionToolbar();
        this.searchControl = new DataMinerSearchControl();
        this.fetchSizeLabel = new JLabel();
        this.fetchSizeSpinner = new JSpinner();
        this.applyFilterButton.setText("Query");
        this.applyFilterButton.setEnabled(false);
        this.applyFilterButton.setMaximumSize(new Dimension(87, 23));
        this.applyFilterButton.setMinimumSize(new Dimension(87, 23));
        this.applyFilterButton.setPreferredSize(new Dimension(87, 23));
        this.fetchSizeLabel.setText("Fetch Size Label:");
        this.fetchSizeSpinner.setMaximumSize(new Dimension(87, 20));
        this.fetchSizeSpinner.setMinimumSize(new Dimension(87, 20));
        this.fetchSizeSpinner.setPreferredSize(new Dimension(110, 20));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.partitionToolbar, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.searchControl, -2, 324, -2).addGap(18, 18, Short.MAX_VALUE).addComponent(this.fetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fetchSizeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyFilterButton, -2, 110, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.searchControl, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.applyFilterButton, -1, -1, Short.MAX_VALUE).addComponent(this.fetchSizeSpinner, -2, -1, -2).addComponent(this.fetchSizeLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.partitionToolbar, -2, -1, -2).addGap(10, 10, 10)));
    }

    @Override
    public void initRes() {
        this.searchControl.setLabelText(CoefficientsLrb.get("FEATURE_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.applyFilterButton, (String)CoefficientsLrb.get("QUERY"));
        this.applyFilterButton.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("QUERY"));
        this.applyFilterButton.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("QUERY_ADA"));
        this.applyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        ResourceUtils.resLabel((JLabel)this.fetchSizeLabel, (Component)this.fetchSizeSpinner, (String)CoefficientsLrb.get("FETCH_SIZE"));
        this.fetchSizeLabel.getAccessibleContext().setAccessibleName(CoefficientsLrb.get("FETCH_SIZE"));
        this.fetchSizeLabel.getAccessibleContext().setAccessibleDescription(CoefficientsLrb.get("FETCH_SIZE_ADA"));
        this.fetchSizeSpinner.setToolTipText(CoefficientsLrb.get("FETCH_SIZE_ADA") + "\n" + CoefficientsLrb.get("FETCH_SIZE_RANGE"));
        this.fetchSizeSpinner.setModel(new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1000));
    }

    @Override
    public void initUI() {
        if (this.state != null) {
            this.setNumber(this.fetchSizeSpinner, this.state.getFetchSizeValue());
        }
        this.searchControl.useMagnifyingGlassIcon();
        this.searchControl.setTextFieldEnabled(false);
        this.searchControl.addActionListener(false, actionEvent -> this.findPanel.show(this.searchControl.getSearchButton()));
        Model model = ((ModelNode)this.state.getContext().getNode()).getOdmModel();
        PartitionVO partitionVO = this.partitionToolbar.getPartitionVO();
        ModelDescriptor modelDescriptor = new ModelDescriptor(model.getUserName(), model.getModelName(), partitionVO.getPartitionID());
        this.featureIdsQuery = new SearchFeatureIdQuery(this.dbVersion, ExplicitSemanticAnalysisModelType.class, modelDescriptor);
        this.findPanel = new DataMinerFindValuesPanel(this.state.getContext(), (StringSearchQuery)this.featureIdsQuery, DataMinerFindValuesPanel.DisplayMode.BALLOON);
        this.findPanel.addOKListener(actionEvent -> this.prepareReload(true));
        this.applyFilterButton.addActionListener(actionEvent -> {
            int n = this.getNumber(this.fetchSizeSpinner).intValue();
            this.state.setFetchSizeValue(n);
            this.state.getFilterSetting().setFetchSize(n);
            this.prepareReload(false);
        });
    }

    private void prepareReload(boolean bl) {
        if (this.isLoading()) {
            return;
        }
        String string = this.findPanel.getSelectedValue();
        this.searchControl.setSearchText(string);
        this.state.setSelectedTargetClass(string);
        this.findPanel.close(false);
        this.applyFilterButton.setEnabled(StringUtils.isNotEmpty((String)string));
        this.prepareReload();
    }

    @Override
    protected void loadStateAttributes() {
    }

    @Override
    protected ModelViewerPartitionToolbar getPartitionToolbar() {
        return this.partitionToolbar;
    }

    @Override
    protected JSpinner getFetchSizeComponent() {
        return this.fetchSizeSpinner;
    }

    @Override
    protected JCheckBox getAbsoluteValueComponent() {
        return null;
    }

    public void refreshFindValuesQueryPartitionId() {
        PartitionVO partitionVO = this.partitionToolbar.getPartitionVO();
        this.featureIdsQuery.setPartitionId(partitionVO == null ? null : partitionVO.getPartitionID());
        this.searchControl.setSearchText("");
    }
}

