/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.clustering.compare;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataMinerEditor;
import oracle.dmt.dataminer.DataMinerViewGUI;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.MiniHistogramCellRenderer;
import oracle.dmt.dataminer.core.model.clus.compare.CompareClustersModelRow;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.ModelViewerPartitionToolbar;
import oracle.dmt.dataminer.mviewer.ModelViewerPreferenceSettings;
import oracle.dmt.dataminer.mviewer.clustering.ClusterLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.ClusterCompareTableModel;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClusterViewerState;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersLrb;
import oracle.dmt.dataminer.mviewer.clustering.compare.CompareClustersViewerEditor;
import oracle.dmt.dataminer.mviewer.clustering.compare.RenameClusterPanel;
import oracle.dmt.dataminer.mviewer.clustering.tree.ClusteringTreeEditorLrb;
import oracle.dmt.dataminer.navigator.RefreshController;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.TableMessages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.util.Version;

public class CompareClustersMainPanel
extends DataMinerViewGUI {
    private static final String _tooManyAttributes = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SELECTED_ATTRIBUTES_LIMIT");
    private static final String _noSelectedAttributes = CompareClustersLrb.get("COMPARE_CLUSTERS_DETAIL_SELECTED_ATTRIBUTES_NONE");
    private CompareClusterViewerState _state;
    private JPanel _jlegendPanel;
    private JPanel _jGraphMainPanel;
    private JPanel _jGraphPanel;
    private GraphPanel[] _graphPanel;
    private Map<String, GraphDataModel> prevGraphs;
    private boolean _reload = true;
    private boolean _loadedFilterSetting;
    private Dimension _histogramRowDimension = new Dimension(120, 25);
    private CompareClustersMainPanel instance;
    private JLabel _cluster1Label;
    private JLabel _cluster2Label;
    private JButton _jApplyFilterButton;
    private JComboBox<String> _jCluster1Combo;
    private JLabel _jCluster1ComboLabel;
    private JComboBox<String> _jCluster2Combo;
    private JLabel _jCluster2ComboLabel;
    private JPanel _jDetailPanel;
    private JSpinner _jFetchSize;
    private JLabel _jFetchSizeLabel;
    private JCheckBox _jLeafsOnlyCheckBox;
    private JPanel bottomPanel;
    private DataMinerTablePanel dataMinerTablePanel;
    private JPanel fetchPanel;
    private JPanel fetchPanelLabel;
    private JButton jBtnClister1Edit;
    private JButton jBtnClister2Edit;
    private JSplitPane jSplitPane1;
    private ModelViewerPartitionToolbar modelViewerPartitionToolbar1;
    private JPanel topPanel;

    public CompareClusterViewerState getState() {
        return this._state;
    }

    public CompareClustersMainPanel(Editor editor, Context context) {
        super(editor, context);
        this.prevGraphs = new HashMap<String, GraphDataModel>();
        this._state = new CompareClusterViewerState(context);
        this.instance = this;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this._jCluster1ComboLabel = new JLabel();
        this._jCluster1Combo = new JComboBox();
        this.jBtnClister1Edit = new JButton();
        this._jCluster2ComboLabel = new JLabel();
        this._jCluster2Combo = new JComboBox();
        this.jBtnClister2Edit = new JButton();
        this._jLeafsOnlyCheckBox = new JCheckBox();
        this._jApplyFilterButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this._jDetailPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.fetchPanel = new JPanel();
        this.fetchPanelLabel = new JPanel();
        this.modelViewerPartitionToolbar1 = new ModelViewerPartitionToolbar();
        this._jFetchSize = new JSpinner();
        this._jFetchSizeLabel = new JLabel();
        this.topPanel.setLayout(new FlowLayout(0, 12, 0));
        this._jCluster1ComboLabel.setText("Cluster 1:");
        this.topPanel.add(this._jCluster1ComboLabel);
        this._jCluster1Combo.setMinimumSize(new Dimension(150, 20));
        this._jCluster1Combo.setPreferredSize(new Dimension(170, 23));
        this._jCluster1Combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jCluster1ComboActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this._jCluster1Combo);
        this.jBtnClister1Edit.setText("Edit");
        this.jBtnClister1Edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this.jBtnClister1EditActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this.jBtnClister1Edit);
        this._jCluster2ComboLabel.setText("Cluster 2:");
        this.topPanel.add(this._jCluster2ComboLabel);
        this._jCluster2Combo.setPreferredSize(new Dimension(170, 23));
        this._jCluster2Combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jCluster2ComboActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this._jCluster2Combo);
        this.jBtnClister2Edit.setText("Edit");
        this.jBtnClister2Edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this.jBtnClister2EditActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this.jBtnClister2Edit);
        this._jLeafsOnlyCheckBox.setText("Leafs Only");
        this.topPanel.add(this._jLeafsOnlyCheckBox);
        this._jApplyFilterButton.setText("Query");
        this._jApplyFilterButton.setMaximumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setMinimumSize(new Dimension(87, 23));
        this._jApplyFilterButton.setPreferredSize(new Dimension(87, 23));
        this._jApplyFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jApplyFilterButtonActionPerformed(actionEvent);
            }
        });
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setLeftComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout = new GroupLayout(this._jDetailPanel);
        this._jDetailPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1100, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 168, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this._jDetailPanel);
        this.bottomPanel.setLayout(new BorderLayout());
        this.fetchPanel.setLayout(new FlowLayout(0, 0, 0));
        this.fetchPanelLabel.setLayout(new FlowLayout(0, 12, 0));
        this.fetchPanel.add(this.fetchPanelLabel);
        this.bottomPanel.add((Component)this.fetchPanel, "East");
        this.bottomPanel.add((Component)this.modelViewerPartitionToolbar1, "Center");
        this._jFetchSize.setMaximumSize(new Dimension(87, 20));
        this._jFetchSize.setMinimumSize(new Dimension(87, 20));
        this._jFetchSize.setPreferredSize(new Dimension(110, 20));
        this._jFetchSizeLabel.setText("Fetch Size:");
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.topPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this._jFetchSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jFetchSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jApplyFilterButton, -2, 110, -2)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bottomPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1)))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jApplyFilterButton, -2, -1, -2).addComponent(this._jFetchSize, -2, -1, -2).addComponent(this._jFetchSizeLabel)).addComponent(this.topPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 376, Short.MAX_VALUE).addContainerGap()));
    }

    private void _jCluster1ComboActionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setClusterLabel1((String)this._jCluster1Combo.getSelectedItem());
    }

    private void _jCluster2ComboActionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        this._state.setClusterLabel2((String)this._jCluster2Combo.getSelectedItem());
    }

    private void _jApplyFilterButtonActionPerformed(ActionEvent actionEvent) {
        this._jApplyFilterButton_actionPerformed(actionEvent);
    }

    private void jBtnClister1EditActionPerformed(ActionEvent actionEvent) {
        this.renameCluster(this._jCluster1Combo, this._jCluster2Combo, true);
    }

    private void jBtnClister2EditActionPerformed(ActionEvent actionEvent) {
        this.renameCluster(this._jCluster2Combo, this._jCluster1Combo, false);
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this._jApplyFilterButton, (String)ClusterLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleName(ClusterLrb.get("QUERY"));
        this._jApplyFilterButton.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("QUERY_ADA"));
        this._jApplyFilterButton.setIcon(OracleIcons.getIcon((String)"run.png"));
        this._jApplyFilterButton.setToolTipText(ClusterLrb.get("QUERY_ADA"));
        ResourceUtils.resLabel((JLabel)this._jFetchSizeLabel, (Component)this._jFetchSize, (String)ClusterLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleName(ClusterLrb.get("FETCH_SIZE"));
        this._jFetchSizeLabel.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("FETCH_SIZE_ADA"));
        this._jFetchSize.setToolTipText(ClusterLrb.get("FETCH_SIZE_ADA") + "\n" + ClusterLrb.get("FETCH_SIZE_RANGE"));
        this._jFetchSize.setModel(new SpinnerNumberModel(ModelViewerPreferenceSettings.getInstance().getFetchSizeClusteringModel(), 1, Integer.MAX_VALUE, 100));
        ResourceUtils.resButton((AbstractButton)this.jBtnClister1Edit, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT"));
        this.jBtnClister1Edit.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT"));
        this.jBtnClister1Edit.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jBtnClister2Edit, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT2"));
        this.jBtnClister2Edit.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT"));
        this.jBtnClister2Edit.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_EDIT_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jLeafsOnlyCheckBox, (String)ClusterLrb.get("LEAVES_ONLY"));
        this._jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleName(ClusterLrb.get("LEAVES_ONLY"));
        this._jLeafsOnlyCheckBox.getAccessibleContext().setAccessibleDescription(ClusterLrb.get("LEAVES_ONLY_ADA"));
        this._jLeafsOnlyCheckBox.setToolTipText(ClusterLrb.get("LEAVES_ONLY_ADA"));
        ResourceUtils.resLabel((JLabel)this._jCluster1ComboLabel, this._jCluster1Combo, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER1"));
        this._jCluster1ComboLabel.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER1"));
        this._jCluster1ComboLabel.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER1_ADA"));
        ResourceUtils.resLabel((JLabel)this._jCluster2ComboLabel, this._jCluster2Combo, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER2"));
        this._jCluster2ComboLabel.getAccessibleContext().setAccessibleName(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER2"));
        this._jCluster2ComboLabel.getAccessibleContext().setAccessibleDescription(CompareClustersLrb.get("COMPARE_CLUSTERS_VIEWER_CLUSTER2_ADA"));
        this.loadRowsOutOfTotalLabel(0, 0);
    }

    public void initUI() {
        this._jFetchSize.setLocale(Locale.getDefault());
        this._jLeafsOnlyCheckBox.setSelected(true);
        this._jLeafsOnlyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompareClustersMainPanel.this._jLeafsOnlyCheckBox_actionPerformed(actionEvent);
            }
        });
        this._jGraphPanel = new JPanel();
        this._jGraphPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this._jGraphPanel);
        this._jGraphMainPanel = new JPanel();
        this._jGraphMainPanel.setLayout(new BorderLayout());
        this._jGraphMainPanel.setPreferredSize(new Dimension(300, 300));
        this._jGraphMainPanel.add((Component)jScrollPane, "Center");
        this.jSplitPane1.setResizeWeight(0.8);
        this.jSplitPane1.setDividerLocation(400);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setRightComponent(this._jGraphMainPanel);
        this.dataMinerTablePanel.getTable().setFillsViewportHeight(true);
        this.dataMinerTablePanel.getTable().setSelectionMode(2);
        this.dataMinerTablePanel.getTable().setShowGrid(true);
        this.dataMinerTablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                CompareClustersMainPanel.this.handleSelectionChanged();
            }
        });
        this.setLoading(true);
        this.initializeControls();
        this._jCluster1Combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object = CompareClustersMainPanel.this._jCluster2Combo.getSelectedItem();
                    CompareClustersMainPanel.this._jCluster2Combo.setModel(CompareClustersMainPanel.this.convertDataSource(CompareClustersMainPanel.this._state.getClusterLabels(), CompareClustersMainPanel.this._jCluster1Combo.getSelectedItem()));
                    CompareClustersMainPanel.this._jCluster2Combo.setSelectedItem(object);
                    if (CompareClustersMainPanel.this._jCluster2Combo.getSelectedItem() != null) {
                        CompareClustersMainPanel.this._state.setClusterLabel2((String)CompareClustersMainPanel.this._jCluster2Combo.getSelectedItem());
                    }
                }
            }
        });
        this.modelViewerPartitionToolbar1.setVisible(false);
        this.jSplitPane1.updateUI();
    }

    @Override
    public void load() {
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    public void reloadForQuery() {
        this.setLoading(true);
        this.enableControls(false);
        this.dataMinerTablePanel.getTable().repaint();
        this.createMessagePanel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
        this.prevGraphs.clear();
        LoadUIReloadQuery loadUIReloadQuery = new LoadUIReloadQuery();
        loadUIReloadQuery.execute();
    }

    @Override
    public void reload() {
        this.setLoading(true);
        this.enableControls(false);
        this.dataMinerTablePanel.getTable().repaint();
        this.createMessagePanel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
        this.prevGraphs.clear();
        LoadUI loadUI = new LoadUI();
        loadUI.setExternalLoad(true);
        loadUI.execute();
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setNoEntryInstructionText(TableMessages.LOADING.getMessage());
        this.enableControls(false);
    }

    public void loadClusterCombos() {
        String string;
        List<String> list = this._state.getClusterLabels();
        this._jCluster1Combo.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[list.size()])));
        if (list.size() > 1) {
            this._jCluster2Combo.setModel(this.convertDataSource(list, this._state.getClusterLabel1()));
        }
        String string2 = string = this._state.getClusterLabel1();
        if (list.contains(string)) {
            this._jCluster1Combo.setSelectedItem(string);
        } else if (list.size() > 0) {
            string2 = list.get(0);
            this._state.setClusterLabel1(string2);
            this._jCluster1Combo.setSelectedItem(string2);
        }
        String string3 = this._state.getClusterLabel2();
        if (string3 == null) {
            return;
        }
        String string4 = string3;
        if (list.contains(string3)) {
            this._jCluster2Combo.setSelectedItem(string3);
        } else {
            int n = 0;
            do {
                if (list.contains(string3)) continue;
                string4 = list.get(n++);
            } while (string4.equals(string2));
            this._state.setClusterLabel2(string4);
            this._jCluster2Combo.setSelectedItem(string4);
        }
    }

    private void enableControls(boolean bl) {
        this._jApplyFilterButton.setEnabled(bl);
        this._jFetchSize.setEnabled(bl);
        this._jFetchSizeLabel.setEnabled(bl);
        this._jCluster1Combo.setEnabled(bl);
        this._jCluster2Combo.setEnabled(bl);
        this.jBtnClister1Edit.setEnabled(bl);
        this.jBtnClister2Edit.setEnabled(bl);
        if (!this._state.getLevelDetails()) {
            this._jLeafsOnlyCheckBox.setEnabled(false);
        } else {
            this._jLeafsOnlyCheckBox.setEnabled(bl);
        }
    }

    private void _jLeafsOnlyCheckBox_actionPerformed(ActionEvent actionEvent) {
        if (this.isLoading()) {
            return;
        }
        boolean bl = this._jLeafsOnlyCheckBox.isSelected();
        this._state.setLeafsOnlyNew(bl);
        this._reload = false;
        this.loadClusterCombos();
        this._reload = true;
        if (null == this._state.getClusterLabel2()) {
            return;
        }
        this._jApplyFilterButton_actionPerformed(null);
    }

    protected void _jApplyFilterButton_actionPerformed(ActionEvent actionEvent) {
        this._jApplyFilterButton.setEnabled(false);
        if (this.validateSettings()) {
            if (this.overLayPanel != null) {
                this.overLayPanel.setState(BlockingComponent.State.BLOCKED);
            }
            this.reloadForQuery();
        }
    }

    private void renameCluster(JComboBox<String> jComboBox, JComboBox<String> jComboBox2, boolean bl) {
        String string = (String)jComboBox.getSelectedItem();
        RenameClusterPanel renameClusterPanel = new RenameClusterPanel(this.getContext(), this._state, string);
        if (renameClusterPanel.showAsDialog(this)) {
            try {
                String string2 = this._state.renameClusterLabelNew(renameClusterPanel.getCurrentName(), string);
                this.setLoading(true);
                String string3 = (String)jComboBox.getSelectedItem();
                Vector<String> vector = new Vector<String>(this._state.getClusterLabels());
                jComboBox.setModel(new DefaultComboBoxModel<String>(vector));
                jComboBox.getModel().setSelectedItem(string2);
                String string4 = (String)jComboBox2.getSelectedItem();
                if (bl) {
                    jComboBox2.setModel(this.convertDataSource(vector, string2));
                } else {
                    jComboBox2.setModel(new DefaultComboBoxModel<String>(vector));
                }
                if (string3.equals(string4)) {
                    jComboBox2.getModel().setSelectedItem(string2);
                } else {
                    jComboBox2.getModel().setSelectedItem(string4);
                }
                this._jApplyFilterButton_actionPerformed(null);
                CompareClustersViewerEditor compareClustersViewerEditor = (CompareClustersViewerEditor)this.getEditor();
                RefreshController.getInstance().forceRefreshInSiblingEditors(compareClustersViewerEditor.getParentNodeId(), this.getEditor());
            }
            catch (Exception exception) {
                if (exception.getMessage().equals(CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"))) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_NO_PRIVILEGE_MESG"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), null);
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_TITLE"), (String)CompareClustersLrb.get("COMPARE_CLUSTERS_RENAME_FAILURE_MESG"), null);
            }
        }
    }

    private boolean validateSettings() {
        boolean bl = false;
        bl = true;
        Number number = this.getNumber(this._jFetchSize);
        this._state.getFilterSetting().setFetchSize(number.intValue());
        this._state.getFilterSetting().setUseFilterSpecification(false);
        return bl;
    }

    private Number getNumber(JSpinner jSpinner) {
        return (Number)jSpinner.getValue();
    }

    private void loadRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ClusterLrb.get("ATTRIBUTES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format((int)n);
        String string3 = NumericFormat.format((int)n2);
        String string4 = MessageFormat.format(string, string2, string3);
        this.dataMinerTablePanel.setTitle(string4);
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this._state.getHelpInfo();
    }

    @Override
    public void setLoading(boolean bl) {
        super.setLoading(bl);
        this.enableControls(!bl);
    }

    private void setupTable(GenericBaseTableModel genericBaseTableModel) {
        this.dataMinerTablePanel.setup((TableModel)genericBaseTableModel, null, new String[]{ClusterCompareTableModel.COL_NAMES[0], ClusterCompareTableModel.COL_NAMES[1]}, 1);
        this.dataMinerTablePanel.getTable().setRowHeight((int)this._histogramRowDimension.getHeight());
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getIntegerRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
        MiniHistogramCellRenderer miniHistogramCellRenderer = new MiniHistogramCellRenderer(this._state, this._histogramRowDimension, 20);
        TableColumnModel tableColumnModel = this.dataMinerTablePanel.getTable().getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(tableCellRenderer2);
        tableColumnModel.getColumn(3).setCellRenderer(miniHistogramCellRenderer);
        if (genericBaseTableModel instanceof ClusterCompareTableModel) {
            tableColumnModel.getColumn(0).setPreferredWidth(200);
            tableColumnModel.getColumn(1).setPreferredWidth(50);
            tableColumnModel.getColumn(2).setPreferredWidth(100);
            tableColumnModel.getColumn(3).setPreferredWidth(150);
            tableColumnModel.getColumn(4).setPreferredWidth(100);
            tableColumnModel.getColumn(5).setPreferredWidth(100);
        } else {
            tableColumnModel.getColumn(0).setPreferredWidth(800);
        }
    }

    private DefaultComboBoxModel<String> convertDataSource(List<String> list, Object object) {
        int n = 0;
        n = object == null ? list.size() : list.size() - 1;
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (object != null && string.equals(object)) continue;
            stringArray[n2++] = string;
        }
        return new DefaultComboBoxModel<String>(stringArray);
    }

    @Override
    public void setLoaded(boolean bl) {
        super.setLoaded(bl);
        if (!this._loadedFilterSetting) {
            this._loadedFilterSetting = true;
        }
    }

    public void createMessagePanel(String string) {
        this._jGraphPanel.removeAll();
        this._jGraphPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont((float)font.getSize() * 2.0f);
        jLabel.setFont(font2);
        int n = this._jGraphPanel.getGraphics() != null ? this._jGraphPanel.getGraphics().getFontMetrics(font2).stringWidth(string) : 400;
        Dimension dimension = this._jGraphPanel.getSize();
        jPanel.add(Box.createHorizontalStrut((dimension.width - n) / 2));
        jPanel.add(jLabel);
        this._jGraphPanel.add(jPanel);
        this._jGraphPanel.updateUI();
        this.hideLegendPanel();
    }

    private void handleSelectionChanged() {
        if (!(this.dataMinerTablePanel.getTable().getModel() instanceof ClusterCompareTableModel)) {
            return;
        }
        boolean bl = true;
        ClusterCompareTableModel clusterCompareTableModel = (ClusterCompareTableModel)((Object)this.dataMinerTablePanel.getTable().getModel());
        if (clusterCompareTableModel.getSrcData() == null || clusterCompareTableModel.getSrcData().size() == 0 || ((CompareClustersModelRow)clusterCompareTableModel.getSrcData().get(0)).getCluster1Label1() == null || ((CompareClustersModelRow)clusterCompareTableModel.getSrcData().get(0)).getCluster1Label1().equals("")) {
            return;
        }
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = null;
        if (null == nArray || nArray.length == 0) {
            bl = false;
            string = _noSelectedAttributes;
        } else if (nArray.length > 12) {
            bl = false;
            string = _tooManyAttributes;
        }
        if (!bl) {
            this.createMessagePanel(string);
            return;
        }
        if (!this._state.isLoaded()) {
            return;
        }
        LoadGraphPanel loadGraphPanel = new LoadGraphPanel(nArray);
        loadGraphPanel.execute();
    }

    private void showLegendPanel(GraphDataModel graphDataModel) {
        if (this._jlegendPanel != null) {
            this._cluster1Label.setText(graphDataModel.getRowLabels()[1].toString());
            this._cluster2Label.setText(graphDataModel.getRowLabels()[0].toString());
        } else {
            this._jlegendPanel = new JPanel(new FlowLayout());
            DynamicIcon dynamicIcon = new DynamicIcon(CompareClusterViewerState.colors[1]);
            this._cluster1Label = new JLabel(graphDataModel.getRowLabels()[1].toString(), dynamicIcon, 2);
            this._jlegendPanel.add(this._cluster1Label);
            DynamicIcon dynamicIcon2 = new DynamicIcon(CompareClusterViewerState.colors[0]);
            this._cluster2Label = new JLabel(graphDataModel.getRowLabels()[0].toString(), dynamicIcon2, 2);
            this._jlegendPanel.add(this._cluster2Label);
        }
    }

    private void hideLegendPanel() {
        if (this._jlegendPanel != null) {
            this._jGraphMainPanel.remove(this._jlegendPanel);
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Boolean, Void> {
        private boolean externalLoad;

        public void setExternalLoad(boolean bl) {
            this.externalLoad = bl;
        }

        public LoadUI() {
            super(CompareClustersMainPanel.this, CompareClustersMainPanel.this.overLayPanel, CompareClustersMainPanel.this.dataMinerTablePanel.getTable());
            this.externalLoad = false;
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            CompareClustersMainPanel.this.modelViewerPartitionToolbar1.load(CompareClustersMainPanel.this.getEditor());
            CompareClustersMainPanel.this._state.load(CompareClustersMainPanel.this.modelViewerPartitionToolbar1.getSelectedPartitionID(), this.externalLoad);
            return CompareClustersMainPanel.this._state.isLoaded();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(CompareClustersMainPanel.this.getEditor().getContext(), throwable, ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"));
        }

        @Override
        protected void onSuccess(Boolean bl) throws Exception {
            if (!CompareClustersMainPanel.this._state.getLevelDetails()) {
                if (DbVersionHelper.isDB122Up((Version)CompareClustersMainPanel.this._state.getDbVersion())) {
                    CompareClustersMainPanel.this.dataMinerTablePanel.getTable().setNoEntryInstructionText("");
                    CompareClustersMainPanel.this.setupTable(new ClusterCompareTableModel(false));
                    CompareClustersMainPanel.this._jCluster2Combo.removeAllItems();
                    CompareClustersMainPanel.this._jCluster1Combo.removeAllItems();
                    CompareClustersMainPanel.this.createMessagePanel(ClusteringTreeEditorLrb.get("KM_NOMODEL_DETAILS_MESSAGE"));
                } else {
                    CompareClustersMainPanel.this.setupTable(new ClusterCompareTableModel(true));
                }
            } else {
                CompareClustersMainPanel.this._state.loadDataUI(false);
                CompareClustersMainPanel.this._jCluster1Combo.setModel(CompareClustersMainPanel.this.convertDataSource(CompareClustersMainPanel.this._state.getClusterLabels(), null));
                CompareClustersMainPanel.this._jCluster1Combo.setSelectedItem(CompareClustersMainPanel.this._state.getClusterLabel1());
                CompareClustersMainPanel.this._jCluster1Combo.setRenderer(new ComboBoxRenderer(0));
                if (CompareClustersMainPanel.this._state.getClusterLabel2() == null) {
                    CompareClustersMainPanel.this._jCluster2Combo.setVisible(false);
                    CompareClustersMainPanel.this._jCluster2ComboLabel.setVisible(false);
                    CompareClustersMainPanel.this.jBtnClister2Edit.setVisible(false);
                    if (CompareClustersMainPanel.this._state.getClusterLabels() != null && CompareClustersMainPanel.this._state.getClusterLabels().size() <= 1) {
                        CompareClustersMainPanel.this._jLeafsOnlyCheckBox.setSelected(false);
                        CompareClustersMainPanel.this._jLeafsOnlyCheckBox.setEnabled(false);
                    }
                } else {
                    CompareClustersMainPanel.this._jCluster2Combo.setModel(CompareClustersMainPanel.this.convertDataSource(CompareClustersMainPanel.this._state.getClusterLabels(), CompareClustersMainPanel.this._state.getClusterLabel1()));
                    CompareClustersMainPanel.this._jCluster2Combo.setSelectedItem(CompareClustersMainPanel.this._state.getClusterLabel2());
                    CompareClustersMainPanel.this._jCluster2Combo.setRenderer(new ComboBoxRenderer(1));
                }
                if (((ODMrTableModel)CompareClustersMainPanel.this._state.getTableModel()).getSrcData().size() > 0) {
                    CompareClustersMainPanel.this.setupTable(CompareClustersMainPanel.this._state.getTableModel());
                    CompareClustersMainPanel.this.dataMinerTablePanel.trySearch();
                    CompareClustersMainPanel.this.loadRowsOutOfTotalLabel(CompareClustersMainPanel.this._state.getTableModel().getRowCount(), CompareClustersMainPanel.this._state.getTotalNumberOfModelAttributesNew());
                    CompareClustersMainPanel.this.enableControls(true);
                    if (CompareClustersMainPanel.this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                        int n = CompareClustersMainPanel.this.dataMinerTablePanel.getTable().convertRowIndexToModel(0);
                        CompareClustersMainPanel.this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{n});
                    }
                    CompareClustersMainPanel.this._state.reloadClusterCacheNew();
                } else {
                    CompareClustersMainPanel.this.setupTable(new ClusterCompareTableModel(true));
                    CompareClustersMainPanel.this.createMessagePanel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
                }
            }
            CompareClustersMainPanel.this.setLoaded(true);
        }

        @Override
        protected void onFinally() {
            CompareClustersMainPanel.this.setLoading(false);
            CompareClustersMainPanel.this._jApplyFilterButton.setEnabled(CompareClustersMainPanel.this._state.getClusterLabel2() != null);
        }
    }

    private class LoadUIReloadQuery
    extends ODMrSwingWorker<Boolean, Void> {
        public LoadUIReloadQuery() {
            super(CompareClustersMainPanel.this, CompareClustersMainPanel.this.overLayPanel, CompareClustersMainPanel.this.dataMinerTablePanel.getTable());
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            CompareClustersMainPanel.this.modelViewerPartitionToolbar1.load(CompareClustersMainPanel.this.getEditor());
            CompareClustersMainPanel.this._state.reload(CompareClustersMainPanel.this.modelViewerPartitionToolbar1.getSelectedPartitionID());
            return CompareClustersMainPanel.this._state.isLoaded();
        }

        @Override
        protected void onFailure(Throwable throwable) {
            DataMinerEditor.handleEditorException(CompareClustersMainPanel.this.getEditor().getContext(), throwable, ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"));
        }

        @Override
        protected void onSuccess(Boolean bl) throws Exception {
            if (!CompareClustersMainPanel.this._state.getLevelDetails()) {
                if (DbVersionHelper.isDB122Up((Version)CompareClustersMainPanel.this._state.getDbVersion())) {
                    CompareClustersMainPanel.this.dataMinerTablePanel.getTable().setNoEntryInstructionText("");
                    CompareClustersMainPanel.this.setupTable(new ClusterCompareTableModel(false));
                    CompareClustersMainPanel.this._jCluster2Combo.removeAllItems();
                    CompareClustersMainPanel.this._jCluster1Combo.removeAllItems();
                    CompareClustersMainPanel.this.createMessagePanel(ClusteringTreeEditorLrb.get("KM_NOMODEL_DETAILS_MESSAGE"));
                } else {
                    CompareClustersMainPanel.this.setupTable(new ClusterCompareTableModel(true));
                }
            } else {
                CompareClustersMainPanel.this._state.loadDataUI(false);
                if (((ODMrTableModel)CompareClustersMainPanel.this._state.getTableModel()).getSrcData().size() > 0) {
                    CompareClustersMainPanel.this.setupTable(CompareClustersMainPanel.this._state.getTableModel());
                    CompareClustersMainPanel.this.dataMinerTablePanel.trySearch();
                    CompareClustersMainPanel.this.loadRowsOutOfTotalLabel(CompareClustersMainPanel.this._state.getTableModel().getRowCount(), CompareClustersMainPanel.this._state.getTotalNumberOfModelAttributesNew());
                    CompareClustersMainPanel.this.enableControls(true);
                    if (CompareClustersMainPanel.this.dataMinerTablePanel.getTable().getRowCount() > 0) {
                        int n = CompareClustersMainPanel.this.dataMinerTablePanel.getTable().convertRowIndexToModel(0);
                        CompareClustersMainPanel.this.dataMinerTablePanel.getTable().setSelectedRowsInModel(new int[]{n});
                    }
                    CompareClustersMainPanel.this._state.reloadClusterCacheNew();
                } else {
                    CompareClustersMainPanel.this.setupTable(new ClusterCompareTableModel(true));
                    CompareClustersMainPanel.this.createMessagePanel(ClusterLrb.get("NO_HISTOGRAM_TO_DISPLAY"));
                }
            }
            CompareClustersMainPanel.this.setLoaded(true);
        }

        @Override
        protected void onFinally() {
            CompareClustersMainPanel.this.setLoading(false);
            CompareClustersMainPanel.this._jApplyFilterButton.setEnabled(CompareClustersMainPanel.this._state.getClusterLabel2() != null);
        }
    }

    private class LoadGraphPanel
    extends SwingWorker {
        Exception _ex = null;
        boolean _success = false;
        GraphDataModel[] localGraphModel = null;
        int[] _selectedRowsInModel;

        public LoadGraphPanel(int[] nArray) {
            this._selectedRowsInModel = nArray;
            this.localGraphModel = new GraphDataModel[nArray.length];
        }

        protected Object doInBackground() throws Exception {
            try {
                ClusterCompareTableModel clusterCompareTableModel = (ClusterCompareTableModel)((Object)CompareClustersMainPanel.this.dataMinerTablePanel.getTable().getModel());
                List list = clusterCompareTableModel.getSrcData();
                for (int i = 0; i < this._selectedRowsInModel.length; ++i) {
                    CompareClustersModelRow compareClustersModelRow = (CompareClustersModelRow)list.get(this._selectedRowsInModel[i]);
                    String string = compareClustersModelRow.getFullAttributeName();
                    if (!CompareClustersMainPanel.this.prevGraphs.containsKey(string)) {
                        this.localGraphModel[i] = CompareClustersMainPanel.this._state.createGraphDataModelForAttribute(string);
                        CompareClustersMainPanel.this.prevGraphs.put(string, this.localGraphModel[i]);
                        continue;
                    }
                    this.localGraphModel[i] = CompareClustersMainPanel.this.prevGraphs.get(string);
                }
                this._success = true;
            }
            catch (Exception exception) {
                this._ex = exception;
                this._success = false;
            }
            return CompareClustersMainPanel.this._state;
        }

        @Override
        protected void done() {
            super.done();
            if (this._success && this._ex == null) {
                int n;
                int n2 = this._selectedRowsInModel.length;
                CompareClustersMainPanel.this._graphPanel = new GraphPanel[n2];
                for (n = 0; n < n2; ++n) {
                    CompareClustersMainPanel.this._graphPanel[n] = new GraphPanel(this.localGraphModel[n]);
                    this.localGraphModel[n].setDepthRadius(Integer.valueOf(CompareClustersMainPanel.this._state.getDepthRadius()));
                    boolean bl = false;
                    if (n2 == 1) {
                        bl = true;
                        this.localGraphModel[n].setLegendSeriesCount(Integer.valueOf(2));
                    }
                    this.localGraphModel[n].setLegendVisible(bl);
                    CompareClustersMainPanel.this._graphPanel[n].initGraph();
                    this.localGraphModel[n].setStyleSelection(CompareClustersMainPanel.this._state.getStyleSelection());
                    CompareClustersMainPanel.this._graphPanel[n].updateGraphStyle();
                }
                CompareClustersMainPanel.this._jGraphPanel.removeAll();
                if (n2 == 1) {
                    CompareClustersMainPanel.this._jGraphPanel.setLayout(new BorderLayout());
                    CompareClustersMainPanel.this._jGraphPanel.add((Component)CompareClustersMainPanel.this._graphPanel[0], "Center");
                } else if (n2 % 3 == 0) {
                    CompareClustersMainPanel.this._jGraphPanel.setLayout(new GridLayout(0, 3));
                } else {
                    CompareClustersMainPanel.this._jGraphPanel.setLayout(new GridLayout(0, 2));
                }
                for (n = 0; n < n2; ++n) {
                    CompareClustersMainPanel.this._jGraphPanel.add(CompareClustersMainPanel.this._graphPanel[n]);
                }
                CompareClustersMainPanel.this._jGraphPanel.updateUI();
                if (n2 == 1) {
                    CompareClustersMainPanel.this.hideLegendPanel();
                } else {
                    CompareClustersMainPanel.this.showLegendPanel(this.localGraphModel[0]);
                    CompareClustersMainPanel.this._jGraphMainPanel.add((Component)CompareClustersMainPanel.this._jlegendPanel, "Last");
                }
                CompareClustersMainPanel.this._jGraphMainPanel.updateUI();
            } else if (this._ex != null) {
                DataMinerEditor.handleEditorException(CompareClustersMainPanel.this.getEditor().getContext(), this._ex, ClusterLrb.get("DETAIL_CLUSTER_FAILURE_TITLE"), ClusterLrb.get("DETAIL_CLUSTER_FAILURE_MESG"));
            }
        }
    }

    private static class DynamicIcon
    implements Icon {
        Color color;

        DynamicIcon(Color color) {
            this.color = color;
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 2, 10, 10);
        }
    }

    private static class ComboBoxRenderer
    extends BasicComboBoxRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private Integer clusterId;

        ComboBoxRenderer(Integer n) {
            this.clusterId = n;
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DynamicIcon dynamicIcon = new DynamicIcon(CompareClusterViewerState.colors[this.clusterId]);
            if (!bl) {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            } else {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            }
            this.setIcon(dynamicIcon);
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

