/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.rules;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.IconHintLabel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.model.ar.ItemSetStructure;
import oracle.dmt.dataminer.core.model.ar.Rule;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.arrules.ARPreferences;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ItemSetStructurePreferencePanel;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARRuleDetailViewer;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARRulesViewerState;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARRulesViewerTableModel;
import oracle.dmt.dataminer.mviewer.arrules.rules.ARSaveRulesPanel;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.UITools;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;

public class ARRulesViewer
extends JPanel
implements DataminerGUIPanel {
    private ARRulesViewerState state;
    private ARRulesViewerTableModel tableModel;
    private JPanel jPanel1;
    private JSplitPane jSplitPane1;
    private ARRuleDetailViewer ruleDetailViewer;
    private DataMinerTablePanel rulesTablePanel;
    private JButton jSaveRulesBtn;
    private JButton jRuleStructureBtn;
    private IconHintLabel jAggregatesHintLbl;

    public ARRulesViewer(ARRulesViewerState aRRulesViewerState) {
        this.state = aRRulesViewerState;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.rulesTablePanel = new DataMinerTablePanel();
        this.ruleDetailViewer = new ARRuleDetailViewer();
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.65);
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.rulesTablePanel, -1, 596, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.rulesTablePanel, -1, 284, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jSplitPane1.setRightComponent(this.ruleDetailViewer);
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jSplitPane1).addGap(0, 0, 0)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 450, Short.MAX_VALUE));
    }

    @Override
    public void initRes() {
        this.jAggregatesHintLbl = new IconHintLabel(ARRulesLrb.get("AR_AGGREGATES_HINT"));
    }

    @Override
    public void initUI() {
        this.ruleDetailViewer.displayDetailsFor(Collections.emptyList());
        this.jRuleStructureBtn = new JButton();
        this.jRuleStructureBtn.setIcon(OracleIcons.getIcon((String)"extras/small-gear.png"));
        this.jRuleStructureBtn.addActionListener(new ItemSetStructureActionListener());
        this.jRuleStructureBtn.setToolTipText(ARRulesLrb.get("RULE_ITEMSET_FORMAT_BTN_TOOLTIP"));
        this.jSaveRulesBtn = new JButton(ARRulesLrb.get("SAVE_RULES_TITLE"));
        this.jSaveRulesBtn.addActionListener(new ArSaveRulesActionListener());
        this.rulesTablePanel.addControlBarComponents(this.jSaveRulesBtn, this.jRuleStructureBtn);
    }

    void beforeLoad() {
        this.ruleDetailViewer.displayDetailsFor(null);
        this.setRowsOutOfTotalLabel(0, 0);
    }

    void afterLoad() {
        this.setupArTable();
        this.checkAggregates();
        this.updateColumnsToDisplay();
        this.afterQuery();
    }

    void afterQuery() {
        this.setRowsOutOfTotalLabel(this.state.getRulesData().size(), this.state.getTotalRulesCount());
        this.setupArTableData();
    }

    private void setRowsOutOfTotalLabel(Integer n, Integer n2) {
        String string = ARRulesLrb.get("RULES_ROWS_OUT_OF_TOTAL");
        String string2 = NumericFormat.format((int)n);
        String string3 = NumericFormat.format((int)n2);
        String string4 = MessageFormat.format(string, string2, string3);
        this.rulesTablePanel.setTitle(string4);
    }

    private void checkAggregates() {
        boolean bl;
        boolean bl2 = bl = this.state.aggregates().size() > 0;
        if (bl) {
            this.rulesTablePanel.addHint(this.jAggregatesHintLbl);
        } else {
            this.rulesTablePanel.removeHint(this.jAggregatesHintLbl);
        }
        this.ruleDetailViewer.enableAggregateDetails(bl);
    }

    private void setupArTable() {
        boolean bl = this.state.aggregates().size() > 0;
        this.tableModel = bl ? new ARRulesViewerTableModel(this.state.getDatabaseVersion(), this.state.aggregates()) : new ARRulesViewerTableModel(this.state.getDatabaseVersion());
        this.rulesTablePanel.getTable().setColumnSelectorAvailable(true);
        this.rulesTablePanel.getTable().setSelectionMode(2);
        this.rulesTablePanel.getTable().getSelectionModel().addListSelectionListener(new RulesTableSelectionListener());
        this.rulesTablePanel.getTable().setFixedColumns(1, 65);
        this.rulesTablePanel.setup((TableModel)((Object)this.tableModel), null, new String[]{ARRulesViewerTableModel.COLUMN_NAMES[1], ARRulesViewerTableModel.COLUMN_NAMES[2]}, 0);
        TableColumnModel tableColumnModel = this.rulesTablePanel.getTable().getFullColumnModel();
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(4.0, true, Formats.ModelViewer.getPercentage());
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerPercentRenderer();
        TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
        TableCellRenderer tableCellRenderer3 = FormatTableCellRenderer.getIntegerRenderer();
        Double d = this.state.getMaximumLiftValue();
        if (d != null && d != 0.0) {
            histogramBarRenderer.setMaximumValue(d);
        } else {
            histogramBarRenderer.setMaximumValue(100.0);
        }
        tableColumnModel.getColumn(3).setCellRenderer(histogramBarRenderer);
        tableColumnModel.getColumn(4).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(5).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(6).setCellRenderer(tableCellRenderer3);
        tableColumnModel.getColumn(8).setCellRenderer(tableCellRenderer);
        tableColumnModel.getColumn(7).setCellRenderer(tableCellRenderer);
        if (DbVersionHelper.isDB122Up((Version)this.state.getDatabaseVersion())) {
            tableColumnModel.getColumn(9).setCellRenderer(tableCellRenderer);
        }
        for (int i = 0; i < this.state.aggregates().size(); ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = ARRulesViewerTableModel.COLUMN_NAMES_12_2.length + i * 8 + j;
                tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer2);
            }
        }
        if (this.state.getTotalRulesCount() == 0) {
            this.rulesTablePanel.getTable().setNoEntryInstructionText(ARRulesLrb.get("NO_RULES_IN_MODEL"));
        }
    }

    private void setupArTableData() {
        UITools.setTableModelData(this.getRulesTable(), this.state.getRulesData());
        this.rulesTablePanel.getTable().autoSizeColumnsToFit();
    }

    private void updateColumnsToDisplay() {
        int n;
        int n2;
        int n3;
        ARPreferences aRPreferences = ARPreferences.getInstance();
        boolean bl = !aRPreferences.getShowRuleColumn();
        boolean bl2 = !aRPreferences.getShowAntecedentColumn();
        boolean bl3 = !aRPreferences.getShowConsequentColumn();
        boolean bl4 = !aRPreferences.getShowItemsetAntecedentColumn();
        boolean bl5 = !aRPreferences.getShowItemsetConsequentColumn();
        boolean bl6 = !aRPreferences.getShowAverageColumn();
        boolean[] blArray = new boolean[]{bl, bl2, bl3, bl4, bl5};
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = this.tableModel.getLastColumnIndex();
        for (n3 = 0; n3 < this.state.aggregates().size(); ++n3) {
            boolean[] blArray2 = blArray;
            n2 = blArray2.length;
            for (n = 0; n < n2; ++n) {
                boolean bl7 = blArray2[n];
                if (bl7) {
                    arrayList.add(n4);
                }
                ++n4;
            }
            n4 += 3;
        }
        n3 = this.tableModel.getLastColumnIndex() + blArray.length;
        for (int i = 0; i < this.state.aggregates().size(); ++i) {
            for (n2 = 0; n2 < 3; ++n2) {
                n = blArray[n2];
                if (n != 0 || bl6) {
                    arrayList.add(n3);
                }
                ++n3;
            }
            n3 += blArray.length;
        }
        int[] nArray = new int[arrayList.size()];
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            nArray[n2] = (Integer)arrayList.get(n2);
        }
        this.rulesTablePanel.getTable().setHiddenColumns(nArray);
    }

    DataMinerTable getRulesTable() {
        return this.rulesTablePanel.getTable();
    }

    private class ItemSetStructureActionListener
    implements ActionListener {
        private ItemSetStructureActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ItemSetStructure itemSetStructure = ARRulesViewer.this.state.getRulesData().get(0).getItemSetStructure();
            ItemSetStructurePreferencePanel itemSetStructurePreferencePanel = new ItemSetStructurePreferencePanel(itemSetStructure);
            DialogHelper dialogHelper = new DialogHelper(itemSetStructurePreferencePanel);
            if (dialogHelper.showAsDialog(ARRulesViewer.this)) {
                this.setNewStructure(itemSetStructurePreferencePanel.getSelectedItemSetStructure());
            }
        }

        private void setNewStructure(ItemSetStructure itemSetStructure) {
            for (Rule rule : ARRulesViewer.this.state.getRulesData()) {
                rule.setItemSetStructure(itemSetStructure);
            }
        }
    }

    private class ArSaveRulesActionListener
    implements ActionListener {
        private ArSaveRulesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ARSaveRulesPanel aRSaveRulesPanel = new ARSaveRulesPanel(ARRulesViewer.this.rulesTablePanel.getTable(), ARRulesViewer.this.state.hasAggregates());
            DialogHelper dialogHelper = new DialogHelper(aRSaveRulesPanel);
            dialogHelper.showAsDialog(ARRulesViewer.this);
        }
    }

    private class RulesTableSelectionListener
    implements ListSelectionListener {
        private RulesTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            assert (ARRulesViewer.this.rulesTablePanel.getTable().getModel() instanceof ARRulesViewerTableModel);
            int[] nArray = ARRulesViewer.this.rulesTablePanel.getTable().getSelectedRowsInModel();
            ARRulesViewerTableModel aRRulesViewerTableModel = (ARRulesViewerTableModel)((Object)ARRulesViewer.this.rulesTablePanel.getTable().getModel());
            ArrayList<Rule> arrayList = new ArrayList<Rule>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add((Rule)aRRulesViewerTableModel.getRow(nArray[i]));
            }
            ARRulesViewer.this.ruleDetailViewer.displayDetailsFor(arrayList);
        }
    }
}

