/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.mviewer.arrules.itemsets;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.controls.renderers.HistogramBarRenderer;
import oracle.dmt.dataminer.core.model.ar.ItemSet;
import oracle.dmt.dataminer.core.model.ar.ItemSetStructure;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;
import oracle.dmt.dataminer.mviewer.arrules.ARRulesLrb;
import oracle.dmt.dataminer.mviewer.arrules.ItemSetStructurePreferencePanel;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARItemSetDetailViewer;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARItemSetsTableModel;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARItemSetsViewerState;
import oracle.dmt.dataminer.mviewer.arrules.itemsets.ARSaveItemSetsPanel;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.UITools;
import oracle.javatools.icons.OracleIcons;

public class ARItemSetsViewer
extends JPanel {
    private ARItemSetsViewerState state;
    private ARItemSetsTableModel tableModel;
    private ARItemSetDetailViewer detailViewer;
    private DataMinerTablePanel itemsetsTablePanel;
    private JSplitPane jSplitPane;
    private JButton saveItemSetsBtn;
    private JButton itemSetStructureBtn;

    public ARItemSetsViewer(ARItemSetsViewerState aRItemSetsViewerState) {
        this.state = aRItemSetsViewerState;
        this.initComponents();
        this.initUI();
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.itemsetsTablePanel = new DataMinerTablePanel();
        this.detailViewer = new ARItemSetDetailViewer();
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.6);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setLeftComponent(this.itemsetsTablePanel);
        this.jSplitPane.setRightComponent(this.detailViewer);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane, -1, 410, Short.MAX_VALUE).addContainerGap()));
    }

    private void initUI() {
        this.initControlBarComponents();
    }

    private void initControlBarComponents() {
        this.saveItemSetsBtn = new JButton(ARRulesLrb.get("SAVE_ITEMSETS_TITLE"));
        this.saveItemSetsBtn.addActionListener(new SaveItemSetsActionListener());
        this.itemSetStructureBtn = new JButton();
        this.itemSetStructureBtn.setIcon(OracleIcons.getIcon((String)"extras/small-gear.png"));
        this.itemSetStructureBtn.addActionListener(new ItemSetStructureActionListener());
        this.itemsetsTablePanel.addControlBarComponents(this.saveItemSetsBtn, this.itemSetStructureBtn);
    }

    DataMinerTable getItemSetsTable() {
        return this.itemsetsTablePanel.getTable();
    }

    void beforeLoad() {
        this.detailViewer.displayDetailsFor(null);
        this.setRowsCountLabel(0);
    }

    void afterLoad() {
        this.setupItemSetsTable();
        this.updateStateDepedantComponents();
    }

    void afterQuery() {
        this.updateTableModelWithState();
        this.updateStateDepedantComponents();
    }

    private void updateStateDepedantComponents() {
        this.detailViewer.enableAggregateDetails(this.state.hasAggregates());
        this.itemSetStructureBtn.setVisible(this.state.is2dModel());
        this.setRowsCountLabel(this.tableModel.getRowCount());
    }

    private void setRowsCountLabel(Integer n) {
        Integer n2 = this.state.getTotalItemSetsCount();
        String string = NumericFormat.format((int)n);
        String string2 = CommonLrb.get("LOADING");
        if (n2 != null) {
            string2 = NumericFormat.format((int)n2);
        }
        String string3 = ARRulesLrb.get("ITEMSET_ROWS_OUT_OF_TOTAL");
        String string4 = MessageFormat.format(string3, string, string2);
        this.itemsetsTablePanel.setTitle(string4);
    }

    private void setupItemSetsTable() {
        boolean bl = this.tableModel == null;
        DataMinerTable dataMinerTable = this.itemsetsTablePanel.getTable();
        this.tableModel = new ARItemSetsTableModel(this.state.getItemSets(), this.state.getAggregates());
        if (bl) {
            this.itemsetsTablePanel.setup((TableModel)((Object)this.tableModel), null, 0, true);
            dataMinerTable.setSelectionMode(2);
            dataMinerTable.getSelectionModel().addListSelectionListener(new ItemSetTableSelectionHandler());
            dataMinerTable.setUseTransferHandler(true);
        } else {
            this.itemsetsTablePanel.getTable().setModel((TableModel)((Object)this.tableModel));
            this.itemsetsTablePanel.getTable().setSorted(true);
        }
        dataMinerTable.getSelectionModel().clearSelection();
        TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerNumericRenderer();
        HistogramBarRenderer histogramBarRenderer = new HistogramBarRenderer(100.0, true, Formats.ModelViewer.getPercentage());
        TableColumnModel tableColumnModel = dataMinerTable.getColumnModel();
        tableColumnModel.getColumn(2).setCellRenderer(histogramBarRenderer);
        for (int i = 0; i < this.state.getAggregates().size(); ++i) {
            int n = ARItemSetsTableModel.LAST_BASE_COLUMNS_INDEX + i;
            tableColumnModel.getColumn(n).setCellRenderer(tableCellRenderer);
        }
    }

    private void updateTableModelWithState() {
        UITools.setTableModelData(this.itemsetsTablePanel.getTable(), this.state.getItemSets());
    }

    private class SaveItemSetsActionListener
    implements ActionListener {
        private SaveItemSetsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ARSaveItemSetsPanel aRSaveItemSetsPanel = new ARSaveItemSetsPanel(ARItemSetsViewer.this.itemsetsTablePanel.getTable(), ARItemSetsViewer.this.state.hasAggregates());
            DialogHelper dialogHelper = new DialogHelper(aRSaveItemSetsPanel);
            dialogHelper.showAsDialog(ARItemSetsViewer.this);
        }
    }

    private class ItemSetStructureActionListener
    implements ActionListener {
        private ItemSetStructureActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ItemSetStructure itemSetStructure = ARItemSetsViewer.this.state.getItemSets().get(0).getItemSetStructure();
            ItemSetStructurePreferencePanel itemSetStructurePreferencePanel = new ItemSetStructurePreferencePanel(itemSetStructure);
            DialogHelper dialogHelper = new DialogHelper(itemSetStructurePreferencePanel);
            if (dialogHelper.showAsDialog(ARItemSetsViewer.this)) {
                this.setNewStructure(itemSetStructurePreferencePanel.getSelectedItemSetStructure());
            }
        }

        private void setNewStructure(ItemSetStructure itemSetStructure) {
            for (ItemSet itemSet : ARItemSetsViewer.this.state.getItemSets()) {
                itemSet.setItemSetStructure(itemSetStructure);
            }
        }
    }

    private class ItemSetTableSelectionHandler
    implements ListSelectionListener {
        private ItemSetTableSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            boolean bl2 = bl = !listSelectionEvent.getValueIsAdjusting();
            if (bl) {
                int[] nArray = ARItemSetsViewer.this.itemsetsTablePanel.getTable().getSelectedRowsInModel();
                List list = ARItemSetsViewer.this.tableModel.getRows(nArray);
                ARItemSetsViewer.this.detailViewer.displayDetailsFor(list);
            }
        }
    }
}

