/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.SchemaChooserTableModel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.TableChooserPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class SchemaChooserPane
extends AbstractPanel<AbstractNode>
implements DialogDisplayable {
    private SchemaChooserTableModel _selectedSchemaModel;
    private ListStructure _listFromPreferences;
    private String _connectionName;
    private TableChooserPreferenceSettings _tableChooserPrefenceSettings = TableChooserPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private DataMinerTablePanel availableTablePanel;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private DataMinerTablePanel selectedTablePanel;

    public SchemaChooserPane(Context context) {
        super(context, null);
        assert (context != null) : "Context must not be null";
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.availableTablePanel = new DataMinerTablePanel();
        this.selectedTablePanel = new DataMinerTablePanel();
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.availableTablePanel, -1, 277, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSelectBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.jRemoveAllBtn, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedTablePanel, -1, 288, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(52, 52, 52).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addContainerGap(112, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.selectedTablePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.availableTablePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
    }

    @Override
    public void initRes() {
        this.availableTablePanel.setTitle(ControlsLrb.get("SCHEMA_CHOOSER_AVAILABLE_SCHEMAS"));
        this.selectedTablePanel.setTitle(ControlsLrb.get("SCHEMA_CHOOSER_SELECTED_SCHEMAS"));
        this.jSelectBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.getAccessibleContext().setAccessibleDescription(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ALL_ADA"));
        this.jSelectBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ADA"));
        this.jSelectAllBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_SELECT_ALL_ADA"));
        this.jRemoveBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ADA"));
        this.jRemoveAllBtn.setToolTipText(ControlsLrb.get("SCHEMA_CHOOSER_REMOVE_ALL_ADA"));
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    @Override
    public void initUI() {
        this._connectionName = ConnectionFolder.getConnectionName(this._context);
        this.enableControls(false);
        this.jSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.availableTablePanel.getTable(), SchemaChooserPane.this.selectedTablePanel.getTable());
            }
        });
        this.jSelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.availableTablePanel.getTable().selectAll();
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.availableTablePanel.getTable(), SchemaChooserPane.this.selectedTablePanel.getTable());
            }
        });
        this.jRemoveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.selectedTablePanel.getTable(), SchemaChooserPane.this.availableTablePanel.getTable());
            }
        });
        this.jRemoveAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SchemaChooserPane.this.selectedTablePanel.getTable().selectAll();
                SchemaChooserPane.this.moveItems(SchemaChooserPane.this.selectedTablePanel.getTable(), SchemaChooserPane.this.availableTablePanel.getTable());
            }
        });
        LoadUI loadUI = new LoadUI();
        loadUI.execute();
    }

    private void setupTables(SchemaChooserTableModel schemaChooserTableModel, SchemaChooserTableModel schemaChooserTableModel2) {
        this.availableTablePanel.setup((TableModel)((Object)schemaChooserTableModel), ControlsLrb.get("SCHEMA_CHOOSER_AVAILABLE_SCHEMAS"), 0);
        this.selectedTablePanel.setup((TableModel)((Object)schemaChooserTableModel2), ControlsLrb.get("SCHEMA_CHOOSER_SELECTED_SCHEMAS"), 0);
    }

    private void enableControls(boolean bl) {
        this.jRemoveAllBtn.setEnabled(bl);
        this.jRemoveBtn.setEnabled(bl);
        this.jSelectAllBtn.setEnabled(bl);
        this.jSelectBtn.setEnabled(bl);
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2) {
        int[] nArray = genericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        List list = ((SchemaChooserTableModel)((Object)genericTable.getModel())).getSrcData();
        List list2 = ((SchemaChooserTableModel)((Object)genericTable2.getModel())).getSrcData();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)list.get(nArray[i]);
            arrayList.add(string);
        }
        ((SchemaChooserTableModel)((Object)genericTable2.getModel())).addRows(arrayList);
        ((SchemaChooserTableModel)((Object)genericTable.getModel())).removeRows(arrayList);
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n = list2.indexOf(arrayList.get(i));
            assert (n != -1) : "Unexpected state - added item should be present and must have an index";
            nArray2[i] = n;
        }
        genericTable2.setSelectedRowsInModel(nArray2);
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                SchemaChooserPane.this._listFromPreferences.clear();
                List list = SchemaChooserPane.this._selectedSchemaModel.getSrcData();
                for (String string : list) {
                    SchemaChooserPane.this._listFromPreferences.add((Object)string);
                }
                SchemaChooserPane.this._tableChooserPrefenceSettings.setIncludedSchemaList(SchemaChooserPane.this._connectionName, SchemaChooserPane.this._listFromPreferences);
            }

            @Override
            public String getTitle() {
                return ControlsLrb.get("SCHEMA_CHOOSER_DLG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "schema_selection_dialog";
            }

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                jEWTDialog.setOKButtonEnabled(false);
            }

            @Override
            public JComponent getContent() {
                return SchemaChooserPane.this;
            }
        };
    }

    private class LoadUI
    extends ODMrSwingWorker<SchemaChooserTableModel, Void> {
        private LoadUI() {
            super(SchemaChooserPane.this, null, SchemaChooserPane.this.availableTablePanel.getTable(), SchemaChooserPane.this.selectedTablePanel.getTable());
        }

        @Override
        protected SchemaChooserTableModel doInBackground() throws Exception {
            SchemaChooserTableModel schemaChooserTableModel = new SchemaChooserTableModel();
            SchemaChooserPane.this._listFromPreferences = SchemaChooserPane.this._tableChooserPrefenceSettings.getIncludedSchemaList(SchemaChooserPane.this._connectionName);
            Iterator iterator = SchemaChooserPane.this._listFromPreferences.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                arrayList.add(string);
            }
            SchemaChooserPane.this._selectedSchemaModel = new SchemaChooserTableModel((List<String>)arrayList);
            schemaChooserTableModel.load(SchemaChooserPane.this._context);
            schemaChooserTableModel.removeDuplicateRows(SchemaChooserPane.this._selectedSchemaModel.getSrcData());
            return schemaChooserTableModel;
        }

        @Override
        protected void onSuccess(SchemaChooserTableModel schemaChooserTableModel) throws Exception {
            schemaChooserTableModel.fireTableDataChanged();
            SchemaChooserPane.this.setupTables(schemaChooserTableModel, SchemaChooserPane.this._selectedSchemaModel);
            UITools.getParentDialog(SchemaChooserPane.this).setOKButtonEnabled(true);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)UITools.getParentWindow(SchemaChooserPane.this), (Throwable)throwable, (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_TITLE"), (String)ControlsLrb.get("SCHEMA_CHOOSER_FAILURE_MESSAGE"), null);
        }

        @Override
        protected void onFinally() {
            SchemaChooserPane.this.enableControls(true);
        }
    }
}

